/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: mfbbres.c,v 1.12 88/09/06 14:53:36 jim Exp $ */
#include <dos.h>
#include "X.h"
#include "misc.h"
#include "ega.h"
#include "egafuncs.h"
#include "mxfuncs.h"

/* Solid bresenham line */
/* NOTES
   e2 is used less often than e1, so it's not in a register
*/

void
mfbBresS(rop, addr, nlwidth, signdx, signdy, axis, x1, y1, e, e1, e2, len)
int rop;		/* a reduced rasterop */

u_char *addr;
int nlwidth;		/* width in longwords of bitmap */
int signdx, signdy;	/* signs of directions */
int axis;		/* major axis (Y_AXIS or X_AXIS) */
int x1, y1;		/* initial point */
int e;		/* error accumulator */
int e1;	/* bresenham increments */
int e2;
int len;	/* length of line */

{
    int yinc;	/* increment to next scanline */
    int addrb;		/* bitmask */
    u_char iswin = (u_long)addr >> 16 == 0x0a;

    /* point to longword containing first point */
    addr += (y1 * nlwidth) + (x1 >> 3);
#ifdef EGA_HIRES
    if (iswin && vga_hires) {
	if (addr > vga_mem(0xffff)) {
	    addr -= 0x10000;
	    if (!vga_curpage) {
		vga_curpage = 1;
		SetPage();
	    }
	} else if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	}
    }
#endif
    addrb = x1&07;
    yinc = signdy * nlwidth;

    if (rop == RROP_BLACK)
    {
        if (axis == X_AXIS)
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addr &= ~(0x80>>addrb);
		    if (e < 0)
		        e += e1;
		    else
		    {
		        addr += yinc;
#ifdef EGA_HIRES
			if (iswin && vga_hires) {
			    /* see if this increment has caused
			     * addr to overlap */
			    if (addr > vga_mem(0xffff)) {
				addr -= 0x10000;
				if (!vga_curpage) {
				    vga_curpage = 1;
				    SetPage();
				}
			    } else if (addr < vga_mem(0)) {
				addr += 0x10000;
				if (vga_curpage) {
				    vga_curpage = 0;
				    SetPage();
				}
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 7)
		    {
		        addrb = -1;
		        addr++;
		    }
		    addrb++;
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addr &= ~(0x80 >>addrb);
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        addr += yinc;
#ifdef EGA_HIRES
			if (iswin && vga_hires) {
			    /* see if this increment has caused
			     * addr to overlap */
			    if (addr > vga_mem(0xffff)) {
				addr -= 0x10000;
				if (!vga_curpage) {
				    vga_curpage = 1;
				    SetPage();
				}
			    } else if (addr < vga_mem(0)) {
				addr += 0x10000;
				if (vga_curpage) {
				    vga_curpage = 0;
				    SetPage();
				}
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 0)
		    {
		        addrb = 8;
		        addr--;
		    }
		    addrb--;
	        }
	    }
        } /* if X_AXIS */
        else
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addr &= ~(0x80 >>addrb);
		    if (e < 0)
		        e += e1;
		    else
		    {
		        if (addrb == 7)
		        {
			    addrb = -1;
			    addr++;
		        }
		        addrb++;
		        e += e2;
		    }
		    addr += yinc;
#ifdef EGA_HIRES
		    if (iswin && vga_hires) {
			/* see if this increment has caused
			 * addr to overlap */
			if (addr > vga_mem(0xffff)) {
			    addr -= 0x10000;
			    if (!vga_curpage) {
				vga_curpage = 1;
				SetPage();
			    }
			} else if (addr < vga_mem(0)) {
			    addr += 0x10000;
			    if (vga_curpage) {
				vga_curpage = 0;
				SetPage();
			    }
			}
		    }
#endif
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addr &= ~(0x80>>addrb);
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        if (addrb == 0)
		        {
			    addrb = 8;
			    addr--;
		        }
		        addrb--;
		        e += e2;
		    }
		    addr += yinc;
#ifdef EGA_HIRES
		    if (iswin && vga_hires) {
			/* see if this increment has caused
			 * addr to overlap */
			if (addr > vga_mem(0xffff)) {
			    addr -= 0x10000;
			    if (!vga_curpage) {
				vga_curpage = 1;
				SetPage();
			    }
			} else if (addr < vga_mem(0)) {
			    if (vga_curpage) {
				vga_curpage = 0;
				SetPage();
			    }
			}
		    }
#endif
	        }
	    }
        } /* else Y_AXIS */
    } 
    else if (rop == RROP_WHITE)
    {
        if (axis == X_AXIS)
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addr |= 0x80>>addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        addr += yinc;
#ifdef EGA_HIRES
			if (iswin && vga_hires) {
			    /* see if this increment has caused
			     * addr to overlap */
			    if (addr > vga_mem(0xffff)) {
				addr -= 0x10000;
				if (!vga_curpage) {
				    vga_curpage = 1;
				    SetPage();
				}
			    } else if (addr < vga_mem(0)) {
				addr += 0x10000;
				if (vga_curpage) {
				    vga_curpage = 0;
				    SetPage();
				}
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 7)
		    {
		        addrb = -1;
		        addr++;
		    }
		    addrb++;
	        }
	    }
	    else
	    {
		while(len--)
	        {
		    *addr |= 0x80 >>addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        addr += yinc;
#ifdef EGA_HIRES
			if (iswin && vga_hires) {
			    /* see if this increment has caused
			     * addr to overlap */
			    if (addr > vga_mem(0xffff)) {
				addr -= 0x10000;
				if (!vga_curpage) {
				    vga_curpage = 1;
				    SetPage();
				}
			    } else if (addr < vga_mem(0)) {
				addr += 0x10000;
				if (vga_curpage) {
				    vga_curpage = 0;
				    SetPage();
				}
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 0)
		    {
		        addrb = 8;
		        addr--;
		    }
		    addrb--;
	        }
	    }
        } /* if X_AXIS */
        else
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addr |= 0x80 >>addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        if (addrb == 7)
		        {
			    addrb = -1;
			    addr++;
		        }
		        addrb++;
		        e += e2;
		    }
		    addr += yinc;
#ifdef EGA_HIRES
		    if (iswin && vga_hires) {
			/* see if this increment has caused
			 * addr to overlap */
			if (addr > vga_mem(0xffff)) {
			    addr -= 0x10000;
			    if (!vga_curpage) {
				vga_curpage = 1;
				SetPage();
			    }
			} else if (addr < vga_mem(0)) {
			    addr += 0x10000;
			    if (vga_curpage) {
				vga_curpage = 0;
				SetPage();
			    }
			}
		    }
#endif
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addr |= 0x80 >>addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        if (addrb == 0)
		        {
			    addrb = 8;
			    addr--;
		        }
		        addrb--;
		        e += e2;
		    }
		    addr += yinc;
#ifdef EGA_HIRES
		    if (iswin && vga_hires) {
			/* see if this increment has caused
			 * addr to overlap */
			if (addr > vga_mem(0xffff)) {
			    addr -= 0x10000;
			    if (!vga_curpage) {
				vga_curpage = 1;
				SetPage();
			    }
			} else if (addr < vga_mem(0)) {
			    addr += 0x10000;
			    if (vga_curpage) {
				vga_curpage = 0;
				SetPage();
			    }
			}
		    }
#endif
	        }
	    }
        } /* else Y_AXIS */
    }
    else if (rop == RROP_INVERT)
    {
        if (axis == X_AXIS)
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addr ^= 0x80 >>addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        addr += yinc;
#ifdef EGA_HIRES
			if (iswin && vga_hires) {
			    /* see if this increment has caused
			     * addr to overlap */
			    if (addr > vga_mem(0xffff)) {
				addr -= 0x10000;
				if (!vga_curpage) {
				    vga_curpage = 1;
				    SetPage();
				}
			    } else if (addr < vga_mem(0)) {
				addr += 0x10000;
				if (vga_curpage) {
				    vga_curpage = 0;
				    SetPage();
				}
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 7)
		    {
		        addrb = -1;
		        addr++;
		    }
		    addrb++;
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addr ^= 0x80 >> addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        addr += yinc;
#ifdef EGA_HIRES
			if (iswin && vga_hires) {
			    /* see if this increment has caused
			     * addr to overlap */
			    if (addr > vga_mem(0xffff)) {
				addr -= 0x10000;
				if (!vga_curpage) {
				    vga_curpage = 1;
				    SetPage();
				}
			    } else if (addr < vga_mem(0)) {
				addr += 0x10000;
				if (vga_curpage) {
				    vga_curpage = 0;
				    SetPage();
				}
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 0)
		    {
		        addrb = 8;
		        addr--;
		    }
		    addrb--;
	        }
	    }
        } /* if X_AXIS */
        else
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addr ^= 0x80 >> addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        if (addrb == 7)
		        {
			    addrb = -1;
			    addr++;
		        }
		        addrb++;
		        e += e2;
		    }
		    addr += yinc;
#ifdef EGA_HIRES
		    if (iswin && vga_hires) {
			/* see if this increment has caused
			 * addr to overlap */
			if (addr > vga_mem(0xffff)) {
			    addr -= 0x10000;
			    if (!vga_curpage) {
				vga_curpage = 1;
				SetPage();
			    }
			} else if (addr < vga_mem(0)) {
			    if (vga_curpage) {
				vga_curpage = 0;
				SetPage();
			    }
			}
		    }
#endif
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addr ^= 0x80 >> addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        if (addrb == 0)
		        {
			    addrb = 8;
			    addr--;
		        }
		        addrb--;
		        e += e2;
		    }
		    addr += yinc;
#ifdef EGA_HIRES
		    if (iswin && vga_hires) {
			/* see if this increment has caused
			 * addr to overlap */
			if (addr > vga_mem(0xffff)) {
			    addr -= 0x10000;
			    if (!vga_curpage) {
				vga_curpage = 1;
				SetPage();
			    }
			} else if (addr < vga_mem(0)) {
			    addr += 0x10000;
			    if (vga_curpage) {
				vga_curpage = 0;
				SetPage();
			    }
			}
		    }
#endif
	        }
	    }
        } /* else Y_AXIS */
    }
} 
