#include	"X.h"
#include	"Xmd.h"
#include	"input.h"
#include	"keysym.h"
#include	"ibmkbd.h"

static KeySym PCMap_US[] = {
	XK_Escape,	NoSymbol,		/* 0x01 */
	XK_1,		XK_exclam,		/* 0x02 */
	XK_2,		XK_at,			/* 0x03 */
	XK_3,		XK_numbersign,		/* 0x04 */
	XK_4,		XK_dollar,		/* 0x05 */
	XK_5,		XK_percent,		/* 0x06 */
	XK_6,		XK_asciicircum,		/* 0x07 */
	XK_7,		XK_ampersand,		/* 0x08 */
	XK_8,		XK_asterisk,		/* 0x09 */
	XK_9,		XK_parenleft,		/* 0x0a */
	XK_0,		XK_parenright,		/* 0x0b */
	XK_minus,	XK_underscore,		/* 0x0c */
	XK_equal,	XK_plus,		/* 0x0d */
	XK_BackSpace,	NoSymbol,		/* 0x0e */
	XK_Tab,		NoSymbol,		/* 0x0f */
	XK_Q,		NoSymbol,		/* 0x10 */
	XK_W,		NoSymbol,		/* 0x11 */
	XK_E,		NoSymbol,		/* 0x12 */
	XK_R,		NoSymbol,		/* 0x13 */
	XK_T,		NoSymbol,		/* 0x14 */
	XK_Y,		NoSymbol,		/* 0x15 */
	XK_U,		NoSymbol,		/* 0x16 */
	XK_I,		NoSymbol,		/* 0x17 */
	XK_O,		NoSymbol,		/* 0x18 */
	XK_P,		NoSymbol,		/* 0x19 */
	XK_bracketleft,	XK_braceleft,		/* 0x1a */
	XK_bracketright,	XK_braceright,	/* 0x1b */
	XK_Return,	NoSymbol,		/* 0x1c */
	XK_Control_L,	NoSymbol,		/* 0x1d */
	XK_A,		NoSymbol,		/* 0x1e */
	XK_S,		NoSymbol,		/* 0x1f */
	XK_D,		NoSymbol,		/* 0x20 */
	XK_F,		NoSymbol,		/* 0x21 */
	XK_G,		NoSymbol,		/* 0x22 */
	XK_H,		NoSymbol,		/* 0x23 */
	XK_J,		NoSymbol,		/* 0x24 */
	XK_K,		NoSymbol,		/* 0x25 */
	XK_L,		NoSymbol,		/* 0x26 */
	XK_semicolon,	XK_colon,		/* 0x27 */
	XK_quoteright,	XK_quotedbl,		/* 0x28 */
	XK_quoteleft,	XK_asciitilde,		/* 0x29 */
	XK_Shift_L,	NoSymbol,		/* 0x2a */
	XK_backslash,	XK_bar,			/* 0x2b */
	XK_Z,		NoSymbol,		/* 0x2c */
	XK_X,		NoSymbol,		/* 0x2d */
	XK_C,		NoSymbol,		/* 0x2e */
	XK_V,		NoSymbol,		/* 0x2f */
	XK_B,		NoSymbol,		/* 0x30 */
	XK_N,		NoSymbol,		/* 0x31 */
	XK_M,		NoSymbol,		/* 0x32 */
	XK_comma,	XK_less,		/* 0x33 */
	XK_period,	XK_greater,		/* 0x34 */
	XK_slash,	XK_question,		/* 0x35 */
	XK_Shift_R,	NoSymbol,		/* 0x36 */
	XK_KP_Multiply,	NoSymbol,		/* 0x37 */	/* XXX */
	XK_Alt_L,	NoSymbol,		/* 0x38 */
	XK_space,	NoSymbol,		/* 0x39 */
	XK_Caps_Lock,	NoSymbol,		/* 0x3a */
	XK_F1,		NoSymbol,		/* 0x3b */
	XK_F2,		NoSymbol,		/* 0x3c */
	XK_F3,		NoSymbol,		/* 0x3d */
	XK_F4,		NoSymbol,		/* 0x3e */
	XK_F5,		NoSymbol,		/* 0x3f */
	XK_F6,		NoSymbol,		/* 0x40 */
	XK_F7,		NoSymbol,		/* 0x41 */
	XK_F8,		NoSymbol,		/* 0x42 */
	XK_F9,		NoSymbol,		/* 0x43 */
	XK_F10,		NoSymbol,		/* 0x44 */
	XK_Pause,	NoSymbol,		/* 0x45 */
	XK_Scroll_Lock,	NoSymbol,		/* 0x46 */	/* XXX */
	XK_Home,	XK_KP_7,		/* 0x47 */
	XK_Up,		XK_KP_8,		/* 0x48 */
	XK_Prior,	XK_KP_9,		/* 0x49 */
	XK_KP_Subtract,	NoSymbol,		/* 0x4a */
	XK_Left,	XK_KP_4,		/* 0x4b */
	NoSymbol,	XK_KP_5,		/* 0x4c */
	XK_Right,	XK_KP_6,		/* 0x4d */
	XK_KP_Add,	NoSymbol,		/* 0x4e */
	XK_End,		XK_KP_1,		/* 0x4f */
	XK_Down,	XK_KP_2,		/* 0x50 */
	XK_Next,	XK_KP_3,		/* 0x51 */
	XK_Insert,	XK_KP_0,		/* 0x52 */
	XK_Delete,	XK_KP_Decimal,		/* 0x53 */
	XK_Execute,	NoSymbol,		/* 0x54 */	/* XXX */
	NoSymbol,	NoSymbol,		/* 0x55 */	/* XXX */
	XK_backslash,	XK_bar,			/* 0x56 */	/* XXX */
	XK_F11,		NoSymbol,		/* 0x57 */	/* XXX */
	XK_F12,		NoSymbol,		/* 0x58 */	/* XXX */
	XK_Super_L,	NoSymbol,		/* 0x59 */	/* XXX */
	XK_KP_7,	XK_Home,		/* 0x5a */	/* num-lock */
	XK_KP_8,	XK_Up,			/* 0x5b */	/* num-lock */
	XK_KP_9,	XK_Prior,		/* 0x5c */	/* num-lock */
	XK_KP_4,	XK_Left,		/* 0x5d */	/* num-lock */
	XK_KP_5,	NoSymbol,		/* 0x5e */	/* num-lock */
	XK_KP_6,	XK_Right,		/* 0x5f */	/* num-lock */
	XK_KP_Enter,	NoSymbol,		/* 0x60 */
	XK_Control_R,	NoSymbol,		/* 0x61 */	/* ext */
	XK_Shift_L,	NoSymbol,		/* 0x62 */	/* gen ext */
	XK_KP_Divide,	NoSymbol,		/* 0x63 */	/* ext */
	NoSymbol,	NoSymbol,		/* 0x64 */	/* ext */
	NoSymbol,	XK_Print,		/* 0x65 */	/* ext */
	XK_Alt_R,	NoSymbol,		/* 0x66 */
	XK_Num_Lock,	NoSymbol,		/* 0x67 */	/* ext */
	XK_Break,	NoSymbol,		/* 0x68 */	/* ext */
	XK_Home,	NoSymbol,		/* 0x69 */	/* ext */
	XK_Up,		NoSymbol,		/* 0x6a */	/* ext */
	XK_Prior,	NoSymbol,		/* 0x6b */	/* ext */
	NoSymbol,	NoSymbol,		/* 0x6c */
	XK_Left,	NoSymbol,		/* 0x6d */	/* ext */
	NoSymbol,	NoSymbol,		/* 0x6e */
	XK_Right,	NoSymbol,		/* 0x6f */	/* ext */
	NoSymbol,	NoSymbol,		/* 0x70 */
	XK_End,		NoSymbol,		/* 0x71 */	/* ext */
	XK_Down,	NoSymbol,		/* 0x72 */	/* ext */
	XK_Next,	NoSymbol,		/* 0x73 */	/* ext */
	XK_Insert,	NoSymbol,		/* 0x74 */	/* ext */
	XK_Delete,	NoSymbol,		/* 0x75 */	/* ext */
	XK_KP_1,	XK_End,			/* 0x76 */	/* num-lock */
	XK_KP_2,	XK_Down,		/* 0x77 */	/* num-lock */
	XK_KP_3,	XK_Next,		/* 0x78 */	/* num-lock */
	XK_KP_0,	XK_Insert,		/* 0x79 */	/* num-lock */
	XK_KP_Decimal,	XK_Delete,		/* 0x7a */	/* num-lock */
};

KeySymsRec pcKeySyms_US = {
    /*	map	   minKeyCode	maxKC	width */
    PCMap_US,		1+KBD_OFFSET,	0x7a+KBD_OFFSET,	2,
};

#define	cT	(ControlMask)
#define	sH	(ShiftMask)
#define	lK	(LockMask)
#define	mT	(Mod1Mask)		/* Alt */
#define nL	(Mod2Mask)		/* NumLock */
#define mS	(Mod3Mask)		/* Alt Gr */
CARD8 pcModMap[MAP_LENGTH] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* xx-08 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 09-18 */
    0,  0,  0,  0,  cT, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 19-28 */
    0,  sH, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  sH, 0,  mT,/* 29-38 */
    0,  lK, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 39-48 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 49-58 */
    0,  0,  0,  0,  0,  0,  0,  0,  cT, sH, 0,  0,  0,  mT, nL, 0, /* 59-68 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  mT, 0,  0, /* 69-78 */
    0,  0,  0,  0,  0,  0,  0,  sH, 0,  0,  0,  0,  0,  0,  0,  0, /* 79-88 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 89-98 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 99-a8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* a9-b8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* b9-c8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* c9-d8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* d9-e8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* e9-f8 */
};
