/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <sys/types.h>
#include <sys/sysent.h>
#include <sys/time.h>
#include <errno.h>
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"

struct tcpopen_func {
	int (_fastcall _near *proc)(int, int _near *, void _far *);
} _near tcpopen_funcs[] = {
	0,
	tcpopen_init,
	tcpopen_shutdown,
	tcpopen_socket,
	tcpopen_info,
	tcpopen_accept,
	tcpopen_drain,
	tcpopen_release,
	tcpopen_eof,
	tcpopen_read,
	tcpopen_write,
	tcpopen_recv,
	tcpopen_sendto,
	tcpopen_select,
	0
};

#define N_FUNCS (sizeof (tcpopen_funcs) / sizeof (tcpopen_funcs[0]))

int
main(argc, argv, envp)
int argc;
char **argv;
char **envp;
{
	leave(0);
	/* NOTREACHED */
	return 0;
}

/*
 * The arguments len and arg are passed by reference(!) from an ASM routine.
 * Don't let the optimizer remove assignments to these variables.
 */
#pragma loop_opt(off)
int _near
rpc_entry(func, arg, len, buf)
int func, arg, len;
void _far *buf;
{
    struct tcpopen_func _near *tfp;
    int i;

    tfp = &tcpopen_funcs[func];
    if ((unsigned)func >= N_FUNCS || !tfp->proc) {
	arg = NETERR_BADCALL;
	len = 0;
	return -1;
    }
    i = (tfp->proc)(arg, &len, buf);
    if (i < 0) {
	len = errno;
	arg = convert_error(errno);
	return -1;
    }
    return i;
}
#pragma loop_opt()

int _fastcall _near
tcpopen_shutdown(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    scloseall();
    return 0;
}

int _fastcall _near
tcpopen_select(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    struct timeval ztime;
    int ret;
    fd_set ifds, ofds;

    ztime.tv_sec = 0;
    ztime.tv_usec = 0;
    *(long *)&ifds = ((long _far *)buf)[0];
    *(long *)&ofds = ((long _far *)buf)[1];
    ret = select(32, &ifds, &ofds, 0, &ztime);
    if (ret < 0)
	return ret;
    ((long _far *)buf)[0] = *(long *)&ifds;
    ((long _far *)buf)[1] = *(long *)&ofds;
    *len = 2 * sizeof (long);
    return ret;
}

int _fastcall _near
tcpopen_release(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    return sclose(arg | FD_SOCKET);
}

int _fastcall _near
tcpopen_eof(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    return shutdown(arg | FD_SOCKET, 1);
}
