/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <pctcp/types.h>
#include <pctcp/pctcp.h>
#include <pctcp/netinfo.h>
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"

typedef unsigned long u_long;
typedef unsigned short u_short;

int _near neterrno;
int _near netsuberrno;

struct tcp_func {
	int (_fastcall *proc)(int, int *, void _far *);
} _near tcp_funcs[] = {
	tcp_startup,
	tcp_init,		/*  1 */
	tcp_shutdown,		/*  2 */
	tcp_socket,		/*  3 */
	tcp_info,		/*  4 */
	tcp_accept,		/*  5 */
	tcp_drain,		/*  6 */
	tcp_release,		/*  7 */
	tcp_eof,		/*  8 */
	tcp_read,		/*  9 */
	tcp_write,		/* 10 */
	tcp_recv,		/* 11 */
	tcp_sendto,		/* 12 */
	tcp_select,		/* 13 */
	0
};

#define n_funcs (sizeof (tcp_funcs) / sizeof (tcp_funcs[0]))

int
rpc_entry(func, arg, len, buf)
int func, arg, len;
void _far *buf;
{
    struct tcp_func near *nfp;
    int i;

    nfp = &tcp_funcs[func];
    if ((unsigned)func >= n_funcs || !nfp->proc) {
	arg = NETERR_BADCALL;
	len = 0;
	return -1;
    }
    i = (nfp->proc)(arg, &len, buf);
    if (i < 0) {
	int *ap = &arg;
	*ap = convert_error(neterrno, netsuberrno);
	return -1;
    }
    return i;
}

int _fastcall
tcp_startup(arg, len, buf)
int arg, *len;
void _far *buf;
{
    return 0;
}

int _fastcall
tcp_shutdown(arg, len, buf)
int arg, *len;
void _far *buf;
{
    net_abortall();
    net_releaseall();
    return 0;
}

int _fastcall
tcp_select(arg, len, buf)
int arg, *len;
void _far *buf;
{
    u_long x, y;
    int ret;

    x = 0;
    y = 0;
    /* PC/PCP wants nfds to be the highest index you
     * are looking for.  Its maximum value is 31.
     * The standard implementation is to make it the
     * number of bits you are looking for.
     */
    ret = _net_select(arg - 1, &x, &y);
    if (ret < 0)
	return ret;
    ((u_long _far *)buf)[0] &= x;
    ((u_long _far *)buf)[1] &= y;
    *len = 2 * sizeof (long);
    return ret;
}

int _fastcall
tcp_sendto(arg, len, buf)
int arg, *len;
void _far *buf;
{
    struct addr tcp_addr;
    struct sendto_head head = *(struct sendto_head _far *)buf;

    tcp_addr.fhost = head.addr.host;
    tcp_addr.lsocket = 0;
    tcp_addr.fsocket = head.addr.socket;
    tcp_addr.protocol = 0;
    buf = (char _far *)buf + sizeof (struct sendto_head);
    *len -= sizeof (struct sendto_head);
    return _net_writeto(arg, buf, *len, &tcp_addr, head.flags);
}

int _fastcall
tcp_info(arg, len, buf)
int arg, *len;
void _far *buf;
{
    struct netinfo tcp_ni;
    struct net_info _far *ni = (struct net_info _far *)buf;

    if (net_info(arg, &tcp_ni) < 0)
	return -1;
    ni->ip_address = tcp_ni.ip_address;
    ni->ip_broadcast = (tcp_ni.ip_address & tcp_ni.ip_subnet) |
			(0xffffffffL & ~tcp_ni.ip_subnet);
    *len = sizeof (struct net_info);
    return 0;
}

int _fastcall
tcp_accept(arg, len, buf)
int arg, *len;
void _far *buf;
{
    struct addr tcp_addr;
    struct net_addr _far *addr = (struct net_addr _far *)buf;

    if (get_peer(arg, &tcp_addr) < 0)
	return -1;
    addr->host = tcp_addr.fhost;
    addr->socket = tcp_addr.fsocket;
    *len = sizeof (struct net_addr);
    return arg;
}

int _fastcall
tcp_drain(arg, len, buf)
int arg, *len;
void _far *buf;
{
    return _net_read(arg, buf, 512, 0, NET_FLG_DRAIN);
}

int _fastcall
tcp_release(arg, len, buf)
int arg, *len;
void _far *buf;
{
    return net_release(arg);
}

int _fastcall
tcp_eof(arg, len, buf)
int arg, *len;
void _far *buf;
{
    return net_eof(arg);
}

int _fastcall
tcp_read(arg, len, buf)
int arg, *len;
void _far *buf;
{
    int ret;

    ret = _net_read(arg, buf, *len, 0, 0);
    if (ret < 0)
	return ret;
    *len = ret;
    return ret;
}

int _fastcall
tcp_write(arg, len, buf)
int arg, *len;
void _far *buf;
{
    return _net_write(arg, buf, *len, 0);
}

int _fastcall
tcp_recv(arg, len, buf)
int arg, *len;
void _far *buf;
{
    int ret;
    struct addr tcp_addr;
    struct net_addr _far *addr = (struct net_addr _far *)buf;

    *len -= sizeof (struct net_addr);
    ret = _net_read(arg, (char _far *)buf + sizeof (struct net_addr),
	*len, &tcp_addr, 0);
    if (ret < 0)
	return ret;
    addr->host = tcp_addr.fhost;
    addr->socket = tcp_addr.fsocket;
    *len = ret + sizeof (struct net_addr);
    return ret;
}
