/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1992 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "../defs.h"

static int map[] = {
	0,			/* NET_NOERR */
	NETERR_ADDRINUSE,	/* NET_ERR_INUSE */
	NETERR_SYSTEM,		/* NET_DOS_ERR */
	NETERR_NOMEM,		/* NET_ERR_NOMEM */
	NETERR_BADFD,		/* NET_ERR_NOTNETCONN */
	NETERR_OTHER+1,		/* NET_ERR_ILLEGALOP */
	NETERR_OTHER+2,		/* NET_ERR_BADPKT */
	NETERR_HOSTUNREACH,	/* NET_ERR_NOHOST */
	NETERR_OTHER+3,		/* NET_ERR_CANTOPEN */
	NETERR_NETUNREACH,	/* NET_ERR_NET_UNREACHABLE */
	NETERR_HOSTUNREACH,	/* NET_ERR_HOST_UNREACHABLE */
	NETERR_HOSTUNREACH,	/* NET_ERR_PROT_UNREACHABLE */
	NETERR_HOSTUNREACH,	/* NET_ERR_PORT_UNREACHABLE */
	NETERR_TIMEOUT,		/* NET_ERR_TIMEOUT */
	NETERR_HOST,		/* NET_ERR_HOSTUNKNOWN */
	NETERR_HOST,		/* NET_ERR_NOSERVERS */
	NETERR_OTHER+4,		/* NET_ERR_SERVER_ERR */
	NETERR_BADARGS,		/* NET_ERR_BADFORMAT */
	NETERR_BADARGS,		/* NET_ERR_BADARG */
	NETERR_NOTESTAB,	/* NET_ERR_EOF */
	NETERR_OTHER+7,		/* NET_ERR_RESET */
	NETERR_WOULD_BLOCK,	/* NET_ERR_WOULD_BLOCK */
	NETERR_NOTESTAB,	/* NET_ERR_UNBOUND */
	NETERR_BADFD,		/* NET_ERR_NODESC */
	NETERR_BADCALL,		/* NET_ERR_BADSYSCALL */
	NETERR_BROADCAST,	/* NET_ERR_CANTBROADCAST */
	NETERR_NOTESTAB,	/* NET_ERR_NOTESTAB *
	NETERR_OTHER+9,		/* NET_ERR_REENTRY */
	NETERR_OTHER+10,	/* NET_ERR_ICMPMSG */
};
#define nerrors (sizeof map / sizeof map[0])

static int submap[] = {
	0
};
#define nsuberrors (sizeof submap / sizeof submap[0])

int _fastcall
convert_error(err, suberr)
int err;
int suberr;
{
	if (err < 0 || err >= nerrors)
		return err;
	err = map[err];
	if (err >= 0)
		return err;
	if (suberr < 0 || suberr > nsuberrors)
		return suberr;
	return submap[suberr];
}
