/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1993 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <sys/types.h>
#include <errno.h>
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"

struct novell_func {
	int (_fastcall *proc)(short _far *);
} _near novell_funcs[] = {
	0,
	novell_init,
	novell_shutdown,
	novell_socket,
	novell_info,
	novell_accept,
	novell_drain,
	novell_release,
	novell_eof,
	novell_read,
	novell_write,
	novell_recv,
	novell_sendto,
	novell_select,
	0
};

#define N_FUNCS (sizeof (novell_funcs) / sizeof (novell_funcs[0]))

int
main(argc, argv, envp)
int argc;
char **argv;
char **envp;
{
	return 0;
}

int
rpc_entry(buf, size)
short _far *buf;
int size;
{
    struct novell_func near *nfp;
    int i;

    nfp = &novell_funcs[buf[0]];
    if ((unsigned)buf[0] >= N_FUNCS || !nfp->proc) {
	buf[0] = -1;
	buf[2] = NETERR_BADCALL;
	return 6;
    }
    i = (nfp->proc)(buf);
    if (i < 0) {
	buf[0] = i;
	buf[1] = errno;
	buf[2] = convert_error(errno);
	return 6;
    }
    return i;
}

int _fastcall
novell_shutdown(buf)
short _far *buf;
{
    return 0;
}
