/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1993 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"

char _near shared_buf[4096];

int _fastcall
novell_init(buf)
short _far *buf;
{
    dfputs("Novell LAN WP transport layer\r\n");
    buf[0] = 0;		/* no init routine */
    buf[2] = (u_short)shared_buf;
    buf[3] = (u_short)((u_long)(char far *)shared_buf >> 16);
    buf[4] = sizeof shared_buf;
    return 10;
}

int _fastcall
novell_drain(buf)
short _far *buf;
{
    int ret;

    ret = soread(buf[1], shared_buf, sizeof shared_buf);
    if (ret < 0)
	return ret;
    buf[0] = ret;
    return 2;
}

int _fastcall
novell_read(buf)
short _far *buf;
{
    int ret;

    ret = soread(buf[1], shared_buf, buf[2]);
    if (ret < 0)
	return ret;
    buf[0] = ret;
    return 2;
}

int _fastcall
novell_write(buf)
short _far *buf;
{
    int ret;

    ret = sowrite(buf[1], shared_buf, buf[2]);
    if (ret < 0)
	return ret;
    buf[0] = ret;
    return 2;
}

int _fastcall
novell_recv(buf)
short _far *buf;
{
    int ret;
    struct sockaddr_in in;
    int len;
    struct net_addr _far *addr = (struct net_addr _far *)&buf[1];


    len = sizeof in;
    ret = recvfrom(buf[1], shared_buf, buf[2], 0, (SADDR_PTR)&in, &len);
    if (ret < 0)
	return ret;
    buf[0] = ret;
    addr->host = in.sin_addr.s_addr;
    addr->socket = ntohs(in.sin_port);
    return sizeof (struct net_addr) + sizeof (short);
}

int _fastcall
novell_sendto(buf)
short _far *buf;
{
    struct sockaddr_in in;
    struct net_addr _far *addr = (struct net_addr _far *)&buf[4];
    int ret;

    in.sin_family = AF_INET;
    in.sin_addr.s_addr = addr->host;
    in.sin_port = htons(addr->socket);
    memset(in.sin_zero, 0, sizeof in.sin_zero);
    ret = sendto(buf[1], shared_buf, buf[2], 0, (SADDR_PTR)&in, sizeof in);
    if (ret < 0)
	return ret;
    buf[0] = ret;
    return 2;
}
