/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1992 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#define DADDLEN 6		/* ethernet address length */
#define	MTU 1500		/* maximum ethernet transmission unit */
#define WINDOWSIZE 4096		/* 4Kbytes */
#define TSENDSIZE 1024
#define SLIPSENDSIZE 768
#define	IMAXLEN	(MTU - 20)	/* max IP data length */
#define UMAXLEN (IMAXLEN - 8)	/* max UDP data length */
#define TMAXSIZE (IMAXLEN - 20)	/* max TCP data length */
#define ICMPMAX 300 
#define	AMAXLEN 64		/* max ARP packet length */

#define NPORTS	32

#define MINRTO	18		/* actually 18.2 ticks per second */
#define MAXRTO	1820		/* this makes MAXRTO 100 seconds */
#define CONNWAITTIME 20		/* default contime in seconds */
#ifdef __HIGHC__
extern unsigned short htons(unsigned short);
extern unsigned short ntohs(unsigned short);
#else
#ifdef __WATCOMC__
unsigned short	_sswap(unsigned short);
#pragma aux	_sswap =	\
	0x86 0xe0	/* XCHG	AH,AL */ \
	parm	[ax] \
	modify exact	[ax] \
	value	[ax];

unsigned long	_lswap(unsigned long);
#pragma	aux	_lswap =	\
	0x86 0xe0	/* XCHG	AH,AL */ \
	0xc1 0xc0 0x10	/* ROL	EAX,16 */ \
	0x86 0xe0	/* XCHG	AH,AL */ \
	parm	[eax] \
	modify exact	[eax] \
	value	[eax];

#define	htons(s)	_sswap(s)
#define	ntohs(s)	_sswap(s)
#define	htonl(l)	_lswap(l)
#define	ntohl(l)	_lswap(l)
#define	ffsl(l)		_ffsl(l)
#else
#define htons(x) ((u_int)((u_char)(x) << 8) | (u_char)((unsigned int)(x) >> 8))
#define ntohs(x) ((u_int)((u_char)(x) << 8) | (u_char)((unsigned int)(x) >> 8))
#endif
#endif
