/***********************************************************
Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: mkfontdir.c,v 1.10 88/10/11 08:07:40 rws Exp $ */

#include <stdio.h>
#include <X11/Xos.h>
/* #include <X11/Xmu.h>  don't include this */
void XmuCopyISOLatin1Lowered();
#include <dos.h>
#include <direct.h>
#include <errno.h>

#include "fontdir.h"

#define  XK_LATIN1
#include <X11/keysymde.h>

#define MAXPATHLEN	67

typedef void (*GetNameProc)(/* fp, font_name */);
typedef struct _FileType {
    char 		*extension;
    GetNameProc		proc;
    char		**filter;
} FileTypeRec, *FileType;

extern void GetSNFFontName();

/*
 * The table of font file formats that are understood.  Order is important.
 */
static FileTypeRec fileTypes[] = {
    {".snf", GetSNFFontName, NULL},
};

/*
 * Only works when table is freshly built. I.e. it cannot contain any aliases.
 */
static void WriteFontDir(table)
    FontTable table;
{
    char name[MAXPATHLEN];
    FILE *file;
    int i;
    int width = 0;

    /* XXX unix dependent file-name mangling */
    strcpy(name, table->directory);
    strcat(name, FontDirFile);
    file = fopen(name, "w");
    if (file == NULL)
	return;
    for (i = 0; i < table->name.used; i++) {
	int idx = table->name.fn[i].u.index;
	int len = strlen(table->file.ff[idx].name);
	if (len > width)
	    width = len;
    }
    width += 4;
    fprintf(file, "%d\n", table->name.used);
    for (i = 0; i < table->name.used; i++) {
	int idx = table->name.fn[i].u.index;
	fprintf(file, "%-*s %s\n",
		width, table->file.ff[idx].name, table->name.fn[i].name);
    }
    fclose(file);
}

#if defined(macII) || (defined(SYSV) && !defined(hpux))
#define vfork() fork()
#endif
#ifdef notdef
static int
FontFilter(fp, filter)
    FILE *fp;
    char **filter;
{
    int pfd[2];
    int pid;

    if (pipe(pfd) < 0) {
	fclose(fp);
	return (-1);
    }
    switch(pid = vfork()) {
    case 0:
	dup2(fileno(fp), 0);
	close(fileno(fp));
	dup2(pfd[1], 1);
	close(pfd[0]);
	close(pfd[1]);
	execvp(filter[0], filter);
	_exit(127);
    case -1:
	close(pfd[0]);
	close(pfd[1]);
	fclose(fp);
	return(-1);
    default:
	dup2(pfd[0], fileno(fp));
	close(pfd[0]);
	close(pfd[1]);
	return(pid);
    }    
}
#endif
static Boolean ProcessFile (dir, path, table, fileType)
    struct dirent *dir;
    char *path;
    FontTable table;
    FileType fileType;
{
    int i, j;
    Boolean found;
    FILE *file;
    char font_name[MAXPATHLEN];
    int pid, child;

    file = fopen(path, "r");
    if (file == NULL) {
	perror(path);
	return False;
    }
    font_name[0] = NUL;
    i = strlen(dir->d_name) - strlen(fileType->extension);
    strncpy(font_name, dir->d_name, i + 1);
    font_name[i] = NUL;
    if (fileType->filter) {
#ifdef notdef	
	pid = FontFilter(file, fileType->filter);
	if (pid < 0) {
	    fprintf (stderr, "failed to process file %s\n", path);
	    return False;
	}
#else
       return False;
#endif
    }
    (*fileType->proc)(file, font_name);
    fclose(file);
#ifdef notdef	
    if (pid >= 0)
       do { child = wait(0); } while (child != pid && child != -1);
#endif
    if (strlen(font_name) == 0) {
	fprintf(stderr, "%s: invalid font, skipping\n", path);
	return False;
    }
    XmuCopyISOLatin1Lowered (font_name, font_name);
    i = AddFileEntry(table, dir->d_name, False);
    j = FindNameInFontTable (table, font_name, &found);
    if (found) {
	fprintf (stderr, "duplicate FONT property %s in file %s and %s\n",
	    font_name, path, table->file.ff[table->name.fn[j].u.index].name);
	return False;
    }
    (void) AddNameEntry(table, font_name, i);
    return True;
}

static Boolean Ematch(ext, name)
    char *ext;
    char *name;
{
    int i,j;

    i = strlen(name);
    j = strlen(ext);
    return ((i > j) && (strcmp(ext, name + i - j) == 0));
}

static Boolean Fmatch(name, ext, table)
    char *name;
    char *ext;
    FontTable table;
{
    int i, j;
    char *file;
    FileType ft;

    j = strlen(name) - strlen(ext);
    for (i = 0; i != table->file.used; i++) {
	file = table->file.ff[i].name;
	if ((strlen(file) > j) && !strncmp(name, file, j)) {
	    file += j;
	    for (ft = fileTypes; ft->extension != ext; ft++) {
		if (!strcmp(file, ft->extension))
		    return True;
	    }
	}
    }
    return False;
}

static int EnumFiles(directory, fileType, data)
    char *directory;
    FileType fileType;
    FontTable data;		/* should be an opaque type */
{
    DIR * dirp;
    struct dirent  *file;
    int     count = 0;
    int     i;
    char    filespec[MAXPATHLEN];
    char    filepath[MAXPATHLEN];

    if ((dirp = opendir (directory)) == NULL) {
	return 0;
    }

    while ((file = readdir (dirp)) != NULL) {
	if (Ematch (fileType->extension, file->d_name) &&
	    !Fmatch (file->d_name, fileType->extension, data)) {
	    strcpy (filepath, directory);
	    if (directory[strlen(directory) - 1] != '/')
		strcat (filepath, "/");
	    strcat (filepath, file->d_name);
	    if (ProcessFile(file, filepath, data, fileType))
		count++;
	}
    }
    closedir (dirp);
    return count;
}

static void DoDirectory(dir)
    char *dir;
{
    FontTable table;
    char dirName[MAXPATHLEN];
    FileType fileType;

    /* XXX unix dependent file-name mangling */
    strcpy(dirName, dir);
    if (dirName[strlen(dirName) - 1] != '/')
	strcat(dirName, "/");
    table = MakeFontTable(dirName, 5);
    for (fileType = fileTypes; fileType->extension; fileType++)
	(void)EnumFiles(dir, fileType, table);
    if (table->file.used > 0)
	WriteFontDir(table);
    FreeFontTable(table);
}

main (argc, argv)
    int argc;
    char **argv;
{
    int i;

    if (argc == 1)
	DoDirectory(".");
    else
	for (i = 1; i < argc; i++) {
	    DoDirectory(argv[i]);
 	}
    exit(0);	
}

Xfree (l)
unsigned long	*l;
{
	free ((char *) l);
}

unsigned long *
Xalloc (n)
unsigned long	n;
{
	extern char	*malloc ();

	return (unsigned long *) malloc ((unsigned) n);
}

unsigned long *
Xrealloc (l, n)
unsigned long	*l;
unsigned long	n;
{
	extern char	*realloc ();

	return (unsigned long *) realloc ((char *) l, (unsigned) n);
}

void
XmuCopyISOLatin1Lowered(dest, source)
    unsigned char *dest, *source;
{

    for (; *source; source++, dest++) {
	if ((*source >= XK_A) && (*source <= XK_Z))
	    *dest = *source + (XK_a - XK_A);
	else if ((*source >= XK_Agrave) && (*source <= XK_Odiaeresis))
	    *dest = *source + (XK_agrave - XK_Agrave);
	else if ((*source >= XK_Ooblique) && (*source <= XK_Thorn))
	    *dest = *source + (XK_oslash - XK_Ooblique);
	else
	    *dest = *source;
    }
    *dest = '\0';
}
