#include <dos.h>
#include <io.h>

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
typedef unsigned long u_long;

#include "netdef.h"
#include "in.h"
#include "protocol.h"
#include "net.h"
#include "tcp.h"	/* for State #defines */
#include "../msdos/msdos.h"
#include "sntcp.h"

#ifndef NULL
#define NULL 0
#endif

#define TCPCONN

#define BUFSIZE		512
#define MAXBUFSIZE	8192
#define MAXOUTBUF	8192
#define ANRSIZE		512

typedef struct _connectionInput {
    struct _connectionInput _near *next;
    char *buffer;               /* contains current client input */
    int  bufcnt;                /* count of bytes in buffer */
    int size;
} ConnectionInput, _near *ConnectionInputPtr;

typedef struct _connectionOutput {
    struct _connectionOutput _near *next;
    int size;
    unsigned char *buf;
    int count;
} ConnectionOutput, _near *ConnectionOutputPtr;

typedef struct _osComm {
    struct tcpport tcpport;
    int fd;
    ConnectionInputPtr input;
    ConnectionOutputPtr output;
    u_short flags;
    int client;
    unsigned long conn_time;
} OsCommRec, *OsCommPtr;

#define OS_REUSE	0x0001		/* re-use the request in the buffer */
#define OS_REQUEST	0x0002		/* full request left in input buffer */
#define OS_BLOCKED	0x0004		/* output write-blocked */
#define OS_CLOSING	0x0200		/* wait for output to drain first */

/* #define X_PRINT_PORT	5600 */
#define XDMCP
