	name	headland

	.286p

NUMPAGES	equ	1
HEADLAND	equ	1
VESA		equ	0

setpage	MACRO	page
	push	dx
	push	bx
	mov	bl,page
	mov	dx,3cch
	in	al,dx
	and	al,not 20h		; clear bit 5
	mov	ah,bl
	and	ah,2
	shl	ah,4
	or	al,ah
	mov	dx,3c2h
	out	dx,al
	mov	dx,3c4h
	mov	ah,bl
	and	ah,1
	mov	al,0f9h
	out	dx,ax
	and	bl,0ch
	mov	bh,bl
	shr	bh,2
	or	bl,bh
	mov	al,0f6h
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f0h
	or	al,bl
	out	dx,al
	pop	bx
	pop	dx
	ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs: _text, ds: _text, es:nothing

	org	0

include common.asm

	ASSUME	ds: _text
do_local	PROC NEAR
				; mode in reg al upon call
	mov	bl,al
	sub	bh,bh		; zero high byte
	push	bx
	mov	ax,6f05h	; extended BIOS call
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
	mov	ax,6f04h	; get current mode
	int	10h
	pop	bx
	cmp	bl,al		; check current mode with what we want
	jne	local_bad
	mov	dx,3c4h		; enable extended register bank access
	mov	ax,0e06h
	out	dx,ax
	mov	al,0ffh		; enable access to 2nd bank of 256k
	out	dx,al
	inc	dx
	in	al,dx
	or	al,10h		; force bit 4
	out	dx,al
	mov	bx,es:[di]	; check for BW or Color
	or	bh,bh
	jnz	local_color
	mov	ax,offset VGABW		; use this vga paginig routine
	mov	ret_data.page_off,ax
	mov	dx,3c4h
	mov	al,0f6h
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f0h
	out	dx,al
	jmp	short local_cont
local_color:
	mov	dl,0
	setpage	dl
local_cont:
	xor	ax,ax		; return OK
	ret
local_bad:
	mov	ax,08002h	; non-supported mode
	ret
do_local	ENDP
	ASSUME	ds: nothing

old_mode	db	?
mono_modes:
	dw	0011h		; 640x480 mono
	dw	0062h		; 800x600 16 colors
	dw	0065h		; 1024x768 16 colors
	dw	0		; 1280x1024 16 colors
color_modes:
	dw	0067h		; 640x480 256 colors
	dw	0069h		; 800x600 256 colors
	dw	0		; 1024x768 256 colors
	dw	0		; 1280x1024 256 colors

	ASSUME	ds: nothing
include copy.asm
include stipple.asm


;	VGABW	sets the VGA page for 1024x768 mono mode only
;
	ASSUME	ds: nothing
VGABW	PROC	FAR
	push	bp
	mov	bp,sp

	mov	ah,6[bp]
	and	ah,3
	mov	al,ah
	shl	al,2
	or	ah,al
	mov	dx,3c4h
	mov	al,0f6h
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f0h
	or	al,ah
	out	dx,al

	pop	bp
	ret
VGABW	ENDP

	ASSUME	ds: _text
Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP
	ASSUME	ds: nothing

copyright db	10, 13, 'Headland Video 7 driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
