#include "X.h"
#include "Xmd.h"
#include "Xproto.h"
#include "fontstruct.h"
#include "dixfontstr.h"
#include "scrnintstr.h"

#include "vga.h"

Bool
vgaRealizeFont( pscr, pFont)
    ScreenPtr	pscr;
    FontPtr	pFont;
{
#ifdef notdef
    /*
     * pGC->font is now known to be valid
     */
    int			index = pscr->myNum;
    FontInfoPtr		pfi = pFont->pFI;
    CharInfoPtr		maxb = &pfi->maxbounds;
    CharInfoPtr		minb = &pfi->minbounds;

    /*
     * pick the fastest output routines that can do the job.
     */
    if (   maxb->metrics.rightSideBearing -
   		minb->metrics.leftSideBearing > 32	/* big glyphs */
	  || pfi->drawDirection != FontLeftToRight
	  || pfi->noOverlap == 0)
	pFont->devPriv[ index] = (pointer)FT_VARPITCH;
    else  /* an optimizable case */
    {
	if (     maxb->metrics.leftSideBearing ==
		    minb->metrics.leftSideBearing /* fixed pitch */
	      && maxb->metrics.leftSideBearing == 0	  /* fixed pitch */
	      && maxb->metrics.rightSideBearing ==
	            minb->metrics.rightSideBearing /* fixed pitch */
	      && maxb->metrics.characterWidth ==
	            minb->metrics.characterWidth  /* fixed pitch */
	      && maxb->metrics.ascent ==
	            minb->metrics.ascent	  /* fixed height */
	      && maxb->metrics.descent ==
	            minb->metrics.descent)  /* fixed height */
	    pFont->devPriv[ index] = (pointer)FT_FIXPITCH;
	else
	    pFont->devPriv[ index] = (pointer)FT_SMALLPITCH;
    }
#endif
    return (TRUE);
}

Bool
vgaUnrealizeFont(pscr, pFont)
ScreenPtr	pscr;
FontPtr		pFont;
{
	return TRUE;
}
