/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: scrinit.c,v 1.57 88/10/02 15:08:27 rws Exp $ */

#include "X.h"
#include "Xproto.h"	/* for xColorItem */
#include "Xmd.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "resource.h"
#include "colormap.h"
#include "vga.h"
#include "cursor.h"
#include "..\common\ibmmouse.h"
#include "../../mi/mistruct.h"
#include "dix.h"
#include <dos.h>
#include "../../mi/mipointer.h"

#include "servermd.h"
#include <string.h>

extern int _near monitorResolution;

char near vga_oldmode = -1;

static VisualRec far visual = {
/* vid  class       bpRGB cmpE nplan rMask gMask bMask oRed oGreen oBlue */
   0,   PseudoColor, 6,   16,   4,    0,    0,    0,    0,   0,     0
};

static VisualID VID;

static DepthRec depth = {
/* depth	numVid		vids */
    4,		1,		&VID,
#ifdef notdef
    1,		0,		0
#endif
};

vgaPrivScr _near vgapriv;

Bool
vgainit(iScreen, pScreen, argc, argv)
int iScreen;
ScreenPtr pScreen;
int argc;
char **argv;
{
    ColormapPtr pColormap;
    union REGS regs;
    _segment	fb = 0xa000;
    int		mode = VGA_MODE;
    int		i;
    CARD16	zero = 0, ones = ~0;

    regs.h.ah = 0x0f;	/* get current video mode */
    int86(0x10, &regs, &regs);
    vga_oldmode = regs.h.al;

    while (argc > 0) {
	if (strcmp(*argv, "-mode") == 0) {
		argv++; argc--;
		if (!argc) {
			printf("bad -mode argument\n");
			break;
		}
		mode = atoi(*argv);
	}
	argv++; argc--;
    }

    if (vgaGeneration != serverGeneration)
    {
	vgaGCPrivateIndex = AllocateGCPrivateIndex();
/*	vgaScrPrivateIndex = AllocateScreenPrivateIndex(); */
	visual.vid = FakeClientID(0);
	VID = visual.vid;
	vgaGeneration = serverGeneration;
    }
    if (!AllocateGCPrivate(pScreen, vgaGCPrivateIndex, sizeof(vgaPrivGC)))
	return FALSE;

    regs.h.ah = 0;	/* set video mode */
    regs.h.al = (char)mode;
    int86(0x10, &regs, &regs);
    /* get crt size in pixels */
    regs.h.ah = 0xf;
    int86(0x10, &regs, &regs);

    pScreen->devPrivate = (pointer)&vgapriv;

    vgapriv.fb = fb;
    vgapriv.devKind = regs.h.ah;
    pScreen->width = (int)regs.h.ah * 8;
    pScreen->height = (*(unsigned char *)0x484 + 1) * *(unsigned short *)0x485;
/*
printf("vga: mode=%d, columns=%d, height=%d\n", regs.h.al, regs.h.ah, pScreen->height);
*/

    if (monitorResolution) {
	pScreen->mmWidth = pScreen->width * 25 / monitorResolution;
	pScreen->mmHeight = pScreen->height * 25 / monitorResolution;
    } else {
	pScreen->mmWidth = 250;
	pScreen->mmHeight = 180;
    }

    pScreen->numDepths = 1;
    pScreen->allowedDepths = &depth;

    pScreen->rootDepth = 8;
    pScreen->rootVisual = VID;
    pScreen->backingStoreSupport = NotUseful;
    pScreen->saveUnderSupport = NotUseful;

    pScreen->numVisuals = 1;
    pScreen->visuals = &visual;

    pScreen->CreateWindow = vgaCreateWindow;
    pScreen->DestroyWindow = vgaDestroyWindow;
    pScreen->PositionWindow = vgaPositionWindow;
    pScreen->RealizeWindow = vgaMapWindow;
    pScreen->UnrealizeWindow = vgaUnmapWindow;
    pScreen->ChangeWindowAttributes = vgaChangeWindowAttributes;
    pScreen->ValidateTree = miValidateTree;
    pScreen->WindowExposures = miWindowExposures;

    pScreen->ClearToBackground = miClearToBackground;
    pScreen->PaintWindowBackground = vgaPaintWindow;
    pScreen->PaintWindowBorder = vgaPaintWindow;
    pScreen->CopyWindow = vgaCopyWindow;

    pScreen->RealizeFont = vgaRealizeFont;
    pScreen->UnrealizeFont = vgaUnrealizeFont;
    pScreen->GetImage = miGetImage;
    pScreen->GetSpans = vgaGetSpans;
    pScreen->CreatePixmap = vgaCreatePixmap;
    pScreen->DestroyPixmap = vgaDestroyPixmap;

    pScreen->CreateColormap = vgaCreateColormap;
    pScreen->DestroyColormap = vgaDestroyColormap;
    pScreen->InstallColormap = vgaInstallColormap;
    pScreen->UninstallColormap = vgaUninstallColormap;
    pScreen->ListInstalledColormaps = vgaListInstalledColormaps;
    pScreen->StoreColors = vgaStoreColors;
    pScreen->ResolveColor = vgaResolveColor;

    pScreen->CreateGC = vgaCreateGC;

    pScreen->RegionCreate = miRegionCreate;
    pScreen->RegionInit = miRegionInit;
    pScreen->RegionCopy = miRegionCopy;
    pScreen->RegionDestroy = miRegionDestroy;
    pScreen->RegionUninit = miRegionUninit;
    pScreen->Intersect = miIntersect;
    pScreen->Inverse = miInverse;
    pScreen->Union = miUnion;
    pScreen->Subtract = miSubtract;
    pScreen->RegionReset = miRegionReset;
    pScreen->TranslateRegion = miTranslateRegion;
    pScreen->RectIn = miRectIn;
    pScreen->PointInRegion = miPointInRegion;
    pScreen->RegionNotEmpty = miRegionNotEmpty;
    pScreen->RegionEmpty = miRegionEmpty;
    pScreen->RegionExtents = miRegionExtents;
    pScreen->RegionAppend = miRegionAppend;
    pScreen->RegionValidate = miRegionValidate;
#ifdef SHAPE
    pScreen->BitmapToRegion = mfbPixmapToRegion;
    pScreen->RectsToRegion = miRectsToRegion;
#endif
    pScreen->SendGraphicsExpose = miSendGraphicsExpose;

    pScreen->CloseScreen = vgaClose;
    pScreen->SaveScreen = vgaSaveScreen;

    /*
     * Cursor functions
     */
    pScreen->PointerNonInterestBox = mousePointerNonInterestBox;
    pScreen->RealizeCursor = mouseRealizeCursor;
    pScreen->UnrealizeCursor = mouseUnrealizeCursor;
    pScreen->DisplayCursor = mouseDisplayCursor;
    pScreen->SetCursorPosition = mouseSetCursorPosition;
    pScreen->CursorLimits = mouseCursorLimits;
    pScreen->ConstrainCursor = mouseConstrainCursor;
    pScreen->RecolorCursor = vgaRecolorCursor;

    pScreen->QueryBestSize = vgaQueryBestSize;

    /* os layer stuff */
#ifdef notused
    pScreen->BlockHandler = vgaBlockHandler;
    pScreen->WakeupHandler = vgaWakeupHandler;
    pScreen->wakeupData = (pointer)0;
    pScreen->blockData = (pointer)0;
#endif

    pScreen->defColormap = (Colormap) FakeClientID(0);
    pScreen->minInstalledCmaps = 1;
    pScreen->maxInstalledCmaps = 1;
    pScreen->whitePixel = 0xf;
    pScreen->blackPixel = 0;
    if ((i = CreateColormap(pScreen->defColormap, pScreen, &visual,
	&pColormap, AllocNone, 0)) != Success || pColormap == NULL) {
		ErrorF("vgainit: CreateColormap returned %d\n", i);
		ErrorF("memavl=%u\n", _memavl());
		return FALSE;
    }
    if (AllocColor(pColormap, &zero, &zero, &zero, (&pScreen->blackPixel), 0) ||
	AllocColor(pColormap, &ones, &ones, &ones, (&pScreen->whitePixel), 0))
		FatalError("vgaInit: Can't alloc black & white pixels\n");
    vgaInstallColormap(pColormap);

#ifndef DIRECT_MOUSE
    /* Initialize the mouse to black on white */
    vgaCursor.fore_color = pScreen->blackPixel;
    vgaCursor.back_color = pScreen->whitePixel;
    vgaCursor.depth = depth.depth;
#endif

    return TRUE;
}

/* Should this be a 8-bit array? */
int near endtab[16] = 
	{
	0x0000,
	0x8000,
	0xC000,
	0xE000,
	0xF000,
	0xF800,
	0xFC00,
	0xFE00,
	0xFF00,
	0xFF80,
	0xFFC0,
	0xFFE0,
	0xFFF0,
	0xFFF8,
	0xFFFC,
	0xFFFE
	};

void _near
screen_abort()
{
	if (vga_oldmode != -1)
		vgaClose(0, (ScreenPtr)0);
}
