#include "X.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "misc.h"
#include "window.h"
#include "windowstr.h"
#include "dix.h"
#include <dos.h>
#include "scrnintstr.h"
#include "gcstruct.h"
#include "servermd.h"
#include "pixmap.h"
#include "pixmapst.h"
#include "vga.h"

extern char near vga_oldmode;

int _near
vgaprobe(i, pScreenInfo, argc, argv)
int i;
ScreenInfo _near *pScreenInfo;
int argc;
char **argv;
{
    union REGS regs;

    regs.h.ah = 0x12;
    regs.h.bl = 0x10;
    int86(0x10, &regs, &regs);
    if (regs.h.bl == 0x10)
	return 0;
    AddScreen(vgainit, argc, argv);
    return 1;
}

Bool
vgaClose(index, pScreen)
int index;
ScreenPtr pScreen;
{
    union REGS regs;

    if (vga_oldmode != -1) {
	regs.h.ah = 0;	/* set video mode */
	regs.h.al = vga_oldmode;
	int86(0x10, &regs, &regs);
	vga_oldmode = -1;
    }
    if (pScreen == 0)
	return FALSE;
    pScreen->devPrivate = 0;
    return TRUE;
}

vgaSaveScreen(pScr, on)
ScreenPtr pScr;
int on;
{

	outp(0x3c4, 1);
	if (on == SCREEN_SAVER_OFF)
		outp(0x3c5, inp(0x3c5) & ~0x20);
	else
		outp(0x3c5, inp(0x3c5) | 0x20);
	return TRUE;
}

void
vgaQueryBestSize(kind, pWidth, pHeight)
int kind;
unsigned short *pWidth, *pHeight;
{
	unsigned width, test;

	switch (kind) {
	    case CursorShape:
#ifdef DIRECT_MOUSE
		*pWidth = 16;
		*pHeight = 16;
#endif
		break;
	    case TileShape:
	    case StippleShape:
		width = *pWidth;
		if (width > 0) {
			/* Find the smallest power of two greater than
			 * width. */
			test = 1;
			while (test < width)
				test <<= 1;
			*pWidth = test;
		}
		break;
	}
}
