/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: scrinit.c,v 1.57 88/10/02 15:08:27 rws Exp $ */

#include <string.h>
#include <fcntl.h>
#include "X.h"
#include "Xproto.h"	/* for xColorItem */
#include "Xmd.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "resource.h"
#include "colormap.h"
#include "ega.h"
#include "cursor.h"
#include "..\common\ibmmouse.h"
#include "../../mi/mistruct.h"
#include "dix.h"
#include <dos.h>
#include "../../mi/mipointer.h"

#include "servermd.h"

extern int _near monitorResolution;

static VisualRec far visual = {
/* vid  class       bpRGB cmpE nplan rMask gMask bMask oRed oGreen oBlue */
   0,   StaticGray, 1,    2,   1,    0,    0,    0,    0,   0,     0
};

static VisualID VID;

static DepthRec depth = {
/* depth	numVid		vids */
    1,		1,		&VID
};

egaPrivScr _near egapriv;
struct vga_conf _near vga_conf;

struct resolution {
	int width, height;
};

static struct resolution vga_res[] = {
    { 0,	0},
    { 640,	480},
    { 800,	600},
    { 1024,	768}
};

static void vga_open(int);
static void _far vga_close(void);
static void _far vga_noop(int);

Bool
egainit(iScreen, pScreen, argc, argv)
int iScreen;
ScreenPtr pScreen;
int argc;
char **argv;
{
    ColormapPtr pColormap;
    union REGS regs;
    _segment	fb = 0xa000;
    int		mode = 1;
    int		fd, i;

    while (argc > 0) {
	if (strcmp(*argv, "-mode") == 0) {
		argv++; argc--;
		if (!argc) {
			printf("bad -mode argument\n");
			break;
		}
		mode = atoi(*argv);
	}
	argv++; argc--;
    }

    if (i = _dos_open("XWVGA", O_RDONLY, &fd)) {
	fd = -1;
    }

    if (egaGeneration != serverGeneration)
    {
	egaGCPrivateIndex = AllocateGCPrivateIndex();
/*	egaScrPrivateIndex = AllocateScreenPrivateIndex(); */
	visual.vid = FakeClientID(0);
	VID = visual.vid;
	egaGeneration = serverGeneration;
    }
    if (!AllocateGCPrivate(pScreen, egaGCPrivateIndex, sizeof(egaPrivGC)))
	return FALSE;

    if (fd < 0) {
	if (mode != 1 && mode != 2) {
	    fprintf(stderr, "Mode %x is not supported by your VGA card.\n", mode);
	    return FALSE;
	}
	vga_conf.version = 0;
	vga_conf.close = vga_close;
	vga_conf.page = vga_noop;
	vga_conf.copy = 0;
	vga_conf.move = 0;
	vga_open(mode);
    } else {
	regs.h.ah = 0x44;
	regs.h.al = 3;
	regs.x.bx = fd;
	regs.x.cx = sizeof mode;
	regs.x.dx = (short)&mode;
	intdos(&regs, &regs);
	if (regs.x.cflag) {
	    fprintf(stderr, "Mode %x is not supported by your VGA card.\n", mode);
	    (void)_dos_close(fd);
	    return FALSE;
	}

	regs.h.ah = 0x44;
	regs.h.al = 2;
	regs.x.bx = fd;
	regs.x.cx = sizeof vga_conf;
	regs.x.dx = (short)&vga_conf;
	intdos(&regs, &regs);
	if (regs.x.cflag) {
	    fprintf(stderr, "XWVGA: read failed error code %d\n", regs.x.ax);
	    (void)_dos_close(fd);
	    return FALSE;
	}
	(void)_dos_close(fd);
    }
    egapriv.curpage = 0;

    pScreen->devPrivate = (pointer)&egapriv;

    egapriv.fb = fb;
    egapriv.devKind = vga_res[mode].width >> 3;
    egapriv.hires = mode >= 3;
    pScreen->width = vga_res[mode].width;
    pScreen->height = vga_res[mode].height;

    if (monitorResolution) {
	pScreen->mmWidth = pScreen->width * 25 / monitorResolution;
	pScreen->mmHeight = pScreen->height * 25 / monitorResolution;
    } else {
	pScreen->mmWidth = 250;
	pScreen->mmHeight = 180;
    }

    pScreen->numDepths = 1;
    pScreen->allowedDepths = &depth;

    pScreen->rootDepth = 1;
    pScreen->rootVisual = VID;
    pScreen->defColormap = (Colormap) FakeClientID(0);
    pScreen->minInstalledCmaps = 1;
    pScreen->maxInstalledCmaps = 1;
    pScreen->whitePixel = 1;
    pScreen->blackPixel = 0;
    pScreen->backingStoreSupport = NotUseful;
    pScreen->saveUnderSupport = NotUseful;

    pScreen->numVisuals = 1;
    pScreen->visuals = &visual;

    pScreen->CreateWindow = egaCreateWindow;
    pScreen->DestroyWindow = egaDestroyWindow;
    pScreen->PositionWindow = egaPositionWindow;
    pScreen->RealizeWindow = egaMapWindow;
    pScreen->UnrealizeWindow = egaUnmapWindow;
    pScreen->ChangeWindowAttributes = egaChangeWindowAttributes;
    pScreen->ValidateTree = miValidateTree;
    pScreen->WindowExposures = miWindowExposures;

    pScreen->ClearToBackground = miClearToBackground;
    pScreen->PaintWindowBackground = egaPaintWindow;
    pScreen->PaintWindowBorder = egaPaintWindow;
    pScreen->CopyWindow = egaCopyWindow;

    pScreen->RealizeFont = egaRealizeFont;
    pScreen->UnrealizeFont = egaUnrealizeFont;
    pScreen->GetImage = egaGetImage;
    pScreen->GetSpans = egaGetSpans;
    pScreen->CreatePixmap = egaCreatePixmap;
    pScreen->DestroyPixmap = egaDestroyPixmap;

    pScreen->CreateColormap = egaCreateColormap;
    pScreen->DestroyColormap = egaDestroyColormap;
    pScreen->InstallColormap = egaInstallColormap;
    pScreen->UninstallColormap = egaUninstallColormap;
    pScreen->ListInstalledColormaps = egaListInstalledColormaps;
    pScreen->StoreColors = NoopDDA;
    pScreen->ResolveColor = egaResolveColor;

    pScreen->CreateGC = egaCreateGC;

    pScreen->RegionCreate = miRegionCreate;
    pScreen->RegionInit = miRegionInit;
    pScreen->RegionCopy = miRegionCopy;
    pScreen->RegionDestroy = miRegionDestroy;
    pScreen->RegionUninit = miRegionUninit;
    pScreen->Intersect = miIntersect;
    pScreen->Inverse = miInverse;
    pScreen->Union = miUnion;
    pScreen->Subtract = miSubtract;
    pScreen->RegionReset = miRegionReset;
    pScreen->TranslateRegion = miTranslateRegion;
    pScreen->RectIn = miRectIn;
    pScreen->PointInRegion = miPointInRegion;
    pScreen->RegionNotEmpty = miRegionNotEmpty;
    pScreen->RegionEmpty = miRegionEmpty;
    pScreen->RegionExtents = miRegionExtents;
    pScreen->RegionAppend = miRegionAppend;
    pScreen->RegionValidate = miRegionValidate;
#ifdef SHAPE
    pScreen->BitmapToRegion = mfbPixmapToRegion;
    pScreen->RectsToRegion = miRectsToRegion;
#endif
    pScreen->SendGraphicsExpose = miSendGraphicsExpose;

    pScreen->CloseScreen = egaClose;
    pScreen->SaveScreen = egaSaveScreen;

    /*
     * Cursor functions
     */
    pScreen->PointerNonInterestBox = mousePointerNonInterestBox;
    pScreen->RealizeCursor = mouseRealizeCursor;
    pScreen->UnrealizeCursor = mouseUnrealizeCursor;
    pScreen->DisplayCursor = mouseDisplayCursor;
    pScreen->SetCursorPosition = mouseSetCursorPosition;
    pScreen->CursorLimits = mouseCursorLimits;
    pScreen->ConstrainCursor = mouseConstrainCursor;
    pScreen->RecolorCursor = egaRecolorCursor;

    pScreen->QueryBestSize = egaQueryBestSize;

    /* os layer stuff */
#ifdef notused
    pScreen->BlockHandler = egaBlockHandler;
    pScreen->WakeupHandler = egaWakeupHandler;
    pScreen->wakeupData = (pointer)0;
    pScreen->blockData = (pointer)0;
#endif
    if ((i = CreateColormap(pScreen->defColormap, pScreen, &visual,
	&pColormap, AllocNone, 0)) != Success ||
	    pColormap == NULL) {
		ErrorF("egainit: CreateColormap returned %d\n", i);
		ErrorF("memavl=%u\n", _memavl());
		return FALSE;
    }
    egaInstallColormap(pColormap);

    return TRUE;
}

/* Should this be a 8-bit array? */
int near endtab[16] = 
	{
	0x0000,
	0x8000,
	0xC000,
	0xE000,
	0xF000,
	0xF800,
	0xFC00,
	0xFE00,
	0xFF00,
	0xFF80,
	0xFFC0,
	0xFFE0,
	0xFFF0,
	0xFFF8,
	0xFFFC,
	0xFFFE
	};

void _near
screen_abort()
{
	if (egapriv.fb)
		egaClose(0, (ScreenPtr)0);
}

/* The cursor is black and white.  Therefore we don't need to do much
 * work here.
 */
void
egaRecolorCursor( pScr, pCurs, displayed)
    ScreenPtr	pScr;
    CursorPtr	pCurs;
    Bool	displayed;
{
}

static char oldmode;

static void _far
vga_close()
{
    union REGS regs;

    regs.h.ah = 0;
    regs.h.al = oldmode;
    int86(0x10, &regs, &regs);
}

static void
vga_open(mode)
int mode;
{
    union REGS regs;

    regs.h.ah = 0xf;
    int86(0x10, &regs, &regs);
    oldmode = regs.h.al;
    regs.h.ah = 0;
    regs.h.al = mode == 1 ? 0x11 : 0x6a;
    int86(0x10, &regs, &regs);
}

static void _far
vga_noop(x)
int x;
{
}
