/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: mfbbres.c,v 1.12 88/09/06 14:53:36 jim Exp $ */
#include "X.h"
#include "misc.h"
#include "ega.h"

/* Solid bresenham line */
/* NOTES
   e2 is used less often than e1, so it's not in a register
*/
#define SEG_CHANGE	(yinc < 0 && (u_short)addrl > 0xff80 || \
			 yinc > 0 && (u_short)addrl < 0x80)

void near
mfbBresS(rop, addr, base, nlwidth, signdx, signdy, axis, x1, y1, e, e1, e2, len)
int rop;		/* a reduced rasterop */

_segment base;
char _based(void) *addr;
int nlwidth;		/* width in longwords of bitmap */
int signdx, signdy;	/* signs of directions */
int axis;		/* major axis (Y_AXIS or X_AXIS) */
int x1, y1;		/* initial point */
int e;		/* error accumulator */
int e1;	/* bresenham increments */
int e2;
int len;	/* length of line */

{
    register int yinc;	/* increment to next scanline */
    register int addrb;		/* bitmask */
    char _based(base) *addrl = addr;

    /* point to longword containing first point */
    addrl = addrl + (y1 * nlwidth) + (x1 >> 3);
#ifdef EGA_TSENG
    if (egapriv.hires && base == egapriv.fb) {
	if (y1 < TSENG_LPP) {
	    if (egapriv.curpage)
		(*vga_conf.page)(egapriv.curpage = 0);
	} else if (!egapriv.curpage)
	    (*vga_conf.page)(egapriv.curpage = 1);
    }
#endif
    addrb = x1&07;
    yinc = signdy * nlwidth;

    if (rop == RROP_BLACK)
    {
        if (axis == X_AXIS)
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addrl &= ~(0x80>>addrb);
		    if (e < 0)
		        e += e1;
		    else
		    {
		        addrl += yinc;
#ifdef EGA_TSENG
			if (egapriv.hires && base == egapriv.fb) {
			    /* see if this increment has caused
			     * addrl to overlap */
			    if (SEG_CHANGE) {
				if (egapriv.curpage)
				    (*vga_conf.page)(egapriv.curpage = 0);
				else
				    (*vga_conf.page)(egapriv.curpage = 1);
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 7)
		    {
		        addrb = -1;
		        addrl++;
		    }
		    addrb++;
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addrl &= ~(0x80 >>addrb);
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        addrl += yinc;
#ifdef EGA_TSENG
			if (egapriv.hires && base == egapriv.fb) {
			    /* see if this increment has caused
			     * addrl to overlap */
			    if (SEG_CHANGE) {
				if (egapriv.curpage)
				    (*vga_conf.page)(egapriv.curpage = 0);
				else
				    (*vga_conf.page)(egapriv.curpage = 1);
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 0)
		    {
		        addrb = 8;
		        addrl--;
		    }
		    addrb--;
	        }
	    }
        } /* if X_AXIS */
        else
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addrl &= ~(0x80 >>addrb);
		    if (e < 0)
		        e += e1;
		    else
		    {
		        if (addrb == 7)
		        {
			    addrb = -1;
			    addrl++;
		        }
		        addrb++;
		        e += e2;
		    }
		    addrl += yinc;
#ifdef EGA_TSENG
		    if (egapriv.hires && base == egapriv.fb) {
			/* see if this increment has caused
			 * addrl to overlap */
			if (SEG_CHANGE) {
			    if (egapriv.curpage)
				(*vga_conf.page)(egapriv.curpage = 0);
			    else
				(*vga_conf.page)(egapriv.curpage = 1);
			}
		    }
#endif
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addrl &= ~(0x80>>addrb);
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        if (addrb == 0)
		        {
			    addrb = 8;
			    addrl--;
		        }
		        addrb--;
		        e += e2;
		    }
		    addrl += yinc;
#ifdef EGA_TSENG
		    if (egapriv.hires && base == egapriv.fb) {
			/* see if this increment has caused
			 * addrl to overlap */
			if (SEG_CHANGE) {
			    if (egapriv.curpage)
				(*vga_conf.page)(egapriv.curpage = 0);
			    else
				(*vga_conf.page)(egapriv.curpage = 1);
			}
		    }
#endif
	        }
	    }
        } /* else Y_AXIS */
    } 
    else if (rop == RROP_WHITE)
    {
        if (axis == X_AXIS)
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addrl |= 0x80>>addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        addrl += yinc;
#ifdef EGA_TSENG
			if (egapriv.hires && base == egapriv.fb) {
			    /* see if this increment has caused
			     * addrl to overlap */
			    if (SEG_CHANGE) {
				if (egapriv.curpage)
				    (*vga_conf.page)(egapriv.curpage = 0);
				else
				    (*vga_conf.page)(egapriv.curpage = 1);
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 7)
		    {
		        addrb = -1;
		        addrl++;
		    }
		    addrb++;
	        }
	    }
	    else
	    {
		while(len--)
	        {
		    *addrl |= 0x80 >>addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        addrl += yinc;
#ifdef EGA_TSENG
			if (egapriv.hires && base == egapriv.fb) {
			    /* see if this increment has caused
			     * addrl to overlap */
			    if (SEG_CHANGE) {
				if (egapriv.curpage)
				    (*vga_conf.page)(egapriv.curpage = 0);
				else
				    (*vga_conf.page)(egapriv.curpage = 1);
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 0)
		    {
		        addrb = 8;
		        addrl--;
		    }
		    addrb--;
	        }
	    }
        } /* if X_AXIS */
        else
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addrl |= 0x80 >>addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        if (addrb == 7)
		        {
			    addrb = -1;
			    addrl++;
		        }
		        addrb++;
		        e += e2;
		    }
		    addrl += yinc;
#ifdef EGA_TSENG
		    if (egapriv.hires && base == egapriv.fb) {
			/* see if this increment has caused
			 * addrl to overlap */
			if (SEG_CHANGE) {
			    if (egapriv.curpage)
				(*vga_conf.page)(egapriv.curpage = 0);
			    else
				(*vga_conf.page)(egapriv.curpage = 1);
			}
		    }
#endif
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addrl |= 0x80 >>addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        if (addrb == 0)
		        {
			    addrb = 8;
			    addrl--;
		        }
		        addrb--;
		        e += e2;
		    }
		    addrl += yinc;
#ifdef EGA_TSENG
		    if (egapriv.hires && base == egapriv.fb) {
			/* see if this increment has caused
			 * addrl to overlap */
			if (SEG_CHANGE) {
			    if (egapriv.curpage)
				(*vga_conf.page)(egapriv.curpage = 0);
			    else
				(*vga_conf.page)(egapriv.curpage = 1);
			}
		    }
#endif
	        }
	    }
        } /* else Y_AXIS */
    }
    else if (rop == RROP_INVERT)
    {
        if (axis == X_AXIS)
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addrl ^= 0x80 >>addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        addrl += yinc;
#ifdef EGA_TSENG
			if (egapriv.hires && base == egapriv.fb) {
			    /* see if this increment has caused
			     * addrl to overlap */
			    if (SEG_CHANGE) {
				if (egapriv.curpage)
				    (*vga_conf.page)(egapriv.curpage = 0);
				else
				    (*vga_conf.page)(egapriv.curpage = 1);
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 7)
		    {
		        addrb = -1;
		        addrl++;
		    }
		    addrb++;
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addrl ^= 0x80 >> addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        addrl += yinc;
#ifdef EGA_TSENG
			if (egapriv.hires && base == egapriv.fb) {
			    /* see if this increment has caused
			     * addrl to overlap */
			    if (SEG_CHANGE) {
				if (egapriv.curpage)
				    (*vga_conf.page)(egapriv.curpage = 0);
				else
				    (*vga_conf.page)(egapriv.curpage = 1);
			    }
			}
#endif
		        e += e2;
		    }
		    if (addrb == 0)
		    {
		        addrb = 8;
		        addrl--;
		    }
		    addrb--;
	        }
	    }
        } /* if X_AXIS */
        else
        {
	    if (signdx > 0)
	    {
	        while(len--)
	        {
		    *addrl ^= 0x80 >> addrb;
		    if (e < 0)
		        e += e1;
		    else
		    {
		        if (addrb == 7)
		        {
			    addrb = -1;
			    addrl++;
		        }
		        addrb++;
		        e += e2;
		    }
		    addrl += yinc;
#ifdef EGA_TSENG
		    if (egapriv.hires && base == egapriv.fb) {
			/* see if this increment has caused
			 * addrl to overlap */
			if (SEG_CHANGE) {
			    if (egapriv.curpage)
				(*vga_conf.page)(egapriv.curpage = 0);
			    else
				(*vga_conf.page)(egapriv.curpage = 1);
			}
		    }
#endif
	        }
	    }
	    else
	    {
	        while(len--)
	        {
		    *addrl ^= 0x80 >> addrb;
		    if (e <= 0)
		        e += e1;
		    else
		    {
		        if (addrb == 0)
		        {
			    addrb = 8;
			    addrl--;
		        }
		        addrb--;
		        e += e2;
		    }
		    addrl += yinc;
#ifdef EGA_TSENG
		    if (egapriv.hires && base == egapriv.fb) {
			/* see if this increment has caused
			 * addrl to overlap */
			if (SEG_CHANGE) {
			    if (egapriv.curpage)
				(*vga_conf.page)(egapriv.curpage = 0);
			    else
				(*vga_conf.page)(egapriv.curpage = 1);
			}
		    }
#endif
	        }
	    }
        } /* else Y_AXIS */
    }
} 
