/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: ega.h,v 1.9 88/09/06 14:53:21 jim Exp $ */
/* Monochrome Frame Buffer definitions 
   written by drewry, september 1986
*/
#include <stdio.h>
#include <memory.h>
#include <conio.h>
#include "pixmap.h"
#include "region.h"
#include "gc.h"
#include "colormap.h"
#include "miscstruct.h"
#include "../../mi/mibstore.h"
#include "egafuncs.h"
#include "../common/ibmfuncs.h"

#define EGA_TSENG
#define EGA_HIRES
#define TSENG_LPP	512	/* scan lines per page */
#define HIRES_LPP	512	/* scan lines per page */

typedef struct _Window near * WindowPtr;
typedef struct _CharInfo *CharInfoPtr;

typedef struct {
	_segment	fb;	/* segment of frame buffer */
	unsigned	devKind;	/* width of screen in bytes */
	char	curpage;	/* 0 or 1 */
	char	hires;
} egaPrivScr;

extern egaPrivScr _near egapriv;

struct vga_conf {
	u_char	version;
	u_char	spare;
	void (_far *close)(void);
	void (_far *page)(int);
	void (_far *copy)(int, int, int, int, int, int);
	void (_far *move)(int, int, int, int, int, int, int);
};

extern struct vga_conf _near vga_conf;

extern u_char InverseAlu[];

extern void near clearbits(u_char *, u_char *, int, int, int);
extern void near andbits(u_char *, u_char *, int, int, int);
extern void near andReversebits(u_char *, u_char *, int, int, int);
extern void near copybits(u_char *, u_char *, int, int, int);
extern void near andInvertedbits(u_char *, u_char *, int, int, int);
extern void near noopbits(u_char *, u_char *, int, int, int);
extern void near xorbits(u_char *, u_char *, int, int, int);
extern void near orbits(u_char *, u_char *, int, int, int);
extern void near norbits(u_char *, u_char *, int, int, int);
extern void near equivbits(u_char *, u_char *, int, int, int);
extern void near invertbits(u_char *, u_char *, int, int, int);
extern void near orReversebits(u_char *, u_char *, int, int, int);
extern void near copyInvertedbits(u_char *, u_char *, int, int, int);
extern void near orInvertedbits(u_char *, u_char *, int, int, int);
extern void near nandbits(u_char *, u_char *, int, int, int);
extern void near setbits(u_char *, u_char *, int, int, int);

unsigned int near egaGeneration;
int near egaGCPrivateIndex;
int near egaScrPrivateIndex;

/*
   private filed of pixmap
   pixmap.devPrivate = (unsigned int *)pointer_to_bits
   pixmap.devKind = width_of_pixmap_in_bytes

   private field of screen
   a pixmap, for which we allocate storage.  devPrivate is a pointer to
the bits in the hardware framebuffer.  note that devKind can be poked to
make the code work for framebuffers that are wider than their
displayable screen (e.g. the early vsII, which displayed 960 pixels
across, but was 1024 in the hardware.)  this is left to the
code that calls egaScreenInit(), rather than having vgaScreenInit()
take yet another parameter.

   private field of GC 
	pAbsClientRegion is always a real region, although perhaps
an empty one.
	Freeing pCompositeClip is done based on the value of
freeCompClip; if freeCompClip is not carefully maintained, we will end
up losing storage or freeing something that isn't ours.
*/

typedef struct {
    unsigned char	rop;		/* reduction of rasterop to 1 of 3 */
    unsigned char	ropOpStip;	/* rop for opaque stipple */
    short	fExpose;		/* callexposure handling ? */
    short	freeCompClip;
    PixmapPtr	pRotatedTile;		/* tile/stipple  rotated to align */
    PixmapPtr	pRotatedStipple;	/* with window and using offsets */
    RegionPtr	pAbsClientRegion;	/* client region in screen coords */
    RegionPtr	pCompositeClip;		/* free this based on freeCompClip
					   flag rather than NULLness */
    void 	(near * FillArea)(u_char *, u_char *, int, int, int);
    void	(near * movebits)(u_char *, u_char *, int, int, int);
			/* depends only on rop */
    PixmapPtr	*ppPixmap;		/* pointer to tile/stipple ptr */
    short	flags;
    u_char	*fillBits;		/* copied from tile/stipple */
    } egaPrivGC;
typedef egaPrivGC	*vgaPrivGCPtr;

#define EGA_FILLSOLID		0x0001
#define EGA_FASTFILL		0x0002
#define EGA_EGAONE		0x0004
#define EGA_EGAZERO		0x0008

/* freeCompositeClip values */
#define REPLACE_CC	0		/* compsite clip is a copy of a
					   pointer, so it doesn't need to 
					   be freed; just overwrite it.
					   this happens if there is no
					   client clip and the gc has
					   ClipByChildren in it.
					*/
#define FREE_CC		1		/* composite clip is a real
					   region that we need to free
					*/

/* precomputed information about each glyph for GlyphBlt code.
   this saves recalculating the per glyph information for each
box.
*/
typedef struct _pos{
    int xpos;		/* xposition of glyph's origin */
    int xchar;		/* x position mod 32 */
    int leftEdge;
    int rightEdge;
    int topEdge;
    int bottomEdge;
    unsigned int *pdstBase;	/* longword with character origin */
    int widthGlyph;	/* width in bytes of this glyph */
} TEXTPOS;

/* reduced raster ops for ega */
#define RROP_BLACK	GXclear
#define RROP_WHITE	GXset
#define RROP_NOP	GXnoop
#define RROP_INVERT	GXinvert

/* out of clip region codes */
#define OUT_LEFT 0x08
#define OUT_RIGHT 0x04
#define OUT_ABOVE 0x02
#define OUT_BELOW 0x01

/* major axis for bresenham's line */
#define X_AXIS	0
#define Y_AXIS	1

/* optimization codes for FONT's devPrivate field */
#define FT_VARPITCH	0
#define FT_SMALLPITCH	1
#define FT_FIXPITCH	2

/* macros for egabitblt.c, vgafillsp.c
   these let the code do one switch on the rop per call, rather
than a switch on the rop per item (span or rectangle.)
*/

#define fnCLEAR(src, dst)	(0)
#define fnAND(src, dst) 	(src & dst)
#define fnANDREVERSE(src, dst)	(src & ~dst)
#define fnCOPY(src, dst)	(src)
#define fnANDINVERTED(src, dst)	(~src & dst)
#define fnNOOP(src, dst)	(dst)
#define fnXOR(src, dst)		(src ^ dst)
#define fnOR(src, dst)		(src | dst)
#define fnNOR(src, dst)		(~(src | dst))
#define fnEQUIV(src, dst)	(~src ^ dst)
#define fnINVERT(src, dst)	(~dst)
#define fnORREVERSE(src, dst)	(src | ~dst)
#define fnCOPYINVERTED(src, dst)(~src)
#define fnORINVERTED(src, dst)	(~src | dst)
#define fnNAND(src, dst)	(~(src & dst))
#define fnSET(src, dst)		(~0)

#ifndef PURDUE
/* Binary search to figure out what to do for the raster op.  It may
 * do 5 comparisons, but at least it does no function calls 
 * Special cases copy because it's so frequent 
 */
#define DoRop(alu, src, dst) \
( ((alu) == GXcopy) ? (src) : \
    (((alu) >= GXnor) ? \
     (((alu) >= GXcopyInverted) ? \
       (((alu) >= GXnand) ? \
         (((alu) == GXnand) ? ~((src) & (dst)) : ~0) : \
         (((alu) == GXcopyInverted) ? ~(src) : (~(src) | (dst)))) : \
       (((alu) >= GXinvert) ? \
	 (((alu) == GXinvert) ? ~(dst) : ((src) | ~(dst))) : \
	 (((alu) == GXnor) ? ~((src) | (dst)) : (~(src) ^ (dst)))) ) : \
     (((alu) >= GXandInverted) ? \
       (((alu) >= GXxor) ? \
	 (((alu) == GXxor) ? ((src) ^ (dst)) : ((src) | (dst))) : \
	 (((alu) == GXnoop) ? (dst) : (~(src) & (dst)))) : \
       (((alu) >= GXandReverse) ? \
	 (((alu) == GXandReverse) ? ((src) & ~(dst)) : (src)) : \
	 (((alu) == GXand) ? ((src) & (dst)) : 0)))  ) )
#else  /* PURDUE */
/*  Using a "switch" statement is much faster in most cases
 *  since the compiler can do a look-up table or multi-way branch
 *  instruction, depending on the architecture.  The result on
 *  A Sun 3/50 is at least 2.5 times faster, assuming a uniform
 *  distribution of RasterOp operation types.
 *
 *  However, doing some profiling on a running system reveals
 *  GXcopy is the operation over 99.5% of the time and
 *  GXcopy is the next most frequent (about .4%), so we make special
 *  checks for those first.
 *
 *  Note that this requires a change to the "calling sequence"
 *  since we can't engineer a "switch" statement to have an lvalue.
 */
#define DoRop(result, alu, src, dst) \
{ \
    if (alu == GXcopy) \
	result = fnCOPY (src, dst); \
    else if (alu == GXxor) \
        result = fnXOR (src, dst); \
    else \
	switch (alu) \
	{ \
	  case GXclear: \
	    result = fnCLEAR (src, dst); \
	    break; \
	  case GXand: \
	    result = fnAND (src, dst); \
	    break; \
	  case GXandReverse: \
	    result = fnANDREVERSE (src, dst); \
	    break; \
	  case GXandInverted: \
	    result = fnANDINVERTED (src, dst); \
	    break; \
	  case GXnoop: \
	    result = fnNOOP (src, dst); \
	    break; \
	  case GXor: \
	    result = fnOR (src, dst); \
	    break; \
	  case GXnor: \
	    result = fnNOR (src, dst); \
	    break; \
	  case GXequiv: \
	    result = fnEQUIV (src, dst); \
	    break; \
	  case GXinvert: \
	    result = fnINVERT (src, dst); \
	    break; \
	  case GXorReverse: \
	    result = fnORREVERSE (src, dst); \
	    break; \
	  case GXcopyInverted: \
	    result = fnCOPYINVERTED (src, dst); \
	    break; \
	  case GXorInverted: \
	    result = fnORINVERTED (src, dst); \
	    break; \
	  case GXnand: \
	    result = fnNAND (src, dst); \
	    break; \
	  case GXset: \
	    result = fnSET (src, dst); \
	    break; \
	} \
}
#endif  /* PURDUE */

#define DoRRop(alu, src, dst) \
(((alu) == RROP_BLACK) ? ((dst) & ~(src)) : \
 ((alu) == RROP_WHITE) ? ((dst) | (src)) : \
 ((alu) == RROP_INVERT) ? ((dst) ^ (src)) : \
  (dst))

extern char GXtoEGA[];

#define EGA_OP		0x03
#define EGA_COPY	0x00
#define EGA_AND		0x01
#define EGA_OR		0x02
#define EGA_XOR		0x03

#define EGA_PREOP	0x0c
#define EGA_ZERO	0x04	/* send zero */
#define EGA_ONE		0x08	/* send one */
#define EGA_INVERT	0x0c	/* invert src before sending */

struct egaCursor {
	struct _Screen *pScreen;
	struct _CursorBits *pBits;
	int pos_x, pos_y;
	u_char isUp;
	u_char validSaved;
	u_char reDraw;
	u_char shouldBeUp;
	BoxRec saved;		/* region under cursor saved */
	char *pSaved;		/* pointer to saved data */
	int save_size;		/* size in bytes of pSaved */
	int screen_width, screen_height;
};

int	near mouse_X, near mouse_Y;

extern struct egaCursor _near egaCursor;

#define CUR_OVERLAP(X1,Y1,X2,Y2) ((egaCursor.isUp || egaCursor.validSaved) && \
				(X1) < egaCursor.saved.x2 && \
				(X2) > egaCursor.saved.x1 && \
				(Y1) < egaCursor.saved.y2 && \
				(Y2) > egaCursor.saved.y1)
