#include "Xmd.h"
#include "pixmapstr.h"
#include "os.h"		/* for malloc.h */

#include "i8.h"
#include "../../mi/mi.h"

#include "servermd.h"

#include "site.h"

PixmapPtr
i8CreatePixmap(pScreen, width, height, depth)
ScreenPtr pScreen;
int width, height, depth;
{
	long lsize;
	PixmapPtr pPixmap;

	lsize = (long)height * PixmapBytePad(width, depth);
	if (lsize & 0xffff0000)
		return (PixmapPtr)NULL;
	pPixmap = (PixmapPtr)_nmalloc(sizeof(PixmapRec));
	if (!pPixmap)
		return (PixmapPtr)NULL;
	pPixmap->drawable.type = DRAWABLE_PIXMAP;
	pPixmap->drawable.pScreen = pScreen;
	pPixmap->drawable.depth = (u_char)depth;
	pPixmap->drawable.bitsPerPixel = (u_char)depth;
	pPixmap->drawable.width = width;
	pPixmap->drawable.height = height;
	pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
	pPixmap->drawable.x = 0;
	pPixmap->drawable.y = 0;
	pPixmap->refcnt = 1;
	pPixmap->devKind = PixmapBytePad(width, depth);
	if (!(pPixmap->devPrivate.ptr = (char *)xalloc((int)lsize))) {
		_nfree(pPixmap);
		return (PixmapPtr)NULL;
	} else {
		bzero((char *)pPixmap->devPrivate.ptr, (int)lsize);
	}
	return pPixmap;
}

Bool
i8DestroyPixmap(pPixmap)
PixmapPtr pPixmap;
{
	if (--pPixmap->refcnt)
		return TRUE;
	Xfree(pPixmap->devPrivate.ptr);
	_nfree(pPixmap);
	return TRUE;
}
