/*************************************************************************/
/*  TCP states
*     each connection has an associated state in the connection flow.
*     the order of the states now matters, those less than a certain
*     number are the "inactive" states.
*/
#define SCLOSED 1
#define SLISTEN 2
#define SSYNRS	3	/* SSYNR from SSYNS */
#define SSYNR   4
#define SSYNS	5
#define SEST	6
#define SFW1	7
#define SFW2	8
#define SCLOSING 9
#define SCWAIT	10
#define SLAST	11
#define STWAIT	12

#define MINRTO	18		/* actually 18.2 ticks per second */
#define MAXRTO	1820		/* this makes MAXRTO 100 seconds */
#define MSS_SMALL	(512-40)
#define WAITTIME 546		/* time to wait in TIME_WAIT state (30 secs) */
#define TSENDSIZE 1024		/* MSS */
#define SLIPSENDSIZE 768	/* MSS if we are running SLIP */
#define MAXRESENDS	10
