#define htons(x) ((u_short)((u_char)(x) << 8) | (u_char)((u_short)(x) >> 8))
#define ntohs(x) ((u_short)((u_char)(x) << 8) | (u_char)((u_short)(x) >> 8))
#define min(x,y) ((x) < (y) ? (x) : (y))

/*
 * intrinsics
 */
/* Since these are intrinsic, they can take either near or far pointers.
 * If we declare them as taking far pointers, the compiler will still do
 * the right thing if they are called with near pointers.
 */
void *memcpy(void _far *, void _far *, unsigned);
int memcmp(void _far *, void _far *, unsigned);
char *strcpy(char _far *, char _far *);
void *memset(void _far *, int, unsigned);

/*
 *	init.asm
 */
void intr_init(void);
void intr_exit(void);

/*
 *	main.c
 */
int rpc_entry(short _far *buf, int size);
int _fastcall tcp_init(short  _far *buf);
int _fastcall tcp_info(short _far *);
int _fastcall tcp_accept(short _far *);
int _fastcall tcp_drain(short _far *);
int _fastcall tcp_release(short _far *);
int _fastcall tcp_eof(short _far *);
int _fastcall tcp_read(short _far *);
int _fastcall tcp_write(short _far *);
int _fastcall tcp_recv(short _far *);
int _fastcall tcp_sendto(short _far *);
int _fastcall tcp_select(short _far *);

/*
 *	net.c
 */
int _fastcall tcp_shutdown(short  _far *buf);
int _fastcall tcp_socket(short _far *);
void protinit(void);
void free_port(struct port _far *);

/*
 *	io.c
 */
int _fastcall SoClose(unsigned);
/* temporary debug */
short cksum(short _far *, int);

/*
 *	arp.c
 */
void arpinit(void);
int _near sendarp(unsigned char *, unsigned long, unsigned);
void _near queuearp(unsigned char *, unsigned long, unsigned);
u_char _near * _near _fastcall cachelook(u_long);
void _fastcall arpinterpret(union rawether *, u_int);

/*
 *	bootp.c
 */
void set_netmask(void);

/*   
 *	dlayer.c
 */
unsigned char *netdlayer(unsigned long);

/*
 *	event.c
 */
void neteventinit(void);
void neteventshut(void);

/*
 *	icmp.c
 */
void icmpinterpret(union rawether *, unsigned);
void neticmpsend(unsigned long, unsigned char, unsigned char, void _far *, unsigned);

/*
 *	ip.c
 */

/*
 *	packet.c
 */
int _near pkopen(unsigned short, unsigned short, unsigned char);
void pkclose(void);

/*
 *	pkglue.asm
 */
void arp_receiver(void);
void pkt_receiver(void);
void _fastcall patch_vec(unsigned char);
int driver_info(struct packet_info *);
int access_type(int, int, int, void *, unsigned, void (*)());
int release_type(int);
int _fastcall pkxmit(void _far *, unsigned);
int get_address(int, char *, int);
int set_rcv_mode(int, int);

/*
 *	protinit.c
 */
void mbinit(void);

/*
 *	rarp.c
 */
int netgetrarp(void);

/*
 *	route.c
 */
unsigned long find_route(unsigned long);
void setgate(unsigned long, unsigned long);

/*
 *	tcp.c
 */
void tcpinterpret(union rawether *, unsigned);
void tcpsend(struct tcpport _far *p, u_int dlen);

/*
*      tools.c
*/
void tcptick(void);
void transq(struct tcpport _far *p);

/*
 *	udp.c
 */
void udpinterpret(union rawether *, unsigned);

/*
 *	support.asm
 */
unsigned long _fastcall n_clicks(void);
unsigned short _fastcall ipcheck(struct iph *, unsigned);
unsigned short _fastcall iphcheck(unsigned long);
unsigned short tcpcheck(struct pseudotcp *, struct tcph _far *, unsigned);
void _fastcall dfputs(char _near *);
void _fastcall printn(short);
void _fastcall printd(short);
int open(char _far *, unsigned char);
int read(int, char *, int);
int close(int);
unsigned long _fastcall htonl(unsigned long);
unsigned long _fastcall ntohl(unsigned long);
void _far * _fastcall alloc_seg(unsigned short);
void _fastcall dealloc_seg(unsigned short);

/*
 *	sleep.asm
 */
void netsleep(void);

/*
 *	pglue.asm
 */
int pglue_open(unsigned short, unsigned short, unsigned long);
void pglue_close(void);

/*
 *	packet.c
 */

/*
 *	os.c
 */
char _far * _fastcall getenv(char *var);
int _fastcall atoi(char *);
int _fastcall xtoi(char *);
int stricmp(char *, char *);
unsigned long _fastcall inet_addr(char *);
int _fastcall atoi(char *);

/*
 *	config.c
 */
int Sconfigure(char _far *, char);

/*
 *	bootp.c
 */
int bootp_process(void);
void parse_bootp(struct bootp *);

/*
 *	rarp.c
 */
int rarp_process(void);
