#define NET_TYPE_TCP	1
#define NET_TYPE_UDP	2

#define NETERR_ERRNO		1	/* error is in errno */
#define NETERR_ADDRINUSE	2
#define NETERR_NOMEM		3
#define NETERR_BADFD		4
#define NETERR_NETUNREACH	5
#define NETERR_HOSTUNREACH	6
#define NETERR_NOTESTAB		7
#define NETERR_BROADCAST	8
#define NETERR_WOULD_BLOCK	9
#define NETERR_TIMEOUT		10
#define NETERR_HOST		11
#define NETERR_BADCALL		12
#define NETERR_BADARGS		13
#define NETERR_SYSTEM		14	/* System error */
#define NETERR_NOSUPPORT	15
#define NETERR_CONNREFUSED	16
#define NETERR_NOTLOADED	17	/* transport kernel is not loaded */

#define NETERR_OTHER		18
#define MAX_NET_ERR		17

#define	NET_FLG_BROADCAST	0x0080

struct net_addr {
	unsigned long host;
	unsigned short socket;
};

struct net_info {
	unsigned long ip_address;
	unsigned long ip_broadcast;
};

#ifdef __WATCOMC__
int net_socket(int, struct net_addr *);
int net_info(int, struct net_info *);
int net_accept(int, struct net_addr *);
int net_select(int, unsigned long *, unsigned long *);

int net_read(int, void *, int);
int net_write(int, const void *, int);
int net_sendto(int, const void *, int, const struct net_addr *, int);
int net_recv(int, void *, int, struct net_addr *);

int net_drain(int);
int net_release(int);
int net_eof(int);

int net_open(const char *);
void net_shutdown(void);
void net_perror(const char *);

extern int neterrno;
void map_errno(int);
#endif
