#include <stdio.h>
#include <fcntl.h>
#include "config.h"

typedef unsigned char u_char;

main(argc, argv)
char **argv;
{
	struct conf conf;
	int fd;

	argc--; argv++;
	if (!argv) {
		fprintf(stderr, "Usage: printbf file[s]\n");
		exit(1);
	}
	for (; argc; argc--, argv++) {
		fd = open(*argv, O_BINARY|O_RDONLY);
		if (fd < 0) {
			perror(*argv);
			continue;
		}
		memset(&conf, 0, sizeof conf);
		(void) read(fd, &conf, sizeof conf);
		close(fd);
		printf("myip=%d.%d.%d.%d\n",
		    ((u_char *)&conf.myip)[0],
		    ((u_char *)&conf.myip)[1],
		    ((u_char *)&conf.myip)[2],
		    ((u_char *)&conf.myip)[3]);
		printf("snetmask=%d.%d.%d.%d\n",
		    ((u_char *)&conf.snetmask)[0],
		    ((u_char *)&conf.snetmask)[1],
		    ((u_char *)&conf.snetmask)[2],
		    ((u_char *)&conf.snetmask)[3]);
		printf("flags=%x\n", conf.flags);
		printf("address=%x\n", conf.address);
		printf("ioaddr=%x\n", conf.ioaddr);
		printf("domaintime=%d\n", conf.domaintime);
		printf("domainretry=%d\n", conf.domainretry);
		printf("domaincount=%d\n", conf.domaincount);
		printf("arptime=%d\n", conf.arptime);
		printf("retrans=%d\n", conf.retrans);
		printf("mtu=%d\n", conf.mtu);
		printf("maxseg=%d\n", conf.maxseg);
		printf("rwin=%d\n", conf.rwin);
		printf("contime=%d\n", conf.contime);
	}
}
