// Associated include file : Tools\App.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"
#include "tools/tools.h"

DEFINE(TApp);

DEFINE_EVENTS_TABLE(TApp,TShell)
  COMMAND(cmQuit,doQuit)
  KEYDOWN()
END_EVENTS_TABLE

short RegTApp;
char *IdentTApp = "TApp";

TApp::TApp()
{ Defaults();
}

TApp::TApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void TApp::Defaults(void)
{ // Object Identification
  Register=RegTApp;
  Ident=IdentTApp;
}

void TApp::Init(char *argv0)
{ // Start SWORD various parts
  InitCommon(argv0)
  InitMecanism();
  printf("\nPress a key...\n");
  getc(stdin);
  InitGraphics();
  InitDrawings();
  InitGadgets();
  InitTools();
  // Herited constructions
  TShell::Init();
  // Cration du bureau virtuel
  Insert(DesktopCreation());
  // Now the desktop is created, so we can activate
  // graphic phases printing
  ActivateGraphicPhases();
  // Initialise le timing ScreenSaver a partir de maintenant
  // (Vritable dbut de l'appli en mode graphique)
  ScreenSaverReset(60);
  //
  Application=this;
  // Create and initialize the main menu
  TMenu *Menu=new TMenu(ShortVersion,opMainMenu);
  CreateMenuChoices(Menu);
  Menu->InitChoices();
  Desktop->Insert(Menu);
}

void TApp::Done()
{ // Herited destructions
  TShell::Done();
  // New destructions
  DoneTools();
  DoneGadgets();
  DoneDrawings();
  DoneGraphics();
  DoneMecanism();
  DoneCommon();
}

void TApp::Run(void)
{ Debug("Application begins...\n\n");
  DebugIncrement();
  EventsLoop(this);
  DebugDecrement();
  Debug("\nApplication finished\n\n");
}

boolean TApp::KeyDown(int ScanCode, int Toggle)
{ if (TShell::KeyDown(ScanCode,Toggle)) return TRUE;
  if (MainMenu!=NULL) return ProcessMenuHotKey(ScanCode, MainMenu);
  return FALSE;
}

boolean TApp::ProcessMenuHotKey(int ScanCode, TMenu* Menu)
{ TMenuChoice *MC=Menu->FirstChoice();
  while(MC!=NULL)
  { if (MC->SubMenu!=NULL)
	 { // Teste les choix des sous-menus
      if (ProcessMenuHotKey(ScanCode, MC->SubMenu)) return TRUE;
	 }
    else
    { // Teste la HotKey
      if (ScanCode==MC->GlobalScanCode)
      { SetCommand(MC->Command);
		  return TRUE;
      }
    }
    MC=MC->NextChoice();
  }
  return FALSE;
}

boolean TApp::doQuit(void)
{ if (CanClose()) ExitCode=cmQuit;
  return TRUE;
}

boolean TApp::CanClose(void)
{ return TRUE;
}

long ExecDialog(TDialog *Dialog, void *Datas)
{ long Result;
  if (Datas!=NULL)
  { // Sets default values for dialog controls
    Dialog->SetData(Datas);
  }
  // Insert dialog in application and runs it
  Desktop->Insert(Dialog);
  Result=Application->EventsLoop(Dialog);
  if (Datas!=NULL)
  { // Get values of dialog controls if OK was pressed
    if (Result==cmOK) Dialog->GetData(Datas);
  }
  // Delete dialog object
  delete Dialog;
  return Result;
}

TDesktop *TApp::DesktopCreation(void)
{ Debug("TApp::DesktopCreation\n");
  return new TDesktop();
}

void TApp::CreateMenuChoices(TMenu *Menu)
{ TMenuChoice *MC;
  MC=new TMenuChoice("&Quit",ScanAltQ,cmQuit);
  Menu->Insert(MC);
}