// Associated include file : Graphics/Desktop.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"

DEFINE(TDesktop);

DEFINE_EVENTS_TABLE(TDesktop,TZone)
  COMMAND(cmReDrawScreen,doReDrawScreen)
  COMMAND(cmDestroyWindow,doDestroyWindow)
  AUTO()
END_EVENTS_TABLE

// --- TDesktop object

short RegTDesktop;
char *IdentTDesktop = "TDesktop";

TDesktop *Desktop;

// Constructors

TDesktop::TDesktop()
{ Defaults();
  Init();
}

void TDesktop::Defaults(void)
{ // Object identification
  Register=RegTDesktop;
  Ident=IdentTDesktop;
  // Other default values
  SetStatus(sfSelected);
}

void TDesktop::Init(void)
{ // Herited creations
  TZone::Init(0,0,GrMaxX(),GrMaxY());
  // Other creations
  ToDrawZones=new TScreenZone();
  // Ask for a global screen drawing at the begining of the application
  Invalidate();
  // Set the global var Desktop to this object
  Desktop=this;
}

// Events

boolean TDesktop::AutoEvt(void)
{ ShowDrawingNow();
  return FALSE;
}

boolean TDesktop::doReDrawScreen(void)
{ Invalidate();
  ShowDrawingNow();
  return TRUE;
}

boolean TDesktop::doDestroyWindow(void)
{ TWindow *W=(TWindow*)CurrentEvent.InfoPtr;
  if (W->CanClose()) delete W;
  return TRUE;
}

// Graphics

void TDesktop::MakeGlobal(TPoint Src, TPoint& Dest)
{ Dest=Src;
}

void TDesktop::MakeLocal(TPoint Src, TPoint& Dest)
{ Dest=Src;
}

void TDesktop::ShowDrawingNow(void)
{ TScreenZone *SZ;
  // Limite au maximum le nombre de zones  retracer en fusionnant
  // Evntuellement des zones
  ToDrawZones->RegroupZones();
  // Trace toutes les zones
  SZ=ToDrawZones->Son();
  while(SZ!=NULL)
  { DoDraw(SZ->Where);
    SZ=SZ->Next();
  }
  // Efface l'ensemble des zones a retracer
  delete ToDrawZones;
  ToDrawZones=new TScreenZone();
}

void TDesktop::Insert(TAtom *A)
{ // Insre l'objet
  TZone::Insert(A);
  // Demande l'affichage de l'objet
  ((TZone*)A)->Invalidate();
  // Met a jour le systeme de positionnement de souris sur les objets
  SetCommand(cmUpdateMouse);
}

void TDesktop::CalculateClip(void)
{ // Calcule le recouvrement pour le bureau
  TZone::CalculateClip();
  // Recalcule le recouvrement pour toutes les fentres places sur le bureau
  TWindow *W=(TWindow*)Son();
  while(W!=NULL)
  { W->CalculateClip();
    W=W->Next();
  }
}

void TDesktop::Invalidate(TRect What)
{ ToDrawZones->Insert(new TScreenZone(What));
}

void TDesktop::Invalidate(void)
{ delete ToDrawZones;
  ToDrawZones=new TScreenZone();
  ToDrawZones->Insert(new TScreenZone(NoClip));
}

TZone* TDesktop::GetActiveZone(void)
{ TZone *Z=Son();
  while(!Z->GetStatus(sfSelected))
    Z=Z->Next();
  return Z;
}

void TDesktop::Draw(TRect Clip)
{ SetSysColor(Black);
  Bar(Clip);
}

void TDesktop::UnLink(void)
{ TObject::UnLink();
}

