// Associated include file : Graphics/TitleBar.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

DEFINE(TTitleBar);

DEFINE_EVENTS_TABLE(TTitleBar,TZone)
  COMMAND(cmSelect,  doChangeSelect)
  COMMAND(cmUnSelect,doChangeSelect)
  MOUSELDOWN()
END_EVENTS_TABLE

short RegTTitleBar;
char *IdentTTitleBar = "TTitleBar";

// Constructors

TTitleBar::TTitleBar()
{ Defaults();
}

TTitleBar::TTitleBar(int X, int Y, int L, int H, char *_Title)
{ Defaults();
  Init(X,Y,L,H,_Title);
}

TTitleBar::TTitleBar(TRect R, char *_Title)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Title);
}

void TTitleBar::Defaults()
{ // Object identification
  Register=RegTTitleBar;
  Ident=IdentTTitleBar;
  // Other default values
  SetOptions(opCSHiX | opGetAllEvents);
  Title=NULL;
}

void TTitleBar::Init(int X, int Y, int L, int , char *_Title)
{ // Herited constructions
  TZone::Init(X,Y,L,21);
  // New constructions
  if (_Title!=NULL) Title=strdup(_Title);
}

void TTitleBar::Done(void)
{ // Herited destructions
  TZone::Done();
  // New destructions
  if (Title!=NULL) free(Title);
}

// Events

boolean TTitleBar::doChangeSelect(void)
{ Invalidate();
  return FALSE;
}

boolean TTitleBar::MouseLDown(TPoint mWhere, int )
{ if (GetStatus(sfMouseIn))
  { TEvent   Event;
    TWindow *W=Father();
    int      dX1,dY1,dX2,dY2,dX,dY;
    TRect    Rect;
    dX1=W->Corner.X()-mWhere.X();
    dY1=W->Corner.Y()-mWhere.Y();
    dX2=dX1+W->Where.Width()-1;
	 dY2=dY1+W->Where.Height()-1;
    ChangeMouseAspect(MouseCursorHand);
	 GrMouseSetCursorMode(GR_M_CUR_BOX,dX1,dY1,dX2,dY2,NoSysColor[White]);
    BeginDrag();
    do
    { GetEvent(&Event);
    } while(Event.What!=evMouseLUp);
    EndDrag();
    GrMouseSetCursorMode(GR_M_CUR_NORMAL);
    RestoreMouseAspect();
    // Garde l'ancienne coordonne
    Rect=TRect(0,0,W->Where.Width()-1,W->Where.Height()-1)+W->Corner;
    // Dplace la fentre
    dX=Event.Where.X()-mWhere.X();
    dY=Event.Where.Y()-mWhere.Y();
    if ((dX)||(dY))
    { // Demande le retrac de l'ancienne position
      W->Invalidate();
      // Change la position
      W->Where+=TPoint(dX,dY);
      // Met  jour le systme de recouvrement
      Desktop->CalculateClip();
		// Demande de retracer la nouvelle position
      W->Invalidate();
    }
    return TRUE;
  }
  return FALSE;
}

// Graphics

void TTitleBar::Draw(TRect )
{ int   Active=Father()->GetStatus(sfSelected);
  int   L,H,sL,sH;
  char *NewTitle=strdup(Title);
  L=Where.Width();
  H=Where.Height();
  // Trace le fond
  if (Active) SetSysColor(DarkGray);
			else SetSysColor(Black);
  Bar(0,0,L-1,H-2);
  // Ligne en dessous de la barre de titre
  SetSysColor(FaceGray);
  LineX(0,H-1,L-1);
  // Trace le titre
  if (Active) SetSysColor(White);
			else SetSysColor(LightGray);
  FontSystem->ChooseFace(FFace_BOLD);
  FontSystem->TruncStr(L-20,Title,NewTitle);
  sH=FontSystem->HeightStr(NewTitle);
  sL=FontSystem->WidthStr(NewTitle);
  PutSysStr((L-sL)/2,(H-1-sH)/2,NewTitle,FontSystem);
  FontSystem->ChooseFace(FFace_NORMAL);
  free(NewTitle);
}

void TTitleBar::ShrinkInside(TRect& InsideFather)
{ InsideFather.P1()+=TPoint(0,Where.Height());
}
