/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem  : Quite sofisticated tools
   CommandNos : 4200..4299
   File       : Include/Tools/ColEdit.H
   Author     : Eric NICOLAS
   Overview   : Color Edit window and tools
   UpDate     : Apr 08, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLS_COLEDIT_H_
#define _TOOLS_COLEDIT_H_

#define cmColorViewEdited 4200

class TColorView;
class TColorHSView;
class TColorEdit;

// --- TColorView

extern short RegTColorView;
extern char *IdentTColorView;

class TColorView : public TZone
{ DECLARE(TColorView);
  // --- Datas
  protected:
    byte   r,g,b;
    TColor RealColor;
  // --- Functions
  public:
  // Public constructors
          TColorView(void);
          TColorView(int X, int Y, int L, int H);
          TColorView(TRect R);
  // Creation / Destruction
          void Defaults(void);
          void Init(int X, int Y, int L, int H);
          void Done(void);
  // Drawing
  virtual void Draw(TRect Clip);
          void SetColor(byte _r, byte _g, byte _b);
};

// --- TColorHSView

extern short RegTColorHSView;
extern char *IdentTColorHSView;

class TColorHSView : public TZone
{ DECLARE(TColorHSView);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    byte           h,s,v;
    TScreenBitmap *HSzone;
    TScreenBitmap *Vzone;
  // --- Functions
  public:
  // Public constructors
          TColorHSView(void);
          TColorHSView(int X, int Y);
  // Creation / Destruction
          void Defaults(void);
          void Init(int X, int Y);
          void Done(void);
  // Drawing
  virtual void Draw(TRect Clip);
          void SetHSV(byte _h, byte _s, byte _v);
          void GetHSV(byte& _h, byte& _s, byte& _v);
  // User interaction
          boolean MouseLDown(TPoint Where, int Buttons);
          boolean MouseMove (TPoint Where, int Buttons);
          boolean MouseAction(TPoint W);
};

// --- TColorEdit

extern short RegTColorEdit;
extern char *IdentTColorEdit;

class TColorEdit : public TDialog
{ DECLARE(TColorEdit);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    TEditInteger *eR, *eG, *eB;
    TEditInteger *eH, *eS, *eV;
    TColorHSView *HSView;
    TColorView   *ColView;
  // --- Functions
  public:
  // Public constructors
          TColorEdit(void);
          TColorEdit(int X, int Y);
  // Creation / Destruction
          void Defaults(void);
          void Init(int X, int Y);
  //
  virtual void SetData(void *Ptr);
  //
  private:
          TEditInteger *InsertEditBlock(int X, int Y, char *Text);
          void    RGB2HSV(void);
          void    HSV2RGB(void);
          boolean doEditChanged(void);
          boolean doColorViewEdited(void);
};

// --- Structure for data exchange with TColorEdit

struct TColorEditDatas
{ byte Red   ;//PACKED;
  byte Green ;//PACKED;
  byte Blue  ;//PACKED;
  byte Hue   ;//PACKED;
  byte Sat   ;//PACKED;
  byte Val   ;//PACKED;
};

// --- Functions

void EditRGBColor(int X, int Y, byte& r, byte& g, byte& b);
void EditHSVColor(int X, int Y, byte& h, byte& s, byte& v);

#endif // _TOOLS_COLEDIT_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.11:
**   04/04/96 :EN: Initial draft
**   06/04/96 :EN: Moving from Colors sample program to Tools kit. Debugging.
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
**   09/08/05 :EN: Removed PACKED from TColorEditDatas to support latest DJGPP/g++
** ------------------------------------------------------------------------*/
