/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Image manipulation ToolBox
	File      : Include/ToolBox/Image/RdFile.H
	Author    : Eric NICOLAS
	Overview  : Interface with IJG software
	UpDate    : Feb 21, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLBOX_IMAGE_RDFILE_H_
#define _TOOLBOX_IMAGE_RDFILE_H_

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define BMP_SUPPORTED
#define GIF_SUPPORTED
#define PPM_SUPPORTED
#define TARGA_SUPPORTED

/* Includes for IJG-JPEG library */

#define JPEG_CJPEG_DJPEG	    /* define proper options in jconfig.h        */
#define JPEG_INTERNAL_OPTIONS	 /* cjpeg.c,djpeg.c need to see xxx_SUPPORTED */

#include "toolbox/image/jpeg/jinclude.h"
#include "toolbox/image/jpeg/jpeglib.h"
#include "toolbox/image/jpeg/jerror.h"
#include "toolbox/image/jpeg/cderror.h"

#include <setjmp.h>

/* --- Structures for decoding files (was : encoding jpeg files) */

typedef struct cjpeg_source_struct *cjpeg_source_ptr;

struct cjpeg_source_struct
{ JMETHOD(void, start_input, (j_compress_ptr cinfo, cjpeg_source_ptr sinfo) );
  JMETHOD(JDIMENSION, get_pixel_rows, (j_compress_ptr cinfo, cjpeg_source_ptr sinfo) );
  JMETHOD(void, finish_input, (j_compress_ptr cinfo, cjpeg_source_ptr sinfo) );

  FILE *input_file;
  JSAMPARRAY buffer;
  JDIMENSION buffer_height;
};

/* --- Structures for encoding files (was : decoding jpeg files) */

typedef struct djpeg_dest_struct *djpeg_dest_ptr;

struct djpeg_dest_struct
{
  /* start_output is called after jpeg_start_decompress finishes.
   * The color map will be ready at this time, if one is needed.
   */
  JMETHOD(void, start_output, (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo));
  /* Emit the specified number of pixel rows from the buffer. */
  JMETHOD(void, put_pixel_rows, (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo, JDIMENSION rows_supplied));
  /* Finish up at the end of the image. */
  JMETHOD(void, finish_output, (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo));
  /* Target file spec; filled in by djpeg.c after object is created. */
  FILE * output_file;

  /* Output pixel-row buffer.  Created by module init or start_output.
   * Width is cinfo->output_width * cinfo->output_components;
   * height is buffer_height.
   */
  JSAMPARRAY buffer;
  JDIMENSION buffer_height;
};

/* ---- */

/*
 * cjpeg/djpeg may need to perform extra passes to convert to or from
 * the source/destination file format.  The JPEG library does not know
 * about these passes, but we'd like them to be counted by the progress
 * monitor.  We use an expanded progress monitor object to hold the
 * additional pass count.
 */

struct cdjpeg_progress_mgr {
  struct jpeg_progress_mgr pub;	/* fields known to JPEG library */
  int completed_extra_passes;	/* extra passes completed */
  int total_extra_passes;	/* total extra */
  /* last printed percentage stored here to avoid multiple printouts */
  int percent_done;
};

typedef struct cdjpeg_progress_mgr * cd_progress_ptr;

/* --- Different formats procs */

EXTERN cjpeg_source_ptr jinit_read_bmp JPP((j_compress_ptr cinfo));
EXTERN djpeg_dest_ptr jinit_write_bmp JPP((j_decompress_ptr cinfo, boolean is_os2));
EXTERN cjpeg_source_ptr jinit_read_gif JPP((j_compress_ptr cinfo));
EXTERN djpeg_dest_ptr jinit_write_gif JPP((j_decompress_ptr cinfo));
EXTERN cjpeg_source_ptr jinit_read_ppm JPP((j_compress_ptr cinfo));
EXTERN djpeg_dest_ptr jinit_write_ppm JPP((j_decompress_ptr cinfo));
EXTERN cjpeg_source_ptr jinit_read_targa JPP((j_compress_ptr cinfo));
EXTERN djpeg_dest_ptr jinit_write_targa JPP((j_decompress_ptr cinfo));

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _TOOLBOX_IMAGE_RDFILE_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: Initial version
** ------------------------------------------------------------------------*/
