/* --------------------------------------------------------------------------
        Project S.W.O.R.D
        V2.10

        SubSystem : Basic objects, General use mecanisms
        File      : LibSrc/Mecanism/Point.CC
        Author    : Eric NICOLAS
        Overview  : Object TPoint = { int X, int Y }
        UpDate    : Feb 20, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _MECANISM_POINT_H_
#define _MECANISM_POINT_H_

class TPoint
{ protected:
    int _X,_Y;
  public:
         // Constructors
    TPoint();
    TPoint(int X, int Y);
    TPoint(const TPoint& P);
    // Data Access
    int &X();
    int &Y();
    // :: Oprators
    TPoint operator+(TPoint P);
    TPoint operator-(TPoint P);
    TPoint operator+=(TPoint P);
    TPoint operator-=(TPoint P);
    // :: Objects stream
    void Read(TDisk *file);
    void Write(TDisk *file);
};

// Inline functions

inline int &TPoint::X()
{ return _X;
}

inline int &TPoint::Y()
{ return _Y;
}

#endif // _MECANISM_POINT_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.11:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   09/08/05 :EN: Fix for compiling with latest DJGPP/g++
** ------------------------------------------------------------------------*/
