/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Screen graphics management
	File      : Include/Graphics/Desktop.H
	Author    : Eric NICOLAS
	Overview  : TDesktop object
	UpDate    : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_DESKTOP_H_
#define _GRAPHICS_DESKTOP_H_

extern short RegTDesktop;
extern char *IdentTDesktop;

class TDesktop : public TZone
{ DECLARE(TDesktop);
  // -- Datas
  protected:
    TScreenZone *ToDrawZones;
  // -- Functions
  public:
  // Public Constructors
          TDesktop();
  // Creation / Destruction
          void     Defaults(void);
	       void     Init(void);
  // Events
          boolean  AutoEvt(void);
          boolean  doReDrawScreen(void);
          boolean  doDestroyWindow(void);
  // Graphics
  virtual void     MakeGlobal(TPoint Src, TPoint& Dest);
  virtual void     MakeLocal(TPoint Src, TPoint& Dest);
  virtual void     ShowDrawingNow(void);
          void     CalculateClip(void);
  virtual void     Invalidate(TRect What);
  virtual void     Invalidate(void);
  virtual void     Draw(TRect Clip);
  // Linked lists
          TZone*   GetActiveZone(void);
  virtual void     Insert(TAtom *A);
  virtual void     UnLink(void);
  DECLARE_EVENTS_TABLE;
};

extern TDesktop *Desktop;

#endif // _GRAPHICS_DESKTOP_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: Moving this code from graphics.h to grx.h
**   28/02/96 :EN: Changing from struct to class and other little modifs
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
