/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Drivers for hardware and OS access
	File      : Include/Drivers/Disk.H
	Author    : Eric NICOLAS
	Overview  : TDisk : Object for accessing file
	UpDate    : Mar 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _MECANISM_DISK_H_
#define _MECANISM_DISK_H

// Constants for disk access via TDisk

#define stCreate     0x0001
#define stOpen       0x0002
#define stTextMode   0x0004
#define stBegining   0
#define stCurrent    1
#define stEnd        2

class TDisk
{ // Datas
  protected:
    FILE  *FileHandle;
    int    LastRead;
  // Functions
  public:
  // Constructor / Destructor
    TDisk(char *Name, int Acces) { Open(Name,Acces); };
    TDisk() { }
    virtual ~TDisk(void) { Close(); };
  // Open / Close file
    virtual void  Close(void);
    virtual void  Open(char *Name, int Acces);
  // Read / Write
    virtual void  Read(void *Buffer, int Size);
            void  ReadLn(char *Buffer, int MaxLength);
    virtual void  Write(void *Buffer, int Size);
            void  WriteLn(char *Buffer);
  // Position in file
    virtual long  Seek(long Depl, char Mode);
    virtual long  Position(void);
  // Access to Handle
            FILE *Handle(void);
};

// --- Expanding inline funcs

inline FILE *TDisk::Handle(void)
{ return FileHandle;
}

#endif // _MECANISM_DISK_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   13/03/96 :EN: Transfering from "mecanism kit" to "drivers kit"
** ------------------------------------------------------------------------*/
