REM ********************************
REM * Graphics Tutor in Basic 2/2P *
REM ********************************

REM initialize variables
OPTION DEGREES
pause1=250
pause2=50

REM close the screens and windows
CLOSE #2,#1
CLOSE WINDOW 3
CLOSE WINDOW 4
CLOSE WINDOW 2
CLOSE WINDOW 1

REM initialize Window #2
OPEN #2 WINDOW 2
SCREEN #2 GRAPHICS
SET #2 FONT 3 POINTS 14
WINDOW #2 SIZE XDEVICE,YDEVICE
WINDOW #2 PLACE 0,19
WINDOW #2 TITLE "Brain Software Presents"
WINDOW #2 OPEN
GOSUB graphic


REM initialize the program screens
LABEL progstart
CLOSE #2
REM window #2 graphics
OPEN #2 WINDOW 2 
SCREEN #2 GRAPHICS 380 FIXED, 420 FIXED
WINDOW #2 PLACE 250,15
WINDOW #2 TITLE "Output"
WINDOW #2 OPEN

REM window #1 text
OPEN #1 WINDOW 1
SCREEN #1 TEXT 30 FIXED, 23 FIXED
SET #1 FONT 3 POINTS 12
WINDOW #1 PLACE 3,35
WINDOW #1 TITLE "Graphic Tutorial"
WINDOW #1 OPEN

LABEL the_beginning
REM clear the screen
CLS #1
CLS #2

REM *********************
REM * Program goes here *
REM *********************

REM introduction
PRINT #1, "Locomotive Basic 2 is       "
PRINT #1, "based on the gem graphical"
PRINT #1, "environment and so it is"
PRINT #1, "rich in it's graphic commands."
PRINT #1, "The purpose of this program
PRINT #1, "is to show the user what"
PRINT #1, "these commands can do."
PRINT #1, 
PRINT #1, "We will start with the PLOT"
PRINT #1, "command and from there work"
PRINT #1, "on to the other graphic"
PRINT #1, "drawing commands."
PRINT #1, 
PRINT #1, "By the time you've finished"
PRINT #1, "this program I hope you'll"
PRINT #1, "have a good idea of how to"
PRINT #1, "use graphics in Basic 2/2P."
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1

REM PLOT command
PRINT #1, "The first and simplest"
PRINT #1, "graphic command is the PLOT"
PRINT #1, "command.  All this does is"
PRINT #1, "turn on a point on the screen."
PRINT #1, "The syntax of PLOT is:"
PRINT #1, "PLOT #window, x;y [options]"
PRINT #1, 
PRINT #1, "So let us plot a point on the"
PRINT #1, "screen.  We'll write:"
PRINT #1, 
PRINT #1, "PLOT #2, 2500;2700 COLOR 2"

PLOT #2, 2500;2700 COLOR 2
FOR ti=1 TO pause1: NEXT ti

PRINT #1, 
PRINT #1, "Can you see the small dot on"
PRINT #1, "the screen?  It's hard to see"
PRINT #1, "it by itself."
FOR ti=1 TO pause2:NEXT ti
PRINT #1, "Let's circle the point."

CIRCLE #2, 2500;2700, 100 COLOR 1

PRINT #1, 
PRINT #1, "So what good is the PLOT"
PRINT #1, "command?"
PRINT #1,
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM plot in a loop
PRINT #1, "When put together as many"
PRINT #1, "points one can plot any shape"
PRINT #1, "of line."
PRINT #1, 
PRINT #1, "Let's try it again and this"
PRINT #1, "time we'll plot several"
PRINT #1, "points at a time."
PRINT #1,
PRINT #1, "We'll make a loop to do it."
PRINT #1,
PRINT #1, "FOR x1=2000 to 3000"
PRINT #1, "PLOT #2, x1;2700 COLOR 2"
PRINT #1, "NEXT x1"

FOR ti=1 TO pause1: NEXT ti
FOR x1=2000 TO 3000
  PLOT #2, x1;2700 COLOR 2
NEXT x1

PRINT #1,
PRINT #1,"See the red line at the"
PRINT #1, "right.
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1,
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM plot marker
PRINT #1, "In PLOT we can specify a"
PRINT #1, "style for the plotting by"
PRINT #1, "using the MARKER command."
PRINT #1, "The markers available are:"
PRINT #1, 
PRINT #1, "1=thin"
PRINT #1, "2=cross"
PRINT #1, "3=asterisk"
PRINT #1, "4=box"
PRINT #1, "5=an x"
PRINT #1, "6=diamond"
PRINT #1, 
PRINT #1, "So let's plot a line"
PRINT #1, "using an X:"
PRINT #1, "marker MARKER 5:"
PRINT #1, 

FOR ti=1 TO pause1: NEXT ti
FOR x1=2000 TO 3000
  PLOT #2, x1;2700 COLOR 2 SIZE 5 MARKER 5
NEXT x1

PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM line
PRINT #1, "PLOT is most useful for"
PRINT #1, "drawing lines that are not"
PRINT #1, "straight, such as graphing"
PRINT #1, "a function like SIN:"

FOR y1=1 TO 179
  x1=10*y1
  s1=INT(1000*(SIN(y1)))+4000
    PLOT #2, x1;s1 COLOR 4
  REM PRINT #2, s1;
NEXT y1
FOR ti=1 TO pause1: NEXT ti

PRINT #1, 
PRINT #1, "For drawing straight lines"
PRINT #1, "there is a more useful"
PRINT #1, "command called LINE."
PRINT #1,
PRINT #1, "The syntax of LINE is:"
PRINT #1, "LINE #win, x1;y1, x2;y2"
PRINT #1, "[options]"
PRINT #1,
PRINT #1, "So lets draw a blue line:"
PRINT #1,
PRINT #1, "LINE #2, 2000;2000, 3000;"
PRINT #1, "3500 COLOR 4"
PRINT #1,

FOR ti=1 TO pause1: NEXT ti
LINE #2, 2000;2000, 3000;3500 COLOR 4

PRINT #1, "See how fast it is to use"
PRINT #1, "the built-in line command?"
PRINT #1,
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM style
PRINT #1, "There are also 6 styles"
PRINT #1, "of lines that can be"
PRINT #1, "specified. They are:"
PRINT #1, 
PRINT #1, "1=Solid"
PRINT #1, "2=Long Dash"
PRINT #1, "3=Dotted"
PRINT #1, "4=Dash & Dot"
PRINT #1, "5=Short Dash"
PRINT #1, "6=Dash & Double Dot"
PRINT #1, 
PRINT #1, "So lets add a style of"
PRINT #1, "line to our command and"
PRINT #1, "see how that looks:"
PRINT #1, 
PRINT #1, "STYLE 6

FOR ti=1 TO pause1: NEXT ti
LINE #2, 2000;2000, 3000;3500 COLOR 4 STYLE 6

PRINT #1, 
PRINT #1, "Now we can see how versatile"
PRINT #1, "the line command can be."
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM line width
PRINT #1, "When drawing a line another"
PRINT #1, "option we have is how thick"
PRINT #1, "to draw the line. The WIDTH"
PRINT #1, "command controls the width"
PRINT #1, "and refers to how many points"
PRINT #1, "wide the line is."
PRINT #1, 
PRINT #1, "Let's draw another line and"
PRINT #1, "specify a WIDTH of 5:"

FOR ti=1 TO pause1: NEXT ti
LINE #2, 2000;2000, 3000;3500 COLOR 4 WIDTH 5

PRINT #1, 
PRINT #1, "WIDTH 5"
PRINT #1, 
PRINT #1, "Notice how much thicker"
PRINT #1, "the blue line is."
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM start and end points
PRINT #1, "The last option for lines"
PRINT #1, "we'll look at is the start"
PRINT #1, "and end point commands.  The"
PRINT #1, "words START and END when"
PRINT #1, "used as a line option change"
PRINT #1, "the start and end point"
PRINT #1, "style. The styles are:"
PRINT #1, 
PRINT #1, "0=none"
PRINT #1, "1=arrow"
PRINT #1, "2=rounded"
PRINT #1, 
PRINT #1, "So we'll add an arrow point"
PRINT #1, "end point on our line:

FOR ti=1 TO pause1: NEXT ti
LINE #2, 2000;2000, 3000;3500 COLOR 4 WIDTH 5 END 1

PRINT #1, 
PRINT #1, "END 1"
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM BOX command
PRINT #1, "So what if you wanted to make"
PRINT #1, "a rectangle, would you have"
PRINT #1, "to connect 4 lines together?"
PRINT #1, "Well you could but there's an"
PRINT #1, "easier way.  The next command"
PRINT #1, "look at is the BOX command."
PRINT #1, 
PRINT #1, "The syntax for BOX is:"
PRINT #1, "BOX #win, x1;y1, across, up"
PRINT #1, "[options]"
PRINT #1, 
PRINT #1, "So we'll draw a box like so:"
PRINT #1, "BOX #2, 1000;1000, 3000,3000" 

FOR ti=1 TO pause1: NEXT ti
BOX #2, 1000;1000, 3000, 3000

PRINT #1, 
PRINT #1, "Now we can choose from a"
PRINT #1, "couple of options.  We can"
PRINT #1, "specify a color, we can fill
PRINT #1, "it with color, and we can"
PRINT #1, "fill it with a pattern."
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM box fill
PRINT #1, "So let's try the box again"
PRINT #1, "and this time we'll add:"
PRINT #1, 
PRINT #1, "COLOR 3 FILL WITH 16"
PRINT #1, 
PRINT #1, "to add a basket weave"
PRINT #1, "pattern in green to it."

FOR ti=1 TO pause1: NEXT ti
BOX #2, 1000;1000, 3000, 3000 COLOR 3 FILL WITH 16

PRINT #1, 
PRINT #1, "Using a combination of"
PRINT #1, "the 16 colors and 38"
PRINT #1, "patterns available one"
PRINT #1, "is only limited by their"
PRINT #1, "imagination in what they"
PRINT #1, "can create."
PRINT #1, 
PRINT #1, "There is one more addition"
PRINT #1, "to mention while we are on"
PRINT #1, "BOX, that is making a box"
PRINT #1, "with rounded corners."
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM rounded corners on box
PRINT #1, "Making rounded corners on a"
PRINT #1, "box is really simple because"
PRINT #1, "there's a built-in command"
PRINT #1, "to do just that. It is as"
PRINT #1, "easy as saying ROUNDED."
PRINT #1, 
PRINT #1, "So let's draw our box again"
PRINT #1, "with rounded corners."

FOR ti=1 TO pause1: NEXT ti
BOX #2, 1000;1000, 3000, 3000 COLOR 3 FILL WITH 16 ROUNDED

PRINT #1, 
PRINT #1, "See how easy it is?"
PRINT #1, 
PRINT #1, "So that is the BOX command;"
PRINT #1, "In review you can specify the"
PRINT #1, "COLOR of the box, FILL it"
PRINT #1, "with color or a pattern, and"
PRINT #1, "draw it with rounded corners"
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM circle command
PRINT #1, "The next graphic figure we'll"
PRINT #1, "see is the circle. Using plot"
PRINT #1, "and that geometry formula you"
PRINT #1, "have forgotten by now one"
PRINT #1, "could plot a circle. But we"
PRINT #1, "have a command built in to"
PRINT #1, "do it for you. The syntax is:"
PRINT #1, 
PRINT #1, "CIRCLE #win, xcenter;ycenter,"
PRINT #1, "radius [options]"
PRINT #1, 
PRINT #1, "So now we will make a circle:"
PRINT #1, 
PRINT #1, "CIRCLE #2, 2500;3000, 1500"

FOR ti=1 TO pause1: NEXT ti
CIRCLE #2, 2500;3000, 1500

PRINT #1, 
PRINT #1, "Pretty handy right?
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM circle options
PRINT #1, "The same option we had in"
PRINT #1, "BOX work in CIRCLE (except"
PRINT #1, "for ROUNDED of course).
PRINT #1, 
PRINT #1, "So we can draw a circle"
PRINT #1, "in dark green and fill it"
PRINT #1, "with the navajo pattern."
PRINT #1, "
PRINT #1, "COLOR 11 FILL WITH 17"
PRINT #1, 

FOR ti=1 TO pause1: NEXT ti
CIRCLE #2, 2500;3000, 1500 COLOR 11 FILL WITH 17

PRINT #1, 
PRINT #1, "So now we can draw lines,"
PRINT #1, "boxes and circles, what else"
PRINT #1, "can we do?
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM ellipse
PRINT #1, "Well just as not all boxes"
PRINT #1, "are square, we don't live"
PRINT #1, "in a world of perfect"
PRINT #1, "circles. So the last figure"
PRINT #1, "we can draw is called an"
PRINT #1, "ellipse. We just commonly"
PRINT #1, "call that an oval. For the"
PRINT #1, "ELLIPSE command the syntax"
PRINT #1, "is:"
PRINT #1, 
PRINT #1, "ELLIPSE #win, xcent;ycent,"
PRINT #1, ",xradius, xyratio [options]"
PRINT #1, 
PRINT #1, "The xyratio is the ratio of"
PRINT #1, "the heigth to the width;" 
PRINT #1, "above 1 will make it taller"
PRINT #1, "than it is wide, a decimal"
PRINT #1, "wider than than it is tall."
PRINT #1, "So lets make one ratio 1.5:"

FOR ti=1 TO pause1: NEXT ti
ELLIPSE #2, 2500;3000, 1500, 1.5

PRINT #1,
PRINT #1,
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM ellipse options
PRINT #1, "All the same options we had"
PRINT #1, "with CIRCLE we have with"
PRINT #1, "ELLIPSE."
PRINT #1, 
PRINT #1, "So we can make a purple"
PRINT #1, "ellipse filled with the"
PRINT #1, "dark diamond pattern:
PRINT #1, 
PRINT #1, "ELLIPSE #2, 2500;3000,"
PRINT #1, "1500, 1.5 COLOR 7 FILL"
PRINT #1, "WITH 7"

FOR ti=1 TO pause1: NEXT ti
ELLIPSE #2, 2500;3000, 1500, 1.5 COLOR 7 FILL WITH 7

PRINT #1, 
PRINT #1, "It makes a nice looking"
PRINT #1, "oval for us doesn't it?"
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM pie command
PRINT #1, "OK, so we have a circle"
PRINT #1, "and an oval, how about"
PRINT #1, "just a slice of that"
PRINT #1, "pie? OK, Basic 2 even"
PRINT #1, "has a command to make"
PRINT #1, "that, it is called PIE."
PRINT #1, "The syntax is:
PRINT #1, 
PRINT #1, "PIE #win, xcent;ycent,"
PRINT #1, "radius, start angle,"
PRINT #1, "end angle, [options]
PRINT #1, "
PRINT #1, "Take a circle, bisect it"
PRINT #1, "so we have 0, 90, 180"
PRINT #1, "and 270 degrees. The"
PRINT #1, "start angle is from 0"
PRINT #1, "to where the pie slice"
PRINT #1, "starts, and the end"
PRINT #1, "angle is from 0 to where"
PRINT #1, "the pie slice ends."

FOR ti=1 TO pause1: NEXT ti
CIRCLE #2, 2500;3000, 1500 COLOR 1
LINE #2, 2500;1400, 2500;4600 COLOR 1
LINE #2, 900;3000, 4100;3000 COLOR 1
PRINT #2, AT(24;4); "90"
PRINT #2, AT(5;13); "180"
PRINT #2, AT(23;21); "270"
PRINT #2, AT(41;13); "0"

PRINT #1, "
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1

REM PIE screen 2
PRINT #1, "Say we want to start"
PRINT #1, "at 45 degrees from 0"
PRINT #1, "and end at 90 degrees"
PRINT #1, "from 0; our PIE state-"
PRINT #1, "ment would say:"
PRINT #1, 
PRINT #1, "PIE #2, 2500;3000, 1500"
PRINT #1, "45, 90"
PRINT #1, "

FOR ti=1 TO pause1: NEXT ti
PIE #2, 2500;3000, 1500, 45, 90

PRINT #1, "Then we fill it in:"
PRINT #1, "COLOR 13 FILL WITH 16"

FOR ti=1 TO pause1: NEXT ti
PIE #2, 2500;3000, 1500, 45, 90 COLOR 13 FILL WITH 16

PRINT #1, 
PRINT #1, "And that is all there"
PRINT #1, "is to the PIE command"
PRINT #1, "for circles in Basic 2.
PRINT #1, "
PRINT #1, "
PRINT #1, "
PRINT #1, "
PRINT #1, "
PRINT #1, "
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM ELLIPTICAL PIE 
PRINT #1, "There is also a PIE"
PRINT #1, "command for ellipses in"
PRINT #1, "Basic 2. It works about"
PRINT #1, "the same as the regular"
PRINT #1, "PIE command. The syntax"
PRINT #1, "is:"
PRINT #1, 
PRINT #1, "ELLIPTICAL PIE #win,"
PRINT #1, "xcent;ycent, radius,"
PRINT #1, "xyratio, start angle,"
PRINT #1, "end angle [options]"
PRINT #1
PRINT #1, "So we draw a slice:"

ELLIPSE #2, 2500;3000, 1500, 1.5
FOR ti=1 TO pause1: NEXT ti
ELLIPTICAL PIE #2, 2500;3000, 1500, 1.5, 45, 90

PRINT #1, "Then we fill it in:"
PRINT #1, "COLOR 15 FILL WITH 21"

FOR ti=1 TO pause1: NEXT ti
ELLIPTICAL PIE #2, 2500;3000, 1500, 1.5, 45, 90 COLOR 15 FILL WITH 21

PRINT #1, 
PRINT #1, "And that is all there"
PRINT #1, "is to the PIE command"
PRINT #1, "for ellipses.
PRINT #1, "
PRINT #1, "
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM shape command
PRINT #1, "The final graphics command"
PRINT #1, "we have in Basic 2 is the"
PRINT #1, "SHAPE command. This is a"
PRINT #1, "powerful command that"
PRINT #1, "uses a series of points"
PRINT #1, "and plots lines from"
PRINT #1, "point to point ending up"
PRINT #1, "where it started. The"
PRINT #1, "syntax for SHAPE is:"
PRINT #1, 
PRINT #1, "SHAPE #win, x;y, x;y, etc"
PRINT #1, "
PRINT #1, "Let's draw a triangle:"

FOR ti=1 TO pause1: NEXT ti
SHAPE #2, 1000;1000, 2000;2000, 1000;3000

PRINT #1, "
PRINT #1, "SHAPE 1000;1000, 2000;"
PRINT #1, "2000, 1000;3000"
PRINT #1, "
PRINT #1, "But remember with SHAPE"
PRINT #1, "you can draw any shape."
PRINT #1, "
PRINT #1, "
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1
CLS #2

REM shape and fill
PRINT #1, "With SHAPE we also have"
PRINT #1, "the COLOR and FILL options"
PRINT #1, "that we have with our"
PRINT #1, "other graphic shapes."
PRINT #1, "
PRINT #1, "So lets draw a shape and"
PRINT #1, "fill it and see if you"
PRINT #1, "can tell what it is:"
PRINT #1, "

FOR ti=1 TO pause1: NEXT ti
SHAPE #2, 1000;1000, 1000;3000, 2000;4000, 3000;3000, 3000;1000 COLOR 10 FILL WITH 9

PRINT #1, "It kinda looks like the"
PRINT #1, "end of a brick house"
PRINT #1, "doesn't it?"
PRINT #1, "
PRINT #1, "So that should give you"
PRINT #1, "an idea of the power of"
PRINT #1, "SHAPE. Combined with the"
PRINT #1, "other commands you should"
PRINT #1, "be able to draw just about"
PRINT #1, "anything you can ever"
PRINT #1, "imagine!"
PRINT #1, "
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""
CLS #1

REM final picture

REM sky
BOX #2, 1;1, XVIRTUAL, YVIRTUAL COLOR 4 FILL WITH 1
REM grass
BOX #2, 1;1, XVIRTUAL, 2000 COLOR 11 FILL WITH 11
REM front wall
SHAPE #2, 1000;1000, 1000;2500, 2000;3500, 3000;2500, 3000;1000 COLOR 10 FILL WITH 9
REM roof
SHAPE #2, 3000;2500, 2000;3500, 4000;3600, 5000;2600 COLOR 11 FILL WITH 20
REM side wall
SHAPE #2, 3000;1000, 3000;2500, 5000;2600, 5000;1100 COLOR 10 FILL WITH 9
REM door
BOX #2, 1750;1000, 500, 1000 COLOR 1 FILL WITH 30
REM front window
CIRCLE #2, 2000;2600, 300 COLOR 6 FILL
CIRCLE #2, 2000;2600, 300 COLOR 1
REM side window
SHAPE #2, 3500;1250, 3500;2000, 4500;2100, 4500;1350 COLOR 6 FILL
SHAPE #2, 3500;1250, 3500;2000, 4500;2100, 4500;1350 COLOR 1

SET #1 FONT 3 POINTS 18
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "    I hope you had fun"
PRINT #1, "    and that this helps"
PRINT #1, "    you out in all your"
PRINT #1, "    future programming."
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, 
PRINT #1, "
PRINT #1, "<press any key to continue>"
REPEAT
  i$=INKEY$
UNTIL i$<>""

ALERT 1 TEXT "That is the end","of this lesson.","Please proceed","to the next","lesson." BUTTON "OK"

END

REM ***********************
REM * Software Intro Here *
REM ***********************

LABEL graphic
REM fill screen
BOX #2, 1;1, XVIRTUAL, YVIRTUAL COLOR 10 FILL WITH 4

BOX #2, 2000;500, 3200, 4000 COLOR 0 FILL ROUNDED
BOX #2, 2000;500, 3200, 4000 COLOR 1 ROUNDED

REM make the graphic

FOR f=10 TO 1200 STEP 10
  CIRCLE #2, 3600;2500, f COLOR 2 FILL
NEXT f

FOR f=1200 TO 10 STEP -2
  CIRCLE #2, 3600;2500, f COLOR 1
NEXT f

FOR f=10 TO 1200 STEP 10
  CIRCLE #2, 3600;2500, f COLOR 0
NEXT f

MOVE #2, 2920;1820

REM print company name in graphic
FOR n=0 TO 270 STEP 90
  PRINT #2, ANGLE (n);"Brain Software";
NEXT n


REM print name and copyright
SET #2 FONT 3 POINTS 14
  PRINT #2, ANGLE (0) AT(26;4); "Brain Software Productions "
SET #2 FONT 3 POINTS 10
  PRINT #2, AT(32;6);"(C) Copyright 2001"
REM MOVE #2, 1700;1100
SET #2 FONT 3 POINTS 18
  PRINT #2, ANGLE (0) AT(32;22); "PRESENTS";

FOR ti=1 TO pause1: NEXT ti

REM chapter intro screen

CLS #2
REM fill screen
BOX #2, 1;1, XVIRTUAL, YVIRTUAL COLOR 1 FILL WITH 31
BOX #2, 1500;500, 4100, 4000 COLOR 0 FILL ROUNDED
BOX #2, 1500;500, 4100, 4000 COLOR 1 ROUNDED

REM make graphics
CIRCLE #2, 2800;3200, 500 COLOR 2 FILL
ELLIPSE #2, 4200;3200, 500, 1.5 COLOR 3 FILL
BOX #2, 3000;2700, 1000, 1000 COLOR 4 FILL

MOVE #2, 1000;1900

REM add text
SET #2 FONT 3 POINTS 18
  PRINT #2, ANGLE (0) AT(18;16); "Programming Locomotive Basic 2"
SET #2 FONT 3 POINTS 14
  PRINT #2, ANGLE (0) AT(29;18); "Chapter 4: Graphics"

LABEL final_loop
REM menu
SET #2 FONT 2 POINTS 12
  PRINT #2, AT(34;20); "<B> to end"
SET #2 FONT 2 POINTS 12
  PRINT #2, AT(32;21); "<Q> to go to Gem"
SET #2 FONT 2 POINTS 12
  PRINT #2, AT(31;22); "<space> start program"
GOSUB waitkey
  IF ans$=" " THEN RETURN
  IF ans$="Q" THEN SYSTEM
  IF ans$<>"B" THEN GOTO final_loop
END

LABEL waitkey
REM wait for key
y=TIME+3000
  REPEAT
    ans$=UPPER$(INKEY$)
    IF (TIME<6000) OR (TIME>y) THEN ans$=" "
  UNTIL ans$<>""
RETURN
END
