/************************************************************************

    INSTALL 2.0.1 - GEM installer

    Copyright (C) 1985,2000  Caldera Inc. / John Elliott 
                             <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/


#include "ppdgem.h"
#include "install.h"

WORD hndl_dialog(LPTREE tree)
{
	WORD x,y,w,h, exobj;

	form_center(tree, &x,&y,&w,&h);
	form_dial(0, 0,0,0,0, x,y,w,h);
	objc_draw(tree, ROOT, MAX_DEPTH, x,y,w,h);
	exobj = form_do(tree, ROOT);
	form_dial(3, 0,0,0,0, x,y,w,h);
	return exobj;
}


VOID init_gembits(VOID)
{
	WORD x,y,w,h;
	WORD wchar, hchar, wbox, hbox;
	
	rsrc_gaddr(R_TREE, COPYING, (LPVOID *)&gl_tree);
	wind_get(0, WF_WXYWH, &x,&y,&w,&h);
	graf_handle(&wchar, &hchar, &wbox, &hbox);
	

	gl_tree[0].ob_x = x + wchar;
	gl_tree[0].ob_y = y + hchar;
}



WORD load_resources(VOID)
{
	if (!rsrc_load(ADDR("INSTAL.RSC")))
	{
		form_alert(0,ADDR("[3][Install can't find the |"
		                     "resource file : INSTAL.RSC][ Cancel ]"));
		return 0;
	}
	init_gembits();
	return 1;
}


VOID set_radio(LPTREE tree, WORD parent, WORD child)
{
	WORD obj = tree[parent].ob_head;

	while (obj != parent)
	{
		/* The original used set_state() functions here, 
		 * and set the state to absolute values rather than
		 * bit-twiddling */
		 
		if (obj == child)
		{
			tree[obj].ob_state |= SELECTED;
		}
		else
		{
			tree[obj].ob_state &= ~SELECTED;
		}
		obj = tree[obj].ob_next;
	}
}

WORD get_radio(LPTREE tree, WORD parent)
{
	WORD obj = tree[parent].ob_head;

	while (obj != parent)
	{
		if ((tree[obj].ob_flags & RBUTTON) &&
		    (tree[obj].ob_state & SELECTED)) return obj;

		obj = tree[obj].ob_next;
	}
	return -1;
}


/* Choose target drive */

BYTE choose_drive(VOID)
{
	WORD chosen, curctl;
	BYTE letter;
	UWORD mask;
	LPTREE ptree;
	LONG obspec, lletter;
	
	letter = 'A';
	curctl = WDA;

	rsrc_gaddr(R_TREE, WHICHDRV, (LPVOID *)&gl_tree);
	mask = 0x8000;
	while (mask)
	{
		if (global[14] & mask)
		{
			/* In the original, this next line was done with three
			 * subroutines and doubtless a stream of compatibility
			 * macros. Thank goodness for far pointers */

			gl_tree[curctl].ob_flags ^= (HIDETREE | RBUTTON);

			ptree = &gl_tree[curctl];
			obspec = (LONG)(ptree->ob_spec);
			lletter = ((LONG)letter) << 24;
			obspec &= 0xFFFFFFL;		/* Remove old driveletter */
			obspec |= lletter;			/* Insert new driveletter */
			ptree->ob_spec = (LPVOID)obspec;
			++curctl;
		}
		mask = mask >> 1;
		++letter;
	}
	set_radio(gl_tree, WDBOX, WDA);

	/* Only one drive? */
	if (curctl - 1 == WDA) chosen = 1; else chosen = 0;

	if (!chosen)
	{
		if (hndl_dialog(gl_tree) == WDOK) chosen = 1;
		else							  chosen = 0;
	}
	if (!chosen) return 0;
	chosen = get_radio(gl_tree, WDBOX);
	obspec = (LONG)(gl_tree[chosen].ob_spec);
	return (obspec >> 24);
}



VOID sh_parse(WORD *doex, WORD *iscr, WORD *isgr, BYTE *cmdbuf, BYTE *tailbuf)
{
	WORD n;
	BYTE *srcstr = line_pointer;

	while (*srcstr == ' ') ++srcstr;

	*doex = *(srcstr++) - '0'; ++srcstr;
	*iscr = *(srcstr++) - '0'; ++srcstr;
	*isgr = *(srcstr++) - '0'; ++srcstr;

	while (*srcstr != '\r' && *srcstr != '\n' && *srcstr != ' ')
	{
		*(cmdbuf++) = *(srcstr++);
	}
	*cmdbuf = 0;
	if (*srcstr == '\r') srcstr += 2;
	else			   ++srcstr;

	n = 1;
	while (*srcstr != '\r' && *srcstr != '\n' && *srcstr != ' ')
	{
		tailbuf[(n++)] = *(srcstr++);
	}
	tailbuf[n]   = '\r';
	tailbuf[n+1] = 0;
	tailbuf[0] = 1 + strlen(tailbuf+1);
}


