/************************************************************************

    INSTALL 2.0.1 - GEM installer

    Copyright (C) 1985,2000  Caldera Inc. / John Elliott 
                             <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/


#include <string.h>	/* strcpy, strlen, strcmp */
#include <dos.h>	/* for union REGS */
#include "instal.h"

#define BUFLEN 	 0x4000	/* 16k buffer for script - we could probably go
						 * up to about 47k if pushed for space  */

/* Command IDs */
#define CMD_DOS       0
#define CMD_ALERT     1
#define CMD_SRCMSG    2
#define CMD_PATBAT    3
#define CMD_COPY      4
#define CMD_MD        5
#define CMD_IF1BUTN   6
#define CMD_IF2BUTN   7
#define CMD_IF3BUTN   8
#define CMD_IFHD      9
#define CMD_IFFD     10
#define CMD_GOTO     11
#define CMD_COLON    12
#define CMD_RUN      13
#define CMD_CHECKVER 14
#define CMD_SETFLAG  15
#define CMD_CLRFLAG  16
#define CMD_IFFLAG   17
#define CMD_REN      18
#define CMD_DEL      19
#define CMD_CHKVOL   20
#define CMD_DSTMSG   21
#define CMD_CREMSG   22
#define CMD_IFERR    23
#define CMD_SETVOL   24
#define CMD_CURVER   25
#define CMD_IFNOSPC  26
#define CMD_MAX      27


#pragma pack(1)

typedef struct
{
	BYTE reserved[0x15];
	BYTE ff_attr;
	BYTE ff_datetime[4];
	LONG ff_size;
	BYTE ff_name[13];
} FFBLK;

typedef struct
{
	unsigned BYTE signat;
	BYTE reserv[5];
	BYTE attrib;
	BYTE drive;
	BYTE name[8];
	BYTE type[3];
	BYTE other[24];
} EFCB;

#pragma pack(2)

#ifndef EXT
#define EXT extern
#define EQ(x)
#endif

/* External variables */
EXTERN WORD global[];
EXTERN WORD DOS_ERR;
EXTERN union REGS DR;
EXTERN struct SREGS SR;

#define DOS_AX DR.x.ax
#define DOS_DX DR.x.dx
#define DOS_DS SR.ds

extern WORD __DOS(VOID);

/* Global variables */

extern char *script_words[];
extern EFCB volfind_efcb;

EXT BYTE alert_buffer[0x180];
EXT BYTE srcmsg_buffer[0x180] EQ("[3][SOURCE FILE NOT FOUND!][  OK  |Cancel]");
EXT BYTE cremsg_buffer[0x180] EQ("[3][UNABLE TO CREATE FILE DURING COPY!][ OK |Cancel]");
EXT BYTE dstmsg_buffer[0x180] EQ("[3][ERROR WRITING FILE!][ ok ]");
EXT BYTE sh_cmdbuf[0x80], sh_tailbuf[0x80];

EXT WORD srcmsg_defbut, cremsg_defbut, dstmsg_defbut;

EXT WORD gl_gemver;
EXT WORD script_error;
EXT WORD have_fixed_drive;
EXT WORD gl_rmsg[8];
EXT LPWORD ad_rmsg;
EXT WORD gl_something[9];
EXT LPWORD ad_something;
EXT WORD flg_1butn, flg_2butn, flg_3butn;
EXT WORD write_ok_flag;
EXT BYTE *script_pointer, *line_pointer, *script_base;
EXT LPTREE gl_tree;
EXT LPLPTR gl_writing, gl_reading;
EXT FFBLK ffblk;
EXT BYTE script_buf[BUFLEN];
EXT BYTE setvol_dta[64];


/* Functions: instutil.c */

BYTE *parse_alert(BYTE *src, BYTE *dest, WORD a, WORD *defbut);
VOID check_fixed(VOID);
WORD load_script(VOID);
WORD script_match(VOID);
WORD next_line(VOID);
BYTE *get_word(BYTE *src, BYTE *dest);
VOID script_goto(VOID);
WORD xtoi(BYTE *s);
BYTE *skip_spaces(BYTE *s);
WORD atow(BYTE *s);
LONG free_space(WORD drive);
VOID fix_error(VOID);

VOID inc_pointer(LPBYTE *pptr, LONG *plong, LONG incr);
VOID repaint_ctrl(LPTREE tree, WORD ctl);
VOID get_file_dir(char *src, char *dst);



/* Functions: instgem.c */
WORD load_resources(VOID);
WORD hndl_dialog(LPTREE tree);
BYTE choose_drive(VOID);
VOID sh_parse(WORD *doex, WORD *iscr, WORD *isgr, BYTE *cmdbuf, BYTE *tailbuf);



