

/************************************************************************/
/*                                                                      */
/*                 ****   *      *   ***   ***  *****                   */
/*                 *   *  *      *  *   *   *     *                     */
/*                 ****   *      *  *****   *     *                     */
/*                 *   *  *  *   *  *   *   *     *                     */
/*                 ****    ** **    *   *  ***    *                     */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*                           Awaiting events                            */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#include "bench.h"       /* GEM and workbench bindings */



/*********************************************************************/
/*                                                                   */
/*                           __makerect                              */
/*                                                                   */
/*   This function constructs a rectangle for use with event_mouse.  */
/* It returns five parameters, for feeding to event_multi. It        */
/* TRUE if the construction should be fed to event_multi, FALSE      */
/* otherwise.                                                        */
/*                                                                   */
/*********************************************************************/

__makerect (which, quel_rectangle, go_in, target, fifth)
WORD   which, quel_rectangle, go_in, *fifth;
GRECT *target;

{ GRECT window, work, current;
  LONG tree;

  if (__window [which]._which_rectangle [quel_rectangle] < 0)
    return (FALSE);

  /* get some relevent parameters */

  __get_window (which, WF_WXYWH, &window);
  __grect_assign (&work, &(__window [which]._rectangle [quel_rectangle]));

  /* and consider each possible rectangle */

  if (work.g_x < 0)
  switch (__window [which]._which_rectangle [quel_rectangle]) {

    case WB_WORK : /* relative to window's work area */
      __grect_assign (target, &window);
      break;

    case WB_CURRENT : /* ... current area */
      __get_window (which, WF_CXYWH, target);
      break;

    case WB_ROOT : /* relative to window's tree's root */
      tree = __window [which]._contents;
      __getarea (tree, 0, target);
      break;

    case WB_ABSOLUTE : /* screen addressing */
      __get_window (0, WF_WXYWH, target);
      break;

    default : /* it is the window's work area */
      __grect_assign (target, &window);
      __window [which]._intersect [quel_rectangle] = FALSE;

  } else {

    target -> g_w = work.g_w;
    target -> g_h = work.g_h;

    switch (__window [which]._which_rectangle [quel_rectangle]) {

      case WB_WORK : /* relative to window's work area */
        target -> g_x = window.g_x + work.g_x;
        target -> g_y = window.g_y + work.g_y;
        break;

      case WB_CURRENT : /* ... current area */
        __get_window (which, WF_CXYWH, &current);
        target -> g_x = current.g_x + work.g_x;
        target -> g_y = current.g_y + work.g_y;
        break;

      case WB_OBJECT : /* item in window's object tree */
        tree = __window [which]._contents;
        __getarea (tree, work.g_x, &target);
        break;

      case WB_ROOT : /* relative to window's tree's root */
        tree = __window [which]._contents;
        objc_offset (tree, 0, &(target -> g_x), &(target -> g_y));
        target -> g_x += work.g_x;
        target -> g_y += work.g_y;
        break;

      case WB_ABSOLUTE : /* screen addressing */
        target -> g_x = work.g_x;
        target -> g_y = work.g_y;
        break;

      default : /* it is the window's work area */
        __grect_assign (target, &window);

    }

  }

  /* if desired, intersect it with the window's work area */

  if (__window [which]._intersect [quel_rectangle])
    if (! __intersect (target, &window))
      return (FALSE);    

  else
    if (target -> g_w <= 0 || target -> g_h <= 0)
      return (FALSE);

  /* otherwise all's ok */

  *fifth = ! go_in;
  return (TRUE);

}



/**********************************************************************/
/*                                                                    */
/*                       wb_await                                     */
/*                                                                    */
/*   This functions waits for one of a specified set of events. It    */
/* takes the following parameters:                                    */
/*                                                                    */
/*      WORD events     Which bevents are awaited, out of:            */
/*                        WB_1ENTER    Enter rectangle 1              */
/*                        WB_1LEAVE    Leave rectangle 1              */
/*                        WB_2ENTER    Enter rectangle 2              */
/*                        WB_2LEAVE    Leave rectangle 2              */
/*                        WB_ACTIVATE  Double click on an object      */
/*                        WB_SELECT    Object(s) selected             */
/*                        WB_DESELECT  Object(s) deselected           */
/*                        WB_DRAG      Objects dragged                */
/*                        WB_CLOSE     Window closed                  */
/*                        WB_MENU      Menu item selected             */
/*                        WB_MESSAGE   Unknown message event          */
/*                        WB_DELAY     Minimum timer delay            */
/*                        WB_KEYBOARD  Character typed in             */
/*                        WB_MOUSE     Mouse event in low level wind  */
/*                        WB_SUPPORT   Low level window support event */
/*      WORD *mesaddr         Message buffer address                  */
/*      LONG time             Timer delay                             */
/*      WORD *current_window  receives current window handler         */
/*      WORD *source_object   Activated object                        */
/*      WORD *target_window   Target window of drag                   */
/*      WORD *target_object   Target object of drag (if known)        */
/*      WORD *menu            Menu chosen                             */
/*      WORD *item            Item in menu chosen                     */
/*      WORD *dragkeys        Shift, Alt and Cntrl keys for drag      */
/*      WORD *key             Key typed on keyboard                   */
/*                                                                    */
/*  The function returns those events that occured.                   */
/*                                                                    */
/**********************************************************************/

WORD wb_await (wb_events, mesaddr, time, current_window, source_object, 
               target_window, target_object, menu, item, dragkeys, key)
WORD wb_events, *mesaddr, *current_window, *source_object, *target_window,
     *target_object, *menu, *item, *dragkeys, *key;
LONG time;

{ WORD events_awaited,    /* events awaited               */
       t,                 /* temporary storage            */
       junkx, junky,      /* unwanted objects             */
       event,             /* that which occured           */
       mesag [8],         /* message buffer               */
       aes_handler,       /* top window's handler         */
       go_in [2],         /* enter or leave rectangle?    */ 
       lowtime, hightime, /* timer details                */
       timex, timey,      /* position after time delay    */
       mousex, mousey,    /* mouse position               */
       mousewindow,       /* mouse window                 */
       under_mouse,       /* object underneath mouse      */
       recalc,            /* recalculated mouse form?     */
       button,            /* mouse buttons                */
       clicks,            /* number of mouse clicks       */
       shift,             /* shift control or alt         */
       ascii,             /* keyboard character           */
       reply;             /* the events that occured      */
  GRECT mouse [2];        /* mouse event parameters       */
  LONG message_addr;      /* message address              */

  /* start to build up parameters for the evnt_multi, by considering   */
  /* which events the calling code wants.                              */

  /* always await messages */

  events_awaited = MU_MESAG;
  message_addr = ADDR (mesag);

  /* deal with rectangles */

  wind_get (0, WF_TOP, &aes_handler, 0, 0, 0);

  if (recalc = (((__curwin = __aesbench (aes_handler)) >= 0) ||
                 (! __window [0]._handler)))
    events_awaited |= MU_BUTTON;

  *current_window = __curwin;

  /* prepare timer */

  if (wb_events & WB_DELAY) {

    events_awaited |= MU_TIMER;
    lowtime = (WORD) (time & 0xFFFFL);
    hightime = (WORD) ((time & 0xFFFF0000L) >> 8);

  } else {

    lowtime = 200;
    hightime = 0;

  }

  if (recalc && (wb_events & WB_KEYBOARD))
    events_awaited |= MU_KEYBD;

  event = 0;
  reply = 0;

  do { /* while (reply == 0) */

    if (recalc && __curwin >= 0) {

      graf_mkstate (&mousex, &mousey, &button, &shift);
      t = (wb_events & WB_0ENTER);

      if (__makerect (__curwin, 0, t, &(mouse [0]), &(go_in [0])))
        if (wb_events & (WB_0ENTER | WB_0LEAVE))
          events_awaited |= MU_M1;

        else
        if (__window [__curwin]._mouseform [0] != 0) {

          events_awaited |= MU_M1;
          go_in [0] = (mousex >= mouse [0].g_x &&
                       mousex <= mouse [0].g_x + mouse [0].g_w &&
                       mousey >= mouse [0].g_y &&
                       mousey <= mouse [0].g_y + mouse [0].g_h);
 
         if (event)
            graf_mouse (go_in [0] ? __window [__curwin]._mouseform [0] : 0,
                        GEM_NULL);
 
        }

      t = (wb_events & WB_1ENTER);

      if (__makerect (__curwin, 1, t, &(mouse [1]), &(go_in [1])))
        if (wb_events & (WB_1ENTER | WB_1LEAVE))
          events_awaited |= MU_M2;

        else
        if (__window [__curwin]._mouseform [1] != 0) {

          events_awaited |= MU_M2;
          go_in [1] = (mousex >= mouse [1].g_x &&
                       mousex <= mouse [1].g_x + mouse [1].g_w &&
                       mousey >= mouse [1].g_y &&
                       mousey <= mouse [1].g_y + mouse [1].g_h);

          if (event)
            graf_mouse (go_in [1] ? __window [__curwin]._mouseform [1] : 0,
                        GEM_NULL);

        }

      recalc = FALSE;

    }

    /* NOTE evnt_multi returns immediately if the mouse is out of a */
    /* rectangle and program is waiting for it to exit. It does not */
    /* wait for the boundry to be crossed in the direction required */

    event = evnt_multi (/* event */ events_awaited, 
                        /* button */ 2, 1, 1,
                        /* mouse 1 */ go_in [0], mouse [0].g_x, mouse [0].g_y,
                                                 mouse [0].g_w, mouse [0].g_h,
                        /* mouse 2 */ go_in [1], mouse [1].g_x, mouse [1].g_y,
                                                 mouse [1].g_w, mouse [1].g_h,
                        /* message */ message_addr,
                        /* timer */ lowtime, hightime,
                        /* location */ &mousex, &mousey,
                        /* buttons */ &button, &shift,
                        /* keyboard */ &ascii,
                        /* clicks */ &clicks);

    /* set up awaits replies */

    *dragkeys = shift;

    /* timer event */

    if ((event & MU_TIMER) &&
        (wb_events & WB_DELAY))
      reply |= WB_DELAY;

    /* keyboard */

    if (event & MU_KEYBD)
      if (wb_events & WB_KEYBOARD) {

        *key = ascii;
        reply |= WB_KEYBOARD;

      }

    /* rectangle event */

    if (event & MU_M1) {

      if (wb_events & (WB_0ENTER | WB_0LEAVE))
        reply |= (go_in [0] == 0 ? WB_0ENTER : WB_0LEAVE);

      if (__window [__curwin]._mouseform [0] != 0) {

        graf_mouse ((go_in [0] == 0 ? __window [__curwin]._mouseform [0] : 0), 
                     GEM_NULL);
        go_in [0] = ! go_in [0];

      }

    }

    if (event & MU_M2) {

     if (wb_events & (WB_1ENTER | WB_1LEAVE))
        reply |= (go_in [1] == 0 ? WB_1ENTER : WB_1LEAVE);

      if (__window [__curwin]._mouseform [1] != 0) {

        graf_mouse ((go_in [1] == 0 ? __window [__curwin]._mouseform [1] : 0),
                     GEM_NULL);
        go_in [1] = ! go_in [1];
 
      }

    }

    if (event & MU_BUTTON)

      /* button chosen: do something if the mouse is over the current window */

      if (((aes_handler = wind_find (mousex, mousey)) >= 0) &&
         (((mousewindow = __aesbench (aes_handler)) == __curwin) ||
           (mousewindow == 0))) {

        *current_window = mousewindow;

        /* if low level window, forget any more support */
 
        if (__window [mousewindow]._control & WB_LOWMOUSE) {

          reply |= WB_MOUSE;
          __mousex = mousex;
          __mousey = mousey;
          __event = event;

        } else

        /* otherwise, try and find out what the user wants */

        if ((__window [mousewindow]._contents != NULL) &&
            (under_mouse = objc_find (__window [mousewindow]._contents, 
                            ROOT, MAX_DEPTH, mousex, mousey)) >= 0) {

          *source_object = under_mouse;

          /* activation is easy ! */

          if (clicks > 1) {

            if ((wb_events & WB_ACTIVATE) &&
                (__window [mousewindow]._control & WB_ACTIVATE))
              reply |= WB_ACTIVATE;

          } else
          if (__window [mousewindow]._contents != NULL) {

            /* otherwise decide whether selection, deselection or
               drag - wait a bit to see if mouse button remains
               depressed */

            evnt_timer (200, 0);
            graf_mkstate (&junkx, &junky, &button, &shift);

            /* if its down, do a drag */

            if (button & 1)
              __drag (mousewindow, under_mouse, target_window, 
                      target_object, mousex, mousey, shift, &reply);

            else
              if (under_mouse >= 0)
                __choose (mousewindow, under_mouse, shift, &reply);

            if (! (wb_events & WB_SELECT))
              reply &= ~ WB_SELECT;

            if (! (wb_events & WB_DESELECT))
              reply &= ~ WB_DESELECT;

            __mousex = mousex;
            __mousey = mousey;

          }

        }

      }

    /* a message event */

    if (event & MU_MESAG) {
      BOOLEAN s;

      s = FALSE;

      /* call relevent routine depending on the message */

      switch (mesag [0]) {

        /* menu item selected */

        case MN_SELECTED :

          if (wb_events & WB_MENU) {

            *menu = mesag [3];
            *item = mesag [4];
            reply |= WB_MENU;

          }

          break;

        /* redraw window */
 
        case WM_REDRAW :

          if (! (__wb_flags & WB_SUPRESS_REDRAW))
            __redraw (mesag [3], mesag [4], mesag [5], mesag [6], mesag [7]);

          else
            __wb_flags &= ~ WB_SUPRESS_REDRAW;

          break;

        /* close window component selected */

        case WM_CLOSED :

          if (wb_events & WB_CLOSE)
            reply |= WB_CLOSE;

          break;

        /* user request window to be bought to the top */

        case WM_TOPPED :
          __itemrelease (__curwin, &reply);
          __bringtop (mesag [3], FALSE, &reply);
          recalc = TRUE;
          break;

        /* window size toggle icon selected */

        case WM_FULLED :
          __itemrelease (__curwin, &reply);
          __fulled (mesag [3]);
          recalc = TRUE;
          break;

        /* window has got a new size */

        case WM_SIZED :
          __itemrelease (__curwin, &reply);
          __resize (mesag [3], mesag [4], mesag [5], mesag [6], mesag [7]);
          recalc = TRUE;
          break;

        /* window has been moved */

        case WM_MOVED :
          __itemrelease (__curwin, &reply);
          __reposition (mesag [3], mesag [4], mesag [5], mesag [6], mesag [7]);
          recalc = TRUE;
          break;

        /* there's a new window on top of the heap */

        case WM_NEWTOP :
          recalc = TRUE;
          __itemrelease (__curwin, &reply);
          __bringtop (mesag [3], TRUE, &reply);
          break;

        default :

          __itemrelease (__curwin, &reply);

          if (__window [__curwin]._control & WB_LOWSUPPORT) {

            if (event & (WM_ARROWED | WM_VSLID | WM_HSLID))
              reply |= WB_SUPPORT;

            else
              s = TRUE;

          } else
          switch (mesag [0]) {

            /* one of the arrows or shaded parts of the slider bar selected */

            case WM_ARROWED :
              __increment (mesag [3], mesag [4]);
              break;

            /* vertical slider moved */

            case WM_VSLID :
              __vslide (mesag [3], mesag [4]);
              break;

            /* horizontal slider moved */

            case WM_HSLID :
              __hslide (mesag [3], mesag [4]);
              break;

            /* other messages */

            default :
              s = TRUE;

          }


      }

      if (s && (wb_events & WB_MESSAGE)) {

        for (t = 0; t < 8; t++)
          mesaddr [t] = mesag [t];

        reply |= WB_MESSAGE;

      }

    }

  } while (reply == 0);

  return (reply);

}



