{$DEFINE Not Atari}
{$I-} { no IO checking }
{$D-} { no debugging }
{$B-} { quick boolean expressions }
{$S-} { no stack checking }
{$N-} { no numeric coprocessor }
{$V-} { relaxed checking of VAR strings }
{$R-} { no range checking }
Unit Gembind;

Interface

{$IFNDEF Atari}
Uses DOS;
{$ENDIF}

Const No_Window       =  -1;  { kein Fenster verfgbar }
      Root            =   0;  { Wurzel des Objektbaum }
      Null_Index      =  -1;  { kein Objekt gefunden }
      Max_Depth       =   8;  { Maximale Schachtelungstiefe }
      Max_Tree        = 100;  { Maximale Baumgre }
      Max_C_String    = 255;  { Maximale Lnge eines C_String in Pascal }
      Max_Fn          =  12;  { Lnge des Dateinamen }
      Max_Path        = 128;  { Lnge des Pfadnamen }
      Max_WTitle      =  80;  { Lnge des Fenstertitels }

      R_Tree          = 0;    { Resourcestrukturen }
      R_Object        = 1;
      R_Tedinfo       = 2;
      R_Iconblock     = 3;
      R_Bitblk        = 4;
      R_String        = 5;

      E_Keyboard      =  1;
      E_Button        =  2;
      E_Mouse1        =  4;
      E_Mouse2        =  8;
      E_Message       = 16;
      E_Timer         = 32;

      Replace_Mode    = 1;
      Trans_Mode      = 2;
      XOR_Mode        = 3;
      Rev_Trans_Mode  = 4;

      Solid           = 1;
      LongDash        = 2;
      Dotted          = 3;
      DashDot         = 4;
      Dashed          = 5;
      DashDotDot      = 6;

      Normal          =   0;
      Thickened       =   1;
      Lightened       =   2;
      Slanted         =   4;
      Underlined      =   8;
      Outlined        =  16;
      Shadowed        =  32;
      Draw3D          =  64;
      WhiteBak        = 128;

      System_Font     = 3;
      Small_Font      = 5;

      G_Box           = 20;
      G_Text          = 21;
      G_BoxText       = 22;
      G_Image         = 23;
      G_ProgDef       = 24;
      G_UserDef       = 24;
      G_IBox          = 25;
      G_Button        = 26;
      G_Boxchar       = 27;
      G_String        = 28;
      G_FText         = 29;
      G_FBoxText      = 30;
      G_Icon          = 31;
      G_Title         = 32;

      None            = $000;
      Selectable      = $001;
      Default         = $002;
      Exit_Btn        = $004;
      Editable        = $008;
      Radio_Btn       = $010;
      Last_Ob         = $020;
      Touch_Exit      = $040;
      Hide_Tree       = $080;
      Indirect        = $100;

      Selected        = 1;
      Crossed         = 2;
      Checked         = 4;
      Disabled        = 8;

      G_Name          = $001;
      G_Close         = $002;
      G_Full          = $004;
      G_Move          = $008;
      G_Info          = $010;
      G_Size          = $020;
      G_UpArrow       = $040;
      G_DnArrow       = $080;
      G_VSlide        = $100;
      G_LArrow        = $200;
      G_RArrow        = $400;
      G_HSlide        = $800;
      G_All           = $FEF;
      G_HotClose      = $1000;  { BALJ }

      White           =  0;
      Black           =  1;
      Red             =  2;
      Green           =  3;
      Blue            =  4;
      Cyan            =  5;
      Yellow          =  6;
      Magenta         =  7;
      L_White         =  8;
      L_Black         =  9;
      L_Red           = 10;
      L_Green         = 11;
      L_Blue          = 12;
      L_Cyan          = 13;
      L_Yellow        = 14;
      L_Magenta       = 15;

      MN_Selected     = 10;
      WM_Redraw       = 20;
      WM_Topped       = 21;
      WM_Closed       = 22;
      WM_Fulled       = 23;
      WM_Arrowed      = 24;
      WM_HSlid        = 25;
      WM_VSlid        = 26;
      WM_Sized        = 27;
      WM_Moved        = 28;
      WM_Newtop       = 29;
      WM_Untopped     = 30;
      AC_Open         = 40;
      AC_Close        = 41;
      CT_Update       = 50;
      CT_Move         = 51;
      CT_Newtop       = 52;

      WF_Kind         =  1;
      WF_Name         =  2;
      WF_Info         =  3;
      WF_WorkXYWH     =  4;
      WF_CurrXYWH     =  5;
      WF_PrevXYWH     =  6;
      WF_FullXYWH     =  7;
      WF_HSlide       =  8;
      WF_VSlide       =  9;
      WF_Top          = 10;
      WF_FirstXYWH    = 11;
      WF_NextXYWH     = 12;
      WF_Newdesk      = 14;
      WF_HSlSize      = 15;
      WF_VSlSize      = 16;
      WF_Screen       = 17;
      WF_TAttrb       = 18;
      WF_SizTop       = 19;
      { This messages were originally missing (HR) }
      WA_UPPAGE=0;
      WA_DNPAGE=1;
      WA_UPLINE=2;
      WA_DNLINE=3;
      WA_LFPAGE=4;
      WA_RTPAGE=5;
      WA_LFLINE=6;
      WA_RTLINE=7;

      SCRAP_CSV=$1;
      SCRAP_TXT=$2;
      SCRAP_GEM=$4;
      SCRAP_IMG=$8;
      SCRAP_DCA=$10;
      SCRAP_USR=$8000;

Type Mouse_Type = (M_Arrow, M_Text_Curs,
                   M_Bee, M_Point_Hand,
                   M_Flat_Hand, M_Thin_Cross,
                   M_Thick_Cross, M_Outln_Cross);

     Text_Ptr = ^Char;

     File_Name    = String [Max_Fn];
     Path_Name    = String [Max_Path];
     Window_Title = String [Max_WTitle];

     Message_Buffer = Array [0..15] Of Integer;

     Ctrl_Parms     = Array [0.. 11] Of Integer;
     Global_Parms   = Array [0.. 15] Of Integer;
     Int_In_Parms   = Array [0..128] Of Integer;
     Int_Out_Parms  = Array [0.. 45] Of Integer;
     Pts_In_Parms   = Array [0..128] Of Integer;
     Pts_Out_Parms  = Array [0.. 11] Of Integer;
     Addr_In_Parms  = Array [0..  2] Of Pointer;
     Addr_Out_Parms = Array [0..  2] Of Pointer;

     Rectangle = Record
                   x, y, w, h : Integer;
                 End;

     Str255 = String [255];

     TE_Just = (TE_Left, TE_Right, TE_Center);

     Tree_Range = Root..Max_Tree;
     Tree_Index = Null_Index..Max_Tree;

     Ob_Type = G_Box..G_Title;

     C_String   = Packed Array [0..Max_C_String] Of Char;
     String_Ptr = ^C_String;

     Text_Ed_Info = Record
                      te_ptext     : String_Ptr;
                      te_ptmplt    : String_Ptr;
                      te_pvalid    : String_Ptr;
                      te_font      : Integer;
                      te_junk1     : Integer;
                      te_just      : Integer;
                      te_color     : Integer;
                      te_junk2     : Integer;
                      te_thickness : Integer;
                      te_txtlen    : Integer;
                      te_tmplen    : Integer;
                   End;
     Ted_Ptr = ^Text_Ed_Info;

     Spec_Info = Record Case Ob_Type Of
                   G_Box,
                   G_IBox,
{$IFDEF Atari}
                   G_Boxchar  : (thick : Integer; { eigentlich Longint, daher }
                                 color : Integer);{ vertauscht auf Intel-Rech.}
{$ELSE}
                   G_Boxchar  : (color : Integer; { eigentlich Longint, daher }
                                 thick : Integer);{ vertauscht auf Intel-Rech.}
{$ENDIF}
                   G_Text,
                   G_BoxText,
                   G_FText,
                   G_FBoxText : (info : Ted_Ptr);
                   G_Image,
                   G_ProgDef,
                   G_Icon     : (ptr : Pointer);
                   G_String,
                   G_Button,
                   G_Title    : (str : String_Ptr);
                 End;

     GEM_Object = Record      { eigentlich "Object"; umbenannt wg. TP >= 5.5 }
                ob_next  : Integer;
                ob_head  : Integer;
                ob_tail  : Integer;
                ob_type  : Integer;
                ob_flags : Integer;
                ob_state : Integer;
                ob_spec  : Spec_Info;
                ob_x     : Integer;
                ob_y     : Integer;
                ob_w     : Integer;
                ob_h     : Integer;
              End;

     Tree       = Array [Tree_Range] Of GEM_Object;
     Tree_Ptr   = ^Tree;
     Menu_Ptr   = Tree_Ptr;
     Dialog_Ptr = Tree_Ptr;

     Icon_Block = Record
                    ib_pmask : Longint;
                    ib_pdata : Longint;
                    ib_ptext : Longint;
                    ib_char  : Integer;
                    ib_xchar : Integer;
                    ib_ychar : Integer;
                    ib_xicon : Integer;
                    ib_yicon : Integer;
                    ib_wicon : Integer;
                    ib_hicon : Integer;
                    ib_xtext : Integer;
                    ib_ytext : Integer;
                    ib_wtext : Integer;
                    ib_htext : Integer;
                  End;

     Bit_Block = Record
                   bi_pdata : Longint;
                   bi_wb    : Integer;
                   bi_hl    : Integer;
                   bi_x     : Integer;
                   bi_y     : Integer;
                   bi_color : Integer;
                 End;

     Mouse_Form = Record
                    hot_x : Integer;
                    hot_y : Integer;
                    res   : Integer;
                    mask_color : Integer;
                    data_color : Integer;
                    mask : Array [0..15] Of Word; { Integer; }
                    data : Array [0..15] Of Word; {Integer; }
                  End;

     MFDB_Type = Record
                   start  : Longint;
                   width  : Integer;
                   heigth : Integer;
                   wwidth : Integer;
                   format : Integer;
                   planes : Integer;
                   fut1   : Integer;
                   fut2   : Integer;
                   fut3   : Integer;
                 End;

Var Control  : Ctrl_Parms;
    Global   : Global_Parms;
    Int_In   : Int_In_Parms;
    Int_Out  : Int_Out_Parms;
    Addr_In  : Addr_In_Parms;
    Addr_Out : Addr_Out_Parms;
    Pts_In   : Pts_In_Parms;
    Pts_Out  : Pts_Out_Parms;
    VDI_Handle,
    GEMResX,
    GEMResY  : Integer;
    { This variables are for the new commands (HR) }
    re:registers;
    emm_error:word;
    SD_Version:Word;
    SD_Type:Word;
    SD_Base:Word;
    SD_DMA:Word;
    SD_Options:Word;

Procedure Split_Addr(Addr: Pointer; Var p1, p2: Integer);

Procedure AES_Call(Op: Integer;
                   Var Int_In  : Int_In_Parms;
                   Var Int_Out : Int_Out_Parms;
                   Var Addr_In : Addr_In_Parms;
                   Var Addr_Out: Addr_Out_Parms);

Procedure VDI_Call(Cmd, Sub_Cmd: Integer;
                   NInts, NPts : Integer;
                   Var Control : Ctrl_Parms;
                   Var Int_In  : Int_In_Parms;
                   Var Int_Out : Int_Out_Parms;
                   Var Pts_In  : Pts_In_Parms;
                   Var Pts_Out : Pts_Out_Parms;
                   Translate   : Boolean);

{ New Commands (HR) }

{Sound driver functions start}
Procedure Volume(vol:word);
Function PlayWAV(af:string):Boolean;
Function PlayIWAV(af:string):Boolean;
Procedure stopWav;
Procedure SD_Info;
Procedure SpeakerOn;
Procedure SpeakerOff;
Procedure StereoOn;
Procedure StereoOff;
Procedure WaitForDma;
Procedure DMAStop;
Procedure PlaySample(a,b,c,d:Word);
{Sound driver functions end}
{Shell functions start}
Function Shel_write(doex,isgem,isover:integer;pcmd,ptail:string):boolean;
{Shell functions end}
{Clipboard functions start}
Function Scrp_Read:string;
Function Scrp_write(name:string):integer;
Procedure Scrp_Clear;
{Clipboard functions end}
{EMS functions start}
Function Ems_Inst:Boolean;
Function ems_errcode:word;
Function ems_num_page:integer;
Function ems_free_page:Integer;
Function ems_frame_seg:Word;
Function ems_alloc(Pages:word):Word;
Function ems_map(Handle,logp,physp:word):Boolean;
Function ems_free(Handle:word):Boolean;
Function ems_version:Integer;
Function ems_save_map(Handle:Word):boolean;
Function ems_restore_map(Handle:word):boolean;
{EMS functions end}

Function Init_GEM: Integer;

Procedure Exit_GEM;

Function Open_Workstation(Id, Mode, Size: Integer): Integer;

Procedure Close_Workstation;

Procedure Clear_Workstation;

Procedure Update_Workstation;

Procedure Form_Advance;

Procedure Alpha_Text(t: Str255);

Function AES_Version: Integer;

Procedure Hide_Mouse;

Procedure Show_Mouse;

Procedure Set_MForm(Var Form: Mouse_Form);

Procedure Set_Mouse(M_Type: Mouse_Type);

Procedure Mouse_Position(x, y: Integer);

Procedure Init_Mouse;

Function Do_Alert(Maske: Str255; Btn: Integer): Integer;

Function Load_Resource(Name: String): Boolean;

Procedure Free_Resource;

Procedure Find_Menu(Index: Integer; Var Menu: Menu_Ptr);

Procedure Find_Dialog(Index: Integer; Var Dial: Dialog_Ptr);

Procedure Find_Alert(Index: Integer; Var Alert: Str255);

Function Find_Resource(R_Type, R_Index: Integer): Tree_Ptr;

Procedure Form_Dial(flag,litx,lity,litw,lith,bigx,bigy,bigw,bigh: Integer);

Function Form_Do(Dialog: Dialog_Ptr; Ed_Start: Integer): Integer;

Procedure Obj_Draw(Dialog: Dialog_Ptr; Start, Tiefe, x,y,w,h: Integer);

Function Do_Dialog(Dialog: Dialog_Ptr; Ed_Start: Integer): Integer;

Function Redo_Dialog(Dial: Dialog_Ptr; Ed_Start: Integer): Integer;

Procedure Show_Dialog(Dialog: Dialog_Ptr);

Procedure Center_Dialog(Dial: Dialog_Ptr);

Procedure End_Dialog(Dialog: Dialog_Ptr);

Procedure Set_DText(Dial: Dialog_Ptr; Item: Tree_Index; s: Str255;
                    Font: Integer; Just: TE_Just);

Procedure Set_DEdit(Dial: Dialog_Ptr; Item: Tree_Index;
                    Template, Valid, Initial: Str255;
                    Font: Integer; Just: TE_Just);

Procedure Obj_SetState(Dial: Dialog_Ptr; Index: Tree_Index;
                       State: Integer; Redraw: Boolean);

Function Obj_State(Dial: Dialog_Ptr; Index: Integer): Integer;

Procedure Obj_SetFlags(Dial: Dialog_Ptr; Index: Tree_Index;
                       Flags: Integer);

Function Obj_Flags(Dial : Dialog_Ptr; Index : Integer) : Integer;

Procedure Get_DEdit(Dial : Dialog_Ptr; Item : Tree_Index; Var s : Str255);

Procedure Draw_Menu(Menu : Menu_Ptr);

Procedure Erase_Menu(Menu : Menu_Ptr);

Procedure Menu_Hilight(Menu : Menu_Ptr; Title : Tree_Index);

Procedure Menu_Normal(Menu : Menu_Ptr; Title : Tree_Index);

Procedure Menu_Check(Menu : Menu_Ptr; Item : Tree_Index; Checked : Boolean);

Procedure Menu_Enable(Menu : Menu_Ptr; Item : Tree_Index);

Procedure Menu_Disable(Menu : Menu_Ptr; Item : Tree_Index);

Procedure Menu_Text(Menu: Menu_Ptr; Item: Tree_Index; MText: Str255);

Function Menu_Register(Id : Integer; Var Name : Str255) : Integer;

Procedure Menu_Unregister(Id: Integer);

Function Menu_Click(Click, Setit: Integer): Integer;

Function New_Window(w_type : Integer; Var Title : Window_Title;
                    x_max, y_max, w_max, h_max : Integer) : Integer;

Procedure Open_Window(Handle : Integer; x, y, w, h : Integer);

Procedure Set_WName(Handle : Integer; Var Name : Window_Title);

Procedure Set_Winfo(Handle : Integer; Var info : Window_Title);

Procedure Close_Window(Handle : Integer);

Procedure Delete_Window(Handle : Integer);

Procedure Work_Rect(Handle : Integer; Var x, y, w, h : Integer);

Function Front_Window : Integer;

Procedure Bring_To_Front(Handle : Integer);

Procedure Set_Window(Handle: Integer);

Function Get_Window: Integer;

Procedure Wind_Get(Handle, request : Integer; Var v1, v2, v3, v4 : Integer);

{ BALJ - 20000604 - Wind_Calc routine seemed to be missing }
Procedure Wind_Calc(CalcType, WinType : Integer; Var x, y, w, h : Integer);

Procedure Wind_Set(Handle, Request : Integer; v1, v2, v3, v4 : Integer);

Function Get_In_File(Var Path, Name : Path_Name) : Boolean;

{$IFDEF Atari}
Function Get_Ex_In_File(Var Path, Name : Path_Name; Title : String) : Boolean;
{$ENDIF}

Function Get_Out_File(Prompt: Str255; Var Name: Path_Name): Boolean;

Procedure Rubberbox(x, y, w1, h1 : Integer; Var w2, h2 : Integer);

Procedure Movebox(x1, y1, w, h, x2, y2 : Integer);

Procedure Dragbox(x1,y1,w1,h1,x2,y2,w2,h2 : Integer; Var Endx, Endy : Integer);

Procedure Growbox(stx, sty, stw, sth, fix, fiy, fiw, fih : Integer);

Procedure Shrinkbox(stx, sty, stw, sth, fix, fiy, fiw, fih : Integer);

Function Slidebox(Dialog : Dialog_Ptr; Vater,Sohn,Modus:Integer):Integer;

Procedure Xgrf_Stepcalc(stw, sth, xc, yc, w, h : Integer;
                        Var cx, cy, cnt, xstep, ystep : Integer);

Procedure Xgrf_2Box(xc, yc, w, h : Integer; corners : Boolean;
                    cnt, xstep, ystep : Integer; doubled : Boolean);

Function Get_Event(emask, bmask, bstate, n_clicks : Integer;
                   ticks : LongInt;
                   m1_flag : Boolean; m1x, m1y, m1w, m1h : Integer;
                   m2_flag : Boolean; m2x, m2y, m2w, m2h : Integer;
                   Var message : Message_Buffer;
                   Var key, brtn, bclick, mx, my, kstate : Integer): Integer;

Procedure Set_Clip(x, y, w, h: Integer);

Procedure Draw_String(x, y :Integer; s: Str255);

Procedure Justified_Text(x, y, len, wrd, Chr :Integer; s: Str255);

Procedure Text_Alignment(h, v : Integer);

Procedure Line_Color(Color_Index: Integer);

Procedure Set_Color(Color : Integer; Red, Green, Blue : Integer);

Procedure Line_Width(width: Integer);

Procedure Draw_Mode(Mode: Integer);

Procedure Paint_Color(Color_Index: Integer);

Procedure Paint_Style(Style_Index: Integer);

Procedure Paint_Outline(On : Boolean);

Procedure Paint_Rect(x, y, w, h: Integer);

Procedure Line_Endstyle(beg_Style, End_Style: Integer);

Procedure Line_Style(Style: Integer);

Procedure Move_To(x, y : Integer);

Procedure Pline(x1, y1, x2, y2 : Integer);

Procedure Line_To(x, y : Integer);

Procedure Plot(x, y : Integer);

Procedure Frame_Rect(x, y, w, h: Integer);

Procedure Text_Heigth(Height: Integer);

Function Text_Point(Height: Integer): Integer;

Procedure Text_Color(Color : Integer);

Procedure Text_Style(Style: Integer);

Procedure Text_Rotation(Angle: Integer);

Procedure First_Rect(Hand: Integer; VAR x, y, w, h: Integer);

Procedure Next_Rect(Hand: Integer; VAR x, y, w, h: Integer);

Function Rect_Intersect(x1, y1, w1, h1: Integer;
                        VAR x2, y2, w2, h2: Integer): Boolean;

Procedure Set_WSize(hand, x, y, w, h: Integer);

Procedure Sys_Font_Size(VAR wchar, hchar, wbox, hbox: Integer);

Procedure Clear_Screen;

Procedure Begin_Update;

Procedure End_Update;

Procedure Begin_Mouse;

Procedure End_Mouse;

Procedure Paint_Oval(x, y, x_rad, y_rad: Integer);

Procedure Frame_Oval(x, y, x_rad, y_rad: Integer);

Procedure Paint_Round_Rect(x, y, w, h : Integer);

Procedure Frame_Round_Rect(x, y, w, h : Integer);

Procedure Paint_Arc(x, y, x_rad, y_rad, beg_ang, end_ang : Integer);

Procedure Frame_Arc(x, y, x_rad, y_rad, beg_ang, end_ang : Integer);

Procedure Border_Rect(Handle: Integer; Var x, y, w, h: Integer);

Function Obj_Find(Dial: Dialog_Ptr; Start, Depth, x, y : Integer): Integer;

Procedure Obj_Offset(Dial: Dialog_Ptr; Index: Integer; VAR x, y: Integer);

Procedure Obj_Size(Dial: Dialog_Ptr; Index: Integer; Var x, y, w, h: Integer);

Procedure Obj_Redraw(Dial: Dialog_Ptr; Item: Tree_Index);

Function Find_Window(x, y: Integer): Integer;

Procedure Obj_Add(Dial: Tree_Ptr; Parent, Child: Integer);

Procedure Rsrc_Obfix(Dial: Tree_Ptr; Obj: Integer);

Function D_Color(Border, Text: Integer; Mode: Boolean;
                 Pattern, Inside: Integer): Integer;

Function New_Dialog(N_Items, x, y, w, h: Integer): Dialog_Ptr;

Function Add_DItem(Dial: Dialog_Ptr; Obj_Type, Flags: Integer;
                   x, y, w, h: Integer; Border, Color: Integer): Tree_Index;

Procedure Delete_Dialog(Dial: Dialog_Ptr);

Function New_Menu(N_Items: Integer; About: Str255): Menu_Ptr;

Function Add_MTitle(Menu: Menu_Ptr; Item: Str255): Integer;

Function Add_MItem(Menu: Menu_Ptr; Title: Tree_Index; Item: Str255): Integer;

Procedure Delete_Menu(Menu: Menu_Ptr);

Function Load_Fonts: Integer;

{$IFNDEF Atari}
Function Ex_Load_Fonts(Font_Max, Font_Free: Integer): Integer;
{$ENDIF}

Procedure Unload_Fonts;

Procedure Set_Font(Font: Integer);

Function Font_Name(Font: Integer; Var Name: String): Integer;

Function Get_Keyboard: Integer;

Function Get_Button(bclicks, bmask, bstate: Integer;
                    Var bmx, bmy, bbutton, bkstate: Integer): Integer;

Function Get_Mouse(moflags, mox, moy, mowidth, moheight: Integer;
                   Var momx, momy, mobutton, mokstate: Integer): Integer;

Function Get_Message(Var msg: Message_Buffer): Integer;

Function Get_Timer(ticks: Longint): Integer;

Procedure TLine(Winkel, Laenge: Integer);

Function String_Width(S: Str255): Integer;

Procedure Font_Info(Var MinADE, MaxADE, dist0, dist1, dist2, dist3, dist4,
                    MaxWidth, eff0, eff1, eff2: Integer);

Function GEM_Installed : Boolean;

Implementation

Const Crystal : Array [10..131,1..3] Of Byte =
      (
{ 10} (0, 1, 0), (2, 1, 1), (2, 1, 1),
      (0, 1, 1), (2, 1, 1), (1, 1, 1),
      (2, 1, 0), (0, 1, 0), (0, 0, 0),
{ 19} (0, 1, 0), (0, 1, 0), (3, 5, 0),
      (5, 5, 0), (0, 1, 1), (2, 1, 0),
      (16,7, 1), (2, 1, 0), (0, 0, 0),
{ 28} (0, 0, 0), (0, 0, 0), (1, 1, 1),
      (2, 1, 1), (2, 1, 1), (2, 1, 1),
      (1, 1, 2), (1, 1, 1), (1, 1, 0),
{ 37} (2, 1, 0), (0, 0, 0), (0, 0, 0),
      (2, 1, 1), (1, 1, 1), (6, 1, 1),
      (4, 1, 1), (1, 3, 1), (2, 1, 1),
{ 46} (4, 2, 1), (8, 1, 1), (0, 0, 0),
      (0, 0, 0), (1, 1, 1), (9, 1, 0),
      (1, 1, 1), (1, 1, 0), (0, 5, 1),
{ 55} (3, 3, 1), (2, 2, 1), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
{ 64} (0, 0, 0), (0, 0, 0), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
      (4, 3, 0), (8, 3, 0), (6, 1, 0),
{ 73} (8, 1, 0), (8, 1, 0), (4, 1, 1),
      (3, 1, 1), (0, 5, 0), (1, 1, 1),
      (0, 5, 0), (0, 1, 1), (0, 1, 1),
{ 82} (0, 1, 0), (0, 0, 0), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 2, 2),
{ 91} (0, 2, 3), (0, 0, 0), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
{100} (5, 1, 0), (5, 1, 0), (1, 1, 0),
      (1, 1, 0), (2, 5, 0), (6, 1, 0),
      (2, 1, 0), (1, 1, 0), (6, 5, 0),
{109} (0, 0, 0), (0, 1, 1), (0, 1, 0),
      (2, 1, 0), (2, 1, 1), (1, 1, 1),
      (0, 0, 0), (0, 0, 0), (0, 0, 0),
{118} (0, 0, 0), (0, 0, 0), (0, 1, 2),
      (3, 1, 2), (1, 1, 1), (1, 1, 1),
      (0, 1, 1), (0, 1, 2), (0, 1, 2),
{127} (0, 0, 2), (0, 0, 0), (0, 0, 0),
      (6, 6, 0), (9, 1, 0)
      );

      rad = 0.017453292;

Var TurtleX, TurtleY : Integer; { aktuelle Position der Turtle }
Var AktWind,                    { Fenster auf das sich die Koordinaten beziehen }
    OffsetX, OffsetY : Integer; { Offset, der zu jeder Koordinate addiert wird }

Function Min(a, b: Integer) : Integer;
Begin
  If a < b Then Min := a Else Min := b
End;

Function Max(a, b: Integer) : Integer;
Begin
  If a > b Then Max := a Else Max := b
End;

Function RPos(c: Char; s: String): Integer;
{letzte Position von c in s, sonst 0}
Var i : Integer;
Begin
  i := Length(s);
  While (c <> s[i]) And (i > 0) Do
    i := i - 1;
  RPos := i;
End;

Function File_Exists(Name: Path_Name): Boolean;
Var f : File;
Begin
  {$I-}
  Assign(f, Name);
  Reset(f);
  File_Exists := (IOResult = 0);
  {$I+}
end;

Procedure Pas_To_C(s : Str255; Var C_Str : C_String);
Var i : Integer;
Begin
  For i := 1 To Length(s) Do
    C_Str[i-1] := s[i];
  C_Str[Length(s)] := Chr(0);
End;

Procedure C_To_Pas(C_Str : C_String; Var s : Str255);
Var i : Integer;
Begin
  i := 0;
  s := '';
  While C_str[i] <> Chr(0) Do
  Begin
    s := Concat(s,C_Str[i]);
    i := i + 1;
  End;
End;

Procedure Split_Addr(Addr : Pointer; Var p1, p2 : Integer);
Var Trick : Record Case Integer Of
              0 : (p : Pointer);
              1 : (a1 : Integer;
                   a2 : Integer);
            End;
Begin
  Trick.p := Addr;
  p1 := Trick.a1;
  p2 := Trick.a2;
End;

{$IFNDEF Atari}
Procedure AES_Call(op : Integer; Var Int_In   : Int_In_Parms;
                                 Var Int_Out  : Int_Out_Parms;
                                 Var Addr_In  : Addr_In_Parms;
                                 Var Addr_Out : Addr_Out_Parms);
Var Regs : Registers;
    Addr_Block : Record
                   Control_Point  : Pointer;
                   Global_Point   : Pointer;
                   Int_In_Point   : Pointer;
                   Int_Out_Point  : Pointer;
                   Addr_In_Point  : Pointer;
                   Addr_Out_Point : Pointer;
                 End;
Begin
  Control[0] := Op;
  Control[1] := Crystal[Op,1];
  Control[2] := Crystal[Op,2];
  Control[3] := Crystal[Op,3];
  Addr_Block.Control_Point  := Addr(Control);
  Addr_Block.Global_Point   := Addr(Global);
  Addr_Block.Int_In_Point   := Addr(Int_In);
  Addr_Block.Int_Out_Point  := Addr(Int_Out);
  Addr_Block.Addr_In_Point  := Addr(Addr_In);
  Addr_Block.Addr_Out_Point := Addr(Addr_Out);
  Regs.ES := Seg(Addr_Block);
  Regs.BX := Ofs(Addr_Block);
  Regs.CX := 200;  { AES - Kennziffer }
  Intr($EF,Regs);
End;

Procedure VDI_Call(Cmd, Sub_Cmd : Integer; NInts, NPts : Integer;
                   Var Control  : Ctrl_Parms;
                   Var Int_In   : Int_In_Parms;
                   Var Int_Out  : Int_Out_Parms;
                   Var Pts_In   : Pts_In_Parms;
                   Var Pts_Out  : Pts_Out_Parms;
                   Translate    : Boolean);
Var i : Integer;
    Regs : Registers;
    Addr_Block : Record
                   Control_Point : Pointer;
                   Int_In_Point  : Pointer;
                   Pts_In_Point  : Pointer;
                   Int_Out_Point : Pointer;
                   Pts_Out_Point : Pointer;
                 End;
Begin
  If Translate And (AktWind >= 0) Then
  Begin
    For i := 1 To NPts Do
    Begin
      Pts_In[2*i-2] := Pts_In[2*i-2] + OffsetX;
      Pts_In[2*i-1] := Pts_In[2*i-1] + OffsetY;
    End;
  End;
  Control[0] := Cmd;
  Control[1] := NPts;
  Control[3] := NInts;
  Control[5] := Sub_Cmd;
  Control[6] := VDI_Handle;
  Addr_Block.Control_Point := Addr(Control);
  Addr_Block.Int_In_Point  := Addr(Int_In);
  Addr_Block.Pts_In_Point  := Addr(Pts_In);
  Addr_Block.Int_Out_Point := Addr(Int_Out);
  Addr_Block.Pts_Out_Point := Addr(Pts_Out);
  Regs.DS := Seg(Addr_Block);
  Regs.DX := Ofs(Addr_Block);
  Regs.CX := 1139; { VDI - Kennziffer }
  Intr($EF,Regs);
End;
{$ENDIF}

{$IFDEF Atari}

{$L D:\PPASCAL\SOURCEX\XAESVDI.O}

Procedure XAES (Adr : Pointer);
External;

Procedure XVDI (Adr : Pointer);
External;

Procedure AES_Call(op : Integer; Var Int_In   : Int_In_Parms;
                                 Var Int_Out  : Int_Out_Parms;
                                 Var Addr_In  : Addr_In_Parms;
                                 Var Addr_Out : Addr_Out_Parms);
Var Addr_Block : Record
                   Control_Point  : Pointer;
                   Global_Point   : Pointer;
                   Int_In_Point   : Pointer;
                   Int_Out_Point  : Pointer;
                   Addr_In_Point  : Pointer;
                   Addr_Out_Point : Pointer;
                 End;
Begin
  Control[0] := Op;
  Control[1] := Crystal[Op,1];
  Control[2] := Crystal[Op,2];
  Control[3] := Crystal[Op,3];
  Addr_Block.Control_Point  := Addr(Control);
  Addr_Block.Global_Point   := Addr(Global);
  Addr_Block.Int_In_Point   := Addr(Int_In);
  Addr_Block.Int_Out_Point  := Addr(Int_Out);
  Addr_Block.Addr_In_Point  := Addr(Addr_In);
  Addr_Block.Addr_Out_Point := Addr(Addr_Out);
  XAES(Addr(Addr_Block));
End;

Procedure VDI_Call(Cmd, Sub_Cmd : Integer; NInts, NPts : Integer;
                   Var Control  : Ctrl_Parms;
                   Var Int_In   : Int_In_Parms;
                   Var Int_Out  : Int_Out_Parms;
                   Var Pts_In   : Pts_In_Parms;
                   Var Pts_Out  : Pts_Out_Parms;
                   Translate    : Boolean);
Var i : Integer;
    Addr_Block : Record
                   Control_Point : Pointer;
                   Int_In_Point  : Pointer;
                   Pts_In_Point  : Pointer;
                   Int_Out_Point : Pointer;
                   Pts_Out_Point : Pointer;
                 End;
Begin
  If Translate And (AktWind >= 0) Then
  Begin
    For i := 1 To NPts Do
    Begin
      Pts_In[2*i-2] := Pts_In[2*i-2] + OffsetX;
      Pts_In[2*i-1] := Pts_In[2*i-1] + OffsetY;
    End;
  End;
  Control[0] := Cmd;
  Control[1] := NPts;
  Control[3] := NInts;
  Control[5] := Sub_Cmd;
  Control[6] := VDI_Handle;
  Addr_Block.Control_Point := Addr(Control);
  Addr_Block.Int_In_Point  := Addr(Int_In);
  Addr_Block.Pts_In_Point  := Addr(Pts_In);
  Addr_Block.Int_Out_Point := Addr(Int_Out);
  Addr_Block.Pts_Out_Point := Addr(Pts_Out);
  XVDI(Addr(Addr_Block));
End;
{$ENDIF}

Procedure AES(Op: Integer);
Begin
  AES_Call(Op,Int_In,Int_Out,Addr_In,Addr_Out);
End;

Procedure VDI(Cmd, Sub_Cmd, NInts, NPts: Integer; Translate: Boolean);
Begin
  VDI_Call(Cmd, Sub_Cmd, NInts, NPts, Control,
           Int_In,Int_Out,Pts_In,Pts_Out,
           Translate);
End;

Function Init_GEM : Integer;
Var i : Integer;
Begin
  If GEM_Installed Then
  Begin
    AES(10);           { Appl_Init }
    Init_GEM := Int_Out[0];
    If Int_Out[0] >= 0 Then
    Begin
      AES(77);         { Graf_Handle }
      VDI_Handle := Int_Out[0];
      For i := 0 To 9 Do
        Int_In[i] := 1;
      Int_In[10] := 2;
      VDI(100,0,11,0,False); { virtuelle Workstation auf }
      VDI_Handle := Control[6];
      GEMResX := Int_Out[0];
      GEMResY := Int_Out[1];
    End;
  End
  Else Init_GEM := -1;
End;

Procedure Exit_GEM;
Begin
  VDI(101,0,0,0,False); { virtuelle Workstation zu }
  AES(19);              { Appl_Exit }
End;

Function Open_Workstation(Id, Mode, Size : Integer): Integer;
Var i : Integer;
Begin
  Int_In[0] := Id;
  For i := 1 To 9 Do
    Int_In[i] := 1;
  Int_In[10] := Mode;
  Int_In[11] := (Size * 256) + 255;
  VDI(1, 0, 12, 0, False);
  Open_Workstation := Control[6];
End;

Procedure Close_Workstation;
Begin
  VDI(2, 0, 0, 0, False);
End;

Procedure Clear_Workstation;
Begin
  VDI(3, 0, 0, 0, False);
End;

Procedure Update_Workstation;
Begin
  VDI(4, 0, 0, 0, False);
End;

Procedure Form_Advance;
Begin
  VDI(5, 20, 0, 0, False);
End;

Procedure Alpha_Text(t : Str255);
Var i : Integer;
Begin
  For i := 1 To Length(t) Do
    Int_In[i-1] := Ord(t[i]);
  Int_In[Length(t)] := 0;
  VDI(5, 25, Length(t), 0, False);
End;

Function AES_Version : Integer;
Begin
  AES_Version := Global[0];
End;

Procedure Hide_Mouse;
Begin
  Int_In[0] := 256;
  AES(78);
End;

Procedure Show_Mouse;
Begin
  Int_In[0] := 257;
  AES(78);
End;

Procedure Set_MForm(Var Form : Mouse_Form);
Var i : Integer;
Begin
  Int_In[0] := 255; { User-definierte Mausform }
  Addr_In[0] := Addr(Form);
  AES(78);
End;

Procedure Set_Mouse(M_Type : Mouse_Type);
Begin
  Int_In[0] := Ord(M_Type);
  AES(78);
End;

Procedure Mouse_Position(x, y: Integer);
Var Feld: Array[1..3] of Integer;
Begin
  Int_In[0] := 1;
  Int_In[1] := 100;
  Feld[1] := 2;
  Feld[2] := x;
  Feld[3] := y;
  Addr_In[0] := Addr(Feld);
  AES(14);
End;

Procedure Init_Mouse;
Begin
  Hide_Mouse;
  Set_Mouse(M_Arrow);
  Show_Mouse;
End;

Function Do_Alert(Maske : Str255; Btn : Integer) : Integer;
Begin
  Int_In[0] := Btn;
  Maske[Length(Maske)+1] := Chr(0);     { C-Konvention }
  Addr_In[0] := Addr(Maske[1]);         { 0. Byte berspringen ! }
  AES(52);
  Do_Alert := Int_Out[0];
End;

Function Load_Resource(Name : String) : Boolean;
Begin
  Name[Length(Name)+1] := Chr(0);
  Addr_In[0] := Addr(Name[1]);
  AES(110);
  Load_Resource := (Int_Out[0] <> 0);
End;

Procedure Free_Resource;
Begin
  AES(111);
End;

Procedure Find_Menu(Index : Integer; Var Menu : Menu_Ptr);
Begin
  Int_In[0] := R_Tree;
  Int_In[1] := Index;
  AES(112);
  Menu := Menu_Ptr(Addr_Out[0]);
End;

Procedure Find_Dialog(Index : Integer; Var Dial : Dialog_Ptr);
Begin
  Int_In[0] := R_Tree;
  Int_In[1] := Index;
  AES(112);
  Dial := Dialog_Ptr(Addr_Out[0]);
End;

Procedure Find_Alert(Index: Integer; Var Alert: Str255);
Var i : Integer;
    PStr : String_Ptr;
Begin
  Int_In[0] := R_String;
  Int_In[1] := Index;
  AES(112);
  PStr := String_Ptr(Addr_Out[0]);
  C_To_Pas(PStr^,Alert);
End;

Function Find_Resource(R_Type, R_Index : Integer): Tree_Ptr;
Begin
  Int_In[0] := R_Type;
  Int_In[1] := R_Index;
  AES(112);
  Find_Resource := Tree_Ptr(Addr_Out[0]);
End;

Procedure Form_Dial(flag,litx,lity,litw,lith,bigx,bigy,bigw,bigh : Integer);
Begin
  Int_In[0] := flag;
  Int_In[1] := litx;
  Int_In[2] := lity;
  Int_In[3] := litw;
  Int_In[4] := lith;
  Int_In[5] := bigx;
  Int_In[6] := bigy;
  Int_In[7] := bigw;
  Int_In[8] := bigh;
  AES(51);
End;

Function Form_Do(Dialog : Dialog_Ptr; Ed_Start : Integer) : Integer;
Begin
  Int_In[0] := Ed_Start;
  Addr_In[0] := Pointer(Dialog);
  AES(50);
  Form_Do := Int_Out[0];
End;

Procedure Obj_Draw(Dialog : Dialog_Ptr; Start, Tiefe, x,y,w,h : Integer);
Begin
  Int_In[0] := Start;
  Int_In[1] := Tiefe;
  Int_In[2] := x;
  Int_In[3] := y;
  Int_In[4] := w;
  Int_In[5] := h;
  Addr_In[0] := Pointer(Dialog);
  AES(42);
End;

Function Do_Dialog(Dialog : Dialog_Ptr; Ed_Start : Integer) : Integer;
Var xdial, ydial, wdial, hdial,
    oldx, oldy, oldw, oldh : Integer;
Begin
  Begin_Update;
  xdial := Dialog^[root].ob_x;
  ydial := Dialog^[root].ob_y;
  wdial := Dialog^[root].ob_w;
  hdial := Dialog^[root].ob_h;
  If Dialog^[root].ob_state And Outlined <> 0 Then
  Begin
    xdial := xdial - 3;
    If xdial < 0 Then xdial := 0;
    ydial := ydial - 3;
    If ydial < 0 Then ydial := 0;
    wdial := wdial + 6;
    hdial := hdial + 6;
  End;
  Form_Dial(0,0,0,0,0,xdial,ydial,wdial,hdial);
  Hide_Mouse;
  Obj_Draw(Dialog,root,max_depth,xdial,ydial,wdial,hdial);
  Show_Mouse;
  Do_Dialog := Form_Do(Dialog,Ed_Start);
  End_Update;
End;

Function Redo_Dialog(Dial: Dialog_Ptr; Ed_Start: Integer): Integer;
Begin
  Redo_Dialog := Form_Do(Dial, Ed_Start);
End;

Procedure Show_Dialog(Dialog : Dialog_Ptr);
Begin
  Int_In[0] := Root;
  Int_In[1] := Max_Depth;
  Int_In[2] := 0;
  Int_In[3] := 0;
  Int_In[4] := GEMResX;
  Int_In[5] := GEMResY;
  Addr_In[0] := Pointer(Dialog);
  AES(42);
End;

Procedure Center_Dialog(Dial : Dialog_Ptr);
Begin
{ dieser Code wuerde form_center ersetzten und Dialoge in allen
  Aufloesungen zentrieren

  Dial^[Root].ob_x := (GEMResX - Dial^[Root].ob_w) Div 2;
  Dial^[Root].ob_y := (GEMResY - Dial^[Root].ob_h) Div 2;
}
  Addr_In[0] := Pointer(Dial);
  AES(54);
End;

Procedure End_Dialog(Dialog : Dialog_Ptr);
Var xdial, ydial, wdial, hdial : Integer;
Begin
  xdial := Dialog^[root].ob_x;
  ydial := Dialog^[root].ob_y;
  wdial := Dialog^[root].ob_w;
  hdial := Dialog^[root].ob_h;
  If Dialog^[root].ob_state and outlined <> 0 Then
  Begin
    xdial := xdial - 3;
    If xdial < 0 Then xdial := 0;
    ydial := ydial - 3;
    If ydial < 0 Then ydial := 0;
    wdial := wdial + 6;
    hdial := hdial + 6;
  End;
  Form_Dial(3,0,0,0,0,xdial,ydial,wdial,hdial);
End;

Procedure Set_DText(Dial : Dialog_Ptr; Item : Tree_Index; s : Str255;
                     Font : Integer; Just : TE_Just);
{Es drfen keine lngeren Texte eingesetzt werden, als mit dem RCS Platz}
{reserviert wurde!!!}
Var i : Integer;
Begin
  If (Dial^[Item].ob_type = G_String) Or (Dial^[Item].ob_type = G_Button)
    Or (Dial^[Item].ob_type = G_Title) Then
  Begin
    For i := 1 To Length(s) Do
      Dial^[Item].ob_spec.str^[i-1] := s[i];
    Dial^[Item].ob_spec.str^[Length(s)] := Chr(0);
  End;
  If (Dial^[Item].ob_type = G_Text) Or (Dial^[Item].ob_type = G_BoxText) or
     (Dial^[Item].ob_type = G_FText) Or (Dial^[Item].ob_type = G_FBoxText) Then
  Begin
    For i := 1 To Length(s) Do
      Dial^[Item].ob_spec.info^.te_ptext^[i-1] := s[i];
    Dial^[Item].ob_spec.info^.te_ptext^[Length(s)] := Chr(0);
(*
    Dial^[Item].ob_spec.info^.te_txtlen :=
      Max(Length(s) + 1, Dial^[Item].ob_spec.info^.te_tmplen);
*)
    Dial^[Item].ob_spec.info^.te_font := Font;
    Dial^[Item].ob_spec.info^.te_just := Ord(Just);
 End;
End;

Procedure Set_DEdit(Dial : Dialog_Ptr; Item : Tree_Index;
                    template, valid, initial : Str255;
                    Font : Integer; Just : TE_Just);
{Es drfen keine lngeren Texte eingesetzt werden, als mit dem RCS Platz}
{reserviert wurde!!!}
Var i : Integer;
Begin
  If (Dial^[Item].ob_type = G_Text) Or (Dial^[Item].ob_type = G_BoxText) or
     (Dial^[Item].ob_type = G_FText) Or (Dial^[Item].ob_type = G_FBoxText) Then
  Begin
    For i := 1 To Length(initial) Do
      Dial^[Item].ob_spec.info^.te_ptext^[i-1] := initial[i];
    Dial^[Item].ob_spec.info^.te_ptext^[Length(initial)] := Chr(0);
    Dial^[Item].ob_spec.info^.te_txtlen := Length(valid) + 1; { wg. #0 }
    For i := 1 To Length(template) Do
      Dial^[Item].ob_spec.info^.te_ptmplt^[i-1] := template[i];
    Dial^[Item].ob_spec.info^.te_ptmplt^[Length(template)] := Chr(0);
    Dial^[Item].ob_spec.info^.te_tmplen := Length(template) + 1; { wg. #0 }
    For i := 1 To Length(valid) Do
      Dial^[Item].ob_spec.info^.te_pvalid^[i-1] := valid[i];
    Dial^[Item].ob_spec.info^.te_pvalid^[Length(valid)] := Chr(0);
    Dial^[Item].ob_spec.info^.te_font := Font;
    Dial^[Item].ob_spec.info^.te_just := Ord(Just);
 End;
End;

Procedure Obj_SetState(Dial : Dialog_Ptr; Index : Tree_Index;
                        State : Integer; Redraw : Boolean);
Begin
  Dial^[Index].ob_state := State;
  If Redraw Then Show_Dialog(Dial);
End;

Function Obj_State(Dial : Dialog_Ptr; Index : Integer) : Integer;
Begin
  Obj_State := Dial^[Index].ob_state;
End;

Procedure Obj_SetFlags(Dial : Dialog_Ptr; Index : Tree_Index;
                       Flags : Integer);
Begin
  Dial^[Index].ob_flags := Flags;
End;

Function Obj_Flags(Dial : Dialog_Ptr; Index : Integer) : Integer;
Begin
  Obj_Flags := Dial^[Index].ob_flags;
End;

Procedure Get_DEdit(Dial : Dialog_Ptr; Item : Tree_Index; Var s: Str255);
Var C_Str : C_String;
Begin
  C_Str := Dial^[Item].ob_spec.info^.te_ptext^;
  C_To_Pas(C_Str,s);
End;

Procedure Draw_Menu(Menu : Menu_Ptr);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := 1;
  AES(30);
End;

Procedure Erase_Menu(Menu : Menu_Ptr);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := 0;
  AES(30);
End;

Procedure Menu_Enable(Menu : Menu_Ptr; Item : Tree_Index);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := Item;
  Int_In[1] := 1;
  AES(32);
End;

Procedure Menu_Disable(Menu : Menu_Ptr; Item : Tree_Index);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := Item;
  Int_In[1] := 0;
  AES(32);
End;

Procedure Menu_Text(Menu: Menu_Ptr; Item: Tree_Index; MText: Str255);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := Item;
  MText[Length(MText)+1] := Chr(0);
  MText[0] := Chr(0);
  Addr_In[1] := Addr(MText[1]);
  AES(34);
End;

Procedure Menu_Normal(Menu : Menu_Ptr; Title : Tree_Index);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := Title;
  Int_In[1] := 1;
  AES(33);
End;

Procedure Menu_Check(Menu : Menu_Ptr; Item : Tree_Index; Checked : Boolean);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := Item;
  Int_In[1] := Ord(Checked);
  AES(31);
End;

Function Menu_Register(Id : Integer; Var Name : Str255) : Integer;
Begin
  Int_In[0] := Id;
  Name[Length(Name)+1] := Chr(0);
  Addr_In[0] := Addr(Name[1]);
  AES(35);
  Menu_Register := Int_Out[0];
End;

Procedure Menu_Unregister(Id: Integer);
Begin
  If AES_Version >= $200 Then
  Begin
    Int_In[0] := Id;
    AES(36);
  End;
End;

Function Menu_Click(Click, Setit: Integer): Integer;
Begin
  If AES_Version >= $300 Then
  Begin
    Int_In[0] := Click;
    Int_In[1] := Setit;
    AES(37);
    Menu_Click := Int_Out[0];
  End
  Else Menu_Click := 0;  { alte GEM Versionen koennen nur Drop-Down }
End;

Procedure Menu_Hilight(Menu : Menu_Ptr; Title : Tree_Index);
Begin
  Addr_In[0] := Pointer(Menu);
  Int_In[0] := Title;
  Int_In[1] := 0;
  AES(33);
End;

Function New_Window(w_type : Integer; Var Title : Window_Title;
                     x_max, y_max, w_max, h_max : Integer) : Integer;
Begin
  If (w_max=0) And (h_max=0) Then Work_Rect(0, x_max, y_max, w_max, h_max);
  Int_In[0] := w_type;
  Int_In[1] := x_max;
  Int_In[2] := y_max;
  Int_In[3] := w_max;
  Int_In[4] := h_max;
  AES(100);
  New_Window := Int_Out[0];
  Int_In[0] := Int_Out[0];
  Int_In[1] := WF_Name;
  Title[Length(Title)+1] := Chr(0);
  Split_Addr(Addr(Title[1]),Int_In[2],Int_In[3]);
  AES(105);
End;

Procedure Open_Window(Handle : Integer; x, y, w, h : Integer);
Begin
  If (w=0) And (h=0) Then Work_Rect(0, x, y, w, h);
  Int_In[0] := Handle;
  Int_In[1] := x;
  Int_In[2] := y;
  Int_In[3] := w;
  Int_In[4] := h;
  AES(101);
End;

Procedure Set_WName(Handle : Integer; Var Name : Window_Title);
Begin
  Int_In[0] := Handle;
  Int_In[1] := WF_Name;
  Name[Length(Name)+1] := Chr(0);
  Split_Addr(Addr(Name[1]),Int_In[2],Int_In[3]);
  AES(105);
End;

Procedure Set_Winfo(Handle : Integer; Var Info : Window_Title);
Begin
  Int_In[0] := Handle;
  Int_In[1] := WF_Info;
  Info[Length(Info)+1] := Chr(0);
  Split_Addr(Addr(Info[1]),Int_In[2],Int_In[3]);
  AES(105);
End;

Procedure Close_Window(Handle : Integer);
Begin
  Int_In[0] := Handle;
  AES(102);
End;

Procedure Delete_Window(Handle : Integer);
Begin
  Int_In[0] := Handle;
  AES(103);
End;

Procedure Work_Rect(Handle : Integer; Var x, y, w, h : Integer);
Begin
  Wind_Get(Handle, WF_WorkXYWH, x, y, w, h);
End;

Procedure Wind_Get(Handle, Request : Integer; Var v1, v2, v3, v4 : Integer);
Begin
  Int_In[0] := Handle;
  Int_In[1] := Request;
  AES(104);
  v1 := Int_Out[1];
  v2 := Int_Out[2];
  v3 := Int_Out[3];
  v4 := Int_Out[4];
End;

Procedure Wind_Calc(CalcType, WinType : Integer; Var x, y, w, h : Integer);
Begin                   { BALJ - WIND_CALC missing from original bindings }
  Int_In[0] := CalcType;
  Int_In[1] := WinType;
  Int_In[2] := x;
  Int_In[3] := y;
  Int_In[4] := w;
  Int_In[5] := h;
  AES(108);
  x := Int_Out[1];
  y := Int_Out[2];
  w := Int_Out[3];
  h := Int_Out[4];
End;

Procedure Wind_Set(Handle, Request : Integer; v1, v2, v3, v4 : Integer);
Begin
  Int_In[0] := Handle;
  Int_In[1] := request;
  Int_In[2] := v1;
  Int_In[3] := v2;
  Int_In[4] := v3;
  Int_In[5] := v4;
  AES(105);
End;

Function Front_Window : Integer;
Begin
  Int_In[0] := 0;
  Int_In[1] := WF_Top;
  AES(104);
  Front_Window := Int_Out[1];
End;

Procedure Bring_To_Front(Handle : Integer);
Var foo : Integer;
Begin
  Int_In[0] := Handle;
  Int_In[1] := WF_Top;
  AES(105);
End;

Procedure Set_Window(Handle: Integer);
Var Dummy: Integer;
Begin
  AktWind := Handle;
  If AktWind < 0 Then
  Begin
    OffsetX := 0;
    OffsetY := 0;
  End
  Else
    Work_Rect(AktWind, OffsetX, OffsetY, Dummy, Dummy);
End;

Function Get_Window: Integer;
Begin
  Get_Window := AktWind;
End;

Function Get_In_File(Var Path, Name: Path_Name): Boolean;
Var i : Integer;
    Tmp : Path_Name;
Begin
  Path[Length(Path)+1] := Chr(0);
  Addr_In[0] := Addr(Path[1]);
  Tmp := Name;
  If Pos('\',Tmp) > 0 Then
    Delete(Tmp,1,RPos('\',Tmp));
  Tmp[Length(Tmp)+1] := Chr(0);
  Addr_In[1] := Addr(Tmp[1]);
  AES(90);
  Get_In_File := (Int_Out[1] <> 0);
  If Int_Out[1] <> 0 Then
  Begin
    C_To_Pas(String_Ptr(Addr(Tmp[1]))^, Name);
    C_To_Pas(String_Ptr(Addr(Path[1]))^, Tmp);
    Path := Tmp;
    If RPos('\',Path) > 0 Then
      Name := Concat(Copy(Path,1,RPos('\',Path)), Name);
  End;
End;

{$IFDEF Atari}
Function Get_Ex_In_File(Var Path, Name : Path_Name; Title : String) : Boolean;
Var i : Integer;
    Tmp : Path_Name;
Begin
  IF AES_Version >= $104 Then
  Begin
    Path[Length(Path)+1] := Chr(0);
    Addr_In[0] := Addr(Path[1]);
    Tmp := Name;
    If Pos('\',Tmp) > 0 Then
      Delete(Tmp,1,RPos('\',Tmp));
    Tmp[Length(Tmp)+1] := Chr(0);
    Addr_In[1] := Addr(Tmp[1]);
    Title[Length(Title)+1] := Chr(0);
    Addr_In[2] := Addr(Title[1]);
    AES(91);
    Get_Ex_In_File := (Int_Out[1] <> 0);
    If Int_Out[1] <> 0 Then
    Begin
      C_To_Pas(String_Ptr(Addr(Tmp[1]))^, Name);
      C_To_Pas(String_Ptr(Addr(Path[1]))^, Tmp);
      Path := Tmp;
      If RPos('\',Path) > 0 Then
        Name := Concat(Copy(Path,1,RPos('\',Path)), Name);
    End;
  End
  Else
    Get_Ex_In_File := Get_In_File(Path, Name);
End;
{$ENDIF}

Function Get_Out_File(Prompt: Str255; Var Name: Path_Name): Boolean;
Var Dial : Dialog_Ptr;
    Tmp,
    Edit,
    Ok,
    Cancel,
    Btn : Integer;
Begin
  Dial := New_Dialog(5, 0,0,38,8);
  Tmp := Add_DItem(Dial, G_String, None, 2,0,Length(Prompt),2, None, Black);
  Set_DText(Dial, Tmp, Prompt, System_Font, TE_Left);
  Edit := Add_DItem(Dial, G_FText, None, 2,3,36,1, 0, $1180);
  Set_DEdit(Dial, Edit, '__________________________________',
                        'PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP',
                        '                                  ',
                        System_Font, TE_Left);
  Set_DText(Dial, Edit, Name, System_Font, TE_Left);
  Ok := Add_DItem(Dial, G_Button, Selectable Or Default Or Exit_Btn,
                  8,5,8,2, 2, $1180);
  Set_DText(Dial, Ok, 'Ok', System_Font, TE_Left);
  Cancel := Add_DItem(Dial, G_Button, Selectable Or Exit_Btn,
                      22,5,8,2, 2, $1180);
  Set_DText(Dial, Cancel, 'Cancel', System_Font, TE_Left);
  Center_Dialog(Dial);
  Repeat
    Btn := Do_Dialog(Dial, Edit);
    Obj_SetState(Dial, Btn, Normal, True);
    Tmp := 0; { <> 1 }
    If Btn = Ok Then
    Begin
      Get_DEdit(Dial, Edit, Name);
      If File_Exists(Name) Then
        Tmp := Do_Alert('[2][Replace existing contents of|'+Name+' ?][ Ok | Cancel ]',2)
      Else
        Tmp := 1;
    End;
  Until (Btn = Cancel) Or (Tmp = 1);
  End_Dialog(Dial);
  Delete_Dialog(Dial);
  Get_Out_File := (Btn = Ok);
End;

Procedure Rubberbox(x, y, w1, h1 : Integer; Var w2, h2 : Integer);
Begin
  Int_In[0] := x;
  Int_In[1] := y;
  Int_In[2] := w1;
  Int_In[3] := h1;
  AES(70);
  w2 := Int_Out[1];
  h2 := Int_Out[2];
End;

Procedure Movebox(x1, y1, w, h, x2, y2 : Integer);
Begin
  Int_In[0] := w;
  Int_In[1] := h;
  Int_In[2] := x1;
  Int_In[3] := y1;
  Int_In[4] := x2;
  Int_In[5] := y2;
  AES(72);
End;

Procedure Dragbox(x1,y1,w1,h1,x2,y2,w2,h2 : Integer; Var Endx, Endy : Integer);
Begin
  Int_In[0] := w2;
  Int_In[1] := h2;
  Int_In[2] := x2;
  Int_In[3] := y2;
  Int_In[4] := x1;
  Int_In[5] := y1;
  Int_In[6] := w1;
  Int_In[7] := h1;
  AES(71);
  Endx := Int_Out[1];
  Endy := Int_Out[2];
End;

{$IFDEF Atari}
Procedure Growbox(stx,sty,stw,sth,fix,fiy,fiw,fih : Integer);
Begin
  Int_In[0] := stx;
  Int_In[1] := sty;
  Int_In[2] := stw;
  Int_In[3] := sth;
  Int_In[4] := fix;
  Int_In[5] := fiy;
  Int_In[6] := fiw;
  Int_In[7] := fih;
  AES(73);
End;

Procedure Shrinkbox(stx,sty,stw,sth,fix,fiy,fiw,fih : Integer);
Begin
  Int_In[0] := stx;
  Int_In[1] := sty;
  Int_In[2] := stw;
  Int_In[3] := sth;
  Int_In[4] := fix;
  Int_In[5] := fiy;
  Int_In[6] := fiw;
  Int_In[7] := fih;
  AES(74);
End;
{$ELSE}
Procedure Growbox(stx,sty,stw,sth,fix,fiy,fiw,fih : Integer);
Var cx, cy, cnt, xstep, ystep : Integer;
Begin
  If AES_Version < $200 Then
  Begin
    Int_In[0] := stx;
    Int_In[1] := sty;
    Int_In[2] := stw;
    Int_In[3] := sth;
    Int_In[4] := fix;
    Int_In[5] := fiy;
    Int_In[6] := fiw;
    Int_In[7] := fih;
    AES(73);
  End
  Else
  Begin
    Xgrf_Stepcalc(stw, sth, fix, fiy, fiw, fih, cx, cy, cnt, xstep, ystep);
    Xgrf_2Box(cx, cy, stw, sth, True, cnt, xstep, ystep, True);
  End;
End;

Procedure Shrinkbox(stx,sty,stw,sth,fix,fiy,fiw,fih : Integer);
Var cx, cy, cnt, xstep, ystep : Integer;
Begin
  If AES_Version < $200 Then
  Begin
    Int_In[0] := stx;
    Int_In[1] := sty;
    Int_In[2] := stw;
    Int_In[3] := sth;
    Int_In[4] := fix;
    Int_In[5] := fiy;
    Int_In[6] := fiw;
    Int_In[7] := fih;
    AES(74);
  End
  Else
  Begin
    Xgrf_Stepcalc(stw, sth, fix, fiy, fiw, fih, cx, cy, cnt, xstep, ystep);
    Xgrf_2Box(fix, fiy, fiw, fih, True, cnt, -xstep, -ystep, True);
  End;
End;
{$ENDIF}

Function Slidebox(Dialog: Dialog_Ptr; Vater,Sohn,Modus: Integer): Integer;
Begin
  Int_In[0] := Vater;
  Int_In[1] := Sohn;
  Addr_In[0] := Pointer(Dialog);
  AES(76);
  Slidebox := Int_Out[0];
End;

Procedure Xgrf_Stepcalc(stw, sth, xc, yc, w, h : Integer;
                        Var cx, cy, cnt, xstep, ystep : Integer);
Begin
  Int_In[0] := stw;
  Int_In[1] := sth;
  Int_In[2] := xc;
  Int_In[3] := yc;
  Int_In[4] := w;
  Int_In[5] := h;
  AES(130);
  cx := Int_Out[1];
  cy := Int_Out[2];
  cnt := Int_Out[3];
  xstep := Int_Out[4];
  ystep := Int_Out[5];
End;

Procedure Xgrf_2Box(xc, yc, w, h : Integer; corners : Boolean;
                    cnt, xstep, ystep : Integer; doubled : Boolean);
Begin
  Int_In[0] := cnt;
  Int_In[1] := xstep;
  Int_In[2] := ystep;
  Int_In[3] := Ord(doubled);
  Int_In[4] := Ord(corners);
  Int_In[5] := xc;
  Int_In[6] := yc;
  Int_In[7] := w;
  Int_In[8] := h;
  AES(131);
End;

Function Get_Event(emask, bmask, bstate, n_clicks : Integer;
                    ticks : LongInt;
                    m1_flag : Boolean; m1x, m1y, m1w, m1h : Integer;
                    m2_flag : Boolean; m2x, m2y, m2w, m2h : Integer;
                    Var message : Message_Buffer;
                    Var key, brtn, bclick, mx, my, kstate : Integer) : Integer;
Begin
  Int_In[0] := emask;
  Int_In[1] := n_clicks;
  Int_In[2] := bmask;
  Int_In[3] := bstate;
  Int_In[4] := Ord(m1_flag);
  Int_In[5] := m1x;
  Int_In[6] := m1y;
  Int_In[7] := m1w;
  Int_In[8] := m1h;
  Int_In[9] := Ord(m2_flag);
  Int_In[10] := m2x;
  Int_In[11] := m2y;
  Int_In[12] := m2w;
  Int_In[13] := m2h;
  Addr_In[0] := Addr(message);
  Int_In[14] := ticks Mod $10000;
  Int_In[15] := ticks Div $10000;
  AES(25);
  mx := Int_Out[1];
  my := Int_Out[2];
  key := Int_Out[5];
  brtn := Int_Out[6];
  bclick := Int_Out[3];
  kstate := Int_Out[4];
  Get_Event := Int_Out[0];
End;

Procedure Set_Clip(x, y, w, h : Integer);
Begin
  Int_In [0] := 1; { True }
  Pts_In [0] := x;
  Pts_In [1] := y;
  Pts_In [2] := x + w - 1;
  Pts_In [3] := y + h - 1;
  VDI(129, 0, 1, 4, False);
End;

Procedure Draw_String(x, y : Integer; s : Str255);
Var i : Integer;
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  i := 1;
  While (i <= Length(s)) Do
  Begin
    Int_In[i-1] := Ord(s[i]);
    i := i + 1;
  End;
  Int_In[i] := 0;
  VDI(8,0,Length(s),1, True);
End;

Procedure Justified_Text(x, y, len, wrd, chr :Integer; s: Str255);
Var i : Integer;
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := len - OffsetX;
  Pts_In[3] := 0;
  Int_In[0] := wrd;
  Int_In[1] := chr;
  i := 1;
  While (i <= Length(s)) Do
  Begin
    Int_In[i+1] := Ord(s[i]);
    i := i + 1;
  End;
  Int_In[i+1] := 0;
  VDI(11,10,Length(s)+2,2, True);
End;

Procedure Text_Alignment(h, v : Integer);
Begin
  Int_In[0] := h;
  Int_In[1] := v;
  VDI(39,0,2,0, False);
End;

Procedure Set_Color(Color : Integer; Red, Green, Blue : Integer);
Begin
  Int_In[0] := Color;
  Int_In[1] := Red;
  Int_In[2] := Green;
  Int_In[3] := Blue;
  VDI(14,0,4,0, False);
End;

Procedure Line_Color(Color_Index : Integer);
Begin
  Int_In [0] := Color_Index;
  VDI(17, 0, 1, 0, False);
End;

Procedure Line_Width(width: Integer);
Begin
  Pts_In [0] := width;
  Pts_In [1] := 0;
  VDI(16, 0, 0, 1, False);
End;

Procedure Draw_Mode(Mode : Integer);
Begin
  Int_In [0] := Mode;
  VDI(32, 0, 1, 0, False);
End;

Procedure Paint_Color(Color_Index : Integer);
Begin
  Int_In [0] := Color_Index;
  VDI(25, 0, 1, 0, False);
End;

Procedure Paint_Style(Style_Index : Integer);
Begin
  Case Style_Index Of
     0,  1 : Int_In[0] := Style_Index;
     2..25 : Begin
               Int_In[0] := 2;
               Style_Index := Style_Index - 1;
             End;
    26..37 : Begin
               Int_In[0] := 3;
               Style_Index := Style_Index - 25;
             End;
  End;
  VDI(23, 0, 1, 0, False);
  Int_In [0] := Style_Index;
  VDI(24, 0, 1, 0, False);
End;

Procedure Paint_Outline(On : Boolean);
Begin
  Int_In[0] := Ord(On);
  VDI(104, 0, 1, 0, False);
End;

Procedure Paint_Rect(x, y, w, h : Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x + w - 1;
  Pts_In[3] := y + h -1;
  VDI(11, 1, 0, 2, True);
End;

Procedure Line_Endstyle(beg_Style, End_Style: Integer);
Begin
  Int_In [0] := Beg_Style;
  Int_In [1] := End_Style;
  VDI(108, 0, 2, 0, False);
End;

Procedure Line_Style(Style: Integer);
Begin
  Int_In [0] := Style;
  VDI(15, 0, 1, 0, False);
End;

Procedure Move_To(x, y: Integer);
Begin
  TurtleX := x;
  TurtleY := y;
End;

Procedure Pline(x1, y1, x2, y2: Integer);
Begin
  Pts_In[0] := x1;
  Pts_In[1] := y1;
  Pts_In[2] := x2;
  Pts_In[3] := y2;
  VDI(6, 0, 0, 2, True);
  { ntig fr Turtlegraphic }
  TurtleX := x2;
  TurtleY := y2;
End;

Procedure Line_To(x, y: Integer);
Begin
  Pline(TurtleX, TurtleY, x, y);
  TurtleX := x;
  TurtleY := y;
End;

Procedure Plot(x, y: Integer);
Begin
  Pline(x, y, x, y);
  TurtleX := x;
  TurtleY := y;
End;

Procedure Frame_Rect(x, y, w, h: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x + w - 1;
  Pts_In[3] := y;
  Pts_In[4] := x + w - 1;
  Pts_In[5] := y + h - 1;
  Pts_In[6] := x;
  Pts_In[7] := y + h - 1;
  Pts_In[8] := x;
  Pts_In[9] := y;
  Pts_In[10] := x + w - 1;
  Pts_In[11] := y;
  VDI(6, 0, 0, 6, True);
End;

Procedure Text_Heigth(Height: Integer);
{Texthhe in Pixeln}
Begin
  Pts_In[0] := 0;
  Pts_In[1] := Height;
  VDI(12, 0, 0, 1, False);
End;

Function Text_Point(Height: Integer): Integer;
{Texthhe in Point}
Begin
  Int_In[0] := Height;
  VDI(107, 0, 1, 0, False);
  Text_Point := Int_Out[0];
End;

Procedure Text_Color(Color: Integer);
Begin
  Int_In[0] := Color;
  VDI(22, 0, 1, 0, False);
End;

Procedure Text_Style(Style: Integer);
Begin
  Int_In[0] := Style;
  VDI(106, 0, 1, 0, False);
End;

Procedure Text_Rotation(Angle: Integer);
Begin
  Int_In [0] := Angle;
  VDI(13, 0, 1, 0, False);
End;

Procedure First_Rect(Hand: Integer; VAR x, y, w, h: Integer);
Begin
  Wind_Get(Hand, WF_FirstXYWH, x, y, w, h);
End;

Procedure Next_Rect(Hand: Integer; VAR x, y, w, h: Integer);
Begin
  Wind_Get(Hand, WF_NextXYWH, x, y, w, h);
End;

Function Rect_Intersect(x1, y1, w1, h1: Integer;
                        VAR x2, y2, w2, h2: Integer): Boolean;
Var tx, ty, tw, th : Integer;
Begin
  tw := min(x2 + w2, x1 + w1);
  th := min(y2 + h2, y1 + h1);
  tx := max(x2, x1);
  ty := max(y2, y1);
  x2 := tx;
  y2 := ty;
  w2 := tw - tx;
  h2 := th - ty;
  Rect_Intersect := (tw > tx) And (th > ty);
End;

Procedure Set_WSize(hand, x, y, w, h: Integer);
Begin
  Wind_Set(hand, WF_CurrXYWH, x, y, w, h);
End;

Procedure Sys_Font_Size(VAR wchar, hchar, wbox, hbox: Integer);
Begin
  AES(77);
  wchar := int_out[1];
  hchar := int_out[2];
  wbox  := int_out[3];
  hbox  := int_out[4];
End;

Procedure Clear_Screen;
Begin
  Paint_Color(White);
  Paint_Style(Solid);
  Paint_Rect(0,0,GemResX, GemResY);
End;

Procedure Begin_Update;
Begin
  Int_In[0] := 1; { BEG_UPDATE }
  AES(107);
End;

Procedure End_Update;
Begin
  Int_In[0] := 0; { END_UPDATE }
  AES(107);
End;

Procedure Begin_Mouse;
Begin
  Int_In[0] := 3; { BEG_MCTRL }
  AES(107);
End;

Procedure End_Mouse;
Begin
  Int_In[0] := 2; { END_MCTRL }
  AES(107);
End;

Procedure Paint_Oval(x, y, x_rad, y_rad: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x_rad - OffsetX;
  Pts_In[3] := y_rad - OffsetY;
  VDI(11, 5, 0, 2, True);
End;

Procedure Frame_Oval(x, y, x_rad, y_rad: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x_rad - OffsetX;
  Pts_In[3] := y_rad - OffsetY;
  Int_In[0] := 0;
  Int_In[1] := 3600;
  VDI(11, 6, 2, 2, True);
End;

Procedure Paint_Round_Rect(x, y, w, h: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x + w - 1;
  Pts_In[3] := y + h - 1;
  VDI(11, 9, 0, 2, True);
End;

Procedure Frame_Round_Rect(x, y, w, h: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x + w - 1;
  Pts_In[3] := y + h - 1;
  VDI(11, 8, 0, 2, True);
End;

Procedure Paint_Arc(x, y, x_rad, y_rad, beg_ang, end_ang: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x_rad - OffsetX;
  Pts_In[3] := y_rad - OffsetY;
  Int_In[0] := beg_ang;
  Int_In[1] := end_ang;
  VDI(11, 7, 2, 2, True);
End;

Procedure Frame_Arc(x, y, x_rad, y_rad, beg_ang, end_ang: Integer);
Begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x_rad - OffsetX;
  Pts_In[3] := y_rad - OffsetY;
  Int_In[0] := beg_ang;
  Int_In[1] := end_ang;
  VDI(11, 6, 2, 2, True);
End;

Procedure Border_Rect(Handle: Integer; Var x, y, w, h: Integer);
Begin
  Wind_Get(Handle, WF_CurrXYWH, x, y, w, h);
End;

Function Obj_Find(Dial: Dialog_Ptr; Start, Depth, x, y : Integer): Integer;
Begin
  Addr_In[0] := Pointer(Dial);
  Int_In[0] := Start;
  Int_In[1] := Depth;
  Int_In[2] := x;
  Int_In[3] := y;
  AES(43);
  Obj_Find := Int_Out[0];
End;

Procedure Obj_Offset(Dial: Dialog_Ptr; Index: Integer; VAR x, y: Integer);
Begin
  Addr_In[0] := Pointer(Dial);
  Int_In[0] := Index;
  AES(44);
  x := Int_Out[1];
  y := Int_Out[2];
End;

Procedure Obj_Size(Dial: Dialog_Ptr; Index: Integer; Var x, y, w, h: Integer);
Begin
  Obj_Offset(Dial, Index, x, y);
  w := Dial^[Index].ob_w;
  h := Dial^[Index].ob_h;
End;

Procedure Obj_Redraw(Dial: Dialog_Ptr; Item: Tree_Index);
Begin
  Obj_Draw(Dial, Item, Max_Depth, 0, 0, GemResX, GemResY);
End;

Function Find_Window(x, y: Integer): Integer;
Begin
  Int_In[0] := x;
  Int_In[1] := y;
  AES(106);
  Find_Window := Int_Out[0];
End;

Procedure Obj_Add(Dial: Tree_Ptr; Parent, Child: Integer);
Begin
  Addr_In[0] := Pointer(Dial);
  Int_In[0] := Parent;
  Int_In[1] := Child;
  AES(40);
End;

Procedure Rsrc_Obfix(Dial: Tree_Ptr; Obj: Integer);
Begin
  Addr_In[0] := Pointer(Dial);
  Int_In[0] := Obj;
  AES(114);
End;

Function D_Color(Border, Text: Integer; Mode: Boolean;
                 Pattern, Inside: Integer): Integer;
Begin
  D_Color := (Border * 4096) + (Text * 256) + (Ord(Mode) * 128) +
             (Pattern * 16) + Inside;
End;

Function New_Dialog(N_Items, x, y, w, h: Integer): Dialog_Ptr;
Var Foo : Dialog_Ptr;
    i : Integer;
Begin
  New(foo);
  foo^[0].ob_next := -1;
  foo^[0].ob_head := -1;
  foo^[0].ob_tail := -1;
  foo^[0].ob_type := G_Box;
  foo^[0].ob_flags := Last_Ob;
  foo^[0].ob_state := Outlined;
  foo^[0].ob_spec.thick := 2;
  foo^[0].ob_spec.color := 4352;
  foo^[0].ob_x := x;
  foo^[0].ob_y := y;
  foo^[0].ob_w := w;
  foo^[0].ob_h := h;
  Rsrc_Obfix(Foo,Root);
  New_Dialog := Foo;
End;

Function Add_DItem(Dial: Dialog_Ptr; Obj_Type, Flags: Integer;
                    x, y, w, h: Integer; Border, Color: Integer): Tree_Index;
Var Foo : Ted_Ptr;
    Bar : String_Ptr;
    Obj : Integer;
Begin
  Obj := 0;
  While (Dial^[Obj].ob_flags And Last_Ob = 0) And (Obj < (Max_Tree-1)) Do
    Obj := Obj + 1;
  Obj := Obj + 1;
  Dial^[Obj].ob_next := -1;
  Dial^[Obj].ob_head := -1;
  Dial^[Obj].ob_tail := -1;
  Dial^[Obj].ob_type := Obj_Type;
  Dial^[Obj].ob_flags := Flags Or Last_Ob;
  Dial^[Obj-1].ob_flags := Dial^[Obj-1].ob_flags Xor Last_Ob;
  Dial^[Obj].ob_state := Normal;
  case obj_type of
    G_Box, G_IBox, G_BoxChar :
      Begin
        Dial^[Obj].ob_spec.thick := Border;
        Dial^[Obj].ob_spec.color := Color;
      End;
    G_Text, G_BoxText, G_FText, G_FBoxText :
      Begin
        New(Foo);
        Dial^[Obj].ob_spec.info := Foo;
        New(Bar);
        Dial^[Obj].ob_spec.info^.te_ptext := Bar;
        New(Bar);
        Dial^[Obj].ob_spec.info^.te_ptmplt := Bar;
        New(Bar);
        Dial^[Obj].ob_spec.info^.te_pvalid := Bar;
        Dial^[Obj].ob_spec.info^.te_color := Color;
        Dial^[Obj].ob_spec.info^.te_thickness := Border;
      End;
    G_String, G_Button, G_Title :
      Begin
        New(Bar);
        Dial^[Obj].ob_spec.str := Bar;
      End;
  End; { case }
  Dial^[Obj].ob_x := x;
  Dial^[Obj].ob_y := y;
  Dial^[Obj].ob_w := w;
  Dial^[Obj].ob_h := h;
  Obj_Add(Dial,Root,Obj);
  Rsrc_Obfix(Dial,Obj);
  Add_DItem := Obj;
End;

Procedure Delete_Dialog(Dial: Dialog_Ptr);
Var Obj : Integer;
Begin
  Obj := -1;
  Repeat
    Obj := Obj + 1;
    Case Dial^[Obj].ob_type Of
      G_Text, G_BoxText, G_FText, G_FBoxText :
        Begin
          Dispose(Dial^[Obj].ob_spec.info^.te_ptext);
          Dispose(Dial^[Obj].ob_spec.info^.te_ptmplt);
          Dispose(Dial^[Obj].ob_spec.info^.te_pvalid);
          Dispose(Dial^[Obj].ob_spec.info);
        End;
      G_String, G_Button, G_Title : Dispose(Dial^[Obj].ob_spec.str);
    End; { Case }
  Until (Dial^[Obj].ob_flags And Last_Ob <> 0) Or (Obj = Max_Tree);
  Dispose(Dial);
End;

Function New_Menu(N_Items: Integer; About: Str255): Menu_Ptr;
Var Menu : Menu_Ptr;
    Str_Ptr : String_Ptr;
    i : Integer;
Begin
  New(Menu);
  For i := 0 to Max_Tree Do
  Begin
    Menu^[i].ob_next := -1;
    Menu^[i].ob_head := -1;
    Menu^[i].ob_tail := -1;
    Menu^[i].ob_flags := 0;
    Menu^[i].ob_state := Normal;
  End;
  Menu^[Root].ob_type := G_IBox;
  Menu^[Root].ob_spec.thick := 0;
  Menu^[Root].ob_spec.color := 0;
  Menu^[Root].ob_x := 0;
  Menu^[Root].ob_y := 0;
  Menu^[Root].ob_w := 80;
  Menu^[Root].ob_h := 25;
  Rsrc_Obfix(Menu,Root);
  Menu^[1].ob_type := G_Box;
  Menu^[1].ob_spec.thick := 0;
  Menu^[1].ob_spec.color := $1100;  { transparent, Textfarbe 1, Rahmenfarbe 1 }
  Menu^[1].ob_x := 0;
  Menu^[1].ob_y := 0;
  Menu^[1].ob_w := 80;
  Menu^[1].ob_h := 513;
  Obj_Add(Menu,Root,1);
  Rsrc_Obfix(Menu,1);
  Menu^[2].ob_type := G_IBox;
  Menu^[2].ob_spec.thick := 0;
  Menu^[2].ob_spec.color := 0;
  Menu^[2].ob_x := 2;
  Menu^[2].ob_y := 0;
  Menu^[2].ob_w := 6; { Summe der Breiten der Menuetitel (hier nur DESK) }
  Menu^[2].ob_h := 769;
  Obj_Add(Menu,1,2);
  Rsrc_Obfix(Menu,2);
  Menu^[3].ob_type := G_Title;
  New(Str_Ptr); Pas_To_C(' Desk ', Str_Ptr^);
  Menu^[3].ob_spec.str := Str_Ptr;
  Menu^[3].ob_x := 0;
  Menu^[3].ob_y := 0;
  Menu^[3].ob_w := 6;
  Menu^[3].ob_h := 769;
  Obj_Add(Menu,2,3);
  Rsrc_Obfix(Menu,3);
  Menu^[4].ob_type := G_IBox;
  Menu^[4].ob_spec.thick := 0;
  Menu^[4].ob_spec.color := 0;
  Menu^[4].ob_x := 0;
  Menu^[4].ob_y := 769;
  Menu^[4].ob_w := 80;
  Menu^[4].ob_h := 19;
  Obj_Add(Menu,Root,4);
  Rsrc_Obfix(Menu,4);
  Menu^[5].ob_type := G_Box;
  Menu^[5].ob_spec.thick := $FF; { -1 = Rahmen 1 Pixel auerhalb }
  Menu^[5].ob_spec.color := $1100;
  Menu^[5].ob_x := 2;
  Menu^[5].ob_y := 0;
  Menu^[5].ob_w := 20;
  Menu^[5].ob_h := 8;
  Obj_Add(Menu,4,5);
  Rsrc_Obfix(Menu,5);
  Menu^[6].ob_type := G_String;
  New(Str_Ptr); Pas_To_C(About, Str_Ptr^);
  Menu^[6].ob_spec.str := Str_Ptr;
  Menu^[6].ob_x := 0;
  Menu^[6].ob_y := 0;
  Menu^[6].ob_w := 20;
  Menu^[6].ob_h := 1;
  Obj_Add(Menu,5,6);
  Rsrc_Obfix(Menu,6);
  Menu^[7].ob_type := G_String;
  New(Str_Ptr); Pas_To_C('--------------------', Str_Ptr^);
  Menu^[7].ob_spec.str := Str_Ptr;
  Menu^[7].ob_state := Disabled;
  Menu^[7].ob_x := 0;
  Menu^[7].ob_y := 1;
  Menu^[7].ob_w := 20;
  Menu^[7].ob_h := 1;
  Obj_Add(Menu,5,7);
  Rsrc_Obfix(Menu,7);
  For i := 8 To 13 Do
  Begin
    Menu^[i].ob_type := G_String;
    New(Str_Ptr); Pas_To_C(' Desk Accessory x   ',Str_Ptr^);
    Str_Ptr^[16] := Chr(i - 7 + 48);
    Menu^[i].ob_spec.str := Str_Ptr;
    Menu^[i].ob_x := 0;
    Menu^[i].ob_y := i - 6;
    Menu^[i].ob_w := 20;
    Menu^[i].ob_h := 1;
    Obj_Add(Menu,5,i);
    Rsrc_Obfix(Menu,i);
  End;
  Menu^[13].ob_flags := Last_Ob;
  New_Menu := Menu;
End;

Function Add_MTitle(Menu: Menu_Ptr; Item: Str255): Integer;
Var i,
    j,  { THE SCREEN }
    Obj : Integer;
    Str_Ptr : String_Ptr;
Begin
  Obj := 0;
  While (Menu^[Obj].ob_flags And Last_Ob = 0) And (Obj < (Max_Tree-1)) Do
    Obj := Obj + 1;
  Obj := Obj + 1;
  j := Menu^[1].ob_next;
  For i := Obj Downto j+1 Do      { Objekt unter THE SCREEN verschieben }
    Menu^[i] := Menu^[i-1];
  For i := 0 To Obj Do          { Referenzen anpassen }
  Begin
    If Menu^[i].ob_next >= j Then Menu^[i].ob_next := Menu^[i].ob_next + 1;
    If Menu^[i].ob_head >= j Then Menu^[i].ob_head := Menu^[i].ob_head + 1;
    If Menu^[i].ob_tail >= j Then Menu^[i].ob_tail := Menu^[i].ob_tail + 1;
  End;
  Menu^[j].ob_next := -1;
  Menu^[j].ob_head := -1;
  Menu^[j].ob_tail := -1;
  Menu^[j].ob_type := G_Title;
  New(Str_Ptr); Pas_To_C(Item, Str_Ptr^);
  Menu^[j].ob_spec.str := Str_Ptr;
  Menu^[j].ob_x := ((Menu^[j-1].ob_x + Menu^[j-1].ob_w) Div (Menu^[2].ob_x Div 2));
  Menu^[j].ob_y := 0;
  Menu^[j].ob_w := Length(Item);
  Menu^[j].ob_h := 769;
  Obj_Add(Menu,2,j);
  Rsrc_Obfix(Menu,j);
  Menu^[2].ob_w := Menu^[2].ob_w + Menu^[j].ob_w;
  Add_MTitle := j;
  Menu^[Obj].ob_flags := 0;
  Menu^[Obj+1].ob_next := -1;
  Menu^[Obj+1].ob_head := -1;
  Menu^[Obj+1].ob_tail := -1;
  Menu^[Obj+1].ob_flags := Last_Ob;
  Menu^[Obj+1].ob_type := G_Box;
  Menu^[Obj+1].ob_spec.thick := $FF;
  Menu^[Obj+1].ob_spec.color := $1100;
  Menu^[Obj+1].ob_x := (Menu^[j].ob_x Div (Menu^[2].ob_x Div 2)) + 2;
  Menu^[Obj+1].ob_y := 0;
  Menu^[Obj+1].ob_w := 0;
  Menu^[Obj+1].ob_h := 0;
  Obj_Add(Menu,Menu^[1].ob_next,Obj+1); { bei THE SCREEN einhaengen }
  Rsrc_Obfix(Menu,Obj+1);
End;

Function Add_MItem(Menu: Menu_Ptr; Title: Tree_Index; Item: Str255): Integer;
Var Obj,
    Count,
    i,
    MyBox : Integer;
    Str_Ptr : String_Ptr;
Begin
  { 1. freien Eintrag suchen }
  Obj := 0;
  While (Menu^[Obj].ob_flags And Last_Ob = 0) And (Obj < (Max_Tree-1)) Do
    Obj := Obj + 1;
  Obj := Obj + 1;
  { passende Box suchen }
  MyBox := Menu^[Menu^[1].ob_next].ob_head;
  Count := 3;
  While Count <> Title Do
  Begin
    MyBox := Menu^[MyBox].ob_next;
    Count := Count + 1;
  End;
  { Position im Menue feststellen }
  If Menu^[MyBox].ob_head = -1 Then
    Count := 0
  Else
    Count := Menu^[MyBox].ob_tail - Menu^[MyBox].ob_head + 1;
  Menu^[Obj].ob_next := -1;
  Menu^[Obj].ob_head := -1;
  Menu^[Obj].ob_tail := -1;
  Menu^[Obj].ob_flags := Last_Ob;
  Menu^[Obj-1].ob_flags := 0;
  Menu^[Obj].ob_state := Normal;
  Menu^[Obj].ob_type := G_String;
  New(Str_Ptr); Pas_To_C(Item, Str_Ptr^);
  Menu^[Obj].ob_spec.str := Str_Ptr;
  Menu^[Obj].ob_x := 0;
  Menu^[Obj].ob_y := Count;  { Position im Menue }
  Menu^[Obj].ob_w := Length(Item);
  Menu^[Obj].ob_h := 1;
  Obj_Add(Menu,MyBox,Obj);
  Rsrc_Obfix(Menu,Obj);
  { Gre der Box aktualisieren }
  Menu^[MyBox].ob_w := Max(Menu^[MyBox].ob_w, Menu^[Obj].ob_w);
  Menu^[MyBox].ob_h := Menu^[MyBox].ob_h + Menu^[Obj].ob_h;
  Add_MItem := Obj;
End;

Procedure Delete_Menu(Menu: Menu_Ptr);
Var Obj : Integer;
Begin
  Obj := -1;
  Repeat
    Obj := Obj + 1;
    Case Menu^[Obj].ob_type Of
      G_Text, G_BoxText, G_FText, G_FBoxText :
        Begin
          Dispose(Menu^[Obj].ob_spec.info^.te_ptext);
          Dispose(Menu^[Obj].ob_spec.info^.te_ptmplt);
          Dispose(Menu^[Obj].ob_spec.info^.te_pvalid);
          Dispose(Menu^[Obj].ob_spec.info);
        End;
      G_String, G_Button, G_Title : Dispose(Menu^[Obj].ob_spec.str);
    End; { Case }
  Until (Menu^[Obj].ob_flags And Last_Ob <> 0) Or (Obj = Max_Tree);
  Dispose(Menu);
End;

{$I Gembind2.pas }

Begin
  TurtleX := 0; TurtleY := 0;
  AktWind := -1;
  OffsetX := 0; OffsetY := 0;
End.
