REM PIQ - drawing program
''''
GOSUB initialise
''''
REPEAT
  GOSUB list_commands
  GOSUB pick_command
  GOSUB obey_command
UNTIL command = 9
GOSUB final
END
''''
REM *** PROCEDURES and FUNCTIONS ***
''''
LABEL initialise
''''
REM * constants and declarations *
  file = 5
  picture = 2: REM picture stream
  menu = 1: REM menu and prompts stream
  stored_limit = 100
  DIM stored$(1 TO stored_limit) FIXED 17
  RECORD cir; code BYTE, x1 WORD, y1 WORD, radius WORD
  RECORD other; code BYTE, x1 WORD, y1 WORD, x2 WORD, y2 WORD
  REM * set up menu *
  menu$ = "point..line...box....circle.delete.clear..save...load...quit..."
  REM code:1      2      3      4      5      6      7      8      9
  rec$=STRING$(17,  " ")
''''
REM * set up streams, screens and windows *
  REM picture stream
  WINDOW #picture CLOSE
  SCREEN #picture GRAPHICS: REM screen as big as possible
  cell_width = 7*XCELL(#picture)/XPIXEL(#picture)
  menu_width = LEN(menu$)*XCELL(#picture)/XPIXEL(#picture)
  menu_height = YCELL(#picture)/YPIXEL(#picture)
  WINDOW #picture SIZE XUSABLE, YUSABLE-5*YCELL/YPIXEL
  WINDOW #picture SCROLL 0;0
  WINDOW #picture PLACE 0; 3*YCELL/YPIXEL
  WINDOW #picture CURSOR OFF
  WINDOW #picture TITLE "** PICTURE **"
  WINDOW #picture OPEN
  REM menu stream
  WINDOW #menu CLOSE
  SCREEN #menu GRAPHICS menu_width FIXED, menu_height FIXED
  WINDOW #menu PLACE 0; menu_height-YWINDOW
  WINDOW #menu CURSOR OFF
  WINDOW #menu TITLE "menu & prompts"
  WINDOW #menu OPEN
''''
REM * zero counters *
  stored = 0
RETURN
''''
LABEL final
CLS #picture
RETURN

LABEL list_commands: REM display menu of commands
  message$=menu$
  GOSUB ask_prompt
RETURN
''''
LABEL pick_command: REM return command number when button pressed and mousein menu
  where=menu
  GOSUB scanpoint
  command = 1 + x\(cell_width*XPIXEL(#menu))
RETURN
''''
LABEL obey_command
  where=picture
  ON command GOSUB do_point,do_line,do_box,do_circle,do_delete,do_clear,do_save,do_load,do_nothing
RETURN

LABEL do_nothing
RETURN
''''
LABEL do_point
  message$="Move mouse to point and click": GOSUB ask_prompt
  GOSUB scanpoint
  rec$.other.code = 1
  rec$.other.x1 = x
  rec$.other.y1 = y
  PLOT #picture, x;y
  GOSUB store_command
RETURN
''''
LABEL do_line
  message$="Move mouse to line start and click": GOSUB ask_prompt
  GOSUB scanpoint: x1=x: y1=y
  rec$.other.code = 2
  rec$.other.x1 = x1
  rec$.other.y1 = y1
  message$="Move mouse to line end and click": GOSUB ask_prompt
  GOSUB scan_second: x2=x: y2=y
  rec$.other.x2 = x2
  rec$.other.y2 = y2
  LINE #picture, x1;y1, x2;y2
  GOSUB store_command
RETURN
''''
LABEL do_box
  message$="Move to bottom left BOX corner and click": GOSUB ask_prompt
  GOSUB scanpoint: x1=x: y1=y
  rec$.other.code = 3
  rec$.other.x1 = x1
  rec$.other.y1 = y1
  message$="Move to opposite corner of BOX and click": GOSUB ask_prompt
  GOSUB scan_second: x2=x: y2=y
  x2=x2-x1: y2=y2-y1
  rec$.other.x2 = x2
  rec$.other.y2 = y2
  BOX #picture, x1;y1, x2, y2
  GOSUB store_command
RETURN
''''
LABEL do_circle
  message$="Move to circle centre and click": GOSUB ask_prompt
  GOSUB scanpoint: x1=x: y1=y
  rec$.cir.code = 4
  rec$.cir.x1 = x1
  rec$.cir.y1 = y1
  message$="Move to any point on circumference and click": GOSUB ask_prompt
  GOSUB scan_second: x2=x: y2=y
  x = (x1-x2)^2
  y = (y1-y2)^2
  radius = FLOOR(SQR(x+y))
  rec$.cir.radius = radius
  CIRCLE #picture, x1;y1, radius
  GOSUB store_command
RETURN
''''
LABEL do_delete
  IF stored > 0 THEN stored = stored - 1: GOSUB redraw
RETURN
''''
LABEL do_clear
  stored = 0
  CLS #picture
RETURN
''''
LABEL do_save
  CLS #menu
  IF stored = 0 THEN message$="NOTHING TO SAVE!!":GOSUB ask_prompt: RETURN
  INPUT #menu,"Name to save file under";filename$
  OPEN #file OUTPUT filename$
  FOR a = 1 TO stored
    PRINT #file,stored$(a).other.code
    PRINT #file,stored$(a).other.x1
    PRINT #file,stored$(a).other.y1
    PRINT #file,stored$(a).other.x2
    PRINT #file,stored$(a).other.y2
  NEXT
  CLOSE #file
RETURN
''''
LABEL do_load
  REPEAT
    CLS #menu
    INPUT #menu, "Name of file to load";filename$
  UNTIL FIND$(filename$)<>""
  OPEN #file INPUT filename$
  stored = 0
  WHILE NOT(EOF(#file))
    stored = stored + 1
      INPUT #file,stored$(stored).other.code
      INPUT #file,stored$(stored).other.x1
      INPUT #file,stored$(stored).other.y1
      INPUT #file,stored$(stored).other.x2
      INPUT #file,stored$(stored).other.y2
  WEND
  CLOSE #file
  GOSUB redraw
RETURN
''''
LABEL redraw
  CLS #picture
  FOR a = 1 TO stored
    rec$ = WHOLE$(stored$(a))
    code = rec$.other.code
    ON code GOSUB case_point, case_line, case_box, case_circle
  NEXT
RETURN

LABEL case_point: PLOT #picture, rec$.other.x1;rec$.other.y1: RETURN
LABEL case_line: LINE #picture, rec$.other.x1;rec$.other.y1, rec$.other.x2;rec$.other.y2: RETURN
LABEL case_box: BOX #picture, rec$.other.x1;rec$.other.y1,rec$.other.x2,rec$.other.y2: RETURN
LABEL case_circle: CIRCLE #picture, rec$.cir.x1;rec$.cir.y1, rec$.cir.radius: RETURN
''''
LABEL store_command
  IF stored=stored_limit THEN message$="NO ROOM!": GOSUB ask_prompt: RETURN
  stored = stored + 1
  stored$(stored) = WHOLE$(rec$)
RETURN
''''
LABEL scan_second
  MOVE #where,x1;y1 : WINDOW #where CURSOR ON : GOSUB scanpoint
  WINDOW #where CURSOR OFF
RETURN
''''
LABEL scanpoint
  REPEAT
    REPEAT: UNTIL (BUTTON(1) > -1) OR (BUTTON(2) > -1)
    x = XMOUSE-XPLACE(#where)
    y = YMOUSE-YPLACE(#where)
    UNTIL x>= 0 AND x<= XWINDOW(#where) AND y>= 0 AND y<= YWINDOW(#where)
  x=x*XPIXEL(#where): y=y*YPIXEL(#where)
  CLS #menu
  REPEAT: UNTIL (BUTTON(1) < 0) AND (BUTTON(2) < 0)
RETURN
''''
LABEL ask_prompt
  CLS #menu
  PRINT #menu, message$;
  GOSUB wait_5
RETURN

LABEL wait_5
  t=TIME
  REPEAT: UNTIL TIME>t+50
RETURN

