/*  TREE_OP.C  Tree related operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dir.h>
#include <direct.h>
#include <graphics.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <sys\stat.h>
#include <time.h>
#include <fcntl.h>
#include <assert.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define MAXENTRY      512
#define MAXZEILEN     29
#define MAXZEICHEN    31
#define X_WIN_REF     10
#define ABSTAND       12
#define MAX_TIEFE     13
#define TREEINFO      1
#define DIREKT        2
#define VOM_ANFANG    0
#define VON_AKTPOS    1
#define AKT_DIR       2
#define TREE_MEM_ERR  1

extern char newbaum[];
extern char *Path_to_Dir( char *, char *);

static int anz_tree_dirs;
static BYTE Call_mode;
static char *dir_tree_entry[ MAXENTRY], *tree_graph[ MAXENTRY], _tree_zahl_buf[ 4],
       Tree_mem_mode, err_mode;

#pragma warn -par /* WARNUNG: 'Parameter 'parameter' is never used' unterdrcken */

static int _Tree( void **arg_ptr, void *ffblk_ptr)
{
   if( anz_tree_dirs< MAXENTRY)
   {
      if(( dir_tree_entry[ anz_tree_dirs]= getcwd( NULL, MAXDIR))== NULL)
      {
	 err_mode= TREE_MEM_ERR;
	 return( -1);
      }
      strlwr( dir_tree_entry[ anz_tree_dirs]);
      sprintf( _tree_zahl_buf, "%3d", anz_tree_dirs++);
      PrintStatus_at( 22, _tree_zahl_buf);
   }
   else
      return( -1);
   return( 0);
}

#pragma warn +par /* WARNUNG: 'Parameter 'parameter' is never used' erlauben */

BYTE Get_Call_mode( void)
{
   /* FILE_SEARCH, DIR_SEARCH_VOR, DIR_SEARCH_NACH */

   return( Call_mode);
}

int LW_TREE_Funktion( int LW, char *Filter, int ( *FILE_Funktion)( void **, void *), void **arg_ptr, char Mode)
{
   /* LW: 0= A, 1= B, ... */
   char Startdir[ 4];

   sprintf( Startdir, "%c:\\", LW+ 'A');
   return( TREE_Funktion( Startdir, Filter, FILE_Funktion, arg_ptr, Mode));
}

int TREE_Funktion( char *Startdir, char *Filter, int ( *FILE_Funktion)( void **, void *), void **arg_ptr, char Mode)
{
   /*
      Startdir: z.B. C:\\DOS, D:\\
      Mode: |FILE_SEARCH, |DIR_SEARCH_VOR, |DIR_SEARCH_NACH
	    - Filter mu nur bei |FILE_SEARCH angegeben werden ( sonst NULL)
   */
   struct ffblk ffblk;
   int ret_val= 0;
   void *old_maus_cursor= last_maus_cursor;
   char orgdir[ MAXDIR], olddir_of_LW[ MAXDIR];

   MouseArt( maus_sanduhr);
   getcwd( orgdir, MAXDIR);                /* Ausgangsverzeichnis speichern */
   if( !_chdrive( Startdir[ 0]- '@'))  /* Laufwerk konnte gewechselt werden */
   {
      getcwd( olddir_of_LW, MAXDIR);
      if( !chdir( Startdir))
      {
	 ffblk.ff_attrib= _chmod( Startdir, 0);
	 strcpy( ffblk.ff_name, strrchr( Startdir, '\\')+ 1);
	 Call_mode= DIR_SEARCH_VOR;
	 if( Mode& DIR_SEARCH_VOR)
	    ret_val= ( *FILE_Funktion)( arg_ptr, &ffblk);
         if( ret_val== 0)           /* kein Fehler bei der Funktionsausfhrung */
	    ret_val= findfile( Filter, FILE_Funktion, arg_ptr, Mode);
	 Call_mode= DIR_SEARCH_NACH;
	 if( Mode& DIR_SEARCH_NACH)
	    ret_val= ( *FILE_Funktion)( arg_ptr, &ffblk);
	 chdir( olddir_of_LW);
	 _chdrive( orgdir[ 0]- '@');       /* Ausgangsverzeichnis restaurieren */
	 chdir( orgdir);
      }
      else
	 ret_val= -4;
   }
   else
      ret_val= -3;
   MouseArt( old_maus_cursor);
   return( ret_val); /* 0= O.K., -1= Fehler in FILE_Funktion, -2= Break, -3= kein LW-wechsel, -4= kein chdir() */
}

int findfile( char *Filter, int ( *FILE_Funktion)( void **, void *), void **arg_ptr, char Mode)
{
   struct ffblk ffblk;
   int lastentry, ret;

   if( Break( 200, 275, "Soll die Funktion ab-\ngebrochen werden ?"))
      return( -2);
   if( Mode& FILE_SEARCH)
   {
      Call_mode= FILE_SEARCH;
      lastentry= findfirst( Filter, &ffblk, FA_RDONLY| FA_HIDDEN| FA_SYSTEM| FA_ARCH);
      while( !lastentry)
      {
	 if( Break( 200, 275, "Soll die Funktion ab-\ngebrochen werden ?"))
	    return( -2);
	 if( ( *FILE_Funktion)( arg_ptr, &ffblk))     /* Fehler bei der Funktionsausfhrung */
	    return( -1);
	 lastentry= findnext( &ffblk);
      }
   }
   lastentry= findfirst( "*.*", &ffblk, FA_DIREC| FA_RDONLY| FA_HIDDEN| FA_SYSTEM| FA_ARCH);
   while( !lastentry)
   {
      if(( ffblk.ff_attrib& FA_DIREC)&& ( *ffblk.ff_name!= '.'))
      {
	 if( chdir( ffblk.ff_name) != 0)
            return( 4);              /* couldn't change directory but go on */

	 if( Mode& DIR_SEARCH_VOR)
	 {
	    Call_mode= DIR_SEARCH_VOR;
	    switch( ( *FILE_Funktion)( arg_ptr, &ffblk))
	    {
	       case -1:               /* Fehler bei der Funktionsausfhrung */
		  return( -1);
	       case EXIT_DIR:            /* Dieses Verzeichnis berspringen */
		  lastentry= 1;
	    }
	 }
	 if( !lastentry)
	 {
            if(( ret= findfile( Filter, FILE_Funktion, arg_ptr, Mode))< 0)
	       return( ret);
         }
	 lastentry= 0;
	 if( Mode& DIR_SEARCH_NACH)
	 {
	    Call_mode= DIR_SEARCH_NACH;
	    if( ( *FILE_Funktion)( arg_ptr, &ffblk))  /* Fehler bei der Funktionsausfhrung */
	       return( -1);
	 }
         chdir( "..");
      }
      lastentry= findnext( &ffblk);
   }
   return( 0);
}

char *make_dir_cmps( char *dir_sp, char *dir)
{
   char *qbks_ptr, *s_zbks_ptr= dir+ 2, *e_zbks_ptr, cpy_len;

   qbks_ptr= strncpy( dir_sp, dir, 3)+ 3;
   while((( e_zbks_ptr= strchr( ++s_zbks_ptr, '\\'))!= NULL)|| (( e_zbks_ptr= strchr( s_zbks_ptr, '\0'))!= NULL))
   {
      strncpy( qbks_ptr, s_zbks_ptr, cpy_len= e_zbks_ptr- s_zbks_ptr);
      qbks_ptr+= cpy_len;
      if( *e_zbks_ptr)
      {
	 s_zbks_ptr= e_zbks_ptr;
	 while(( 12- cpy_len++)> 0)
	    *( qbks_ptr++)= SPACE;
	 *( qbks_ptr++)= '\\';
      }
      else
	 break;
   }
   *qbks_ptr= '\0';
   return( dir_sp);
}

int dir_cmps( char **elem1, char **elem2)
{
   char dir_1[ 300], dir_2[ 300];

   return( strcmp( make_dir_cmps( dir_1, *elem1), make_dir_cmps( dir_2, *elem2)));
}

int Make_TreeGraph( void)
{
   typedef int ( *fcmp) ( const void *, const void *);
   int i, l, z, ndx, ret_val= 0;
   char anz_ebenen[ MAXENTRY]= { 0}, max_Ebene= 1, *Backslash_ptr, Graph[ MAXZEICHEN+ 1],
	anz_196, Flag;

   if( Tree_Sort== AN)
      qsort( ( void *)dir_tree_entry, anz_tree_dirs, sizeof( char *), ( fcmp)dir_cmps);
   for( i= 1; i< anz_tree_dirs; i++)         /* i= 1, da Root ausgeklammert */
   {
      Backslash_ptr= dir_tree_entry[ i];
      while(( Backslash_ptr= strchr( Backslash_ptr, '\\'))!= NULL)
      {
	 anz_ebenen[ i]++;
	 Backslash_ptr++;
      }
      if( anz_ebenen[ i]> 19)
	 anz_ebenen[ i]= 19;
      if( max_Ebene< anz_ebenen[ i])
	 max_Ebene= anz_ebenen[ i];
   }
   if(( anz_196= (( MAXZEICHEN- 12)/ max_Ebene)- 1)> 4)
      anz_196= 4;
   if(( tree_graph[ 0]= strdup( dir_tree_entry[ 0]))!= NULL)        /* Root */
   {
      strupr( tree_graph[ 0]);
      for( i= 1; i< anz_tree_dirs; i++)         /* i= 1, da Root ausgeklammert */
      {
	 Graph[ 0]= '\0';
	 for( l= 1; l< anz_ebenen[ i]; l++)
	 {
	    strcat( Graph, "");
	    for( z= 0; z< anz_196; z++)
	       strcat( Graph, " ");
	 }
	 for( z= i+ 1, Flag= 0; z< anz_tree_dirs; z++)
	 {
	    if( anz_ebenen[ z]< anz_ebenen[ i])
	    {
	       Flag= 1;
	       break;
	    }
	    if( anz_ebenen[ z]== anz_ebenen[ i])
	       break;
	 }
	 if( !Flag&& ( z< anz_tree_dirs))
	    strcat( Graph, "");
	 else
	    strcat( Graph, "");
	 for( z= 0; z< anz_196; z++)
	    strcat( Graph, "");
	 if(( tree_graph[ i]= strdup( strcat( Graph, strrchr( dir_tree_entry[ i], '\\')+ 1)))== NULL)
	 {
	    if( Tree_mem_mode== DIREKT)
	    {
	       for( l= i; l< anz_tree_dirs; l++)
		  free( dir_tree_entry[ l]);
	    }
	    anz_tree_dirs= i;
	    ErrorMsg( KEIN_SPEICHER". Baum wurde gekrzt");
	    break;
	 }
	 strupr( tree_graph[ i]);
      }
      for( z= 1; z< anz_tree_dirs; z++)         /* z= 1, da Root ausgeklammert */
      {
	 l= anz_ebenen[ z]* ( anz_196+ 1);
	 for( i= 0; i< l; i+= ( anz_196+ 1))
	 {
	    if( tree_graph[ z][ i]== '')
	    {
	       ndx= z+ 1;
	       while( tree_graph[ ndx][ i]== '')
		  tree_graph[ ndx++][ i]= ' ';
	    }
	 }
      }
   }
   else
   {
      ErrorMsg( KEIN_SPEICHER" #1");
      ret_val= -1;
   }
   return( ret_val);
}

void Out_TreeEntry( int X, int Y, int Entry_NR)
{
   int i, y;
   char Work= 1;

   y= Y- 2;
   for( i= 0; ( i< strlen( tree_graph[ Entry_NR]))&& Work; i++, X+= 8)
   {
      setcolor( EGA_WHITE);
      switch( tree_graph[ Entry_NR][ i])
      {
	 case '':
	    line( X+ 10, y, X+ 10, y+ 11);
	    setcolor( EGA_DARKGRAY);
	    line( X+ 13, y, X+ 13, y+ 11);
            break;
	 case '':
	    line( X+ 10, y, X+ 10, y+ 11);
	    line( X+ 13, y+ 4, X+ 15, y+ 4);
	    setcolor( EGA_DARKGRAY);
	    line( X+ 13, y, X+ 13, y+ 3);
	    line( X+ 13, y+ 8, X+ 13, y+ 11);
	    line( X+ 13, y+ 7, X+ 15, y+ 7);
            break;
	 case '':
	    line( X+ 10, y, X+ 10, y+ 7);
	    line( X+ 13, y+ 4, X+ 15, y+ 4);
	    setcolor( EGA_DARKGRAY);
	    line( X+ 13, y, X+ 13, y+ 3);
	    line( X+ 11, y+ 7, X+ 15, y+ 7);
            break;
	 case '':
	    line( X+ 8, y+ 4, X+ 15, y+ 4);
	    setcolor( EGA_DARKGRAY);
	    line( X+ 8, y+ 7, X+ 15, y+ 7);
	    break;
	 case ' ':
	    break;
	 default:
	    Work= 0;
	    break;
      }
   }
   setcolor( datcolor);
   outtextxy( X, Y, &tree_graph[ Entry_NR][ i- 1]);
}

#pragma warn -par /* WARNUNG: 'Parameter 'parameter' is never used' unterdrcken */

void TREE_Balken( int X, int Y, int Zeiger_pos, char an_aus)
{
   int y;

   y= Y+ 76+ ( Zeiger_pos* ABSTAND);
   setwritemode( XOR_PUT);
   setlinestyle( DOTTED_LINE, 0, NORM_WIDTH);
   setcolor( 0x08);
   ShowMouse( AUS);
   rectangle( X+ 9, y, X+ 264, y+ 12);
   ShowMouse( AN);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

#pragma warn +par /* WARNUNG: 'Parameter 'parameter' is never used' erlauben */

void Tree_Up_Down( int X, int Y, RBalken *RB, char Richtung)
{
   if( Richtung== UP)
   {
      ShowMouse( AUS);
      ScrollUpWindow( X+ 9, Y+ 89, X+ 264, Y+ 425, ABSTAND);
      Out_TreeEntry( X+ 10, Y+ 415, RB->proz+ RB->maxstep- 1L);
      ShowMouse( AN);
   }
   else
   {
      ShowMouse( AUS);
      ScrollDownWindow( X+ 9, Y+ 74, X+ 264, Y+ 412, ABSTAND);
      Out_TreeEntry( X+ 10, Y+ 79, RB->proz);
      ShowMouse( AN);
   }
}

void Tree_Entrys( int X, int Y, RBalken *RB)
{
   int ypos, i;

   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   bar( X+ 7, Y+ 74, X+ 266, Y+ 425);
   for( i= RB->proz, ypos= Y+ 67; ( i< ( RB->proz+ MAXZEILEN))&& ( i< RB->max); i++)
      Out_TreeEntry( X+ 10, ypos+= ABSTAND, i);
   if( RB->Zeiger_pos>= RB->max)
      RB->Zeiger_pos= 0;
   ShowMouse( AN);
}

int Get_Tree_Zeile( char *dir, RBalken *RB, char Modus)
{
   int i;
   static int old_Zeiger_pos, old_proz;

   if( *dir)
   {
      if( Modus== VON_AKTPOS)
      {
	 i= ( int)RB->proz;
	 if(( ( int)RB->proz== old_proz)&& ( RB->Zeiger_pos== old_Zeiger_pos))
	    i+= RB->Zeiger_pos+ 1;
      }
      else
	 i= 0;
      strupr( dir);
      for( ; i< anz_tree_dirs; i++)
      {
	 if( Modus== AKT_DIR)
	 {
	    if( stricmp( dir_tree_entry[ i], dir)== 0)
	       break;
	 }
	 else
	 {
	    if( strstr( tree_graph[ i], dir)!= NULL)
	       break;
	 }
      }
      if( i< anz_tree_dirs)
      {
	 if( RB->max> RB->maxstep)
	 {
	    if( i<= ( RB->max- RB->maxstep))
	    {
	       RB->proz= i;
	       RB->Zeiger_pos= 0;
	    }
	    else
	       RB->Zeiger_pos= i- ( RB->proz= RB->max- RB->maxstep);
	    old_proz= ( int)RB->proz;
	    RB->proz_sp= RB->proz;
	 }
	 else
	    RB->Zeiger_pos= i;
	 old_Zeiger_pos= RB->Zeiger_pos;
	 return( 1);
      }
   }
   return( 0);
}

int Drucke_Zeile( char *Zeile)
{
   struct DOSERROR dos_Error;

   if( !Break( 200, 200, "Soll die laufende\nDruckausgabe abge-\nbrochen werden ?"))
   {
      fprintf( stdprn, "%s\n", Zeile);
      dosexterr( &dos_Error);
      if( dos_Error.de_exterror== 83)               /* INT 0x24 abgebrochen */
	 return( -1);
      else
	 return( 0);
   }
   else
      return( -1);
}

void Drucke_Tree( int LW)
{
   time_t secs_now;
   int i;
   char Kopf[ 73];

   MouseArt( maus_sanduhr);
   sprintf( Kopf, "Verzeichnisbaum des Laufwerks %c: vom", LW+ 'A');
   time( &secs_now);
   strftime( &Kopf[ 36], 35, " %d.%m.%y\npersnliche Bemerkung:\n", localtime( &secs_now));
   if( !Drucke_Zeile( Kopf))
   {
      for( i= 0; i< anz_tree_dirs; i++)
      {
	 if( Drucke_Zeile( tree_graph[ i]))
	    break;
      }
   }
   MouseArt( maus_pfeil);
}

int ShowTree( char *path, int *x, int LW)   /* ( LWAUSWAHL, DEFAULT, 'A', 'B'...) */
{
   FILE *Tree_file;
   RBalken RB= { 271, 75, 424, VERT_DIR, 1, MAXZEILEN, 0L, 0L};
   int lw, i, ret_val, Tree_Y= 22, ret, status, x_lw= 200, y_lw= 200;
   unsigned file_length;
   char Search_Dir[ MAXDIR]= "", tmp_array[ MAXPATH], *tmp_ptr, baumneulesen= AUS;
   void *arg_ptr[ 3];
   char *msg[]= { "Namen des Verzeichnisses, in das Sie wechseln mchten",
		  "Mit dem angegebenen Verzeichnisnamen weitersuchen",
		  "Verzeichnisbaum drucken",
		  "Verzeichnisstruktur des Laufwerkes neu lesen",
		  "Doppelklicken um ein Verzeichnis auszuwhlen" };
   WORD mauspos[]= { BUTTON|     FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON2|    FRAME| KEY,                 180, 200,   7,  18, F1,
		     INPUT|      FRAME| KEY|            MSG,  11,  48, 126,  MAXFILE+ MAXEXT- 2, 'v',
		     BUTTON|     FRAME| KEY|            MSG, 141, 168,  32,  66, 'w',
		     BUTTON|     FRAME| KEY|            MSG, 172, 226,  32,  66, 'd',
		     BUTTON|     FRAME| KEY| DEFBUTTON| MSG, 230, 284,  32,  66, 'n',
		     KLICKAREA|                         MSG,   7, 266,  74, 425,
		     ROLLBALKEN|        KEY,                 CURSOR_UP, CURSOR_DOWN, PAGE_UP, PAGE_DOWN, HOME, END, RETURN,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 295, 433, 9, INIT, NULL, AN};

   arg_ptr[ 0]= Search_Dir;
   arg_ptr[ 1]= &RB;
   ( void (*)())arg_ptr[ 2]= TREE_Balken;
   MS.x= x;
   MS.y= &Tree_Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   switch( LW)
   {
      case DEFAULT:
	 lw= getdisk();
	 break;
      case LWAUSWAHL:
	 if(( lw= LW_Auswahl( &x_lw, &y_lw, "Laufwerk auswhlen, dessen Verzeichnisbaum angezeigt werden soll", NOTHING, ALL_DRIVES| DRIVE_READY))< 0)
	    return( -1);
	 break;
      default:
	 lw= LW- 'A';
	 break;
   }
   PCX_Window( MS.x, MS.y, PCX_VERZEICHNISBAUM, &MS.sa, SHADOW);
   do
   {
      ShowMouse( AUS);
      ShowDrive( *MS.x+ 180, *MS.y+ 7, Laufwerksart( lw));
      setcolor( EGA_BLACK);
      ClearTextN( *MS.x+ 205, *MS.y+ 10, 2);
      sprintf( tmp_array, "%c:", lw+ 'A');
      outtextxy( *MS.x+ 205, *MS.y+ 10, tmp_array);
      ShowMouse( AN);
      Tree_mem_mode= anz_tree_dirs= ret_val= ret= 0;
      sprintf( tmp_array, "%c:\\TREEINFO.DB2", lw+ 'A');
      chmod( tmp_array, S_IWRITE);          /* eventuelles O_RDONLY lschen */
      if( access( tmp_array, 0)|| ( newbaum[ lw]&& !Info_Frage( *x+ 8, 250, "Verzeichnisbaum wurde\ngendert.\nBaum neu lesen ?", FRAGE))|| baumneulesen)
      {
	 PrintStatus( "Lese Verzeichnisbaum:   0 Verzeichnisse gefunden");
	 Tree_mem_mode= DIREKT;       /* wichtig fr Freigabe des Speichers */
	 err_mode= 0;
	 if(( status= LW_TREE_Funktion( lw, NULL, _Tree, NULL, DIR_SEARCH_VOR))!= 0)
	 {
	    switch( status)
	    {
	       case -1:                               /* kein Speicher mehr */
		  if( err_mode== TREE_MEM_ERR)
		  {
		     ErrorMsg( KEIN_SPEICHER" #2");
		     ret= ABBRUCH;
		     ret_val= -2;
		  }
		  else
		     ErrorMsg( "Mehr Verzeichnisse vorhanden als gelesen werden knnen");
		  break;
	       case -2:                                          /* Abbruch */
	       case -3:
		  ret= ABBRUCH;
		  ret_val= -1;
		  break;
	    }
	 }
	 if( baumneulesen== AN)
	    baumneulesen= AUS;
	 if( ret_val== 0)                        /* Kein Fehler aufgetreten */
	 {
	    if(( anz_tree_dirs> 3)&& ( LW_TREEINFO== AN))
	    {
	       MouseArt( maus_sanduhr);
	       if(( Tree_file= fopen( tmp_array, "wt"))!= NULL)
	       {
		  for( i= 0; i< anz_tree_dirs; i++)
		  {
		     if(( fwrite( dir_tree_entry[ i], strlen( dir_tree_entry[ i]), 1, Tree_file)!= 1)|| ( fwrite( ",", 1, 1, Tree_file)!= 1))
		     {
			ErrorMsg( WRITE_ERROR"TREEINFO.DB2");
			break;
		     }
		  }
		  fclose( Tree_file);
		  if( i< anz_tree_dirs)          /* nicht alles gespeichert */
		     unlink( tmp_array);
		  else
		     newbaum[ lw]= 0;
	       }
	       else
		  ErrorMsg( CREAT_ERROR"TREEINFO.DB2");
	       MouseArt( maus_pfeil);
	    }
	 }
      }
      else
      {
	 MouseArt( maus_sanduhr);
	 if(( Tree_file= fopen( tmp_array, "rt"))!= NULL)
	 {
	    file_length= filelength( fileno( Tree_file));
	    if(( dir_tree_entry[ 0]= malloc( file_length))!= NULL)
	    {
	       Tree_mem_mode= TREEINFO;
	       if( fread( dir_tree_entry[ 0], file_length, 1, Tree_file)== 1)
	       {
		  *( dir_tree_entry[ 0]+ file_length- 1)= '\0';
		  tmp_ptr= dir_tree_entry[ anz_tree_dirs++];
		  while(( tmp_ptr= strchr( tmp_ptr, ','))!= NULL)
		  {
		     *( tmp_ptr++)= '\0';
		     dir_tree_entry[ anz_tree_dirs++]= tmp_ptr;
		  }
	       }
	       else
	       {
		  ErrorMsg( READ_ERROR"TREEINFO.DB2");
		  ret_val= -3;
	       }
	    }
	    else
	    {
	       ErrorMsg( KEIN_SPEICHER" #3");
	       ret_val= -2;
	    }
	    fclose( Tree_file);
	 }
	 else
	 {
	    ErrorMsg( OPEN_ERROR"TREEINFO.DB2");
	    ret_val= -3;
	 }
	 MouseArt( maus_pfeil);
	 if( ret_val== -3)
	 {
	    unlink( tmp_array);
	    baumneulesen= AN;
	 }
      }
      if( ret_val== 0)                                       /* kein Fehler */
      {
	 if( !Make_TreeGraph())
	 {
	    RB.proz= 0L;
	    RB.max= anz_tree_dirs;
	    __CheckMousepos( &MS);
	    Get_Tree_Zeile( Path_to_Dir( tmp_array, path), &RB, AKT_DIR);
	    MS.statsp= REINIT;
	    Tree_Entrys( *MS.x, *MS.y, &RB);
	    do
	    {
	       switch( status= __CheckMousepos( &MS))
	       {
		  case 0:                                            /* ESC */
		     ret= ABBRUCH;
		     ret_val= -1;
		     break;
		  case 1:                               /* Laufwerkswechsel */
		     if(( status= LW_Auswahl( &x_lw, &y_lw, "Laufwerk auswhlen, dessen Verzeichnisbaum angezeigt werden soll", NOTHING, ALL_DRIVES| DRIVE_READY))>= 0)
		     {
			if( status!= lw)
			{
			   MS.statsp= REINIT;
			   lw= status;
			   ret= NOCHMAL;
			}
		     }
		     break;
		  case 2:                     /* Verzeichnisname eingegeben */
		  case 3:                                   /* weitersuchen */
		     if( Get_Tree_Zeile( Search_Dir, &RB, status- 2))
		     {
			Tree_Entrys( *MS.x, *MS.y, &RB);
			MS.statsp= REINIT;
		     }
		     else
			Hinweis( "Konnte keine bereinstimmung finden");
		     break;
		  case 4:                                        /* Drucken */
		     Drucke_Tree( lw);
		     break;
		  case 5:                                      /* neu lesen */
		     if( !DiskReady( lw))                /* Laufwerk bereit */
		     {
			MS.statsp= REINIT;
			ret= NOCHMAL;
			baumneulesen= AN;
		     }
		     break;
		  case 6:                                /* direkt geklickt */
		     status= ( MStat.y- ( *MS.y+ 79))/ ABSTAND;
		     while( MouseStat()!= NOTHING)   /* auf Loslassen der Maustaste warten */
			;
		     if(( status>= 0)&& ( status< ( RB.max- RB.proz)))
		     {
			delay( klickwait);
			if( MouseStat()!= NOTHING)
			{
			   while( MouseStat()!= NOTHING)   /* auf Loslassen der Maustaste warten */
			      ;
			   if((( MStat.y- ( *MS.y+ 79))/ ABSTAND)== status)
			   {
			      strupr( strcpy( path, dir_tree_entry[ RB.proz+ status]));
			      ret= ABBRUCH;
			   }
			}
		     }
		     break;
		  case 7:
		     switch( RB.ret_val)
		     {
			case ONE_ELEMENT_UP:
			   Tree_Up_Down( *MS.x, *MS.y, &RB, DOWN);
			   break;
			case ONE_ELEMENT_DOWN:
			   Tree_Up_Down( *MS.x, *MS.y, &RB, UP);
			   break;
			case ELEMENT_RANDOM:
			   Tree_Entrys( *MS.x, *MS.y, &RB);
			   break;
			case POINTER_RETURN:
			   strupr( strcpy( path, dir_tree_entry[ RB.proz+ RB.Zeiger_pos]));
			   ret= ABBRUCH;
			   break;
		     }
		     break;
	       }
	    }while( !ret);
	    for( i= 0; i< anz_tree_dirs; i++)
	       free( tree_graph[ i]);
	 }
	 else
	 {
	    ret= ABBRUCH;
	    ret_val= -2;
	 }
      }
      switch( Tree_mem_mode)                             /* Speicher freigeben */
      {
	 case TREEINFO:
	    if( dir_tree_entry[ 0]!= NULL)
	       free( dir_tree_entry[ 0]);
	    break;
	 case DIREKT:
	    for( i= 0; i< anz_tree_dirs; i++)
	       free( dir_tree_entry[ i]);
	    break;
      }
   }while(( ret!= ABBRUCH)|| ( baumneulesen== AN));
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);                      /* -1= Abbruch, -2= kein Speicher */
}
