/*  EXT_EXP.C  File extension expander
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <alloc.h>
#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include "filemgr.h"
#include "mouse_op.h"

#define ANWAHL  0
#define RENAME  1

extern BOOL _Filter( char *file, char *filter, int r_a);

sFlex *FlexTable= NULL;      // Root der lin. Liste der Dateierweiterungen

char *ptrAfterNL( const char *ptr)
{
   char *NLptr;

   if(( NLptr= strpbrk( ptr, "\r\n"))!= NULL)
   {
      do
      {
	 *( NLptr++)= '\0';
      }while(( *NLptr== '\r')|| ( *NLptr== '\n'));
   }
   return( NLptr);
}

void LoadFlexLibrary( void)
{
   // die zu parsende Datei mu mit einem Kommentar oder mit einer Datei-
   // erweiterung beginnen

   BOOL leave= FALSE;
   int handle;
   unsigned int f_length;
   char *mem_ptr, *entry_ptr, *chr_ptr;
   sFlex *flexptr, **new_entry= &FlexTable;

   strcpy( prgexe_ptr, "EXT_FLEX.DB2");
   if(( handle= _open( prgexe_path, O_RDONLY))!= -1)
   {
      if(( mem_ptr= ( char *)malloc(( f_length= filelength( handle))+ 1))!= NULL)
      {
	 if( _read( handle, mem_ptr, f_length)!= -1)
	 {
	    *( mem_ptr+ f_length)= '\0';
	    entry_ptr= mem_ptr;
	    do
	    {
	       while( !leave&& ( *entry_ptr== '#'))      // Kommentar
		  if(( entry_ptr= ptrAfterNL( entry_ptr))== NULL)
		     leave= TRUE;
	       if( !leave)
	       {
		  if(( chr_ptr= strchr( entry_ptr, ':'))== NULL)
		     leave= TRUE;
		  else
		  {
		     *chr_ptr= '\0';
		     if(( flexptr= ( sFlex *)malloc( sizeof( sFlex)))!= NULL)
		     {
			flexptr->next= NULL;
			flexptr->filter= malloc( strlen( entry_ptr)+ 3);
			strcpy( stpcpy( flexptr->filter, "*."), strupr( entry_ptr));
		     }
		     else
			break;

		     entry_ptr= chr_ptr+ 1;
		     if(( chr_ptr= ptrAfterNL( entry_ptr))== NULL)
			leave= TRUE;

		     while( *entry_ptr&& ( ( *entry_ptr== ' ')|| ( *entry_ptr== '\t')))
			entry_ptr++;

		     flexptr->command= strdup( entry_ptr);

		     *new_entry= flexptr;
		     new_entry= &flexptr->next;

		     entry_ptr= chr_ptr;
		  }
	       }
	    }while( !leave);
	 }
	 free( mem_ptr);
      }
      _close( handle);
   }
}

extern long _resource_length( BYTE ID);
extern int _resource_open( BYTE ID);

BOOL MakeFlexLibrary( void)
{
   FILE *dat;
   int   handle, txtlen;
   char *txt_ptr;
   BOOL  ret_val= FALSE;

   strcpy( prgexe_ptr, "EXT_FLEX.DB2");
   if( access( prgexe_path, 0)== -1)
   {
      if(( handle= _resource_open( TXT_FLEXLIBRARY_DEFAULT))!= -1)
      {
	 if(( txt_ptr= malloc( txtlen= _resource_length( TXT_FLEXLIBRARY_DEFAULT)))!= NULL)
	 {
	    if( read( handle, txt_ptr, txtlen)!= -1)
	    {
	       if(( dat= fopen( prgexe_path, "wb"))!= NULL)
	       {
		   if( fwrite( txt_ptr, txtlen, 1, dat)== 1)
		      ret_val= TRUE;
		   else
		      ErrorMsg( WRITE_ERROR"EXT_FLEX.DB2");
		   fclose( dat);
	       }
	       else
		  ErrorMsg( CREAT_ERROR"EXT_FLEX.DB2");
	    }
	    else
	       ErrorMsg( READ_ERROR"RESOURCE.DB2");
	    free( txt_ptr);
	 }
	 else
	    ErrorMsg( KEIN_SPEICHER);
	 _dos_close( handle);
      }
      else
	 ErrorMsg( OPEN_ERROR"RESOURCE.DB2");
   }
   else
      ret_val= TRUE;
   return( ret_val);
}

BOOL FlexExtension( char *filedir, char *filename)
{
   sFlex *flex_ptr= FlexTable;
   BOOL   error= FALSE, ret_val= FALSE;
   int    i, memDelta, expDelta;
   char  *exp_ptr, *com_ptr, *tmp_ptr, *chr_ptr, dir[ MAXDIR];
   char  *extCom[]= { "!.!",
		      "!:",
		      "!\\",
		      "!" };

   if( FlexTable)
   {
      while( flex_ptr)
      {
	 if( _Filter( filename, flex_ptr->filter, ANWAHL))
	 {
	    if(( com_ptr= strdup( flex_ptr->command))!= NULL)
	    {
	       do
	       {
		  for( i= 0; i< sizeof( extCom)/ sizeof( char *); i++)
		     if(( exp_ptr= strstr( com_ptr, extCom[ i]))!= NULL)
			break;
		  switch( i)
		  {
		     case 0:                 // Dateiname+Dateierweiterung
			expDelta= ( ptrdiff_t)exp_ptr- ( ptrdiff_t)com_ptr;
			memDelta= strlen( filename)- strlen( extCom[ i]);
			if(( com_ptr= realloc( com_ptr, strlen( com_ptr)+ memDelta+ 1))!= NULL)
			{
			   exp_ptr= com_ptr+ expDelta;
			   memmove( exp_ptr+ memDelta, exp_ptr, strlen( exp_ptr)+ 1);
			   memcpy( exp_ptr, filename, strlen( filename));
			}
			else
			{
			   ErrorMsg( KEIN_SPEICHER);
			   error= TRUE;
			}
			break;
		     case 1:                 // Laufwerksbezeichnung
			*exp_ptr= *filedir;
			break;
		     case 2:                 // Dateiunterverzeichnis
			tmp_ptr= stpcpy( dir, strchr( filedir, '\\'));
			chr_ptr= exp_ptr+ strlen( extCom[ i]);
			if(( *chr_ptr!= ' ')&& ( *chr_ptr!= '\0')&& ( *chr_ptr!= '\\')&& ( *( tmp_ptr- 1)!= '\\'))
			   strcpy( tmp_ptr++, "\\");
			expDelta= ( ptrdiff_t)exp_ptr- ( ptrdiff_t)com_ptr;
			memDelta= strlen( dir)- strlen( extCom[ i]);
			if(( com_ptr= realloc( com_ptr, strlen( com_ptr)+ memDelta+ 1))!= NULL)
			{
			   exp_ptr= com_ptr+ expDelta;
			   memmove( exp_ptr+ memDelta, exp_ptr, strlen( exp_ptr)+ 1);
			   memcpy( exp_ptr, dir, ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)dir);
			}
			else
			{
			   ErrorMsg( KEIN_SPEICHER);
			   error= TRUE;
			}
			break;
		     case 3:                 // Dateiname (ohne Erweiterung)
			if(( tmp_ptr= strchr( filename, '.'))== NULL)
			   tmp_ptr= filename+ strlen( filename);
			expDelta= ( ptrdiff_t)exp_ptr- ( ptrdiff_t)com_ptr;
			memDelta= ( ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)filename)- strlen( extCom[ i]);
			if(( com_ptr= realloc( com_ptr, strlen( com_ptr)+ memDelta+ 1))!= NULL)
			{
			   exp_ptr= com_ptr+ expDelta;
			   memmove( exp_ptr+ memDelta, exp_ptr, strlen( exp_ptr)+ 1);
			   memcpy( exp_ptr, filename, ( ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)filename));
			}
			else
			{
			   ErrorMsg( KEIN_SPEICHER);
			   error= TRUE;
			}
			break;
		  }
	       }while( !error&& (i< sizeof( extCom)/ sizeof( char *)));
	       if( !error)
	       {
		  if( WriteExecStartBAT( filedir, com_ptr, BAT_FLEX))
		     ret_val= TRUE;
		  free( com_ptr);
	       }
	    }
	    else
	       ErrorMsg( KEIN_SPEICHER);
	    break;
	 }
	 else
	    flex_ptr= flex_ptr->next;
      }
   }
   return( ret_val);
}

void FreeFlexLibrary( void)
{
   sFlex *flex_ptr= FlexTable, *tmp_ptr;

   if( FlexTable)
   {
      while( flex_ptr)
      {
	 free( flex_ptr->filter);
	 free( flex_ptr->command);
	 tmp_ptr= flex_ptr;
	 flex_ptr= flex_ptr->next;
	 free( tmp_ptr);
      }
      FlexTable= NULL;
   }
}