#ifndef _DEFINES_H
#define _DEFINES_H

#include "typedef.h"
#include "version.h"

#define SOUNDBLASTER     0
#define PC_SPEAKER       1

#define SHADOW           0
#define NO_SHADOW        1

#define NOT_MEMORY       -9
#define FATAL_MEMORY     -10
#define MEMORY_EXIT      246

#define FILE_SEARCH      0x80
#define DIR_SEARCH_VOR   0x40  /* Anwenderfunktion wird vor Verzeichniswechsel aufgerufen */
#define DIR_SEARCH_NACH  0x20  /* Anwenderfunktion wird nach Verzeichniswechsel aufgerufen */
#define EXIT_DIR         1                 /* Verzeichnis wird bersprungen */

#define S_FILE           0        /* wird an die Anwenderfunktion geliefert */
#define S_DIR            1

#define PROGRAMM_MANAGER       0
#define DATEI_MANAGER          1
#define PUZZLE_SCHONER         0
#define LINIEN_SCHONER         1
#define DRAG_DROP_KOPIEREN     0
#define DRAG_DROP_VERSCHIEBEN  1

#define GRP_vor_PRG         0
#define PRG_vor_GRP         1
#define EGAL                2

#define TAL              0
#define BERG             1

#define EDIT             0
#define VIEW             1
#define VIEW_HEX         2
#define VIEW_ASCII       3

#define KOPIE            0
#define VERGLEICH        1
#define AUFFRISCHEN      2
#define PRUEFEN          3

#define INFO             0
#define FRAGE            1

#define UP               1
#define DOWN             2
#define AUS              0
#define AN               1
#define ABBRUCH          1
#define NOCHMAL          2
#define TMP_SICHERN      0
#define MIT_ABFRAGE      1
#define OHNE_ABFRAGE     2
#define GRUPPE           0x07
#define PROGRAMM         0x08

#define UNBEKANNT        0
#define DD_525           1                            /* Laufwerk: 5,25" DD */
#define HD_525           2                            /* Laufwerk: 5,25" HD */
#define DD_35            3                             /* Laufwerk: 3,5" DD */
#define HD_35            4                             /* Laufwerk: 3,5" HD */
#define ED_35            5                             /* Laufwerk: 3,5" ED */
#define NO_FORMAT        10

#define NO_DRIVE         -1
#define FLOPPY_525       0
#define FLOPPY_35        1
#define NETZWERK         2
#define FESTPLATTE       3
#define DOUBLEDENSITY    4
#define RAMDISK          5
#define CD_ROM           6

#define A_FLOPPY_525       0x0001
#define A_FLOPPY_35        0x0002
#define A_NETZWERK         0x0004
#define A_FESTPLATTE       0x0008
#define A_DOUBLEDENSITY    0x0010
#define A_RAMDISK          0x0020
#define A_CD_ROM           0x0040

#define FLOPPY_CODE      0xFE  /* if( !( 'ret'& FLOPPY_CODE)) -> is FLOPPY */

#define LW_AUSWAHL_CODE  0x00FF
#define LW_EXTRAS        0xFF00

#define DRIVE_READY      0x8000

#define ALL_DRIVES         0x0000
#define DRIVES_WITH_FORMAT 0x0001
#define SPEZ_DRIVES        0x0002

#define CARRY_FLAG       0x0001
#define ZERO_FLAG        0x0040
#define MAUS_INT         0x33                              /* MausInterrupt */
#define TASTATUR_INT     0x16                          /* TastaturInterrupt */
#define UHR_INT          0x1A                          /* CMOS-UhrInterrupt */
#define DOS_INT          0x21                               /* DosInterrupt */
#define VIDEO_INT        0x10                             /* VideoInterrupt */
#define DISK_INT         0x13                         /* Disketteninterrupt */
#define MULTIPLEX_INT    0x2F                       /* Multiplexerinterrupt */

#define NO_CHECK         0
#define CHECK            1

#define MAX_ANZ_ALARME      3
#define MAX_ALARMMSGLENGTH  31

#define MARKX             88
#define MARKY             105
#define ICONABSTANDX      147
#define ICONABSTANDY      60
#define MARKYWIN          150
#define Y_ICON_MARK_ABST  30

#define HGRP_ID             0
#define GRP_DATEIID         "DBDV2.00GRP"
#define GRP_MAXGRUPPENDIR   200
#define GRP_MAXGRUPPENNAME  17
#define GRP_LASTENTRY       0xFFFFFFFFL
#define GRP_GRUPPE          0
#define GRP_PROGRAMM        1
#define GRP_NOPARAWIN       0
#define GRP_PARAWIN         1
#define GRP_MAXICONBYTES    640
#define GRP_MAXPARAMETER    MAXPATH
#define GRP_DEFAULTDIR      "<DEFAULT>"
#define GRP_MAXFILELENGTH   60000

#define GRP_ICONMASK        0x80000000

#define MAX_HAUPTGRPICONS   24
#define MAX_GRPICONS        20

#define GRP_DRAW            0x80
#define GRP_DRAWFILTER      0x7F
#define GRP_ALT             0x80
#define GRP_NEU             0x81
#define GRP_REDRAW          0x82
#define GRP_JUMPDIR         0x83
#define GRP_AUTOINSTALL     0x01

#define EXE              0
#define COM              1
#define BAT              2
#define TXT              3
#define DIR              4
#define ICO              5
#define BMP              6
#define PCX              7
#define VOC              8
#define WAV              9

#define SORT_FILE        0
#define SORT_EXT         1
#define SORT_SIZE        2
#define SORT_DATE    	 3
#define SORT_TIME        4

#define TASTE_GEDRUECKT    ( !( inportb( 0x60)& 0x80)|| ( inportb( 0x60)== 0xE0))
#define TASTE_LOSGELASSEN     ( inportb( 0x60)& 0x80)
#define LO( wert)          (( BYTE)( ( WORD)wert& 0xFF))
#define HI( wert)          (( BYTE)( ( WORD)wert>> 8))

#ifndef ROLLBALKEN_DEF

#define ROLLBALKEN_DEF

typedef struct{ int x, y, x_y;
		char lage;
		int minstep, maxstep;
		long min, max, proz;
		int greifx_y;
		char ret_val, button_flag;
		int maus_to_Zeiger_ref, Zeiger_pos;
		long proz_sp;
		void *button;
	      }RBalken;                       /* Struktur eines Rollbalkens */

#endif

#define DW_MAXFILTER 51
#define DW_FEST      0
#define DW_BEWEGLICH 1

#ifndef MAXDIR

#include <dir.h>

#endif

typedef struct
	{
	   int *X, *Y, anz_mark;
	   long gesbyte_mark;
	   char Win_Typ, Sort_Typ, entry_mark, stat_dyn, old_verzeichnis[ MAXDIR+ DW_MAXFILTER], *dir_entrys[ 1000], *verzeichnis;
	   RBalken *RB;
	}DATWINStruct;

#ifndef MS_DEF

#define MS_DEF

#include "savescr.h"

#define MAX_INTERN_TASTEN  25

typedef struct
	{
	   int *x, *y, xlength, ylength, spotanz, statsp;
	   char **msg, statzeile;
	   WORD *mauspos;
	   void **arg_ptr;
	   int framesp, frame_ptr_sp, frame_ret, frame_pos_at_element,
	       frame_msg_sp, anz_intern_Tasten, Last_mauspos, Last_arg_ptr,
	       Last_msg;
	   WORD intern_Tasten[ MAX_INTERN_TASTEN][ 4], dup_flag, duplicate;
	   char Taste_Maus;
	   saveall sa;
	}MAUSStruct;

#endif

typedef struct{ WORD       XMS_handle;
		int        File_handle;
		BYTE       Neu,
			   mark[ 7],
			   IconNamelen[ MAX_HAUPTGRPICONS];
		WORD       balkenx,
			   balkeny,
			   ymerk;
		long       seek_pos,
			   mem_len;
		MAUSStruct *MS;
		char       *gruppendir,
			   *gruppe;
		RBalken    *RB;
	      }GRP_struct;

typedef struct
	{  BOOL alarm;
	   char msg[ MAX_ALARMMSGLENGTH];
	   int	stunde,
		minute,
		tag,
		monat;
	}Alarm_struct;

#define SFW_LEER           0
#define SFW_TMP            3   /* Daten werden temporr gespeichert (...wo ermittelt die Funktion) */
#define SFW_PERM_PLATTE    4   /* wird dauerhaft auf Festplatte gespeichert */

typedef struct
	{
	   BYTE mode;
	   FILE *file;
	   WORD XMS_handle;
	}SaveFWindow_struct;

#define AT_GELOESCHT  0
#define AT_GESETZT    1
#define AT_EGAL       2

typedef struct
	{
	   BYTE Archiv,
		Hidden,
		RDonly,
		System;
	   WORD nach_ff_fdate,
		vor_ff_fdate;
	   BOOL nach_Datum,
		vor_Datum,
		aktiv;
	}view_filter_struct;

#define Y_KOMMANDO  458

typedef struct
	{
	   char Zeile[ 128];
	   saveall sa;
	}extended_DatManag_struct;

typedef struct sFlex
{
   struct sFlex *next;
   char *filter;
   char *command;
}sFlex;

#endif  /* _DEFINES_H */
