/* This program is free software; you can redistribute it and/or modify it */
/* under the terms of the GNU General Public License version 2 as          */
/* published by the Free Software Foundation.                              */
/*                                                                         */
/* This program is distributed in the hope that it will be useful, but     */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc., */
/* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <assert.h>
#ifdef __PACIFIC__
#include <unixio.h>
#endif
#include "awale.h"
#include "kitten.h"

/* To make conditional pause()'s possible */
int demo = 0, onep = 0, cat = 0;

/* Dfiniton du tableau donnant la profondeur de recherche suivant la difficulte */
int tab_profondeur[10][6]={{0,0,1,1,3,3},{1,1,1,3,5,9},{2,2,2,4,6,10},{3,3,3,5,7,11},{4,4,4,6,9,13},{5,5,5,7,11,15},{6,6,7,9,13,19},{7,7,9,11,15,23},{8,9,11,13,17,25},{9,11,13,15,19,27}};

/* Affiche l'awale a l'ecran suivant le paramtre def dans awale.h*/
#if !defined(__TURBOC__)&&!defined(__WATCOMC__)&&!defined(__PACIFIC__)
#define afficher(x) afficher_commun(x)
#else
#define afficher(x) afficher_beau(x)
#endif

/* Formate la demande d'un nombre entre a et b*/
/****************************/
int return_valeur(int a,int b)
/****************************/
{
    int choix;
    fprintf(stderr, "\n\n%s : ", kittengets(2,0,"Your choice"));
    choix = getcharacter(0);
    while ((choix<a)||(choix>b))
    {
  	    fprintf(stderr, "%s %d %s %d : ",kittengets(2,1,"Enter between"),a,kittengets(2,2,"and"),b);
            choix = getcharacter(0);
    }
    return choix;
}


/* Cre un awale conforme et le renvoie*/
/**********************************/
void initialiser(awale* a,int total)
/**********************************/
{
    int i;
    for (i=0;i<6;i++)
    {
        a->case_moi[i]=a->case_cpu[i]=4;
    }
    a->score_moi=a->score_cpu=a->fini=0;
    a->tour_jeu=a->difficulte=1;
    if (total==0) return; /* On sort et n'initialise pas la suite*/
    strcpy(a->nom1,kittengets(2,3,"Player 1"));
    strcpy(a->nom2,kittengets(2,4,"Player 2 / CPU"));

}

#if defined(__TURBOC__)||defined(__WATCOMC__)||defined(__PACIFIC__)
/* Affiche l'awale avec un cadre autour en ascii*/
/*************************/
void afficher_beau(awale a)
/*************************/
{
	clrscr();
	printf("\n\n\n%s : %s\n\n",kittengets(2,5,"It's your turn"),(a.tour_jeu==1?a.nom1:a.nom2));
	printf("\311\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\273\n");
	printf("\272%2d\263%2d\263%2d\263%2d\263%2d\263%2d\272    %s : %d\n",a.case_cpu[5],a.case_cpu[4],a.case_cpu[3],a.case_cpu[2],a.case_cpu[1],a.case_cpu[0],kittengets(2,6,"score"),a.score_cpu);
	printf("\272\304\304\305\304\304\305\304\304\305\304\304\305\304\304\305\304\304\272\n");
	printf("\272%2d\263%2d\263%2d\263%2d\263%2d\263%2d\272    %s : %d\n",a.case_moi[0],a.case_moi[1],a.case_moi[2],a.case_moi[3],a.case_moi[4],a.case_moi[5],kittengets(2,6,"score"),a.score_moi);
	printf("\310\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\274\n");
	if(demo || (onep && a.tour_jeu == 2)) pause();
}

#else
/* Affiche l'awale sans cadre, reste commun mais compatible avec tous les ascii*/
/***************************/
void afficher_commun(awale a)
/***************************/
{
	clrscr();
	printf("\n\n\n%s : %s\n\n",kittengets(2,5,"It's your turn"),(a.tour_jeu==1?a.nom1:a.nom2));
	printf("%3d %3d %3d %3d %3d %3d     %s : %d\n\n\n",a.case_cpu[5],a.case_cpu[4],a.case_cpu[3],a.case_cpu[2],a.case_cpu[1],a.case_cpu[0],kittengets(2,6,"score"),a.score_cpu);
	printf("%3d %3d %3d %3d %3d %3d     %s : %d\n\n",a.case_moi[0],a.case_moi[1],a.case_moi[2],a.case_moi[3],a.case_moi[4],a.case_moi[5],kittengets(2,6,"score"),a.score_moi);
	if(demo || (onep && a.tour_jeu == 2)) pause();
}
#endif

/* Le joueur joue un coup entre 0 et 5
 Dplace les pions, change le score
 En paramtre, le plateau de jeu et la case  jouer*/
/*****************************************/
void joueur_joue(awale* a,int case_choisie)
/*****************************************/
{
	int case_gene=case_choisie;
	int nb_graine=a->case_moi[case_choisie]; /* Nombre de graines dans la case  jouer*/
	int case_bis=11; /* Servira pour la rgle : enlve tt enlve rien*/
	int enleve=0;
	
	
	a->case_moi[case_choisie]=0; /* Case  jouer remise  0*/
	
	/*Dpose les graines*/
	while(nb_graine!=0)
	{
		case_gene++;
		if (case_gene==12) case_gene=0;
  		if (case_gene==case_choisie) case_gene++; /* On est dans la case  jouer, on passe  la suivante*/
		if (case_gene>5)
			a->case_cpu[case_gene-6]++;
		else
			a->case_moi[case_gene]++;
		nb_graine--;
	}

	/* Vrifie la rgle : enlve tt enlve rien*/
	if ((case_gene>5)&&((a->case_cpu[case_gene-6]==2)||(a->case_cpu[case_gene-6]==3)))
	{
		while ((case_bis!=case_gene)&&(enleve==0))
		{
			if (a->case_cpu[case_bis-6]!=0) enleve=1;
			case_bis--;
		}
		case_bis--;
		while ((case_bis>5)&&(enleve==0))
		{
			if ((a->case_cpu[case_bis-6]!=2)&&(a->case_cpu[case_bis-6]!=3)) enleve=1;
			case_bis--;
		}
		/* si enleve==1, alors on peut enlever les graines gagnes*/
		if (enleve==1)
			while ((case_gene>5)&&((a->case_cpu[case_gene-6]==2)||(a->case_cpu[case_gene-6]==3)))
			{
				a->score_moi+=a->case_cpu[case_gene-6];
				a->case_cpu[case_gene-6]=0;
				case_gene--;
			}
	}	
	a->tour_jeu=2; /* C'est au tour de l'autre*/
}

	
/* Le cpu joue un coup entre 0 et 5
 Dplace les pions, change le score
 En paramtre le plateau de jeu et la case  jouer*/
/**************************************/
void cpu_joue(awale* a,int case_choisie)
/**************************************/
{
	int case_gene=case_choisie;
	int nb_graine=a->case_cpu[case_choisie];
	int case_bis=11; /* Servira pour la rgle : enlve tt enlve rien*/
	int enleve=0;
	
	
	a->case_cpu[case_choisie]=0;
	
	/*Dpose les graines*/
	while(nb_graine!=0)
	{
		case_gene++;
		if (case_gene==12) case_gene=0;
		if (case_gene==case_choisie) case_gene++;
		if (case_gene>5)
			a->case_moi[case_gene-6]++;
		else
			a->case_cpu[case_gene]++;
		nb_graine--;
	}
	
	/*Enlve celles gagnes et augmente le score*/
		/* Vrifie la rgle : enlve tt enlve rien*/
	if ((case_gene>5)&&((a->case_moi[case_gene-6]==2)||(a->case_moi[case_gene-6]==3)))
	{
		while ((case_bis!=case_gene)&&(enleve==0))
		{
			if (a->case_moi[case_bis-6]!=0) enleve=1;
			case_bis--;
		}
		case_bis--;
		while ((case_bis>5)&&(enleve==0))
		{
			if ((a->case_moi[case_bis-6]!=2)&&(a->case_moi[case_bis-6]!=3)) enleve=1;
			case_bis--;
		}
		/* si enleve==1, alors on peut enlever les graines gagnes*/
		if (enleve==1)
			while ((case_gene>5)&&((a->case_moi[case_gene-6]==2)||(a->case_moi[case_gene-6]==3)))
			{
				a->score_cpu+=a->case_moi[case_gene-6];
				a->case_moi[case_gene-6]=0;
				case_gene--;
			}
	}
	a->tour_jeu=1; /* Au tour de l'autre*/
}

	
/* Demande au joueur quel coup il veut jouer
 Joue le coup choisi*/
/***************************/
void demande_joueur(awale* a)
/***************************/
{
	int i=0;
	int coup;
	
	/* Vrifie si le jeu n'est pas fini*/
	if (a->case_cpu[0]+a->case_cpu[1]+a->case_cpu[2]+a->case_cpu[3]+a->case_cpu[4]+a->case_cpu[5]==0)
	{
		while ((i+a->case_moi[i]<6)&&(i<6)) i++; /* Vrifie si on peut donner des graines*/
		if (i==6)
		{
			a->fini=1;
			return; /* Jeu fini*/
		}
	}
	
	fprintf(stderr, "%s : ",kittengets(2,7,"Which square"));
	coup = getcharacter(0);
	
	/* Coup entre 1 et 6*/
	while ((coup<1)||(coup>6))
	{
		fprintf(stderr, "%s : ",kittengets(2,8,"The number must be between 1 and 6"));
		coup = getcharacter(0);
	}
	
	/* Joue une case non vide*/
	while (a->case_moi[coup-1]==0)
	{
		fprintf(stderr, "%s : ",kittengets(2,9,"The box cannot be empty"));
		coup = getcharacter(0);
	}
	
	/* Vrifie si l'adversaire n'a pas de graine*/
	if (a->case_cpu[0]+a->case_cpu[1]+a->case_cpu[2]+a->case_cpu[3]+a->case_cpu[4]+a->case_cpu[5]==0)
		while (coup+a->case_moi[coup-1] < 7)
		{
			fprintf(stderr, "%s : ",kittengets(2,10,"Seeds must be moved!"));
			coup = getcharacter(0);
		}
		
	joueur_joue(a,coup-1);
}


/* Demande au cpu quel coup il veut jouer
 Joue le coup
 Mode 2 joueurs*/
/************************/
void demande_cpu(awale* a)
/************************/
{
	int i = 0;
	int coup;
	
	/* Vrifie si le jeu n'est pas fini*/
	if (a->case_moi[0]+a->case_moi[1]+a->case_moi[2]+a->case_moi[3]+a->case_moi[4]+a->case_moi[5]==0)
	{
		while ((i+a->case_cpu[i]<6)&&(i<6)) i++; /* Vrifie si on peut donner des graines*/
		if (i==6)
		{
			a->fini=1;
			return; /* Jeu fini*/
		}
	}
	
	fprintf(stderr, "%s : ",kittengets(2,7,"Which square"));
	coup = getcharacter(0);
	
	/* Coup entre 1 et 6*/
	while ((coup<1)||(coup>6))
	{
		fprintf(stderr, "%s : ",kittengets(2,8,"The number must be between 1 and 6"));
		coup = getcharacter(0);
	}
	
	/* Joue une case non vide*/
	while (a->case_cpu[coup-1]==0)
	{
		fprintf(stderr, "%s : ",kittengets(2,9,"The box cannot be empty"));
		coup = getcharacter(0);
	}
	
	/* Vrifie si l'adversaire n'a pas de graine*/
	if (a->case_moi[0]+a->case_moi[1]+a->case_moi[2]+a->case_moi[3]+a->case_moi[4]+a->case_moi[5]==0)
		while (coup-1+a->case_cpu[coup-1]<6)
		{
			fprintf(stderr, "%s : ",kittengets(2,10,"Seeds must be moved!"));
			coup = getcharacter(0);
		}
	
	cpu_joue(a,coup-1);
}


/* Affecte les dernieres graines quand le jeu est fini*/
/*************************/
void terminer_jeu(awale* a)
/*************************/
{
	int i;
	a->score_moi+=a->case_moi[0]+a->case_moi[1]+a->case_moi[2]+a->case_moi[3]+a->case_moi[4]+a->case_moi[5];
	a->score_cpu+=a->case_cpu[0]+a->case_cpu[1]+a->case_cpu[2]+a->case_cpu[3]+a->case_cpu[4]+a->case_cpu[5];
	for (i=0;i<6;i++) a->case_moi[i]=a->case_cpu[i]=0;
}


/* Cherche le meilleur coup du CPU de faon recursive
 Renvoie la case donnant le meilleur coup et le gain de score*/
/*******************************************************/
case_retour meilleure_case_cpu(awale a,int nbre_recursif)
/*******************************************************/
{
	int i;
	case_retour sortie={0,0}; /* On retourne la meilleure case avec le gain*/
	awale awa[6];
	int case_retenue=-1;
	int gain_retenu=-36;
	int gain_actuel;
	int donne[6]={0,0,0,0,0,0}; /* Marquera les cases qui ne donnent pas de graine*/
	
	/* Vrifie si l'adversaire est sans graines et marque les cases qui ne donnent pas*/
	if (a.case_moi[0]+a.case_moi[1]+a.case_moi[2]+a.case_moi[3]+a.case_moi[4]+a.case_moi[5]==0)
	{
		for(i=0;i<6;i++)
			if (i+a.case_cpu[i] < 6)
				donne[i]=1;
		if (donne[0]+donne[1]+donne[2]+donne[3]+donne[4]+donne[5]==6) /* Jeu fini car adversaire sans graine et on peut pas donner*/
		{
			sortie.gain_score=a.score_moi-a.score_cpu;
			terminer_jeu(&a);
			sortie.case_meilleure=-1;
			sortie.gain_score+=a.score_cpu-a.score_moi;
			return sortie;
		}
	}
	
	/* Le jeu n'est pas fini*/
	for (i=0;i<6;i++)
		if ((a.case_cpu[i]!=0)&&(donne[i]==0)) /* donne[i]=1 si adversaire sans graine et cette case ne donne pas*/
		{
			awa[i]=a;
			cpu_joue(&awa[i],i);
			if (nbre_recursif==0)
				gain_actuel=a.score_moi-a.score_cpu+awa[i].score_cpu-awa[i].score_moi;
			else
			{
				sortie=meilleure_case_joueur(awa[i],nbre_recursif-1); /* Lance la fonction rcursive complmentaire*/
				gain_actuel=a.score_moi-a.score_cpu+awa[i].score_cpu-awa[i].score_moi-sortie.gain_score;
			}
			if (gain_actuel>gain_retenu)
			{
				gain_retenu=gain_actuel;
				case_retenue=i;
			}
		}
		
	sortie.case_meilleure=case_retenue;
	sortie.gain_score=gain_retenu;
	
	return sortie;
}
			

/* Cherche le meilleur coup du joueur de facon recursive
 Renvoie la case donnant le meilleur coup et le gain de score
 Fonction complmentaire  meilleure_case_cpu(...)*/
/**********************************************************/
case_retour meilleure_case_joueur(awale a,int nbre_recursif)
/**********************************************************/
{
	int i;
	case_retour sortie={0,0};
	awale awa[6];
	int case_retenue=-1;
	int gain_retenu=-36;
	int gain_actuel;
	int donne[6]={0,0,0,0,0,0}; /* Marque les cases qui ne donnent pas de graine*/
	
	/* Vrifie si l'adversaire est sans graines et marque les cases qui ne donnent pas*/
	/* The next line is where a stack overflow occurs */
	if (a.case_cpu[0]+a.case_cpu[1]+a.case_cpu[2]+a.case_cpu[3]+a.case_cpu[4]+a.case_cpu[5]==0)
	{
		for(i=0;i<6;i++)
			if (i+a.case_moi[i] < 6)
				donne[i]=1;
		if (donne[0]+donne[1]+donne[2]+donne[3]+donne[4]+donne[5]==6) /* Jeu fini*/
		{
			sortie.gain_score=a.score_cpu-a.score_moi;
			terminer_jeu(&a);
			sortie.case_meilleure=-1;
			sortie.gain_score+=a.score_moi-a.score_cpu;
			return sortie;
		}
	}
				
	for(i=0;i<6;i++)
		if ((a.case_moi[i]!=0)&&(donne[i]==0))
		{
			awa[i]=a;
			joueur_joue(&awa[i],i);
			if (nbre_recursif==0)
			{
				gain_actuel=a.score_cpu-a.score_moi+awa[i].score_moi-awa[i].score_cpu;
			}
			else
			{
				sortie=meilleure_case_cpu(awa[i],nbre_recursif-1);
				gain_actuel=a.score_cpu-a.score_moi+awa[i].score_moi-awa[i].score_cpu-sortie.gain_score;
			}
			if (gain_actuel>gain_retenu)
			{
				gain_retenu=gain_actuel;
				case_retenue=i;
			}
		}
		
	sortie.case_meilleure=case_retenue;
	sortie.gain_score=gain_retenu;
	
	return sortie;
}


/* Affiche le gagnant pour jeu 1 joueur*/
/************************************/
void afficher_gagnant_1joueur(awale a)
/************************************/
{
	if (a.score_moi > a.score_cpu)
		printf("%s %s !\n %s.\n\n",kittengets(2,11,"The winner is"),a.nom1,kittengets(2,12,"Congradulations"));
	else {
		if (a.score_moi < a.score_cpu)
			printf("%s !\n %s.\n\n",kittengets(2,13,"The winner is the computer"),kittengets(2,14,"Good try"));
		else
			printf("%s\n %s.\n\n",kittengets(2,15,"A tie!"),kittengets(2,16,"Not too bad"));
	}
	pause();
}

#ifndef NO_DEMO
/* Affiche le message de fin pour la demo*/
/*********************************/
void afficher_gagnant_demo(void)
/*********************************/
{
	printf("\n%s.\n\n",kittengets(2,17,"End of the demo"));
	pause();
}
#endif

#ifndef NO_TWO_PLAYERS
/* Affiche le gagnant pour le jeu  2 joueurs*/
/*************************************/
void afficher_gagnant_2joueurs(awale a)
/*************************************/
{
	if (a.score_moi > a.score_cpu)
		printf("%s %s !\n %s.\n\n",kittengets(2,11,"The winner is"),a.nom1,kittengets(2,12,"Congradulations"));
	else {
		if (a.score_moi < a.score_cpu)
		printf("%s %s !\n %s.\n\n",kittengets(2,11,"The winner is"),a.nom2,kittengets(2,12,"Congradulations"));
		
		else printf("%s\n %s.\n\n", kittengets(2,15,"A tie!"),kittengets(2,16,"Not too bad"));
	}
	pause();
}
#endif

/* Fait tourner le jeu, une fois le joueur, une fois le CPU*/
/******************************/
void lance_jeu_1joueur(awale* a)
/******************************/
{
	int nbre_graine;
	int profondeur;
	case_retour choix_cpu;

	onep = 1;
		
	afficher(*a);
	while (a->fini==0)
	{
		demande_joueur(a); /* demande et joue*/
		afficher(*a);
		if (a->fini==0)
		{
			/* Calcule le nbre d'itrations en fonction du nbre total de graines
			 Moins il y a de graines et plus il va loin dans la recherche*/
			nbre_graine=a->case_moi[0]+a->case_moi[1]+a->case_moi[2]+a->case_moi[3]+a->case_moi[4]+a->case_moi[5]+a->case_cpu[0]+a->case_cpu[1]+a->case_cpu[2]+a->case_cpu[3]+a->case_cpu[4]+a->case_cpu[5];
			profondeur=tab_profondeur[a->difficulte][0];
			if (nbre_graine<24) profondeur=tab_profondeur[a->difficulte][1];
   			if (nbre_graine<18) profondeur=tab_profondeur[a->difficulte][2];
			if (nbre_graine<12) profondeur=tab_profondeur[a->difficulte][3];
			if (nbre_graine<6)  profondeur=tab_profondeur[a->difficulte][4];
			if (nbre_graine<4)  profondeur=tab_profondeur[a->difficulte][5];
			
			choix_cpu=meilleure_case_cpu(*a,profondeur);
			if (choix_cpu.case_meilleure!=-1)
			{
				cpu_joue(a,choix_cpu.case_meilleure);
				afficher(*a);
			}
			else a->fini=1;
		}
	}
	terminer_jeu(a);
	afficher(*a);
	afficher_gagnant_1joueur(*a);
	onep = 0;
}

#ifndef NO_DEMO
/* Fait tourner le jeu en demo, le cpu joue seul*/
/***************************/
void lance_jeu_demo(awale* a)
/***************************/
{
	int nbre_graine;
	int profondeur;
	case_retour choix_cpu;
	case_retour choix_moi;
		
	demo = 1;
	afficher(*a);
	while (a->fini==0)
	{
		nbre_graine=a->case_moi[0]+a->case_moi[1]+a->case_moi[2]+a->case_moi[3]+a->case_moi[4]+a->case_moi[5]+a->case_cpu[0]+a->case_cpu[1]+a->case_cpu[2]+a->case_cpu[3]+a->case_cpu[4]+a->case_cpu[5];
		profondeur=tab_profondeur[a->difficulte][0];
		if (nbre_graine<24) profondeur=tab_profondeur[a->difficulte][1];
		if (nbre_graine<18) profondeur=tab_profondeur[a->difficulte][2];
		if (nbre_graine<12) profondeur=tab_profondeur[a->difficulte][3];
		if (nbre_graine<6)  profondeur=tab_profondeur[a->difficulte][4];
		if (nbre_graine<4)  profondeur=tab_profondeur[a->difficulte][5];
			
		choix_moi=meilleure_case_joueur(*a,profondeur);
		if (choix_moi.case_meilleure!=-1)
		{
			joueur_joue(a,choix_moi.case_meilleure);
			afficher(*a);
		}
		else a->fini=1;
			
		if (a->fini==0)
		{
			/* Calcule le nbre d'itrations en fonction du nbre total de graines*/
			nbre_graine=a->case_moi[0]+a->case_moi[1]+a->case_moi[2]+a->case_moi[3]+a->case_moi[4]+a->case_moi[5]+a->case_cpu[0]+a->case_cpu[1]+a->case_cpu[2]+a->case_cpu[3]+a->case_cpu[4]+a->case_cpu[5];
			profondeur=tab_profondeur[a->difficulte][0];
			if (nbre_graine<24) profondeur=tab_profondeur[a->difficulte][1];
   			if (nbre_graine<18) profondeur=tab_profondeur[a->difficulte][2];
			if (nbre_graine<12) profondeur=tab_profondeur[a->difficulte][3];
			if (nbre_graine<6)  profondeur=tab_profondeur[a->difficulte][4];
			if (nbre_graine<4)  profondeur=tab_profondeur[a->difficulte][5];
							
			choix_cpu=meilleure_case_cpu(*a,profondeur);
			if (choix_cpu.case_meilleure!=-1)
			{
				cpu_joue(a,choix_cpu.case_meilleure);
				afficher(*a);
			}
			else a->fini=1;
		}
	}
	terminer_jeu(a);
	afficher(*a);
	afficher_gagnant_demo();
	demo = 0;
}
#endif

#ifndef NO_TWO_PLAYERS
/* Fait tourner le jeu  2 joueurs, le joueur joue pour lui et le cpu*/
/*******************************/
void lance_jeu_2joueurs(awale* a)
/*******************************/
{
	
	afficher(*a);
	while (a->fini==0)
	{
		demande_joueur(a);
		afficher(*a);
		if (a->fini==0)
		{
			demande_cpu(a);
			afficher(*a);
		}
	}
	terminer_jeu(a);
	afficher_gagnant_2joueurs(*a);
}
#endif

/*******************************/
void changer_difficulte(awale *a)
/*******************************/
{
    clrscr();
    printf("\n\n%s\n\n",kittengets(1,0,"Level of computer difficulty"));
    printf("%s\n",kittengets(1,1,"0. Idiot"));
    printf("%s\n",kittengets(1,2,"1. Bad"));
    printf("%s\n",kittengets(1,3,"2. Low"));
    printf("%s\n",kittengets(1,4,"3. Medium"));
    printf("%s\n",kittengets(1,5,"4. Good"));
    printf("%s\n",kittengets(1,6,"5. Very good"));
    printf("%s\n",kittengets(1,7,"6. Excellent"));
    printf("%s\n",kittengets(1,8,"7. Expert"));
    printf("%s\n",kittengets(1,9,"8. Genius"));
    printf("%s\n",kittengets(1,10,"9. Perfect"));

    a->difficulte=return_valeur(0,9);
}


/*************************/
void changer_noms(awale* a)
/*************************/
{
    clrscr();
    fprintf(stderr, "\n\n%s : ",kittengets(1,11,"The name of the first player"));
    gets(a->nom1);
    fprintf(stderr, "%s : ",kittengets(1,12,"The name of the second player"));
    gets(a->nom2);
}

/*************************/
void viewrules(void)
/*************************/
{
	int i;
	clrscr();
	if(cat == -1)
		printf("%s\n", kittengets(2,20,
				"Language unsupported or insufficient lang variable set"));
	else for(i = 0;i<30;i++) {
		printf("%s\n", kittengets(3,i,NULL));
		if(i == 12) {
			pause();
			clrscr();
		}
	}
	pause();
}

