//======================================================================
//
// Free-XDEL: Gnu Gpl version of XDEL for the FreeDOS project
//
// by Alain Mouette 22/may/2002
//
// Licence: at your option:
//  1) GNU GPL
//  2) do whatever you want, but please put an acknowledgement to me :)
//
// Missing from this version:
//  - LFN support (I'll wait for FreeDOS to have it first)
//
// Compiler Borland-C 3.1, Small model, Optimized for speed
//----------------------------------------------------
// To emulate deltree:
//    use /SDRY (/Y only with DR-DOS 7, undocumented)
//    first directory will not be removed
//----------------------------------------------------
// Acknowledgements:
// Thanks to Arkady Belusof for checking my code and
//  suggesting very usefull fixes and improuvements (Ver 2.03)
//----------------------------------------------------
// Version 2.04 23/jun/2005: only removed extra line-feed at the end
//======================================================================

#include <STDIO.H>
#include <STRING.H>
#include <CONIO.H>
#include <CTYPE.H>
#include <DOS.H>
#include <DIR.H>
#include <STDLIB.H>

#define VERSION "2.04"
//#define debug

//----------------------------------------------------------------------
//--- International messages -------------------------------------------
//----------------------------------------------------------------------

#include "lang.inc"

//----------------------------------------------------------------------
//--- Variables and Constants ------------------------------------------
//----------------------------------------------------------------------

#define OPT_HELP      0x0001
#define OPT_REM_EMPTY 0x0002
#define OPT_NO_WARN   0x0004
#define OPT_OVER_WR   0x0008
#define OPT_PR_EACH   0x0010
#define OPT_DEL_RO    0x0020
#define OPT_SUB_DIR   0x0040
#define OPT_ERROR     0x0080

#define ERR_SYNTAX  1
#define ERR_DELETE  2
#define ERR_MEMORY  3

short options     =0;
char  ctrBrkAbort =0;

//----------------------------------------------------------------------
//--- Basic functions --------------------------------------------------
//----------------------------------------------------------------------

#define bool  int                       // C++ definitions
#define true  1
#define false 0
#define StrCpy(dest,src) strNcpy(dest,src,sizeof(dest))
#define StrCat(dest,src) strNcat(dest,src,sizeof(dest))
#define F_MAX (_MAX_DRIVE+_MAX_DIR+_MAX_FNAME+_MAX_EXT)// maximum file name
//--------------------------------------
char *strNcpy(char *dest, const char *src, int size)
{
 if (dest){
  if (src){
   char* s = strncpy(dest,src,size);
   dest[size-1]=0;
   return (s);
  }else{
   dest[0]=0;
   return (dest);
  }
 }else
  return (0);
}
//--------------------------------------
char *strNcat(char *dest, const char *src, int size)
{
 char* s;
 if (src){
  int len=strlen(dest);
  if (len<size)
   s = strncat(dest,src,size-len);
  dest[size-1]=0;
  return (s);
 }else
  return (dest);
}

//----------------------------------------------------------------------
//--- Program... -------------------------------------------------------
//----------------------------------------------------------------------

//--------------------------------------
#define BUF_SIZE 4096  // Has to be multiple of 32 !!!
static char* wipeBuf=0;

short WipeFile(const char* file,const unsigned long size)
{
 FILE* fp;
 int i,retValue=0;
 unsigned long l;
 // Open file to wipe first
 if ((fp = fopen(file,"r+b"))!=NULL){
  // check if buffer is prepared
  if (!wipeBuf){
   wipeBuf=new char[BUF_SIZE];
   if (!wipeBuf){
    printf(STR_ERR_MEM);
    return(ERR_MEMORY);
   }
   for (i=0;i<BUF_SIZE;i+=32)
    memcpy(&wipeBuf[i],"Completely deleted by FreeXDEL\r\n",32);//fraction of buff!
  }
  // wipe it
  l=size;
  while(l>=BUF_SIZE && !feof(fp)){
   fwrite(wipeBuf,BUF_SIZE,1,fp);       // write full blocks
   l-=BUF_SIZE;
  }
  if (l)
   fwrite(wipeBuf,(int)l,1,fp);         // here l<BUF_SIZE
  fclose(fp);
 }else{
  retValue=ERR_DELETE;                  // error deleting
 }
 return(retValue);
}
//--------------------------------------
bool AskYes(void)
{
 char ch;
 if (ctrBrkAbort)                       // has been aborted earlier
  return(false);
 ch=toupper(getch());
 if (ch==0x03)                          // test Ctrl-C
  ctrBrkAbort=1;
 if (isprint(ch))
  putch(ch);
 if (ch!=YES_CHAR || ctrBrkAbort)
  return(false);
 return(true);
}
//--------------------------------------
bool AskDelete(const char* dir,const char* file)
{
 char *fullDir;
 bool retValue=true;
 fullDir= new char[F_MAX];
 if (_fullpath(fullDir,dir,F_MAX) != NULL){
  while(kbhit()) getch();
  printf(STR_ASK_DEL,fullDir,file);     // Ask confirmation
  if (!AskYes())
   retValue=false;
 }else{
  strNcpy(fullDir,dir,F_MAX);strNcat(fullDir,file,F_MAX);
  printf(STR_BAD_NAME,fullDir);
  retValue=false;
 }
 delete []fullDir;
 return(retValue);
}
//--------------------------------------
bool AskDeleteFile(const char* file)
{
 char *fullName;
 bool retValue=true;
 fullName= new char[F_MAX];
 if (_fullpath(fullName,file,F_MAX) != NULL){
  while(kbhit()) getch();
  printf(STR_ASK_FILE,fullName);
  if (!AskYes())
   retValue=false;
 }else
  retValue=false;
 delete []fullName;
 return(retValue);
}

//--------------------------------------
int xDel2(const char* dir,const char* name)// delete files: one level
{
 char *file;
 struct find_t *ff;
 int dirDone,attr,err;
 int retValue=0;

 file = new char[F_MAX];                // use heap instead of stack
 ff   = new struct find_t;

 #ifdef debug
 printf("\n>>apagando dir=[%s] name=[%s]",dir,name);
 #endif
 //--- Delete ---
 strNcpy(file,dir,F_MAX);strNcat(file,name,F_MAX);
 attr=FA_HIDDEN|FA_SYSTEM|FA_ARCH|FA_DIREC;
 if (options&OPT_DEL_RO)                // include ReadOnly files
  attr|=FA_RDONLY;
 dirDone = _dos_findfirst(file,attr,ff);
 while (!dirDone && !ctrBrkAbort){
  strNcpy(file,dir,F_MAX);strNcat(file,ff->name,F_MAX);// complete file name
  if (ff->attrib&FA_DIREC){
   if (strcmp(ff->name,".") && strcmp(ff->name,"..")){
    //---Recurse SubDirectories---
    if (options&OPT_SUB_DIR){
     strNcat(file,"\\",F_MAX);          // nome do novo diretrio
     #ifdef debug
     printf("\n reentrando diretorio=[%s]",file);
     #endif
     err=xDel2(file,name);              // Recurse new directory
     if (err > retValue)
      retValue = err;                   // Keep higher error
    }
    //---remove empty directories---
    if (options&OPT_REM_EMPTY){
     file[strlen(file)-1]=0;            // remove final '\\'
     #ifdef debug
     printf("\n apagando diretorio=[%s]",file);
     #endif
     if (rmdir(file)!=0)                // will succeed only if empty
      printf(STR_DEL_DIR,file);
    }
   }
  }else{
   //---delete files---
   #ifdef debug
   printf("\n apagando arq=[%s] attrib=%02x",file,ff->attrib);
   #endif
   if (!(ff->attrib&FA_RDONLY) || (options&OPT_DEL_RO)){//double check (bug?)
    if ((options&OPT_PR_EACH)&&!AskDeleteFile(file))// prompt each file
     retValue=ERR_DELETE;               // error deleting file...
    else{
     if (ff->attrib&(~FA_ARCH))
      _dos_setfileattr(file,0);         // remove attributes
     if (options&OPT_OVER_WR){
      err=WipeFile(file,ff->size);
      if (err > retValue)
       retValue = err;                  // Keep higher error
     }
     if (remove(file)!=0){
       printf(STR_DEL_FILE,file);
       retValue=ERR_DELETE;
     }
    }
   }
  }
  dirDone = _dos_findnext(ff);
 }
 #ifdef __WATCOMC__
  _dos_findclose(ff);
 #endif
 delete []file;
 delete ff;
 return (retValue);
}
//--------------------------------------
int xDel(const char* fName)             // Prepare names for deletion
{
 char *dir,*name;
 int retValue;
 char tDrive[_MAX_DRIVE];
 char tDir[_MAX_DIR];
 char tFile[_MAX_FNAME];
 char tExt[_MAX_EXT];

 dir  = new char[F_MAX];                // use heap instead of stack
 name = new char[F_MAX];
 _splitpath(fName,tDrive,tDir,tFile,tExt);
 if (!tFile[0]){                        // no file in name
  printf(STR_BAD_NAME,fName);
  retValue=ERR_DELETE;                  // returns error
 }else{
  _makepath(dir,tDrive,tDir,0,0);       // starting directory
  _makepath(name,0,0,tFile,tExt);       // only name and extention
  strupr(dir);
  strupr(name);
  if (!(options&OPT_NO_WARN)&&!AskDelete(dir,name))// no Warning
   retValue=ERR_DELETE;                 // error deleting file...
  else
   retValue=xDel2(dir,name);            // Deletes first level
 }
 delete []dir;
 delete []name;
 return(retValue);
}
//--------------------------------------
void CheckOption(const char* opt)
{
 short i,len;
 if (!stricmp(opt,"/help")){
  options|=OPT_HELP;
  return;
 }
 len=strlen(opt);
 if (len==1){
  printf(STR_BAD_OPT,opt);
  options|=OPT_ERROR;
  return;
 }
 for (i=1;i<len;i++)
  switch (toupper(opt[i])){
   case 'D':
    options|=OPT_REM_EMPTY;
    break;
   case 'N':
   case 'Y':
    options|=OPT_NO_WARN;
    break;
   case 'O':
    options|=OPT_OVER_WR;
    break;
   case 'P':
    options|=OPT_PR_EACH;
    break;
   case 'R':
    options|=OPT_DEL_RO;
    break;
   case 'S':
    options|=OPT_SUB_DIR;
    break;
   case 'H':
   case '?':
    options|=OPT_HELP;
    break;
   default:
    printf(STR_BAD_OPT,opt);
    options|=OPT_ERROR;
    return;
  }
}
//--------------------------------------
int main(int argc, char **argv)
{
 short firstFile=0;                     // file names in comand line
 short lastFile=0;
 short i,j,k,err,retValue;
 char *fileName;
 FILE * fp;                             // for file lists

 #ifdef debug
 clrscr();
 #endif

 if (argc<=1){
  printf(STR_HELP,VERSION);             // no parameter: write Help
  return(1);
 }
 // --- options ---
 for (i=1;i<argc && !(options&OPT_ERROR) && argv[i][0]=='/';i++)
  CheckOption(argv[i]);
 if (i<argc){
  firstFile=i;                          // remaining parameters are File Names
  for (i=argc-1;i>0 && !(options&OPT_ERROR) && argv[i][0]=='/';i--)
   CheckOption(argv[i]);
  if (i>=firstFile)
   lastFile=i;                          // preceding parameters are File Names
 }
 // --- errors ---
 if (options&OPT_ERROR)
  return(1);
 if (!firstFile || !lastFile){          // no name ramains
  if ((options&OPT_HELP)==OPT_HELP || !options)
   printf(STR_HELP,VERSION);
  else
   printf(STR_NO_NAME);
  return(1);
 }
 // --- write Help ---
 if (options&OPT_HELP){
  printf(STR_NO_NAME);
  return(1);
 }

 #ifdef debug
 printf("\n Options=%04x files: %d-%d",options,firstFile,lastFile);
 for (i=firstFile;i<=lastFile;i++)
  printf("\n File[%d]=[%s]",i,argv[i]);
 #endif

 // --- Start Operation ---
 retValue=0;
 fileName=new char[F_MAX];              // use heap for smaller executable!
 for (i=firstFile;i<=lastFile&&!ctrBrkAbort;i++){// command line list
  if (argv[i][0]=='@'){
   // --- File List ---
   if ((fp = fopen(&argv[i][1],"rt"))!=NULL){
    do{
     errno=0;
     if (fgets(fileName,F_MAX,fp)==NULL){// read one line
      if (errno){
       printf(STR_ERR_FILE,&argv[i][1]);
       break;                           // error reading file
      }else
       continue;
     }
     // --- Clean File Name ---
     strupr(fileName);
     j=strlen(fileName)-1;              // remove SP,TAB e LF on the right
     while ((j>=0)&&((fileName[j]==' ')||(fileName[j]=='\n')||(fileName[j]==9))) j--;
     fileName[++j]=0;
     k=0;                                               // remove SP e TAB on the left
     while ((k<=j)&&((fileName[k]==' ')||(fileName[k]==9))) k++;
     if ((fileName[k]==0)||(fileName[k]==';')||
         ((fileName[k]=='/')&&(fileName[k+1]=='/')))
      continue;                         // Comment [;|//] or empty
     err=xDel(&fileName[k]);
     if (err > retValue)
      retValue = err;                   // don't use macro on function
    }while (!feof(fp));
    fclose(fp);
   }else{
    printf(STR_ERR_FILE,&argv[i][1]);
   }
  }else{
   // --- file from command line ---
   err=xDel(argv[i]);
   if (err > retValue)
    retValue = err;                      // don't use macro on function
  }
 }
 delete []fileName;
 if (wipeBuf)
  delete []wipeBuf;                      // static buffer for wipe
 //printf("\n");
 return(retValue);
}



