/* DOS structures used in loadhi.c */

/* typedefs for common DOS data types */
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

/* memory control block */
struct MCB
{
   BYTE sig;
   WORD owner;
   WORD size;
   BYTE res[3];
   BYTE name[8];
};

/* program segment prefix */
struct PSP
{
   WORD         int20h;
   WORD         nextParagraph;
   BYTE         filler;
   BYTE         cpmDispatcher[5];
   DWORD        int22vector;
   DWORD        int23vector;
   DWORD        int24vector;
   WORD         parentPSP;
   BYTE         defaultProcessFileTable[20];
   WORD         environSeg;
   DWORD        stackSave;
   WORD         fileTableEntries;
   BYTE         far *processFileTable;
   struct PSP   far *previousPSP;
   BYTE         DBCSconsoleFlag;
   BYTE         truenameFlag;
   BYTE         divInfo[2];
   WORD         dosVersion;   
   WORD         winNextPDB;
   WORD         PDB_Partition;
   WORD         PDB_nextPDB;
   BYTE         winOldAp;
   BYTE         reserved1;  
   WORD         PDB_EntryStack;
   BYTE         reserved2[4];
   BYTE         serviceRequest[3];
   BYTE         resreved3[9];
   BYTE         fcb[2][16];
   BYTE         reserved4[4];
   BYTE         commandLine[128];
};

/* 'findfile' structure, written to the DTA on a find first / find next call */
struct findFile {
   BYTE  reserved[0x15];
   BYTE  attr;
   WORD  time;
   WORD  date;
   DWORD size;
   BYTE  name[13];
};

/* EXE file header */
struct ExeHeader
{
   WORD signature;
   WORD extraBytes;
   WORD pages;
   WORD relocItems;
   WORD hdrSize;
   WORD minAlloc;
   WORD maxAlloc;
   WORD initSS;
   WORD initSP;
   WORD checkSum;
   WORD initIP;
   WORD initCS;
   WORD relocTable;
   WORD overlayNo;
};

/* relocation table entry */
struct relocItem
{
   WORD offs, seg;
};

/* structure used by the 'Load Overlay' function */
struct LoadOverlay
{
   WORD loadSeg;
   WORD relocFactor;
};

/* File control block */
struct FCB
{
   BYTE drive;
   BYTE name[8];
   BYTE ext[3];
   WORD currBlock;
   WORD recordSize;
   DWORD fileSize;
   WORD lwDate;
   WORD lwTime;
   BYTE res[8];
   BYTE currRec;
   DWORD recNo;
};

/* seek strategys, used by the seek function */
enum {
  seek_set, seek_cur, seek_end
};
