#!/bin/bash
#
# dodiff.sh
# Written by Richard Dawe <richdawe@bigfoot.com> 2002-04-13
#
# Generate a diff between unpatched and patched sources, with the ability
# to cope with renamed & added files.
#
# This version is for the port of Fileutils 4.1 to DJGPP.
#

SRCDIR=/dev/c/develop/ports/orig/fileutils-4.1
DSTDIR=/dev/c/develop/ports/gnu.dev/filutil4.1-rel

# Files that have the same name under $srcdir as $dstdir
NORMAL=" \
configure.in \
configure \
Makefile.am \
Makefile.in \
Makefile.maint \
aclocal.m4 \
doc/Makefile.in \
doc/fileutils.info \
m4/libintl.m4 \
lib/Makefile.am \
lib/Makefile.in \
lib/addext.c \
lib/backupfile.c \
lib/basename.c \
lib/dirname.c \
lib/euidaccess.c \
lib/getdate.c \
lib/getdate.y \
lib/lchown.h \
lib/makepath.c \
lib/path-concat.c \
lib/stripslash.c \
lib/userspec.c \
lib/xstat.in \
m4/Makefile.in \
man/Makefile.in \
man/Makefile.maint \
man/help2man \
src/Makefile.am \
src/Makefile.in \
src/chgrp.c \
src/copy.c \
src/cp.c \
src/dd.c \
src/df.c \
src/dircolors.c \
src/du.c \
src/install.c \
src/ln.c \
src/ls.c \
src/mv.c \
src/remove.c \
src/rm.c \
src/sys2.h \
tests/Makefile.am \
tests/Makefile.in \
tests/chgrp/Makefile.am \
tests/chgrp/Makefile.in \
tests/chmod/Makefile.am \
tests/chmod/Makefile.in \
tests/cp/Makefile.am \
tests/cp/Makefile.in \
tests/cp/backup-is-src \
tests/cp/fail-perm \
tests/cp/into-self \
tests/cp/same-file \
tests/dd/Makefile.am \
tests/dd/Makefile.in \
tests/dircolors/Makefile.am \
tests/dircolors/Makefile.in \
tests/du/Makefile.am \
tests/du/Makefile.in \
tests/install/Makefile.am \
tests/install/Makefile.in \
tests/install/basic-1 \
tests/ln/Makefile.am \
tests/ln/Makefile.in \
tests/ls/Makefile.am \
tests/ls/Makefile.in \
tests/ls/time-1 \
tests/ls-2/Makefile.am \
tests/ls-2/Makefile.in \
tests/mkdir/Makefile.am \
tests/mkdir/Makefile.in \
tests/mv/Makefile.am \
tests/mv/Makefile.in \
tests/mv/backup-is-src \
tests/mv/diag \
tests/mv/force \
tests/mv/i-2 \
tests/mv/mv-special-1 \
tests/mv/part-symlink \
tests/rm/Makefile.am \
tests/rm/Makefile.in \
tests/rmdir/Makefile.am \
tests/rmdir/Makefile.in \
tests/setgid-check \
tests/shred/Makefile.am \
tests/shred/Makefile.in \
tests/touch/Makefile.am \
tests/touch/Makefile.in \
tests/touch/no-rights"

# Files that have been renamed in $dstdir compared with $srcdir
# Syntax: <old-name>:<new-name>
RENAMED=" \
.kludge-stamp:_kludge-stamp \
.prev-version:_prev-version \
ChangeLog-1997:ChangeLog.97 \
config.h.in:config.h-in \
intl/po2tbl.sed.in:intl/po2tbl-sed.in \
m4/Makefile.am.in:m4/Makefile.am-in \
m4/jm-winsz1.m4:m4/jm-wnsz1.m4 \
m4/jm-winsz2.m4:m4/jm-wnsz2.m4 \
tests/.env-warn:tests/env-warn.txt \
tests/mv/into-self:tests/mv/to-self \
tests/mv/into-self-2:tests/mv/to-self2 \
tests/mv/into-self-3:tests/mv/to-self3 \
tests/mv/into-self-4:tests/mv/to-self4 \
tests/cp/no-deref-link1:tests/cp/nderefl1 \
tests/cp/no-deref-link2:tests/cp/nderefl2 \
tests/cp/no-deref-link3:tests/cp/nderefl3 \
tests/dd/skip-seek:tests/dd/skpseek \
tests/dd/skip-seek2:tests/dd/skpseek2"

# Files that are new in $dstdir
NEW=" \
src/djstart.c \
src/djutils.c \
src/ls-msdos.c"

# Parse command-line args
test=0

while [ $# > 0 ]; do
    # Test mode?
    if [ "$1" = "-n" ]; then
	test=1
	shift
	continue
    # Trace mode?
    elif [ "$1" = "-t" ]; then
	set -x
	shift
	continue
    # Assume the other options are for diff
    else
	break
    fi
done

DIFFOPTS="$@"
DIFF="diff $DIFFOPTS"

# Check that source directories exist
if [ ! -d $SRCDIR ]; then
    echo ERROR: $SRCDIR is not a directory
    exit 1
fi

if [ ! -d $DSTDIR ]; then
    echo ERROR: $DSTDIR is not a directory
    exit 1
fi

# Failure status for existence checks
failed=0

# Check that normal files exist
for i in $NORMAL; do
    if [ ! -r $SRCDIR/$i ]; then
	echo MISSING: $SRCDIR/$i
	failed=1
    fi

    if [ ! -r $DSTDIR/$i ]; then
	echo MISSING: $DSTDIR/$i
	failed=1
    fi
done

# Check that renamed files exist
for i in $RENAMED; do
    origname=`echo $i | cut -d : -f 1`
    newname=`echo $i | cut -d : -f 2`

    if [ ! -r $SRCDIR/$origname ]; then
	echo MISSING: $SRCDIR/$origname
	failed=1
    fi

    if [ ! -r $DSTDIR/$newname ]; then
	echo MISSING: $DSTDIR/$newname
	failed=1
    fi
done

# Check that new files exist
for i in $NEW; do
    if [ ! -r $DSTDIR/$i ]; then
	echo MISSING: $DSTDIR/$i
	failed=1
    fi
done

if [ "a$failed" != "a0" ]; then
    echo Files missing - aborting
    exit 1
fi

if [ "a$test" != "a0" ]; then
    echo Running in test mode - exiting
    exit 0
fi

# Diff the normal files
for i in $NORMAL; do
    $DIFF $SRCDIR/$i $DSTDIR/$i
done

# Diff the renamed files
for i in $RENAMED; do
    origname=`echo $i | cut -d : -f 1`
    newname=`echo $i | cut -d : -f 2`

    $DIFF $SRCDIR/$origname $DSTDIR/$newname
done

# Diff the new files
for i in $NEW; do
    $DIFF /dev/null $DSTDIR/$i
done
