This is wget.info, produced by makeinfo version 4.1 from ./wget.texi.

INFO-DIR-SECTION Net Utilities
INFO-DIR-SECTION World Wide Web
START-INFO-DIR-ENTRY
* Wget: (wget).         The non-interactive network downloader.
END-INFO-DIR-ENTRY

   This file documents the the GNU Wget utility for downloading network
data.

   Copyright (C) 1996, 1997, 1998, 2000, 2001 Free Software Foundation,
Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being "GNU General Public License" and "GNU Free
Documentation License", with no Front-Cover Texts, and with no
Back-Cover Texts.  A copy of the license is included in the section
entitled "GNU Free Documentation License".


File: wget.info,  Node: Portability,  Next: Signals,  Prev: Reporting Bugs,  Up: Various

Portability
===========

   Since Wget uses GNU Autoconf for building and configuring, and avoids
using "special" ultra-mega-cool features of any particular Unix, it
should compile (and work) on all common Unix flavors.

   Various Wget versions have been compiled and tested under many kinds
of Unix systems, including Solaris, Linux, SunOS, OSF (aka Digital
Unix), Ultrix, *BSD, IRIX, and others; refer to the file `MACHINES' in
the distribution directory for a comprehensive list.  If you compile it
on an architecture not listed there, please let me know so I can update
it.

   Wget should also compile on the other Unix systems, not listed in
`MACHINES'.  If it doesn't, please let me know.

   Thanks to kind contributors, this version of Wget compiles and works
on Microsoft Windows 95 and Windows NT platforms.  It has been compiled
successfully using MS Visual C++ 4.0, Watcom, and Borland C compilers,
with Winsock as networking software.  Naturally, it is crippled of some
features available on Unix, but it should work as a substitute for
people stuck with Windows.  Note that the Windows port is *neither
tested nor maintained* by me--all questions and problems should be
reported to Wget mailing list at <wget@sunsite.dk> where the
maintainers will look at them.


File: wget.info,  Node: Signals,  Prev: Portability,  Up: Various

Signals
=======

   Since the purpose of Wget is background work, it catches the hangup
signal (`SIGHUP') and ignores it.  If the output was on standard
output, it will be redirected to a file named `wget-log'.  Otherwise,
`SIGHUP' is ignored.  This is convenient when you wish to redirect the
output of Wget after having started it.

     $ wget http://www.ifi.uio.no/~larsi/gnus.tar.gz &
     $ kill -HUP %%     # Redirect the output to wget-log

   Other than that, Wget will not try to interfere with signals in any
way.  `C-c', `kill -TERM' and `kill -KILL' should kill it alike.


File: wget.info,  Node: Appendices,  Next: Copying,  Prev: Various,  Up: Top

Appendices
**********

   This chapter contains some references I consider useful.

* Menu:

* Robot Exclusion::         Wget's support for RES.
* Security Considerations:: Security with Wget.
* Contributors::            People who helped.


File: wget.info,  Node: Robot Exclusion,  Next: Security Considerations,  Prev: Appendices,  Up: Appendices

Robot Exclusion
===============

   It is extremely easy to make Wget wander aimlessly around a web site,
sucking all the available data in progress.  `wget -r SITE', and you're
set.  Great?  Not for the server admin.

   As long as Wget is only retrieving static pages, and doing it at a
reasonable rate (see the `--wait' option), there's not much of a
problem.  The trouble is that Wget can't tell the difference between the
smallest static page and the most demanding CGI.  A site I know has a
section handled by an, uh, "bitchin'" CGI Perl script that converts
Info files to HTML on the fly.  The script is slow, but works well
enough for human users viewing an occasional Info file.  However, when
someone's recursive Wget download stumbles upon the index page that
links to all the Info files through the script, the system is brought to
its knees without providing anything useful to the downloader.

   To avoid this kind of accident, as well as to preserve privacy for
documents that need to be protected from well-behaved robots, the
concept of "robot exclusion" has been invented.  The idea is that the
server administrators and document authors can specify which portions
of the site they wish to protect from the robots.

   The most popular mechanism, and the de facto standard supported by
all the major robots, is the "Robots Exclusion Standard" (RES) written
by Martijn Koster et al. in 1994.  It specifies the format of a text
file containing directives that instruct the robots which URL paths to
avoid.  To be found by the robots, the specifications must be placed in
`/robots.txt' in the server root, which the robots are supposed to
download and parse.

   Although Wget is not a web robot in the strictest sense of the word,
it can downloads large parts of the site without the user's
intervention to download an individual page.  Because of that, Wget
honors RES when downloading recursively.  For instance, when you issue:

     wget -r http://www.server.com/

   First the index of `www.server.com' will be downloaded.  If Wget
finds that it wants to download more documents from that server, it will
request `http://www.server.com/robots.txt' and, if found, use it for
further downloads.  `robots.txt' is loaded only once per each server.

   Until version 1.8, Wget supported the first version of the standard,
written by Martijn Koster in 1994 and available at
<http://www.robotstxt.org/wc/norobots.html>.  As of version 1.8, Wget
has supported the additional directives specified in the internet draft
`<draft-koster-robots-00.txt>' titled "A Method for Web Robots
Control".  The draft, which has as far as I know never made to an RFC,
is available at <http://www.robotstxt.org/wc/norobots-rfc.txt>.

   This manual no longer includes the text of the Robot Exclusion
Standard.

   The second, less known mechanism, enables the author of an individual
document to specify whether they want the links from the file to be
followed by a robot.  This is achieved using the `META' tag, like this:

     <meta name="robots" content="nofollow">

   This is explained in some detail at
<http://www.robotstxt.org/wc/meta-user.html>.  Wget supports this
method of robot exclusion in addition to the usual `/robots.txt'
exclusion.

   If you know what you are doing and really really wish to turn off the
robot exclusion, set the `robots' variable to `off' in your `.wgetrc'.
You can achieve the same effect from the command line using the `-e'
switch, e.g. `wget -e robots=off URL...'.


File: wget.info,  Node: Security Considerations,  Next: Contributors,  Prev: Robot Exclusion,  Up: Appendices

Security Considerations
=======================

   When using Wget, you must be aware that it sends unencrypted
passwords through the network, which may present a security problem.
Here are the main issues, and some solutions.

  1. The passwords on the command line are visible using `ps'.  The
     best way around it is to use `wget -i -' and feed the URLs to
     Wget's standard input, each on a separate line, terminated by
     `C-d'.  Another workaround is to use `.netrc' to store passwords;
     however, storing unencrypted passwords is also considered a
     security risk.

  2. Using the insecure "basic" authentication scheme, unencrypted
     passwords are transmitted through the network routers and gateways.

  3. The FTP passwords are also in no way encrypted.  There is no good
     solution for this at the moment.

  4. Although the "normal" output of Wget tries to hide the passwords,
     debugging logs show them, in all forms.  This problem is avoided by
     being careful when you send debug logs (yes, even when you send
     them to me).


File: wget.info,  Node: Contributors,  Prev: Security Considerations,  Up: Appendices

Contributors
============

   GNU Wget was written by Hrvoje Niksic <hniksic@arsdigita.com>.
However, its development could never have gone as far as it has, were it
not for the help of many people, either with bug reports, feature
proposals, patches, or letters saying "Thanks!".

   Special thanks goes to the following people (no particular order):

   * Karsten Thygesen--donated system resources such as the mailing
     list, web space, and FTP space, along with a lot of time to make
     these actually work.

   * Shawn McHorse--bug reports and patches.

   * Kaveh R. Ghazi--on-the-fly `ansi2knr'-ization.  Lots of
     portability fixes.

   * Gordon Matzigkeit--`.netrc' support.

   * Zlatko Calusic, Tomislav Vujec and Drazen Kacar--feature
     suggestions and "philosophical" discussions.

   * Darko Budor--initial port to Windows.

   * Antonio Rosella--help and suggestions, plus the Italian
     translation.

   * Tomislav Petrovic, Mario Mikocevic--many bug reports and
     suggestions.

   * Francois Pinard--many thorough bug reports and discussions.

   * Karl Eichwalder--lots of help with internationalization and other
     things.

   * Junio Hamano--donated support for Opie and HTTP `Digest'
     authentication.

   * The people who provided donations for development, including Brian
     Gough.

   The following people have provided patches, bug/build reports, useful
suggestions, beta testing services, fan mail and all the other things
that make maintenance so much fun:

   Ian Abbott Tim Adam, Adrian Aichner, Martin Baehr, Dieter Baron,
Roger Beeman, Dan Berger, T. Bharath, Paul Bludov, Daniel Bodea, Mark
Boyns, John Burden, Wanderlei Cavassin, Gilles Cedoc, Tim Charron, Noel
Cragg, Kristijan Conkas, John Daily, Andrew Davison, Andrew Deryabin,
Ulrich Drepper, Marc Duponcheel, Damir Dzeko, Alan Eldridge, Aleksandar
Erkalovic, Andy Eskilsson, Christian Fraenkel, Masashi Fujita, Howard
Gayle, Marcel Gerrits, Lemble Gregory, Hans Grobler, Mathieu Guillaume,
Dan Harkless, Herold Heiko, Jochen Hein, Karl Heuer, HIROSE Masaaki,
Gregor Hoffleit, Erik Magnus Hulthen, Richard Huveneers, Jonas Jensen,
Simon Josefsson, Mario Juric, Hack Kampbjorn, Const Kaplinsky, Goran
Kezunovic, Robert Kleine, KOJIMA Haime, Fila Kolodny, Alexander
Kourakos, Martin Kraemer, Simos KSenitellis, Hrvoje Lacko, Daniel S.
Lewart, Nicolas Lichtmeier, Dave Love, Alexander V. Lukyanov, Jordan
Mendelson, Lin Zhe Min, Tim Mooney, Simon Munton, Charlie Negyesi, R.
K. Owen, Andrew Pollock, Steve Pothier, Jan Prikryl, Marin Purgar,
Csaba Raduly, Keith Refson, Tyler Riddle, Tobias Ringstrom, Juan Jose
Rodrigues, Edward J. Sabol, Heinz Salzmann, Robert Schmidt, Andreas
Schwab, Chris Seawood, Toomas Soome, Tage Stabell-Kulo, Sven
Sternberger, Markus Strasser, John Summerfield, Szakacsits Szabolcs,
Mike Thomas, Philipp Thomas, Dave Turner, Russell Vincent, Charles G
Waldman, Douglas E. Wegscheid, Jasmin Zainul, Bojan Zdrnja, Kristijan
Zimmer.

   Apologies to all who I accidentally left out, and many thanks to all
the subscribers of the Wget mailing list.


File: wget.info,  Node: Copying,  Next: Concept Index,  Prev: Appendices,  Up: Top

Copying
*******

   GNU Wget is licensed under the GNU GPL, which makes it "free
software".

   Please note that "free" in "free software" refers to liberty, not
price.  As some GNU project advocates like to point out, think of "free
speech" rather than "free beer".  The exact and legally binding
distribution terms are spelled out below; in short, you have the right
(freedom) to run and change Wget and distribute it to other people, and
even--if you want--charge money for doing either.  The important
restriction is that you have to grant your recipients the same rights
and impose the same restrictions.

   This method of licensing software is also known as "open source"
because, among other things, it makes sure that all recipients will
receive the source code along with the program, and be able to improve
it.  The GNU project prefers the term "free software" for reasons
outlined at
<http://www.gnu.org/philosophy/free-software-for-freedom.html>.

   The exact license terms are defined by this paragraph and the GNU
General Public License it refers to:

     GNU Wget is free software; you can redistribute it and/or modify it
     under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

     GNU Wget is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     A copy of the GNU General Public License is included as part of
     this manual; if you did not receive it, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   In addition to this, this manual is free in the same sense:

     Permission is granted to copy, distribute and/or modify this
     document under the terms of the GNU Free Documentation License,
     Version 1.1 or any later version published by the Free Software
     Foundation; with the Invariant Sections being "GNU General Public
     License" and "GNU Free Documentation License", with no Front-Cover
     Texts, and with no Back-Cover Texts.  A copy of the license is
     included in the section entitled "GNU Free Documentation License".

   The full texts of the GNU General Public License and of the GNU Free
Documentation License are available below.

* Menu:

* GNU General Public License::
* GNU Free Documentation License::


File: wget.info,  Node: GNU General Public License,  Next: GNU Free Documentation License,  Prev: Copying,  Up: Copying

GNU General Public License
==========================

                         Version 2, June 1991
     Copyright (C) 1989, 1991 Free Software Foundation, Inc.
     675 Mass Ave, Cambridge, MA 02139, USA
     
     Everyone is permitted to copy and distribute verbatim copies
     of this license document, but changing it is not allowed.

Preamble
========

   The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

   When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it in
new free programs; and that you know you can do these things.

   To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

   For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

   We protect your rights with two steps: (1) copyright the software,
and (2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

   Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

   Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

   The precise terms and conditions for copying, distribution and
modification follow.

    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
  1. This License applies to any program or other work which contains a
     notice placed by the copyright holder saying it may be distributed
     under the terms of this General Public License.  The "Program",
     below, refers to any such program or work, and a "work based on
     the Program" means either the Program or any derivative work under
     copyright law: that is to say, a work containing the Program or a
     portion of it, either verbatim or with modifications and/or
     translated into another language.  (Hereinafter, translation is
     included without limitation in the term "modification".)  Each
     licensee is addressed as "you".

     Activities other than copying, distribution and modification are
     not covered by this License; they are outside its scope.  The act
     of running the Program is not restricted, and the output from the
     Program is covered only if its contents constitute a work based on
     the Program (independent of having been made by running the
     Program).  Whether that is true depends on what the Program does.

  2. You may copy and distribute verbatim copies of the Program's
     source code as you receive it, in any medium, provided that you
     conspicuously and appropriately publish on each copy an appropriate
     copyright notice and disclaimer of warranty; keep intact all the
     notices that refer to this License and to the absence of any
     warranty; and give any other recipients of the Program a copy of
     this License along with the Program.

     You may charge a fee for the physical act of transferring a copy,
     and you may at your option offer warranty protection in exchange
     for a fee.

  3. You may modify your copy or copies of the Program or any portion
     of it, thus forming a work based on the Program, and copy and
     distribute such modifications or work under the terms of Section 1
     above, provided that you also meet all of these conditions:

       a. You must cause the modified files to carry prominent notices
          stating that you changed the files and the date of any change.

       b. You must cause any work that you distribute or publish, that
          in whole or in part contains or is derived from the Program
          or any part thereof, to be licensed as a whole at no charge
          to all third parties under the terms of this License.

       c. If the modified program normally reads commands interactively
          when run, you must cause it, when started running for such
          interactive use in the most ordinary way, to print or display
          an announcement including an appropriate copyright notice and
          a notice that there is no warranty (or else, saying that you
          provide a warranty) and that users may redistribute the
          program under these conditions, and telling the user how to
          view a copy of this License.  (Exception: if the Program
          itself is interactive but does not normally print such an
          announcement, your work based on the Program is not required
          to print an announcement.)

     These requirements apply to the modified work as a whole.  If
     identifiable sections of that work are not derived from the
     Program, and can be reasonably considered independent and separate
     works in themselves, then this License, and its terms, do not
     apply to those sections when you distribute them as separate
     works.  But when you distribute the same sections as part of a
     whole which is a work based on the Program, the distribution of
     the whole must be on the terms of this License, whose permissions
     for other licensees extend to the entire whole, and thus to each
     and every part regardless of who wrote it.

     Thus, it is not the intent of this section to claim rights or
     contest your rights to work written entirely by you; rather, the
     intent is to exercise the right to control the distribution of
     derivative or collective works based on the Program.

     In addition, mere aggregation of another work not based on the
     Program with the Program (or with a work based on the Program) on
     a volume of a storage or distribution medium does not bring the
     other work under the scope of this License.

  4. You may copy and distribute the Program (or a work based on it,
     under Section 2) in object code or executable form under the terms
     of Sections 1 and 2 above provided that you also do one of the
     following:

       a. Accompany it with the complete corresponding machine-readable
          source code, which must be distributed under the terms of
          Sections 1 and 2 above on a medium customarily used for
          software interchange; or,

       b. Accompany it with a written offer, valid for at least three
          years, to give any third party, for a charge no more than your
          cost of physically performing source distribution, a complete
          machine-readable copy of the corresponding source code, to be
          distributed under the terms of Sections 1 and 2 above on a
          medium customarily used for software interchange; or,

       c. Accompany it with the information you received as to the offer
          to distribute corresponding source code.  (This alternative is
          allowed only for noncommercial distribution and only if you
          received the program in object code or executable form with
          such an offer, in accord with Subsection b above.)

     The source code for a work means the preferred form of the work for
     making modifications to it.  For an executable work, complete
     source code means all the source code for all modules it contains,
     plus any associated interface definition files, plus the scripts
     used to control compilation and installation of the executable.
     However, as a special exception, the source code distributed need
     not include anything that is normally distributed (in either
     source or binary form) with the major components (compiler,
     kernel, and so on) of the operating system on which the executable
     runs, unless that component itself accompanies the executable.

     If distribution of executable or object code is made by offering
     access to copy from a designated place, then offering equivalent
     access to copy the source code from the same place counts as
     distribution of the source code, even though third parties are not
     compelled to copy the source along with the object code.

  5. You may not copy, modify, sublicense, or distribute the Program
     except as expressly provided under this License.  Any attempt
     otherwise to copy, modify, sublicense or distribute the Program is
     void, and will automatically terminate your rights under this
     License.  However, parties who have received copies, or rights,
     from you under this License will not have their licenses
     terminated so long as such parties remain in full compliance.

  6. You are not required to accept this License, since you have not
     signed it.  However, nothing else grants you permission to modify
     or distribute the Program or its derivative works.  These actions
     are prohibited by law if you do not accept this License.
     Therefore, by modifying or distributing the Program (or any work
     based on the Program), you indicate your acceptance of this
     License to do so, and all its terms and conditions for copying,
     distributing or modifying the Program or works based on it.

  7. Each time you redistribute the Program (or any work based on the
     Program), the recipient automatically receives a license from the
     original licensor to copy, distribute or modify the Program
     subject to these terms and conditions.  You may not impose any
     further restrictions on the recipients' exercise of the rights
     granted herein.  You are not responsible for enforcing compliance
     by third parties to this License.

  8. If, as a consequence of a court judgment or allegation of patent
     infringement or for any other reason (not limited to patent
     issues), conditions are imposed on you (whether by court order,
     agreement or otherwise) that contradict the conditions of this
     License, they do not excuse you from the conditions of this
     License.  If you cannot distribute so as to satisfy simultaneously
     your obligations under this License and any other pertinent
     obligations, then as a consequence you may not distribute the
     Program at all.  For example, if a patent license would not permit
     royalty-free redistribution of the Program by all those who
     receive copies directly or indirectly through you, then the only
     way you could satisfy both it and this License would be to refrain
     entirely from distribution of the Program.

     If any portion of this section is held invalid or unenforceable
     under any particular circumstance, the balance of the section is
     intended to apply and the section as a whole is intended to apply
     in other circumstances.

     It is not the purpose of this section to induce you to infringe any
     patents or other property right claims or to contest validity of
     any such claims; this section has the sole purpose of protecting
     the integrity of the free software distribution system, which is
     implemented by public license practices.  Many people have made
     generous contributions to the wide range of software distributed
     through that system in reliance on consistent application of that
     system; it is up to the author/donor to decide if he or she is
     willing to distribute software through any other system and a
     licensee cannot impose that choice.

     This section is intended to make thoroughly clear what is believed
     to be a consequence of the rest of this License.

  9. If the distribution and/or use of the Program is restricted in
     certain countries either by patents or by copyrighted interfaces,
     the original copyright holder who places the Program under this
     License may add an explicit geographical distribution limitation
     excluding those countries, so that distribution is permitted only
     in or among countries not thus excluded.  In such case, this
     License incorporates the limitation as if written in the body of
     this License.

 10. The Free Software Foundation may publish revised and/or new
     versions of the General Public License from time to time.  Such
     new versions will be similar in spirit to the present version, but
     may differ in detail to address new problems or concerns.

     Each version is given a distinguishing version number.  If the
     Program specifies a version number of this License which applies
     to it and "any later version", you have the option of following
     the terms and conditions either of that version or of any later
     version published by the Free Software Foundation.  If the Program
     does not specify a version number of this License, you may choose
     any version ever published by the Free Software Foundation.

 11. If you wish to incorporate parts of the Program into other free
     programs whose distribution conditions are different, write to the
     author to ask for permission.  For software which is copyrighted
     by the Free Software Foundation, write to the Free Software
     Foundation; we sometimes make exceptions for this.  Our decision
     will be guided by the two goals of preserving the free status of
     all derivatives of our free software and of promoting the sharing
     and reuse of software generally.

                                NO WARRANTY

 12. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
     WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
     LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
     HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
     WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
     NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
     QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
     PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
     SERVICING, REPAIR OR CORRECTION.

 13. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
     WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
     MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
     LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
     INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
     INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
     DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
     OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
     OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
     ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

                      END OF TERMS AND CONDITIONS

How to Apply These Terms to Your New Programs
=============================================

   If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these
terms.

   To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

     ONE LINE TO GIVE THE PROGRAM'S NAME AND AN IDEA OF WHAT IT DOES.
     Copyright (C) 19YY  NAME OF AUTHOR
     
     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Also add information on how to contact you by electronic and paper
mail.

   If the program is interactive, make it output a short notice like
this when it starts in an interactive mode:

     Gnomovision version 69, Copyright (C) 19YY NAME OF AUTHOR
     Gnomovision comes with ABSOLUTELY NO WARRANTY; for details
     type `show w'.  This is free software, and you are welcome
     to redistribute it under certain conditions; type `show c'
     for details.

   The hypothetical commands `show w' and `show c' should show the
appropriate parts of the General Public License.  Of course, the
commands you use may be called something other than `show w' and `show
c'; they could even be mouse-clicks or menu items--whatever suits your
program.

   You should also get your employer (if you work as a programmer) or
your school, if any, to sign a "copyright disclaimer" for the program,
if necessary.  Here is a sample; alter the names:

     Yoyodyne, Inc., hereby disclaims all copyright
     interest in the program `Gnomovision'
     (which makes passes at compilers) written
     by James Hacker.
     
     SIGNATURE OF TY COON, 1 April 1989
     Ty Coon, President of Vice

   This General Public License does not permit incorporating your
program into proprietary programs.  If your program is a subroutine
library, you may consider it more useful to permit linking proprietary
applications with the library.  If this is what you want to do, use the
GNU Library General Public License instead of this License.

