#INCLUDE ONCE "vbcompat.bi"      ' Needed to use the 'FileExists' function

DECLARE FUNCTION GetCSV(RawCSV AS STRING, n AS INTEGER) AS STRING
DECLARE FUNCTION SpaceToNbsp(InString AS STRING) AS STRING

DIM SHARED ShortMonths(1 TO 12) AS STRING*3 => {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}
DIM AS STRING LineBuff, PkgFile, PkgTitle, PkgVer, PkgDate, PkgDesc


IF FileExists("fdupdate.tab") = 0 THEN PRINT "fdupdate.tab not in current directory.": END(1)

OPEN "fdupdate.tab" FOR INPUT AS #1
OPEN "index.htm" FOR OUTPUT AS #2

PRINT #2, "<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.01 Transitional//EN"">"
PRINT #2, "<html>"
PRINT #2, "<head>"
PRINT #2, "  <title>FreeDOS update server</title>"
PRINT #2, "  <meta name=""Description"" content=""FreeDOS latest packages"">"
PRINT #2, "  <meta http-equiv=""content-type"" content=""text/html; charset=UTF-8"">"
PRINT #2, "  <meta http-equiv=""Content-Language"" content=""en-us"">"
PRINT #2, "  <meta name=""Author"" content=""Mateusz Viste"">"
PRINT #2, "</head>"
PRINT #2, "<body bgcolor=""#E0F0FF"" text=""#000000"" link=""#0000FF"" vlink=""#0000A0"" alink=""#0000A0"">"
PRINT #2, "<br>"
PRINT #2, "<p align=""center""><big><big><b>Welcome to the FreeDOS update server</b></big></big><small><small><br>"
PRINT #2, "<font style=""color: #505050;"">Last generated: "; DAY(NOW); " "; ShortMonths(MONTH(NOW)); " "; YEAR(NOW); "</font></small></small></p>"
PRINT #2, "<br>"
PRINT #2, "<p align=""justify"">This is the main (and only) page of the FreeDOS Update Server. You will find below the listing of all available <a href=""http://www.freedos.org"" style=""text-decoration: none;"">FreeDOS</a> packages in their (presumably) most up to date versions (there are some third-party tools, too). The easiest way of installing them is using the <a href=""fdupdatx.zip"" style=""text-decoration: none;"">FreeDOS Updater</a>. Of course, you can install them manually if you wish.<br>"
PRINT #2, "<br>"
PRINT #2, "Are you the author/maintainer of one of the listed software? If so, please check if my repository contains the latest available version, and send me the latest version of your program. That will greatly help me maintaining the repository up to date.<br>"
PRINT #2, "<br>"
PRINT #2, "I'm working on the FreeDOS update repository in my free time. If you would like to give me a hand, you could check out the <a href=""wip"" style=""text-decoration: none;"">work-in-progress queue</a> to verify and/or repackage some files.</p>"
PRINT #2, "<p align=""right""><a href=""http://www.viste-family.net/mateusz/grumpy/""><img src=""poweredbygrumpy.png"" border=""0""></a></p>"

PRINT #2, "<table width=""100%"" border=""1"" cellspacing=""0"" cellpadding=""5"">"
PRINT #2, "  <tr>"
PRINT #2, "    <td><b>Package name</b></td>"
PRINT #2, "    <td><b>Entered date</b></td>"
PRINT #2, "    <td><b>Description</b></td>"
PRINT #2, "  </tr>"

DO

  LINE INPUT #1, LineBuff
  PkgFile = GetCSV(LineBuff, 1)
  PkgTitle = SpaceToNbsp(GetCSV(LineBuff, 2))
  PkgVer = SpaceToNbsp(GetCSV(LineBuff, 3))
  PkgDate = SpaceToNbsp(GetCSV(LineBuff, 4))
  PkgDesc = GetCSV(LineBuff, 5)

  IF FileExists(PkgFile + ".zip") = 0 THEN PRINT "WARNING! "; PkgFile; ".zip does not exist!"

  IF LEN(PkgDate) = 0 THEN PkgDate = "&nbsp;"

  PRINT #2, "  <tr>"
  PRINT #2, "    <td align=""left""><a href="; CHR(34); PkgFile; ".zip"; CHR(34); ">"; PkgTitle; "&nbsp;"; PkgVer; "</a></td>"
  PRINT #2, "    <td align=""left"">"; PkgDate; "</td>"
  PRINT #2, "    <td align=""justify"">"; PkgDesc; "</td>"
  PRINT #2, "  </tr>"

LOOP UNTIL EOF(1)

PRINT #2, "</table>"
PRINT #2, "<p align=""right""><small>[EOF]</small></p>"
PRINT #2, "</body>"
PRINT #2, "</html>"

CLOSE #1
CLOSE #2


REM *** END OF THE MAIN PROGRAM ***


FUNCTION GetCSV(RawCSV AS STRING,n AS INTEGER) AS STRING
    ' GetCSV analizes a string in CSV format (comma or tab delimited), and
    ' returns the value of the n-th field. If the field doesn't exist, it
    ' returns a null string.
    DIM AS STRING FieldValue
    DIM AS INTEGER Counter, CommaPos, ValueLen
    CommaPos = 0
    FOR Counter = 1 TO n - 1
      DO
        CommaPos += 1
      LOOP UNTIL MID(RawCSV, CommaPos, 1) = CHR(9) OR CommaPos = LEN(RawCSV)
    NEXT Counter
    ValueLen = -1
    DO
        ValueLen += 1
    LOOP UNTIL MID(RawCSV, CommaPos + ValueLen + 1, 1) = CHR(9) OR CommaPos + ValueLen = LEN(RawCSV)
    FieldValue = MID(RawCSV, CommaPos + 1, ValueLen)
    RETURN FieldValue
END FUNCTION


FUNCTION SpaceToNbsp(InString AS STRING) AS STRING
  DIM AS INTEGER x
  DIM AS STRING Wynik
  Wynik = InString
  DO
    x = INSTR(Wynik, " ")
    IF x > 0 THEN Wynik = MID(Wynik, 1, x - 1) + "&nbsp;" + MID(Wynik, x + 1)
  LOOP UNTIL x = 0
  RETURN Wynik
END FUNCTION
