/*
 * KEYMAP.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <dos.h>
#include <conio.h>
#include <dialog.h>

#define A_MAIN		0x1E
#define A_BOLD	   	0x00
#define A_INFO	  	0x1B
#define A_LINE	   	0x17

#define YPOS		3
#define XPOS		60

char *	cp_keymap[];
ROBJ *	IDD_Keymap;

int _getkey(void);
void putmain(void);
void putdata(int, int);

int main(void)
{
	int 	key;
	int 	scan;
	int 	old;
	int 	end;
	COBJ 	cr;
	DOBJ *	dialog;

	end = 0;
	if ((dialog = rsopen(IDD_Keymap)) == 0)
		return 1;

	getcursor(&cr);
	tdshow(dialog);
	putmain();
	putdata(ESC, 0x7E);
	mouseinit();
	mouseon();
	cursoroff();
	do {
		key = _getkey();
		scan = _DL;
		if (key || old != scan) {
			putdata(key, scan);
			old = scan;
			if (key == ENTER && end)
				break;
			if (key == ESC) {
				if (end) {
					break;
				} else {
					pbuttset(63, 22, 10);
					end = 1;
				}
			} else if (key) {
				pbuttclr(63, 22, 10);
				end = 0;
			}
		}

		if (mousep()) {
			int mx = mousex();
			int my = mousey();

			if (my == 22) {
				if (INRANGE(mx, 63, 73)) {
					pbuttms(63, 22, 10);
					break;
				}
			}
			if (mousep() == 1)
				scputs(4, 23, A_INFO, 0, cp_keymap[0x7D]);
			else if (mousep() == 2)
				scputs(4, 23, A_INFO, 0, cp_keymap[0x7E]);
			else
				scputs(4, 23, A_INFO, 0, cp_keymap[0x7F]);
			while (mousep());
			scputc(4, 23, A_INFO, 24, ' ');
		}
	} while (1);

	mouseoff();
	tdclose(dialog);
	setcursor(cr);
	return 0;
}

void putmain(void)
{
	int i;

	scputs(6, 4, A_BOLD, 0, "Shift status word at [0040:0017]:");
	for (i = 0; i < 16; i++)
		scbox(59 - i, 3, 4 + i, 3 + i, 0, A_BOLD);
	scputc(43, 3, A_LINE, 29, ' ');
	scputc(43, 4, A_LINE, 29, ' ');
	scputf(44, 4, A_INFO, 0, "%lb", *(unsigned far *)shift);
	scputs(62, 5, 0, 0,	" ShiftRight\n"
				" ShiftLeft\n"
				" Ctrl\n"
				" Alt\n"
				" ScrollLock\n"
				" NumLock\n"
				" CapsLock\n"
				" InsertState\n"
				" CtrlLeft\n"
				" AltLeft\n"
				" Unused ?\n"
				" CtrlNumKey\n"
				" ScrollKey\n"
				" NumKey\n"
				" CapsKey\n"
				" InsertKey");
	scputs(6,  6, 0, 0, 	"Current keypress:\n"
				"Description:");
	scputs(6, 10, 0, 0, 	"BIOS scan code:\n"
				"ASCII character:\n"
				"Description:");
	scputs( 6, 14, 0, 0,	"Keyboard circular buffer");
	scputs( 8, 15, 0, 0,	"ASCII character:");
	scputs(10, 16, 0, 0,	"[0040:001E]\n"
				"[0040:0026]\n"
				"[0040:002E]\n"
				"[0040:0036]");
    scputs(6, 21, 0, 0, "First free:");
    scputs(6, 22, 0, 0, "Next char:");
}

void putdata(int key, int scan)
{
	int i;
	int id;

	unsigned far *bp = (unsigned far *)0x0040001E;
	unsigned far *fp = (unsigned far *)0x0000041C;
	unsigned far *np = (unsigned far *)0x0000041A;

	scputf(44, 4, A_INFO, 0, "%lb", *(unsigned far *)shift);

	scputf(24, 6, A_INFO, 0, "%d (%02Xh)   ",  scan,  scan);
	scputc(24, 7, A_INFO, 20, ' ');
	scputc(24, 8, A_INFO, 20, ' ');

	if (scan & 0x80) {
		scputf(60 - 36, 3 + 4, A_INFO, 0, "%s\n - released",
			cp_keymap[scan & 0x7F]);
	} else {
		scputs(60 - 36, 3 + 4, A_INFO, 20, cp_keymap[scan & 0x7F]);
	}
	if (key != 0) {
		scputf(24, 10, A_INFO, 0, "%d (%02Xh)  ", scan, scan);//key >> 8, key >> 8);
		scputc(24, 11, A_INFO, 1, key);
		scputc(24, 12, A_INFO, 20, ' ');
		scputs(24, 12, A_INFO, 20, cp_keymap[scan & 0x7F]);
	}
	id = 0;
	for (i = 0; i < 4; i++) {
		scputc(25 + i, 15, A_INFO, 1, bp[i +  0]);
		scputc(29 + i, 15, A_INFO, 1, bp[i +  4]);
		scputc(33 + i, 15, A_INFO, 1, bp[i +  8]);
		scputc(37 + i, 15, A_INFO, 1, bp[i + 12]);

		scputf(22, 16 + i, A_INFO, 0, "%04X", bp[id++]);
		scputf(27, 16 + i, A_INFO, 0, "%04X", bp[id++]);
		scputf(32, 16 + i, A_INFO, 0, "%04X", bp[id++]);
		scputf(37, 16 + i, A_INFO, 0, "%04X", bp[id++]);
	}
	scputf(22, 21, A_INFO, 0, "%04X", *fp);
	scputf(22, 22, A_INFO, 0, "%04X (%04X)", *np, *(unsigned*)(MK_FP(0x0040, *np)));
}

char *cp_keymap[0xFF] = {

    "kbd buffer full",	    	/* 00 - 0F */
    "Esc",
    "1 !",
    "2 @ [\"]",
    "3 #",
    "4 $",
    "5 %",
    "6 ^ [6 &]",
    "7 & [7 /]",
    "8 * [8 (]",
    "9 ( [9 )]",
    "0 ) [0 =]",
    "- _ [+ ?]",
    "= + [\\ `]",
    "Backspace",
    "Tab",

    "q Q",                	/* 10 - 1F */
    "w W",
    "e E",
    "r R",
    "t T",
    "y Y",
    "u U",
    "i I",
    "o O",
    "p P",
    "[ { [ ]",
    "] } [~ ]",
    "Enter",
    "Ctrl",
    "a A",
    "s S",

    "d D",                        /* 20 - 2F */
    "f F",
    "g G",
    "h H",
    "j J",
    "k K",
    "l L",
    "; : [ ]",
    "' \" [ ]",
    "` ~ []",
    "Left Shift",
    "+ | [' *]",
    "z Z",
    "x X",
    "c C",
    "v V",

    "b B",                        /* 30 - 3F */
    "n N",
    "m M",
    ", < [, ;]",
    ". > [. :]",
    "/ ? [- _]",
    "Right Shift",
    "Grey*",
    "Alt",
    "SpaceBar",
    "CapsLock",
    "F1",
    "F2",
    "F3",
    "F4",
    "F5",

    "F6",                       /* 40 - 4F */
    "F7",
    "F8",
    "F9",
    "F10",
    "NumLock",
    "ScrollLock",
    "Home",
    "UpArrow",
    "PgUp",
    "Grey-",
    "LeftArrow",
    "Keypad 5",
    "RightArrow",
    "Grey+",
    "End",

    "DownArrow",                /* 50 - 5F */
    "PgDn",
    "Insert",
    "Delete",
    "SysReq",
    "* F11",
    "left \| (102-key)",
    "F11",
    "F12",
    "* F15",
    "PA1",
    "F13 (LWin)",
    "F14 (RWin)",
    "F15 (Menu)",
    "--",
    "--",

    "--",                       /* 60 - 6F */
    "--",
    "--",
    "F16",
    "F17",
    "F18",
    "F19",
    "F20",
    "F21 (Fn) [*]",
    "F22",
    "F23",
    "F24",
    "--",
    "EraseEOF",
    "--",
    "Copy/Play",

    "--",                       /* 70 - 7F */
    "--",
    "CrSel",
    "<delta> [*]",
    "ExSel",
    "--",
    "Clear",
    "Joyst But1",
    "Joyst But2",
    "Joyst Right",
    "Joyst Left",
    "Joyst Up",
    "Joyst Down",
    "Right mouse",
    "Left mouse",
    "Center mouse",
};

/******** Resource begin Keymap *
	{ 0x481C,   1,   0, { 4, 1,73,23} },
	{ 0x0A00,   0, 'E', {59,21,10, 1} },
********* Resource data  *******************/
static int Keymap_RC[] = {
	0x0DB3,0x481C,0x0001,0x0104,0x1749,0x0A00,0x4500,0x153B,
	0x010A,0x49F0,0xF570,0x17EF,0x7070,0xF07F,0x7007,0xF010,
	0x173F,0x0AF0,0xF010,0x1703,0x16F0,0x5620,0x6C61,0x6575,
	0x2073,0x6F66,0x2072,0x656B,0x6279,0x616F,0x6472,0x7320,
	0x6163,0x206E,0x6F63,0x6564,0x07F6,0x4520,0x6373,0x7061,
	0x2065,0xDC20,0x3FF0,0xF020,0xDF0A,0x03F0,0x7020,
}; //	94 byte
ROBJ *IDD_Keymap = (ROBJ *)&Keymap_RC;
/******** Resource end   Keymap */
