;
; PANEL.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

;;; File Panels

INCLUDE		clib.inc
INCLUDE		io.inc
INCLUDE		dos.inc
INCLUDE		alloc.inc
INCLUDE		string.inc
INCLUDE		ifsmgr.inc
INCLUDE		dialog.inc
INCLUDE		dzmain.inc

		LOCALS

_DATA		SEGMENT

wspanel		DW	0
wsmaxfba	DW	MAXFBLOCK
		DD	DGROUP:config.c_apath.wp_flag
		DD	DGROUP:config.c_apath.wp_mask
		DD	DGROUP:config.c_apath.wp_path
		DD	DGROUP:config.c_apath.wp_file
		DD	DGROUP:config.c_apath.wp_arch
		DD	0

wspanelb	DW	0
wsmaxfbb	DW	MAXFBLOCK
		DD	DGROUP:config.c_bpath.wp_flag
		DD	DGROUP:config.c_bpath.wp_mask
		DD	DGROUP:config.c_bpath.wp_path
		DD	DGROUP:config.c_bpath.wp_file
		DD	DGROUP:config.c_bpath.wp_arch
		DD	0

paneldlgA	DW	(_D_CLEAR or _D_COLOR)
		DW	0
		DB	0,1,40,20
		DD	0
		DD	0

paneldlgB	DW	(_D_CLEAR or _D_COLOR)
		DW	0
		DB	40,1,40,20
		DD	0
		DD	0

spanel		DD 	DGROUP:config.c_apath.wp_flag
		DW 	0
		DW 	0
		DW 	0
		DW 	0
		DD 	DGROUP:panelcelA
		DD 	DGROUP:paneldlgA
		DD 	DGROUP:wspanel
PPROCa		PF 	0

spanelb		DD 	DGROUP:config.c_bpath.wp_flag
		DW 	0
		DW 	0
		DW 	0
		DW 	0
		DD 	DGROUP:panelcelB
		DD 	DGROUP:paneldlgB
		DD 	DGROUP:wspanelb
PPROCb		PF 	0

pxcellbuf	DW	78 dup(0)

panelcelA	DW	(_D_BACKG or _D_MYBUF)
		DB	1
		DB	1
		DB	2,2,12,1
		DD 	DGROUP:pxcellbuf
		DB	2,2,12,1

panelcelB	DW	(_D_BACKG or _D_MYBUF)
		DB	1
		DB	1
		DB	2,2,12,1
		DD 	DGROUP:pxcellbuf
		DB	2,2,12,1

cpanel		LABEL	DWORD
ocpanel		DW	OFFSET spanel
scpanel		DW	SEG DGROUP
panela		DD	DGROUP:spanel
panelb		DD	DGROUP:spanelb

cp_openmsg	DB	"open:",0
cp_pinfo0	DB	" %s ",0
cp_pinfo1	DB	" %c:\...%s ",0
cp_emptydisk	DB 	"[%c:] Empty disk",0
cp_bselected	DB 	"%s byte in %d file(s)",0

_DATA		ENDS

;;--------------------------------------------------------------------------
;; Local functions
;;--------------------------------------------------------------------------

_TEXT		SEGMENT

NPanelState:	mov	dx,ax			; AX = offset panel
		mov	bx,ax
		xor	ax,ax
		mov	bx,WORD PTR [bx.pn_dialog]
		cmp	WORD PTR [bx.dl_wp],ax
		jz	SHORT @@toend
		mov	bx,dx
		mov	bx,WORD PTR [bx.pn_wsub]
		mov	ax,WORD PTR [bx.ws_fcb]
		shr	ax,2
@@toend:	ret

		PUBLIC	PanelPutinfoIZ
		PUBLIC	PanelPutinfoAX
		PUBLIC	PanelPutitemAX

PanelPutinfoIZ:	xor	ax,ax			; SI = offset panel
		mov	[si.pn_cel_index],ax
		mov	[si.pn_fcb_index],ax
PanelPutinfoAX:	push	ax
		push	DS
		push	si
		call	panel_putinfo
		pop	ax
PanelPutitemAX:	push	DS
		push	si
		push	ax
		call	panel_putitem
		mov	ax,1
		ret

strcpyAXDX:	push	DS
		push	ax
		push	DS
		push	dx
		call	strcpy
		ret

InitPanelData:	mov	dx,OFFSET programpath
		cmp	config.c_apath.wp_path,0
		jnz	SHORT @@pb
		mov	ax,OFFSET config.c_apath.wp_path
		call	strcpyAXDX
@@pb:		cmp	config.c_bpath.wp_path,0
		jnz	SHORT @@ma
		mov	ax,OFFSET config.c_bpath.wp_path
		call	strcpyAXDX
@@ma:           mov	dx,OFFSET cp_stdmask
		cmp	config.c_apath.wp_mask,0
		jnz	SHORT @@mb
		mov	ax,OFFSET config.c_apath.wp_mask
		call	strcpyAXDX
@@mb:		cmp	config.c_bpath.wp_mask,0
		jnz	SHORT @@ifs
		mov	ax,OFFSET config.c_bpath.wp_mask
		call	strcpyAXDX
@@ifs:		cmp	_ifsmgr,0
		jnz	SHORT @@toend
		and	config.c_apath.wp_flag,(not _W_LONGNAME)
		and	config.c_bpath.wp_flag,(not _W_LONGNAME)
@@toend:	ret

_TEXT    	ENDS

;;--------------------------------------------------------------------------
;; Global Panel Functions
;;--------------------------------------------------------------------------

PPROC		init_panels
		call	InitPanelData
		cmp	dzcount,0
		jnz	SHORT @@toend
		cmp	argv_filename,0
		jz	SHORT @@toend
		push    argv_filename
		push	0
		call	access
		or	ax,ax
		jnz	SHORT @@toend
		and	cx,_A_SUBDIR
		jz	SHORT @@file
@@a:		and	config.c_lflag,(NOT _W_PANELID)
		les	bx,argv_filename
		cmp	BYTE PTR ES:[bx+1],':'
		jne	SHORT @@dir
		movzx	ax,BYTE PTR ES:[bx]
		or	al,20h
		sub	al,'a'
		push	ax
		call	chdrv
@@dir:		push    argv_filename
		call	chdir
@@path:		push	DS
		push	OFFSET config.c_apath.wp_path
		push	0
		call	fullpath
		jmp	SHORT @@toend
@@file:         push    argv_filename
		call	readword
		cmp	ax,FWID_ZIP
		je	SHORT @@zip
@@toend:	xor	ax,ax
		ret
@@zip:          and	config.c_apath.wp_flag,(NOT _W_ARCHIVE)
		and	config.c_bpath.wp_flag,(NOT _W_ARCHIVE)
		or	config.c_apath.wp_flag,(_W_VISIBLE OR _A_ZIP)
		mov	config.c_apath.wp_arch,0
		push    argv_filename
		call	strfn
		push	dx
		push	ax
		push	DS
		push	OFFSET config.c_apath.wp_file
		push	dx
		push	ax
		call	strcpy
		pop	ax
		pop	dx
		cmp	ax,WORD PTR argv_filename
		je	SHORT @@
		mov	ES,dx
		dec	ax
		mov	bx,ax
		xor	al,al
		mov	ES:[bx],al
		jmp	@@a
@@:             and	config.c_lflag,(NOT _W_PANELID)
		jmp	SHORT @@path
PEND		init_panels

PPROC		panel_state
ARG		panel:	DWORD
		mov	ax,WORD PTR panel
		call	NPanelState
		ret
PEND		panel_state

PPROC		panel_open
ARG		panel:	DWORD
LOCAL		path:	BYTE:[WMAXPATH]
		USES	si,di
		mov	si,WORD PTR panel
		push	[si.pn_wsub]
		call	wsopen
		or	ax,ax
		jz	SHORT @@toend
		mov	di,[si]
		mov     bx,[di]
		and	bx,_W_PANELID
		add	bx,bx
		mov	ax,config.c_pbindex[bx]
		mov	[si.pn_fcb_index],ax
		mov	ax,config.c_pcindex[bx]
		mov	[si.pn_cel_index],ax
		xor	ax,ax
		mov	[si.pn_cel_count],ax
		cmp	si,ocpanel
		jne	SHORT @@1
		push	[di.wp_flag]
		push	SS
		lea	ax,path
		push	ax
		push	DS
		mov	ax,di
		add	ax,wp_path
		push	ax
		call	strcpy
		mov	[di.wp_path],0
		push	[si.pn_wsub]
		call	com_setdevice
		pop	ax
		test	ax,_W_ARCHIVE
		jz	SHORT @@1
		push	ax
		push	SS
		lea	ax,path
		push	ax
		push	DS
		mov	ax,di
		add	ax,wp_path
		push	ax
		call	stricmp
		pop	dx
		or	ax,ax
		jnz	SHORT @@1
		mov	[di],dx
@@1:		test	[di.wp_flag],_W_VISIBLE
		jz	SHORT @@toend
		push    panel
		call	panel_update_fcb
		cmp	si,ocpanel
		jne	SHORT @@toend
		push    panel
		call	panel_setactive
@@toend:	mov	ax,1
		ret
PEND		panel_open

PPROC		panel_close
ARG		panel:	DWORD
		mov	ax,WORD PTR panel
		call	NPanelState
		push	ax
		push	panel
		call	prect_close
		mov	bx,WORD PTR panel
		push	[bx.pn_wsub]
		call	wsclose
@@toend:        pop	ax
		ret
PEND		panel_close

PPROC		panel_hide
ARG		panel:	DWORD
		push	panel
		call	prect_close
		push	ax
		mov	bx,WORD PTR panel
		push	[bx.pn_wsub]
		call	wsfree
		pop	ax
		ret
PEND            panel_hide

PPROC		panel_show
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		or	[bx.wp_flag],_W_VISIBLE
		push	panel
		call	panel_update_all
@@toend:	ret
PEND		panel_show

PPROC		panel_toggle
ARG		panel:	DWORD
		USES	si
		mov	ax,WORD PTR panel
		call	NPanelState
		mov	si,dx
		jz	SHORT @@open
		cmp	dx,ocpanel
		jne	SHORT @@hide
		mov	ax,OFFSET spanel
		cmp	ax,dx
		jne	SHORT @@b
		mov	ax,OFFSET spanelb
@@b:            call	NPanelState
		jz	SHORT @@cp
		push	DS
		push	dx
		call	panel_setactive
		jmp	SHORT @@hide
@@cp:		push	cpanel
		call	panel_hide
@@hide:         push	panel
		call	panel_hide
		jmp	SHORT @@toend
@@open:         push	panel
		call	panel_show
		cmp	si,ocpanel
		je	SHORT @@setactive
		mov	ax,ocpanel
		call	NPanelState
		jnz	SHORT @@toend
@@setactive:    push	panel
		call	panel_setactive
@@toend:        xor	ax,ax
		ret
PEND		panel_toggle

PPROC		panel_sethdd
USES		si,di
ARG		@@pan:	DWORD,\
		@@hdd:	WORD
		call	getdrv
		mov	di,ax
		mov	si,WORD PTR @@pan
		push	[si.pn_wsub]
		push	@@hdd
		call	_disk_init
		push	ax
		call	wschdrv
		push	@@pan
		call	panel_read
		cmp     si,ocpanel
		je	SHORT @@
		push	di
		call	chdrv
		jmp	SHORT @@END
@@:		push	[si.pn_wsub]
		call	com_setdevice
@@END:		call	PanelPutinfoIZ
		ret
PEND		panel_sethdd

PPROC		panel_read
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		push	[bx.pn_wsub]
		push	panel
		push	DS
		mov	ax,[bx]
		add	ax,wp_path
		push	ax
		call	panel_openmsg
		call	wsread
		mov	bx,WORD PTR panel
		mov	[bx.pn_fcb_count],ax
		cmp	ax,[bx.pn_fcb_index]
		ja	SHORT @@toend
		mov	dx,ax
		dec	dx
		mov	[bx.pn_fcb_index],dx
@@toend:	ret
PEND		panel_read

PPROC		panel_curobj
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		cmp	[bx.pn_wsub],0
		jz	SHORT @@null
		push	[bx.pn_wsub]
		mov	ax,[bx.pn_fcb_index]
		add	ax,[bx.pn_cel_index]
		push	ax
		call	wsfblk
@@toend:        ret
@@null:		xor	ax,ax
		mov	dx,ax
		jmp	SHORT @@toend
PEND		panel_curobj

PPROC		panel_setid
ARG		@@pan:	DWORD,\
		@@id:	WORD
		USES	si,di
		mov	bx,WORD PTR @@pan
		xor	ax,ax
		mov	[bx.pn_cel_index],ax
		mov	[bx.pn_fcb_index],ax
		push	@@pan
		call	pcell_set
		mov	bx,WORD PTR @@pan
		mov	ax,@@id
		cmp	ax,[bx.pn_cel_count]
		jnb	SHORT @@
		mov	[bx.pn_cel_index],ax
		jmp	SHORT @@toend
@@:		sub	ax,[bx.pn_cel_count]
		inc	ax
		mov	[bx.pn_fcb_index],ax
		mov	ax,[bx.pn_cel_count]
		dec	ax
		mov	[bx.pn_cel_index],ax
		mov	ax,@@id
@@toend:        ret
PEND		panel_setid

PPROC		panel_ffselected
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		push	[bx.pn_wsub]
		call	wsffirst
		ret
PEND		panel_ffselected

PPROC		panel_setactive
ARG		panel:	DWORD
		USES	si,di
		mov	si,WORD PTR panel
		mov	di,[si]
		and	config.c_lflag,(not _W_PANELID)
		test	[di.wp_flag],_W_PANELID
		jz	SHORT @@
		or	config.c_lflag,_W_PANELID
@@:		push	[si.pn_wsub]
		call	com_setdevice
		or	[di.wp_flag],_W_CURPATH
		cmp     si,ocpanel
		je	SHORT @@cur
		mov	bx,ocpanel
		mov	di,[bx]
		and	[di.wp_flag],(not _W_CURPATH)
		push	[bx.pn_xl]
		call	twclose
		push	cpanel
		call	panel_putinfo
		mov	ocpanel,si
@@cur:		push	panel
		call	pcell_show
		push	panel
		call	panel_putinfo
@@toend:	ret
PEND		panel_setactive

PPROC		panel_update_fcb
ARG		panel:	DWORD
USES		si
		mov	si,WORD PTR panel
		mov	bx,[si]
		mov	ax,[bx]
		and	ax,_W_VISIBLE
		jz	SHORT @@toend
		push	panel
		call	panel_read
		xor	ax,ax
		call	PanelPutinfoAX
@@toend:	ret
PEND		panel_update_fcb

PPROC		panel_update_rect
ARG		panel:	DWORD
		USES	si
		mov	si,WORD PTR panel
		mov	bx,[si]
		mov	ax,[bx]
		and	ax,_W_VISIBLE
		jz	SHORT @@toend
		push	panel
		call	prect_open
		xor	ax,ax
		call	PanelPutinfoAX
		cmp     si,ocpanel
		jne	SHORT @@
		push	panel
		call	pcell_show
@@:		mov	ax,1
@@toend:	ret
PEND		panel_update_rect

PPROC		panel_update_all
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		mov	ax,[bx]
		and	ax,_W_VISIBLE
		jz	SHORT @@toend
		push	panel
		call	panel_read
		push	panel
		call	panel_update_rect
@@toend:	ret
PEND		panel_update_all

PPROC		panel_clr
ARG		rect:	DWORD,\
		flag:	WORD
		USES	si,di
		cmp	flag,CLP_DONOTHING
		jnb	SHORT @@toend
		call	__mshide
		cmp	flag,CLP_CLEARW
		je	SHORT @@2
		mov	dx,03DAh
@@0:		in	al,dx
		and	al,8
		jz	SHORT @@0
@@1:		in	al,dx
		and	al,8
		jnz	SHORT @@1
@@2:		inc	rect.rc_x
		add	rect.rc_y,2
		sub     rect.rc_col,2
		sub     rect.rc_row,3
		xor	ax,ax
		mov	al,rect.rc_x
		mov	dx,ax
		mov	al,rect.rc_y
		call	__xytoesbx
		mov     di,ax
		xor	ax,ax
		mov	al,rect.rc_row
		mov	bx,ax
		mov	al,rect.rc_col
		mov	dx,ax
		cld
		mov	si,di
		mov	cx,dx
		cmp	flag,CLP_MOVEUP
		jl	SHORT @@clear
		je	SHORT @@next
		dec	bx
		jz	SHORT @@clear
		mov	ax,bx
		mov	ah,160
		mul	ah
		add	si,ax
		mov	di,si
@@down:		mov	ax,ES:[di-160]
		stosw
		dec	cx
		jnz	SHORT @@down
		mov	cx,dx
		sub	si,160
		mov	di,si
		dec	bx
		jnz	SHORT @@down
		mov	bx,1
		jmp	SHORT @@clear
@@toend:	ret
@@next:		dec	bx
		jz	SHORT @@clear
@@up:		mov	ax,ES:[di+160]
		stosw
		dec	cx
		jnz	SHORT @@up
		mov	cx,dx
		add	si,160
		mov	di,si
		dec	bx
		jnz	SHORT @@up
		mov	bx,1
@@clear:	mov	ax,ES:[di]
		cmp	al,''
		je	SHORT @@nextch
		mov	al,' '
		mov	ES:[di],ax
@@nextch:	add	di,2
		dec	cx
		jnz	SHORT @@clear
		add	si,160
		mov	di,si
		mov	cx,dx
		or	bx,bx
		jz	SHORT @@mouse
		dec	bx
		jnz	SHORT @@clear
@@mouse:	call	__msshow
		jmp	SHORT @@toend
PEND		panel_clr

PPROC		panel_putitem
ARG		@@pan:	DWORD,\
		@@clr:	WORD
LOCAL		@@rc:	DWORD,\
		@@xl:	WORD,\
		@@id:	WORD
		USES	si,di
		mov	si,WORD PTR @@pan
		mov	bx,WORD PTR [si.pn_dialog]
		mov	eax,[bx.dl_rect]
		mov	@@rc,eax
		mov	bx,[si]
		test	[bx.wp_flag],_W_MINISTATUS
		jz	SHORT @@
		sub	[@@rc.rc_row],2
		test	[bx.wp_flag],_W_DRVINFO
		jz	SHORT @@
		sub	[@@rc.rc_row],3
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@
		inc	[@@rc.rc_row]
@@:             xor	ax,ax
		cmp	ax,[si.pn_fcb_count]
		jz	SHORT @@clear
		push	[si.pn_xl]
		call	twclose
		mov	@@xl,ax
		push	@@pan
		call	pcell_set
		push	@@rc
		push	@@clr
		call	panel_clr
		mov	bx,WORD PTR [si.pn_dialog]
		xor	ax,ax
		mov	@@id,ax
		movzx	di,[bx.dl_rect.rc_y]
		jmp	SHORT @@start
@@next:         inc	@@id
		mov	ax,@@id
@@start:	cmp	ax,[si.pn_cel_count]
		jnb	SHORT @@END
		push	[si.pn_xl]
		push	@@id
		call	xl_getrect
		cmp	@@clr,CLP_MOVEUP
		je	SHORT @@MOVEUP
		cmp	@@clr,CLP_MOVEDN
		je	SHORT @@MOVEDN
@@default:	mov	bx,WORD PTR [si.pn_wsub]
		les	bx,[bx.ws_fcb]
		mov	dx,[si.pn_fcb_index]
		add	dx,@@id
		shl	dx,2
		add	bx,dx
		push	DWORD PTR ES:[bx]
		xor	dx,dx
		mov	dl,al
		push	dx
		mov	dl,ah
		push	dx
		call	[si.pn_putfcb]
		jmp	SHORT @@next
@@clear:	push	@@rc
		push	CLP_CLEARW
		call	panel_clr
		jmp	SHORT @@ret
@@MOVEUP:	mov	bx,WORD PTR [si.pn_xl]
		mov	dx,di
		add	dl,[bx.xl_rows]
		inc	dl
		cmp	ah,dl
		je	SHORT @@default
		jmp	SHORT @@next
@@MOVEDN:	mov	dx,di
		add	dx,2
		cmp	ah,dl
		je	SHORT @@default
		jmp	SHORT @@next
@@END:		cmp	@@xl,0
		jz	SHORT @@mini
		push	@@pan
		call	pcell_show
@@mini:		push	@@pan
		call	panel_putmini
@@ret:		ret
PEND		panel_putitem

PPROC		panel_numselected
ARG		panel:	DWORD
USES		DS,si
		mov	bx,WORD PTR panel
		xor	ax,ax
		mov	cx,[bx.pn_fcb_count]
		or	cx,cx
		jz	SHORT @@toend
		les	bx,[bx.pn_wsub]
		lds	si,[bx.ws_fcb]
		or	si,si
		jz	SHORT @@toend
@@next:         les	bx,[si]
		test	ES:[bx.fb_flag],_A_SELECTED
		jz	SHORT @@
		inc	ax
@@:		add	si,4
@@loop:         dec	cx
		jnz	SHORT @@next
@@toend:	ret
PEND		panel_numselected

;;--------------------------------------------------------------------------
;; Mini Status Window
;;--------------------------------------------------------------------------

PPROC		panel_togglemini
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		les	bx,[bx.pn_flag]
		mov	ax,ES:[bx]
		xor	ax,_W_MINISTATUS
		test	ax,_W_VISIBLE
		mov	ES:[bx],ax
		jz	SHORT @@
		push	panel
		call	panel_update_rect
@@:		call	mousep
		or	ax,ax
		jnz	SHORT @@
		xor	ax,ax
		ret
PEND		panel_togglemini

PPROC		mkbstring
ARG		@@b:	DWORD,\
		@@qh:	DWORD,\
		@@ql:	DWORD
		push	@@b
		push	@@qh
		push	@@ql
		call	qwtobstr
		push	dx
		push	ax
		call	strcpy
		mov	eax,@@qh
		mov	edx,@@ql
		or	eax,eax
		jnz	SHORT @@do
		or	edx,edx
		jz	SHORT @@toend
@@do:           shl	eax,22
		shr	edx,10
		or	eax,edx
		mov	edx,1
@@loop:		cmp	eax,10000
		jb	SHORT @@endl
		shr	eax,10
		inc	edx
		jmp	SHORT @@loop
@@endl:         mov	bx,dx
		shld	edx,eax,16
		or	dx,bx
@@toend:	ret
PEND		mkbstring

PPROC		putmini_selected
ARG		@@p:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD,\
		@@c:	WORD
LOCAL           @@b:	BYTE:[64]
		USES	si,di
		mov	bx,WORD PTR @@p
		xor	eax,eax
		mov	edx,eax
		mov	di,ax
		mov	cx,[bx.pn_fcb_count]
		or	cx,cx
		jz	SHORT @@toend
		mov	bx,WORD PTR [bx.pn_wsub]
		cmp	WORD PTR [bx.ws_fcb],0
		jz	SHORT @@toend
		push	DS
		lds	si,[bx.ws_fcb]
@@loop:         les	bx,[si]
		test	ES:[bx.fb_flag],_A_SELECTED
		jz	SHORT @@next
		inc	di
		test	ES:[bx.fb_flag],_A_SUBDIR
		jnz	SHORT @@next
		add	eax,ES:[bx.fb_size]
		jnc	SHORT @@next
		inc	edx
@@next:		add	si,4
		dec	cx
		jnz	SHORT @@loop
		pop	DS
		lea	bx,@@b
		push	di      ; num selected files
		push	SS
		push	bx      ; size selected
		push	DS      ; format
		push	OFFSET cp_bselected
		push	@@c     ; length of string
		mov	cl,at_background[B_Desktop]
		or	cl,at_foreground[F_Panel]
		push	cx	; color
		push	@@y     ; y
		mov	cx,@@x
		inc	cx
		push	cx      ; x
		push	ss
		push	bx
		push	edx
		push	eax
		call	mkbstring
		call	scputf
		add	sp,18
@@toend:	ret
PEND		putmini_selected

PPROC		panel_openmsg
ARG		@@pan:	DWORD,\
		@@str:	DWORD
		mov	ax,WORD PTR @@pan
		call	NPanelState
		jz	SHORT @@toend
		mov	bx,dx
		mov	bx,[bx]
		mov	ax,[bx]
		and	ax,_W_MINISTATUS
		jz	SHORT @@toend
		mov	bx,dx
		mov	bx,WORD PTR [bx.pn_dialog]
		movzx	ax,[bx.dl_rect.rc_x]
		movzx	dx,[bx.dl_rect.rc_y]
		movzx	cx,[bx.dl_rect.rc_col]
		add	dl,[bx.dl_rect.rc_row]
		sub	dl,2
		sub	cl,9
		add	al,7
		push	ax
		push	dx
		push	cx
		push	@@str
		sub	al,6
		push	ax
		push	dx
		push	0
		push	5
		push	DS
		push    OFFSET cp_openmsg
		push	ax
		push	dx
		add	cl,7
		push	cx
		MKAT	B_Desktop,F_System
		mov	al,' '
		push	ax
		call	scputw
		call	scputs
		call	scpath
@@toend:	ret
PEND		panel_openmsg


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_DATA		SEGMENT

db_disk		DB	?
cp_disk		DB	'C:\',0
cp_free		DB	' Free:',0Ah
cp_total	DB	'Total:',0
cp_byte		DB	'byte',0
cp_novolid	DB	'NONAME',0
cp_drvsize	DB	'%20s',0
cp_volinfo	DB	'%24s',0

_DATA		ENDS

_TEXT		SEGMENT

di_putinfo:     push	di
		push	ds
		push	OFFSET cp_free
		xor	eax,eax
		push	eax
		push	ypos
		push	xpos
		call	scputf
		mov	di,sp
		add     ss:[di.sf_x],32
		mov	ss:[di.sf_foff],OFFSET cp_byte
		call	scputf
		inc	ss:[di.sf_y]
		call	scputf
		add	sp,12
		pop	di
		ret

di_clearline:	push	ax	; xpos
		push	dx	; ypos
		push	37
		MKAT	B_Desktop,F_Panel
		mov	al,' '
		push	ax
		call	scputw
		ret

di_clear:	mov	bx,WORD PTR panel
		mov	bx,WORD PTR [bx.pn_dialog]
		movzx	ax,[bx.dl_rect.rc_y]
		add	al,[bx.dl_rect.rc_row]
		sub	al,4
@@ypos:		mov	ypos,ax
		mov	dx,ax
		mov	al,[bx.dl_rect.rc_x]
		add	ax,2
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@xpos
		add	ax,40
@@xpos:		mov	xpos,ax
		call	di_clearline
		mov	ax,xpos
		mov	dx,ypos
		inc	dx
		call	di_clearline
		mov	ax,xpos
		mov	dx,ypos
		test	config.c_lflag,_C_HORIZONTAL
		jnz	SHORT @@toend
		dec	dx
		jmp	SHORT di_clearline
@@toend:	sub	ax,40
		jmp	SHORT di_clearline

di_disk:	mov	bx,WORD PTR panel
		mov	bx,WORD PTR [bx.pn_wsub]
		mov	bx,WORD PTR [bx.ws_path]
		mov	ax,[bx]
		mov	cp_disk,al
		or	al,al
		jz	SHORT @@nodisk
		cmp	ah,':'
		jne	SHORT @@nodisk
		and	al,(not 20h)
		mov	cp_disk,al
		sub	al,'@'
		mov	db_disk,al
		ret
@@nodisk:	mov     db_disk,0FFh
		ret

di_volid:       call	di_disk
		mov	ax,xpos
		mov	dx,ypos
		dec	dx
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@xpos
		sub	ax,40
		inc	dx
@@xpos:		push	ax
		push	dx
		cmp	db_disk,0FFh
		je	SHORT @@novolid
		lea	bx,sb128
		push	ss
		push	bx
		push	ss
		push	bx
		push	_A_VOLID
		mov	ax,WORD PTR cp_disk
		mov	ss:[bx],ax
		mov	DWORD PTR ss:[bx+2],'*.*\'
		mov     BYTE PTR ss:[bx+6],0
		call	findfirst
		or	ax,ax
		jnz	SHORT @@novolid
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Files]
		push	ax
		xor	ax,ax
		push	ax
		lea	bx,sb128
		add	bx,ff_name
		mov	ss:[bx+12],al
		cmp	BYTE PTR ss:[bx+8],'.'
		jne	SHORT @@pushss
		mov	eax,ss:[bx+9]
		mov	ss:[bx+8],eax
@@pushss:	push	ss
		push	bx
		jmp	SHORT @@putvolid
@@novolid:	mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Hidden]
		push	ax
		xor	ax,ax
		push	ax
		push	ds
		push	OFFSET cp_novolid
@@putvolid:	call	scputs
		ret

di_volinfo:	push	ds
		push	OFFSET cp_disk
		push	ss
		lea	ax,sb128
		push	ax
		call	wvolinfo
		or	ax,ax
		jnz	SHORT @@toend
		push	ss
		lea	ax,sb128
		push	ax
		push	ds
		push	OFFSET cp_volinfo
		push	24
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Desktop]
		push	ax
		mov	ax,xpos
		add	ax,12
		mov	dx,ypos
		dec	dx
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@xpos
		sub	ax,40
		inc	dx
@@xpos:		push	dx
		push	ax
		call	scputf
		add	sp,16
@@toend:	ret

_TEXT		ENDS

PPROC		panel_drvinfo
ARG		panel:	DWORD
LOCAL           xpos:	WORD,\
		ypos:	WORD,\
		sb128:	BYTE:[128]
		USES	si,di
		call	di_clear
		call	di_putinfo
		call	di_volid
		call	di_volinfo
		lea	di,sb128
		xor	ax,ax
		stc
		mov	ss:[di.df_version],ax
		mov	ax,7303h
		mov	cx,SIZE s_diskfree
		mov	dx,OFFSET cp_disk
		push	ss
		pop	es
		int	21h
		jnc	SHORT @@w95
		or	al,al
		jz	SHORT @@dos
@@toend:	ret
@@w95:          mov	eax,ss:[di.df_sclus]
		mov	ebx,ss:[di.df_avail]
		mov	ecx,ss:[di.df_bsec]
		mov	edx,ss:[di.df_total]
		jmp	SHORT @@disk
@@dos:          mov	dl,db_disk
		mov	ah,36h
		int	21h
		cmp	ax,-1
		je	SHORT @@toend
		movzx	eax,ax		; EAX = sectors per cluster
		movzx	ebx,bx		; EBX = number of free clusters
		movzx	ecx,cx		; ECX = bytes per sector
		movzx	edx,dx		; EDX = total clusters on drive
@@disk:         push	eax
		push	ebx
		push	ecx
		mul	edx
		mul	ecx
		push	ss
		push	di
		push	edx
		push	eax
		call	mkbstring
		pop	ecx
		pop	ebx
		pop	eax
		mul	ebx
		mul     ecx
		push	ss
		mov	bx,di
		add	bx,20
		push	bx
		push	edx
		push	eax
		call	mkbstring
		push	ss
		mov	ax,di
		add	ax,20
		push	ax
		push	ds
		push	OFFSET cp_drvsize
		xor	ax,ax
		push	ax
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Files]
		push	ax
		push	ypos
		mov	ax,xpos
		add	ax,11
		push	ax
		call	scputf
		mov	bx,sp
		inc	ss:[bx.sf_y]
		mov	ss:[bx.sf_aoff],di
		call	scputf
		add	sp,16
		jmp	@@toend
PEND		panel_drvinfo

PPROC		panel_putmini
ARG		panel:	DWORD
LOCAL		@@fb:	DWORD,\
		@@x:	WORD
		USES	si,di
		mov	ax,WORD PTR panel
		call	NPanelState
		jz	SHORT @@toend
		mov	si,dx
		mov	bx,[si]
		mov	ax,[bx]
		test	ax,_W_MINISTATUS
		jz	SHORT @@toend
		test	ax,_W_DRVINFO
		jnz	SHORT @@drvinfo
@@nodrvinfo:	push	[si.pn_wsub]
		mov	ax,[si.pn_fcb_index]
		add	ax,[si.pn_cel_index]
		push	ax
		call	wsfblk
		mov	WORD PTR [@@fb],ax
		mov	WORD PTR [@@fb+2],dx
		mov	bx,WORD PTR [si.pn_dialog]
		mov	dx,WORD PTR [bx.dl_rect]
		mov	cx,WORD PTR [bx.dl_rect+2]
		xor	ax,ax
		mov	al,ch
		sub	al,2
		add	al,dh
		mov	di,ax
		mov	al,cl
		sub	al,2
		push	ax
		mov	bx,ax
		mov	al,dl
		inc	al
		mov	@@x,ax
		push	ax
		push	di
		push	bx
		MKAT	B_Desktop,F_Hidden
		mov	al,' '
		push	ax
		call	scputw
		pop	cx
		xor	ax,ax
		cmp	ax,[si.pn_fcb_count]
		jnz	SHORT @@selected
		mov	bx,[si]
		mov	dl,[bx.wp_path]
		push	dx
		push	DS
		push	OFFSET cp_emptydisk
		push	ax
		push	ax
		push	di
		push	@@x
		call	scputf
		add	sp,14
@@toend:	ret

@@drvinfo:	push	panel
		call	panel_drvinfo
		jmp	SHORT @@nodrvinfo

@@selected:	push	panel
		call	panel_numselected
		or	ax,ax
		jz	SHORT @@file
		push	panel
		push	@@x
		push	di
		push	cx
		call	putmini_selected
		jmp	SHORT @@toend

@@file:         push	@@fb
		push	@@x
		push	di
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@0
		cmp	_ifsmgr,0
		jz	SHORT @@0
		call	fbputld
		jmp	SHORT @@upd
@@0:		call	fbputfile

@@upd:		les	bx,@@fb
		test	ES:[bx.fb_flag],_A_UPDIR
		jz	SHORT @@toend
		push	@@x
		push	di
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_System]
		push	ax
		push	12
		mov	ax,[si]
		add	ax,wp_path
		push	DS
		push	ax
		call	strfn
		push	dx
		push	ax
		push	@@x
		push	di
		push	2
		push	' '
		call	scputw
		call	scputs
		jmp	@@toend
PEND		panel_putmini

PPROC		panel_putinfo
ARG		panel:	DWORD
LOCAL		@@path:	DWORD,\
		@@at:	WORD,\
		@@wid:	WORD,\
		@@l:	WORD,\
		@@x:	WORD,\
		@@sx:	WORD,\
		@@sy:	WORD
		USES	si,di
		mov	ax,WORD PTR panel
		call	NPanelState
		jnz	SHORT @@
		jmp	@@toend
@@:		mov	si,dx
		mov	bx,WORD PTR [si.pn_dialog]
		mov	dx,WORD PTR [bx.dl_rect]
		xor	ax,ax
		mov	al,dl
		inc	al
		mov	@@sx,ax
		mov	al,dh
		mov	@@sy,ax
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Files]
		mov	bx,[si]
		test	[bx.wp_flag],_W_CURPATH
		jz	SHORT @@0
		mov	al,at_background[B_DarkGray]
		or	al,at_foreground[F_Black]
@@0:		mov	@@at,ax
		push	DS
		add	bx,wp_path
		push	bx
		push	large 0
		call	wlongpath
		mov	WORD PTR @@path,ax
		mov	WORD PTR @@path+2,dx
		mov	bx,[si]
		test	[bx.wp_flag],_W_ARCHIVE
		jz	SHORT @@1
		push	@@path
		push	DS
		mov	ax,bx
		add	ax,wp_file
		push	ax
		push	DS
		add	bx,wp_arch
		push	bx
		call	strfcat
@@1:		mov	ax,33
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@2
		mov	ax,72
@@2:		mov	@@wid,ax
		push	@@path
		call	strlen
		mov	@@l,ax
		shr	ax,1
		mov	dx,ax
		mov	ax,@@wid
		shr	ax,1
		add	ax,@@sx
		sub	ax,dx
		inc	ax
		mov	@@x,ax
		push	@@sx
		mov	ax,@@sy
		inc	ax
		push	ax
		push	1
		mov	ah,at_background[B_Desktop]
		or	ah,at_foreground[F_Panel]
		mov	bx,[si]
		mov	al,[bx.wp_path]
		push	ax
		call	scputw
		push	@@sx
		push	@@sy
		mov	ax,@@wid
		add	ax,5
		push	ax
		mov	ah,at_background[B_Desktop]
		or	ah,at_foreground[F_Frame]
		mov	al,205
		push	ax
		call	scputw
		mov	ax,@@wid
		cmp	ax,@@l
		jae	SHORT @@3
		mov	ax,@@sx
		mov	@@x,ax
		les	bx,@@path
		mov	al,ES:[bx]
		push	ES
		add	bx,@@l
		sub	bx,@@wid
		add	bx,3
		push	bx
		push	ax
		push	DS
		push	OFFSET cp_pinfo1
		mov	di,18
		jmp	SHORT @@put
@@3:		push	@@path
		push	DS
		push	OFFSET cp_pinfo0
		mov	di,16
@@put:		push	0
		push	@@at
		push	@@sy
		push	@@x
		call	scputf
		add	sp,di
@@toend:	ret
PEND		panel_putinfo

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Current Active Panel

PPROC		cpanel_gettarget
		mov	ax,OFFSET spanel
		call	NPanelState
		jz	SHORT @@null
		mov	ax,OFFSET spanelb
		call	NPanelState
		jz	SHORT @@null
		mov	dx,DS
		mov	ax,OFFSET DGROUP:config.c_apath.wp_path
		cmp	ocpanel,OFFSET spanel
		jne	SHORT @@end
		add	ax,SIZE W_PATH
@@end:		ret
@@null:		mov	dx,ax
		jmp	SHORT @@end
PEND		cpanel_gettarget

PPROC		cpanel_findfirst
		mov	ax,ocpanel
		call	NPanelState
		jz	SHORT @@null
		push	cpanel
		call	panel_ffselected
		or	ax,ax
		jnz	SHORT @@
		push	cpanel
		call	panel_curobj
		or	ax,ax
		jz	SHORT @@null
@@:		mov	ES,dx
		mov	bx,ax
		test	ES:[bx.fb_flag],_A_UPDIR
		jz	SHORT @@end
@@null:         xor	ax,ax
		mov	dx,ax
@@end:		ret
PEND		cpanel_findfirst

PPROC		cpanel_deselect
USES		si,di
ARG		@@fb:	DWORD
		les	bx,@@fb
		and	ES:[bx.fb_flag],(not _A_SELECTED)
		mov	bx,OFFSET dl_progress
		test	[bx.dl_flag],_D_ONSCR
		jz	SHORT @@mini
		mov	al,[bx.dl_rect.rc_y]
		add	al,[bx.dl_rect.rc_row]
		mov	bx,ocpanel
		mov	bx,WORD PTR [bx.pn_dialog]
		mov	ah,[bx.dl_rect.rc_y]
		add	ah,[bx.dl_rect.rc_row]
		dec	ah
		inc	al
		cmp	al,ah
		jae	SHORT @@
@@mini:		push	cpanel
		call	panel_putmini
@@:		mov	si,OFFSET spanel
		cmp	si,ocpanel
		jne	SHORT @@a
		mov	si,OFFSET spanelb
@@a:            mov	bx,WORD PTR [si.pn_xl]
		mov	ax,[bx+2]
		imul	ah
		mov	dx,[si.pn_fcb_count]
		sub	dx,[si.pn_fcb_index]
		cmp	dx,ax
		jae	SHORT @@toend
		mov	bx,WORD PTR [si.pn_wsub]
		mov	ax,[bx.ws_maxfb]
		sub	ax,2
		cmp	ax,[bx.ws_count]
		jna	SHORT @@toend
		push	WORD PTR [@@fb+2]
		mov	ax,WORD PTR [@@fb]
		add	ax,fb_name
		push	ax
		call	strlen
		add	ax,SIZE S_FBLK
		push	ax
		push	ax
		call	malloc
		pop	bx
		or	ax,ax
		jz	SHORT @@toend
		push	dx
		push	ax
		push	@@fb
		push	bx
		call	memcpy
		inc	[si.pn_fcb_count]
		inc	[si.pn_cel_count]
		mov	bx,WORD PTR [si.pn_wsub]
		mov	cx,[bx.ws_count]
		inc	[bx.ws_count]
		les	bx,[bx.ws_fcb]
		shl	cx,2
		add	bx,cx
		mov	ES:[bx],ax
		mov     ES:[bx+2],dx
		push	DS
		push	OFFSET dl_progress
		call	twhide
		push	DS
		push	si
		push	KEY_END
		call	panel_hndevent
		push	cpanel
		push	0
		call	panel_putitem
		push	DS
		push	OFFSET dl_progress
		call	twshow
@@toend:	ret
PEND		cpanel_deselect

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Panel Mouse Event

PPROC		panel_xycmd
ARG		@@pan:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD
LOCAL		@@rc:	DWORD,\
		@@ex:	WORD
		USES	si,di
		mov	ax,WORD PTR @@pan
		call	NPanelState
		jnz	SHORT @@do
		jmp	@@toend
@@do:		mov	si,dx			; SI = offset panel
		mov	bx,WORD PTR [si.pn_dialog]
		mov	eax,[bx.dl_rect]
		mov	@@rc,eax
		xor	ah,ah
		add	al,@@rc.rc_col
		dec	al			; x + col - 1
		mov	@@ex,ax
		push	@@rc
		push	@@x
		push	@@y
		call	rcxyrow			; return line number
		or	ax,ax			; or zero if outside
		jz	SHORT @@outside
		cmp	ax,1			; first line = scroll up
		je	SHORT @@xymovup
		mov	di,ax			; DI to line number
		cmp	ax,2                    ; |C:# -- disk and filter
		jne	SHORT @@testmini
		mov	al,@@rc.rc_x
		cmp	@@x,ax
		je	SHORT @@inside
		add	ax,2
		cmp	@@x,ax
		jbe	SHORT @@newdisk
		inc	ax
		cmp	ax,@@x
		je	SHORT @@config
		jmp	SHORT @@xymovup
@@testmini:	mov	bx,[si]
		test	[bx.wp_flag],_W_MINISTATUS
		jnz	SHORT @@ministatus
		movzx	ax,@@rc.rc_row
		cmp	ax,di
		jne	SHORT @@fileloop
		mov	dx,@@ex
@@exdx:		sub	dx,2
		cmp	dx,@@x
		jne	SHORT @@xymovdn
		mov	ax,PN_XYMINISTATUS
		jmp	SHORT @@toend

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

@@newdisk:	mov	ax,PN_XYNEWDISK
		jmp	SHORT @@toend
@@config:	mov	ax,PN_XYCONFIG
		jmp	SHORT @@toend
@@xymovup:      mov	ax,PN_XYMOVEUP
		jmp	SHORT @@toend
@@xymovdn:      mov	ax,PN_XYMOVEDOWN
		jmp	SHORT @@toend
@@xyfile:	mov	ax,PN_XYFILE
		jmp	SHORT @@toend
@@xydrvinfo:	mov	ax,PN_XYDRVINFO
		jmp	SHORT @@toend
@@inside:	mov	ax,PN_XYINSIDE
		jmp	SHORT @@toend
@@outside:	mov	ax,PN_XYOUTSIDE
@@toend:	ret

@@fileloop:	xor	di,di
@@next:		cmp	di,[si.pn_cel_count]
		jae	SHORT @@inside
		push	[si.pn_xl]
		push	di
		call	xl_getrect
		push	dx
		push	ax
		push	@@x
		push	@@y
		call	rcxyrow
		or	ax,ax
		jnz	SHORT @@xyfile
		inc	di
		jmp	SHORT @@next
@@mend:		jmp	SHORT @@fileloop

@@ministatus:   movzx	ax,@@rc.rc_row
		sub	al,2
		test	[bx.wp_flag],_W_DRVINFO
		jz	SHORT @@m1
		sub	al,2
		test	config.c_lflag,_C_HORIZONTAL
		jnz	SHORT @@m1
		dec	al
@@m1:		cmp	di,ax
		mov	@@rc.rc_row,al
		ja	SHORT @@xymovdn
		jne	SHORT @@mend
		mov	al,@@rc.rc_x
		add	al,2
		cmp	@@x,ax
		je	SHORT @@xydrvinfo
		mov	dx,@@ex
		jmp	@@exdx
PEND		panel_xycmd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Global functions

PPROC		open_panels
		test	config.c_lflag,_W_PANELID
		mov	ocpanel,OFFSET spanel
		jz	SHORT @@a
		mov	ocpanel,OFFSET spanelb
@@a:		test	config.c_apath.wp_flag,_W_VISIBLE
		jz	SHORT @@b
		push	panela
		call	prect_open
@@b:		test	config.c_bpath.wp_flag,_W_VISIBLE
		jz	SHORT @@c
		push	panelb
		call	prect_open
@@c:		push	cpanel
		call	panel_open
		or	ax,ax
		jz	SHORT @@toend
		cmp	ocpanel,OFFSET spanelb
		jne	SHORT @@ob
		push	panela
		call	panel_open
		jmp	SHORT @@1
@@ob:		push	panelb
		call	panel_open
@@1:		mov	ax,1
@@toend:	ret
PEND		open_panels

		END
