;
; DZMAIN.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		string.inc
INCLUDE		dialog.inc
INCLUDE		dzmain.inc

		LOCALS

CR 		= 	13
LF		= 	10
MEMEGA		= 	0484h

_DATA		SEGMENT

linefeed	DB	CR,LF,CR,LF

api_lcount	DW	24
api_oldlcount	DW	24
api_oldcursor	DD	0
api_oldscreen	DD	0

		PUBLIC	api_oldscreen

_DATA		ENDS

_TEXT		SEGMENT

DialogUpdate	PROC	FAR
		call	tupdtime
		call	tupddate
		call	trace
		ret
DialogUpdate	ENDP

ConsoleLoadpal	PROC	NEAR
		test	console,CON_COLOR
		jz	SHORT @@
		push	DS
		push	OFFSET config.c_color.cl_palett
		call	loadpal
@@:		ret
ConsoleLoadpal	ENDP

_TEXT		ENDS

PPROC		init_screen
		call	cursoron
		call	cursory
		add	ax,4
		les	bx,__egaline
		cmp	al,ES:[bx]
		jb	SHORT @@console
		mov	cx,4
		mov	dx,OFFSET linefeed
		call	stderrmsg
@@console:	mov	al,config.c_console
		mov	console,al
		xor	ax,ax
		mov	ES,ax
		mov	al,ES:[MEMEGA]
		mov	api_oldlcount,ax
		inc	ax
		push	ax
		call	scpush
		mov	WORD PTR [api_oldscreen],ax
		mov	WORD PTR [api_oldscreen+2],dx
		push	DS
		push	OFFSET api_oldcursor
		call	getcursor
		call	mouseinit
		call	getesc
		test	config.c_lflag,_C_EGALINE
		jz	SHORT @@j
		mov	api_lcount,49
		mov	com.cmdl_rc.rc_y,48
@@j:		push	api_lcount
		call	apisetlcount
		push	DS
		push	OFFSET at_background
		push	DS
		push	OFFSET config.c_color
		push	40
		call	memcpy
		call	ConsoleLoadpal
		mov	ah,at_background[B_Menus]
		or	ah,at_foreground[F_Menus]
		mov	al,' '
		push	ax
		push	large 0
		push	80
		push	ax
		call	scputw
		pop	ax
		push	0
		push	api_lcount
		push	80
		push	ax
		call	scputw
		mov	ah,at_background[B_Menus]
		or	ah,F_DarkGray
		mov	al,' '
		push	60
		push	0
		push	20
		push	ax
		call	scputw
		push	SCRSEG
		push	4
		push    80
		push	0
		push	DS
		push	OFFSET cp_menusline
		call	wcputs
		mov	dx,1
		mov	ax,api_lcount
		call	__xytoesbx
		push	dx
		push	ax
		push	80
		push	0
		push	DS
		push	OFFSET cp_statusline
		call	wcputs
		mov	WORD PTR [tupdate],OFFSET DialogUpdate
		mov	WORD PTR [tupdate+2],CS
		call	DialogUpdate
		ret
PEND		init_screen

PPROC		apisetlcount
ARG		lcount:	WORD
		mov	ax,lcount
		mov	api_lcount,ax
		xor	ax,ax
		mov	ES,ax
		mov	al,ES:[0484h]
		cmp	ax,lcount
		je	SHORT @@END
		call	__mshide
		mov	ax,lcount
		cmp	al,49
		jne	SHORT @@a
		call	bios_scanline400
		call	bios_loadfont8x8
		jmp	SHORT @@b
@@a:		call	bios_settextmode
		call	ConsoleLoadpal
@@b:		call	__msshow
@@END:		ret
PEND		apisetlcount

PPROC		apiclose
		call	mouseoff
		push	api_oldscreen
		mov	ax,api_oldlcount
		inc	ax
		push	ax
		call	scpop
		mov	ax,api_oldlcount
		cmp	ax,api_lcount
		je	SHORT @@a
		cmp	api_lcount,49
		jne	SHORT @@
		xor	ax,ax
		push	ax
		push	48
		push	160
		push	0720h
		call	scputw
@@:		;push	api_oldlcount
		;call	api_setlcount
@@a:		push	api_oldcursor
		call	setcursor
		test	console,CON_COLOR
		jz	SHORT @@b
		call	resetpal
@@b:		ret
PEND		apiclose

;;--------------------------------------------------------------------------
;; Exclude stdio..
;;--------------------------------------------------------------------------

IFNDEF DEBUG
	IFNDEF _DOSBMP_
PPROC		_flsbuf
ARG		flchar: WORD,\
		stream:	DWORD
		mov	ax,-1
		mov	dx,ax
		ret
PEND		_flsbuf
	ENDIF
ENDIF

		END
