/*
 * CMSUBSIZ.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <dir.h>
#include <progress.h>
#include <stdlib.h>
#include <dzmain.h>

const char
	cp_subsize	[] = "Directory Information",
	cp_selected	[] = "Selected Files",
	cp_bytesize	[] = "BKMGTPE",
	cp_location	[] = "Location:",
	cp_10lu_Files	[] = "%10lu Files\n%10lu Directories",
	cp_totalsbyte	[] = "total %s byte";

static DWORD
	subd_count,
	file_count,
	size_low,
	size_high;

static void clear(void)
{
	subd_count =
	file_count =
	size_low   =
	size_high  = 0L;
}

static void add(DWORD h, DWORD l)
{
	if ((size_low + l) < size_low)
		size_high++;
	size_low += l;
	size_high += h;
}

static int dofile(const char *p, wfblk *wf)
{
	file_count++;
	if (progress_set(NULL, wf->name, 1) || p == NULL)
		return -1;
	add(wf->sizedx, wf->sizeax);
	return 0;
}

static int dosubdir(const char *p)
{
	char *q = (char *)p + strlen(p) - 1;
	if (*q == '\\')
		*q = 0;
	progress_set(NULL, p, 0);
	subd_count++;
	return scan_files(p);
}

static int __getsize(char *p)
{
	fp_maskp = cp_stdmask;
	fp_fileblock = dofile;
	fp_directory = dosubdir;
	return scan_directory(1, p);
}

static int _lc_scansub(char *path)
{
	int x;

	progress_open(cp_subsize, NULL);
	x = __getsize(path);
	progress_close();
	return (x == 0);
}

static int _lc_iddsubinfo(char *info, const char *title)
{
	int x,y;
	long q;
	DOBJ *d;

	d = rsopen(IDD_SUBINFO);
	x = d->rc.x;
	y = d->rc.y;
	wctitle(d->wp, d->rc.col, title);
	twshow(d);
	scputs(x + 5, y + 2, 0, 0, cp_location);
	scpath(x + 15, y + 2, 20, info);
	scputf(x + 4, y + 3, 0, 0,
		cp_10lu_Files, file_count, subd_count - 1);
	q = mkbstring(info, size_high, size_low);
	scputf(x + 6, y + 6, 0, 0, cp_totalsbyte, info);
	if (q & 0xFFFF0000 && q & 0x0000FFFF)
		scputf(x + 12, y + 7, 0, 0, " %lu%c",
			(q & 0xFFFF), cp_bytesize[(q >> 16)]);
	tdmodal(d);
	return 0;
}

static int doselected(char *path)
{
	int x,result;
	fblk **fcb;

	subd_count++;
	result = 1;
	fcb = cpanel->ide->fcb;
	for (x = 0; x < cpanel->fcb_count; x++) {
		if (ISSELECTED(fcb[x]->flag)) {
			if (ISSUBDIR(fcb[x]->flag)) {
				if (!(result = _lc_scansub(strfcat(path, cpanel->ide->path, fcb[x]->name))))
					break;
			} else {
				add(0L, fcb[x]->size);
				file_count++;
			}
		}
	}
	if (result)
		return _lc_iddsubinfo(strcpy(path, cpanel->ide->path), cp_selected);
	return 0;
}

static int _lc_cmsubinfo(panel *p)
{
	FBLK *b;
	char path[WMAXPATH];

	if (panel_state(p) == 0 || ISARCHIVE(*p->flag))
		return 0;
	clear();
	if (panel_ffselected(p))
		return doselected(path);
	if (_lc_scansub(strcpy(path, p->ide->path)))
		return _lc_iddsubinfo(path, cp_subsize);
	return 0;
}

int cmsubinfo(void)
{
	return _lc_cmsubinfo(cpanel);
}

int cmasubinfo(void)
{
	return _lc_cmsubinfo(&panela);
}

int cmbsubinfo(void)
{
	return _lc_cmsubinfo(&panelb);
}

int cmsubsize(void)
{
	FBLK *b;
	char path[WMAXPATH];

	if ((b = panel_curobj(cpanel)) == NULL)
		return 0;
	if (ISARCHIVE(b->flag) || ISUPDIR(b->flag))
		return 0;
	clear();
	if (_lc_scansub(strfcat(path, cpanel->ide->path, b->name)))
		return _lc_iddsubinfo(path, cp_subsize);
	return 0;
}

/******** Resource begin SUBINFO *
	{ 0x0C1C,   1,   0, {22, 7,37,11} },
	{ 0x0000,   0, 'O', {15, 9, 6, 1} },
********* Resource data  *******************/
static int SUBINFO_RC[] = {
	0x0387,0x0C1C,0x0001,0x0716,0x0B25,0x0000,0x4F00,0x090F,
	0x0106,0x25F0,0xF150,0x2A37,0x5B5B,0xF05C,0x5B03,0xF020,
	0x2A1F,0x06F0,0xF020,0x2A0F,0x5EF1,0x4F20,0x206B,0xDC20,
	0x1FF0,0xF020,0xDF06,0x0FF0,0x5020,
}; //	58 byte
ROBJ *IDD_SUBINFO = (ROBJ *)&SUBINFO_RC;
/******** Resource end   SUBINFO */
