/* CMSEARCH.C--
 * Copyright (c) 1999 Hjort Nidudsson
 *
 * Change history:
 * 12 Nov 2008	- cursor off during search
 * 21 Aug 2008	- added IOST
 * 17 Apr 2007	- added macro %FIND%
 * 22 Mar 2007	- fixed bug in Continue/Cancel
 * 20 Mar 2007	- added increased hit count
 * 12 Mar 2007	- fixed Filter
 * 		- added make_batch(): Save Search Result to file
 * 18 Nov 1999	- Created
 */

#include <io.h>
#include <iost.h>
#include <time.h>
#include <alloc.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <progress.h>
#include <dzmain.h>
#include <arch.h>

#define MAXHIT		999
#define LISTFILE	"filelist.bat"

#define MAXINFOTXT	36
typedef struct	{
	long	offset;
	char	text[MAXINFOTXT];
	char	name[2];
      } SBLK;

#define DEFAULTSTATE	0x0027F800

enum Resource_FILE_SEARCH {
	ID_FFMASK = 13,
	ID_FFPATH,
	ID_CONTENT,
	ID_SCANSUB,
	ID_USECASE,
	ID_START,
	ID_CONFIG,
	ID_SAVE,
	ID_GOTO,
	ID_FVIEW,
	ID_QUIT,
	ID_FRAME1,
	ID_FRAME2,
	ITEMCOUNT
};

#define OCOUNT	ID_FFMASK

enum Resource_ADVANCED {
	ID_DATEAFTER,
	ID_DATEBEFORE,
	ID_SIZEGREATER,
	ID_SIZELESS,
	ID_FSYSTEM,
	ID_FHIDDEN,
	ID_FRDONLY,
	ID_FARCHIVE,
	ID_FSUBDIR,
	ID_FNORMAL,
	ID_OK,
	ID_CANCEL
};

enum Resource_FSMakelist {
	ID_FILENAME,
	ID_BEFORE,
	ID_TXTAFTER,
	ID_SOK,
	ID_SCANCEL
};

static int search_view(void);
static int search_advanced(void);
static int search_save(void);
static int search_dofile(const char *, wfblk *);
static int search_dosubdir(const char *);
static int search_path(char *);
static int search_start(void);
static int search_eventcell(void);
static int search_initlist(void);
static int search_exit(void);
static void search_putcellid(void);

static SBLK **search;
static GCMD search_keys[3] = {
	{ ALTX,  search_exit	},
	{ F3, 	 search_view	},
	{ 0, 	 NULL		},
};
static LOBJ list = {
	0, ID_FFMASK, 0, 0, 0, 0, NULL, search_initlist };

int search_exit(void)
{
	while (shift->AltLeft);
	return _C_ESCAPE;
}

int search_view(void)
{
	if (list.count == 0)
		return _C_NORMAL;
	tview(search[list.index + list.celoff]->name,
	      search[list.index + list.celoff]->offset);
	tdialog->index = list.celoff;
	return _C_NORMAL;
}

/* Operation Filters */

int search_advanced(void)
{
	int x,y;

	cmfilter();
	x = tdialog->rc.x + 16;
	y = tdialog->rc.y + 20;
	if (filter == NULL)
		scputc(x, y, 0, 1, ' ');
	else
		scputc(x, y, 0, 1, 7);
	return _C_NORMAL;
}

int search_save(void)
{
	DOBJ *dp;
	int i,h;

	if (list.count == 0)
		return 0;
	if ((dp = rsopen(IDD_FSMakelist)) == NULL)
		return _C_NORMAL;
#ifdef _DOSBMP_
	dp->flag |= _D_DHELP;
#endif
	strcpy(dp->object[ID_FILENAME].data, LISTFILE);
	tdinit(dp);
	if (tdevent(dp) == 0) {
		tdclose(dp);
		return _C_NORMAL;
	}
	if ((h = getouthandle(dp->object[ID_FILENAME].data)) == -1) {
		tdclose(dp);
		return _C_NORMAL;
	}
	for (i = 0; i < list.count; i++) {
		if (*(char *)dp->object[ID_BEFORE].data) {
			oswrite(h, dp->object[ID_BEFORE].data,
				strlen(dp->object[ID_BEFORE].data));
			oswrite(h, " ", 1);
		}
		oswrite(h, search[i]->name, strlen(search[i]->name));
		if (*(char *)dp->object[ID_TXTAFTER].data) {
			oswrite(h, " ", 1);
			oswrite(h, dp->object[ID_TXTAFTER].data,
				strlen(dp->object[ID_TXTAFTER].data));
		}
		oswrite(h, "\r\n", 2);
	}
	close(h);
	tdclose(dp);
	if (panel_state(cpanel)) {
		tdhide(tdialog);
		panel_update_fcb(cpanel);
		tdshow(tdialog);
	}
	return _C_NORMAL;
}

int search_dofile(const char *p, wfblk *wf)
{
	SBLK *	ff;
	TOBJ *	o;
	int 	h;
	int 	usecase;
	int	result;
	char *	q;
	long 	offset;
	char 	b[WMAXPATH];

	result = 0;
	if (list.count >= MAXHIT)
		return result;
	if (filter_wblk(filter, wf) == 0)
		return result;
	strfcat(b, p, wf->name);
	if (progress_set(NULL, wf->name, 1))
		return _ER_USERABORT;
	if (p == NULL)
		return -1;
	o = tdialog->object;
	if (cmpwarg(wf->name, o[ID_FFMASK].data) == 0)
		return result;
	q = (char *)o[ID_CONTENT].data;
	if (*q == 0) {
		if ((ff = (SBLK *)malloc(strlen(b) + sizeof(SBLK))) == NULL)
			return -1;
		memzero(ff, sizeof(SBLK));
		strcpy(ff->name, b);
		search[list.count++] = ff;
		progress_update(list.count);
		return result;
	}
	if ((h = osopen(b, wf->attrib, M_RDONLY, A_OPEN)) == -1)
		return result;
	usecase = 0;
	if (o[ID_USECASE].flag & _O_FLAGB)
		usecase = IO_SEARCHCASE;
//	if (o[ID_HEXSCAN].flag & _O_FLAGB)
//		usecase |= IO_SEARCHHEX;
	if ((offset = osearch(h, wf->sizeax, _bufin, _INTIOBUF, usecase)) == -1L) {
		close(h);
		return result;
	}
	do {
		if ((ff = (SBLK *)malloc(strlen(b) + sizeof(SBLK))) == NULL) {
			close(h);
			return -1;
		}
		search[list.count++] = ff;
		result = progress_update(list.count);
		ff->offset = offset;
		strcpy(ff->name, b);
		lseek(h, offset, SEEK_SET);
		memzero(ff->text, MAXINFOTXT);
		osread(h, ff->text, MAXINFOTXT - 1);
		//strxchg(ff->text, "\t", " ");
		lseek(h, MIN(offset + 1, wf->sizeax), SEEK_SET);
	} while (result == 0 && list.count < MAXHIT &&
		(offset = osearch(h,
			wf->sizeax, _bufin, _INTIOBUF, usecase)) != -1L);
	close(h);
	return result;
}

int search_dosubdir(const char *p)
{
	if (progress_set(NULL, p, 0))
		return _ER_USERABORT;
	return scan_files(p);
}

int search_path(char *p)
{
	char *q = p + strlen(p) - 1;

	if (*q == '\\')
		*q = 0;
	fp_maskp = tdialog->object[ID_FFMASK].data;
	fp_fileblock = search_dofile;
	fp_directory = search_dosubdir;
	if (tdialog->object[ID_SCANSUB].flag & _O_FLAGB)
		return scan_directory(1, p);
	return search_dosubdir(p);
}

int search_start(void)
{
	int 	q;
	TOBJ *	o;
	COBJ 	c;

	if (getcursor(&c))
		cursoroff();
	for (q = 0; q < list.count; q++)
		free(search[q]);

	list.celoff =
	list.index =
	list.numcel =
	list.count = 0;

	o = tdialog->object;
	tdsetbitflag(o, ID_FFMASK, _O_STATE, 0x0FFF);
	tdinit(tdialog);
	scputc(tdialog->rc.x + 4, tdialog->rc.y + 15, 0, 9, 196);
	progress_open(cp_search, NULL);
	progress_set(o[ID_FFPATH].data, 0, MAXHIT + 2);
	search_path(o[ID_FFPATH].data);

	progress_close();
	setcursor(c);
	if (list.count == 0)
		return _C_NORMAL;
	list.numcel = MIN(list.count, ID_FFMASK);
	scputf(tdialog->rc.x + 4, tdialog->rc.y + 15, 0, 0, "[%03d:000]",
		list.count);
	search_initlist();
	for (q = 0; q < list.numcel; q++)
		o[q].flag &=  ~_O_STATE;
	return _C_NORMAL;
}

void search_putcellid(void)
{
	scputf(tdialog->rc.x + 4, tdialog->rc.y + 15, 0, 0,
		"[%03d:%03d]", list.count, list.index + tdialog->index + 1);
}

int search_eventcell(void)
{
	search_putcellid();
	list.celoff = tdialog->index;
	return tdxcellevent();
}

int search_eventstring(void)
{
	int result;

	tminascii = 1;
	result = tdteditevent();
	tminascii = ' ';
        return result;
}

int search_initlist(void)
{
	int x,y,q,t;
	BYTE *p;
	SBLK *ff;

	tdinit(tdialog);
	x = tdialog->rc.x + 4;
	y = tdialog->rc.y + 2;
	for (q = 0; q < list.numcel; q++) {
		ff = search[list.index + q];
		scpath(x, y + q, 32, ff->name);
		for (t = 0; t < MAXINFOTXT; t++)
			scputw(x + t + 33, y + q, 1,
				ff->text[t] >= ' ' ? ff->text[t] : ' ');
	}
	return 1;
}

int ffrsevent(DOBJ *d)
{
	int result;

	result = tdevent(d/*, &list*/);
	IDD_FILE_SEARCH->dialog.rc.x = d->rc.x;
	IDD_FILE_SEARCH->dialog.rc.y = d->rc.y;
	return result;
}

int FindFile(const char *path)
{
	int event;
	int 	x;
	char *	p;
	char *	q;
	TOBJ *	o;
	DOBJ *	d;

	cmclrcmdl();
	if ((search = (SBLK **)malloc(MAXHIT * sizeof(SBLK *))) == NULL)
		return stderror(NULL, EMNOMEM, 0);

	if ((d = rsopen(IDD_FILE_SEARCH)) == NULL) {
		free(search);
		return stderror(NULL, EMNOMEM, 0);
	}

	memzero(search, MAXHIT * sizeof(SBLK *));
	list.celoff =
	list.index  =
	list.numcel =
	list.count  = 0;

	o = d->object;
	o[ID_CONTENT].data = searchstring;
	o[ID_FRAME1].data = search_keys;
	strcpy(o[ID_FFPATH].data, path);
	p = strfn(o[ID_FFPATH].data);
	strcpy(o[ID_FFMASK].data, p);
	if (p == o[ID_FFPATH].data)
		strcpy(o[ID_FFPATH].data, com.sub->path);
	else
		*--p = 0;

	o[ID_START].proc  = search_start;
	o[ID_CONFIG].proc = search_advanced;
	o[ID_SAVE].proc   = search_save;
	o[ID_FVIEW].proc  = search_view;
	o[ID_CONTENT].proc  = search_eventstring;

//	if (xflag & FSEARCH_HEX)
//		o[ID_HEXSCAN].flag |= _O_FLAGB;
	if (xflag & FSEARCH_CASE)
		o[ID_USECASE].flag |= _O_FLAGB;
	if (xflag & FSEARCH_SUB)
		o[ID_SCANSUB].flag |= _O_FLAGB;

	for (x = 0; x < ID_FFMASK; x++)
		o[x].proc = search_eventcell;

	tdinit(d);
	filter = NULL;
	tdialog = d;
	tdllist = &list;

	while ((event = ffrsevent(d)) != 0) {
		if (d->index < ID_FFMASK) {
			x = list.index + d->index;
			tview(search[x]->name, search[x]->offset);
		} else if (d->index == ID_GOTO) {
			break;
		} else {
			search_start();
		}
	}

	xflag &= ~(FSEARCH_CASE | FSEARCH_SUB);
	if (o[ID_USECASE].flag & _O_FLAGB)
		xflag |= FSEARCH_CASE;
	if (o[ID_SCANSUB].flag & _O_FLAGB)
		xflag |= FSEARCH_SUB;
//	if (o[ID_HEXSCAN].flag & _O_FLAGB)
//		xflag |= FSEARCH_HEX;

	x = d->index;
	tdclose(d);

	if (x == ID_GOTO && list.count && panel_state(cpanel)) {
		q = search[list.index + list.celoff]->name;
		if ((p = strrchr(q, '\\')) != NULL) {
			chdrv(TOUPPER(*q) - '@');
			p--;
			if (p[0] == ':' /*|| *p == '\\'*/) {
				p[2] = 0;
			} else {
				p[1] = 0;
			}
			chdir(q);
			strcpy(cpanel->ide->path, q);
			com_setdevice(cpanel->ide);
		}
		panel_update_fcb(cpanel);
	}
	for (x = 0; x < list.count; x++)
		free(search[x]);
	free(search);
	return event;
}

int cmsearch(void)
{
	char b[WMAXPATH];

	return FindFile(strfcat(b, com.sub->path, com.sub->mask));
}

/******** Resource begin FILE_SEARCH *
	{ 0x041C,  26,  13, { 2, 2,76,22} },
	{ 0xA043,   0,   0, { 3, 2,70, 1} },
	{ 0xA043,   0,   0, { 3, 3,70, 1} },
	{ 0xA043,   0,   0, { 3, 4,70, 1} },
	{ 0xA043,   0,   0, { 3, 5,70, 1} },
	{ 0xA043,   0,   0, { 3, 6,70, 1} },
	{ 0xA043,   0,   0, { 3, 7,70, 1} },
	{ 0xA043,   0,   0, { 3, 8,70, 1} },
	{ 0xA043,   0,   0, { 3, 9,70, 1} },
	{ 0xA043,   0,   0, { 3,10,70, 1} },
	{ 0xA043,   0,   0, { 3,11,70, 1} },
	{ 0xA043,   0,   0, { 3,12,70, 1} },
	{ 0xA043,   0,   0, { 3,13,70, 1} },
	{ 0xA043,   0,   0, { 3,14,70, 1} },
	{ 0x0004,   8, 'F', {16,16,32, 1} },
	{ 0x0004,   8, 'L', {16,17,55, 1} },
	{ 0x2004,   8, 'C', {16,18,32, 1} },
	{ 0x0002,   0, 'P', {50,16,22, 1} },
	{ 0x0002,   0, 'E', {50,18,20, 1} },
	{ 0x4000,   0, 'S', { 2,20, 9, 1} },
	{ 0x4000,   0, 'I', {15,20,10, 1} },
	{ 0x4000,   0, 'A', {29,20, 8, 1} },
	{ 0x0000,   0, 'G', {41,20, 8, 1} },
	{ 0x4000,   0, 'V', {53,20, 8, 1} },
	{ 0x0A00,   0, 'Q', {65,20, 8, 1} },
	{ 0x9008,   0,   0, { 3, 1,70, 1} },
	{ 0x8009,   0,   0, { 3,15,70, 1} },
********* Resource data  *******************/
static int FILE_SEARCH_RC[] = {
	0x10B6,0x041C,0x0D1A,0x0202,0x164C,0xA043,0x0000,0x0203,
	0x0146,0xA043,0x0000,0x0303,0x0146,0xA043,0x0000,0x0403,
	0x0146,0xA043,0x0000,0x0503,0x0146,0xA043,0x0000,0x0603,
	0x0146,0xA043,0x0000,0x0703,0x0146,0xA043,0x0000,0x0803,
	0x0146,0xA043,0x0000,0x0903,0x0146,0xA043,0x0000,0x0A03,
	0x0146,0xA043,0x0000,0x0B03,0x0146,0xA043,0x0000,0x0C03,
	0x0146,0xA043,0x0000,0x0D03,0x0146,0xA043,0x0000,0x0E03,
	0x0146,0x0004,0x4608,0x1010,0x0120,0x0004,0x4C08,0x1110,
	0x0137,0x2004,0x4308,0x1210,0x0120,0x0002,0x5000,0x1032,
	0x0116,0x0002,0x4500,0x1232,0x0114,0x4000,0x5300,0x1402,
	0x0109,0x4000,0x4900,0x140F,0x010A,0x4000,0x4100,0x141D,
	0x0108,0x0000,0x4700,0x1429,0x0108,0x4000,0x5600,0x1435,
	0x0108,0x0A00,0x5100,0x1441,0x0108,0x9008,0x0000,0x0103,
	0x0146,0x8009,0x0000,0x0F03,0x0146,0x4CF0,0xF450,0x7078,
	0xF07F,0x7031,0xF03F,0x7019,0xF07F,0x704B,0xF07F,0x7034,
	0xF03F,0x7060,0x5050,0xF05C,0x5006,0x04F0,0xF070,0x5003,
	0xF05C,0x5006,0x04F0,0xF070,0x5003,0xF05C,0x5004,0x04F0,
	0x5070,0x5C50,0x05F0,0xF050,0x7004,0x5050,0xF05C,0x5005,
	0x04F0,0x5070,0x5C50,0x05F0,0xF050,0x704F,0x20F0,0x4620,
	0x6C69,0x2065,0x6553,0x7261,0x6863,0x23F0,0xDA20,0x46F0,
	0xBFC4,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xB320,0x46F0,
	0xB320,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xB320,0x46F0,
	0xB320,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xB320,0x46F0,
	0xB320,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xB320,0x46F0,
	0xB320,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xB320,0x46F0,
	0xB320,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xB320,0x46F0,
	0xB320,0x04F0,0xB320,0x46F0,0xB320,0x04F0,0xC320,0x46F0,
	0xB4C4,0x04F0,0xB320,0x4620,0x6E69,0x2064,0x6946,0x656C,
	0x2073,0xF05B,0xFA20,0x205D,0x205B,0x205D,0x7250,0x636F,
	0x7365,0x2073,0x7573,0x6662,0x6C6F,0x6564,0x7372,0xB320,
	0x04F0,0xB320,0x4C20,0x636F,0x7461,0x6F69,0xF06E,0x2003,
	0xF05B,0xFA37,0x205D,0xF0B3,0x2004,0x20B3,0x6F43,0x746E,
	0x6961,0x696E,0x676E,0x5B20,0x20F0,0x5DFA,0x5B20,0x5D20,
	0x4320,0x7361,0x2065,0x6573,0x736E,0x7469,0x7669,0xF065,
	0x2005,0xF0B3,0x2004,0xF0C0,0xC446,0xF0D9,0x2006,0x7453,
	0x7261,0x2074,0xDC20,0x05F0,0x4620,0x6C69,0x6574,0x2072,
	0xDC20,0x05F0,0x5320,0x7661,0x2065,0xDC20,0x05F0,0x4720,
	0x746F,0x206F,0xDC20,0x05F0,0x5620,0x6569,0x2077,0xDC20,
	0x05F0,0x5120,0x6975,0x2074,0xDC20,0x05F0,0xF020,0xDF09,
	0x04F0,0xF020,0xDF0A,0x04F0,0xF020,0xDF08,0x04F0,0xF020,
	0xDF08,0x04F0,0xF020,0xDF08,0x04F0,0xF020,0xDF08,0x2020,
	0x7070,
}; //	658 byte
ROBJ *IDD_FILE_SEARCH = (ROBJ *)&FILE_SEARCH_RC;
/******** Resource end   FILE_SEARCH */
/******** Resource begin FSMakelist *
	{ 0x041C,   5,   3, {10, 8,61, 9} },
	{ 0x0004,  16, 'F', {13, 2,45, 1} },
	{ 0x0004,  16, 'B', {35, 4,23, 1} },
	{ 0x0004,  16, 'A', {35, 5,23, 1} },
	{ 0x0000,   0, 'O', { 3, 7, 6, 1} },
	{ 0x0A00,   0, 'C', {13, 7,10, 1} },
********* Resource data  *******************/
static int FSMakelist_RC[] = {
	0x07F7,0x041C,0x0305,0x080A,0x093D,0x0004,0x4610,0x020D,
	0x012D,0x0004,0x4210,0x0423,0x0117,0x0004,0x4110,0x0523,
	0x0117,0x0000,0x4F00,0x0703,0x0106,0x0A00,0x4300,0x070D,
	0x010A,0x3DF0,0xF050,0x7040,0xF07F,0x7009,0x2DF0,0xF007,
	0x7050,0xF07F,0x7012,0x17F0,0xF007,0x7013,0xF07F,0x7012,
	0x17F0,0xF007,0x7043,0x5050,0xF05C,0x5003,0x04F0,0x5070,
	0x5C50,0x07F0,0xF050,0x7063,0x1AF0,0x4C20,0x7369,0x6674,
	0x6C69,0xF065,0x205B,0x6946,0x656C,0x616E,0x656D,0xF03A,
	0x2072,0x6554,0x7478,0x7420,0x206F,0x7570,0x2074,0x6562,
	0x6F66,0x6572,0x6620,0x6C69,0x2065,0x616E,0x656D,0x3A73,
	0x1FF0,0x5420,0x7865,0x2074,0x6F74,0x7020,0x7475,0x6120,
	0x7466,0x7265,0x6620,0x6C69,0x2065,0x616E,0x656D,0x3A73,
	0x5EF0,0x4F20,0x206B,0xDC20,0x05F0,0x4320,0x6E61,0x6563,
	0x206C,0xDC20,0x29F0,0xF020,0xDF06,0x04F0,0xF020,0xDF0A,
	0x25F0,0x0720,
}; //	228 byte
ROBJ *IDD_FSMakelist = (ROBJ *)&FSMakelist_RC;
/******** Resource end   FSMakelist */
